/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.parsers;

import com.sun.org.apache.xerces.internal.impl.xs.XMLSchemaValidator;
import com.sun.org.apache.xerces.internal.impl.xs.XSMessageFormatter;
import com.sun.org.apache.xerces.internal.parsers.DTDConfiguration;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarPool;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;

public class StandardParserConfiguration
extends DTDConfiguration {
    protected static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    protected static final String SCHEMA_ELEMENT_DEFAULT = "http://apache.org/xml/features/validation/schema/element-default";
    protected static final String SCHEMA_AUGMENT_PSVI = "http://apache.org/xml/features/validation/schema/augment-psvi";
    protected static final String XMLSCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    protected static final String XMLSCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String GENERATE_SYNTHETIC_ANNOTATIONS = "http://apache.org/xml/features/generate-synthetic-annotations";
    protected static final String VALIDATE_ANNOTATIONS = "http://apache.org/xml/features/validate-annotations";
    protected static final String HONOUR_ALL_SCHEMALOCATIONS = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String SCHEMA_VALIDATOR = "http://apache.org/xml/properties/internal/validator/schema";
    protected static final String SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    protected static final String SCHEMA_NONS_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    protected XMLSchemaValidator fSchemaValidator;

    public StandardParserConfiguration() {
        this(null, null, null);
    }

    public StandardParserConfiguration(SymbolTable symbolTable) {
        this(symbolTable, null, null);
    }

    public StandardParserConfiguration(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        this(symbolTable, grammarPool, null);
    }

    public StandardParserConfiguration(SymbolTable symbolTable, XMLGrammarPool grammarPool, XMLComponentManager parentSettings) {
        super(symbolTable, grammarPool, parentSettings);
        String[] recognizedFeatures = new String[]{NORMALIZE_DATA, SCHEMA_ELEMENT_DEFAULT, SCHEMA_AUGMENT_PSVI, GENERATE_SYNTHETIC_ANNOTATIONS, VALIDATE_ANNOTATIONS, HONOUR_ALL_SCHEMALOCATIONS, XMLSCHEMA_VALIDATION, XMLSCHEMA_FULL_CHECKING};
        this.addRecognizedFeatures(recognizedFeatures);
        this.setFeature(SCHEMA_ELEMENT_DEFAULT, true);
        this.setFeature(NORMALIZE_DATA, true);
        this.setFeature(SCHEMA_AUGMENT_PSVI, true);
        this.setFeature(GENERATE_SYNTHETIC_ANNOTATIONS, false);
        this.setFeature(VALIDATE_ANNOTATIONS, false);
        this.setFeature(HONOUR_ALL_SCHEMALOCATIONS, false);
        String[] recognizedProperties = new String[]{SCHEMA_LOCATION, SCHEMA_NONS_LOCATION};
        this.addRecognizedProperties(recognizedProperties);
    }

    @Override
    protected void configurePipeline() {
        super.configurePipeline();
        if (this.getFeature(XMLSCHEMA_VALIDATION)) {
            if (this.fSchemaValidator == null) {
                this.fSchemaValidator = new XMLSchemaValidator();
                this.fProperties.put(SCHEMA_VALIDATOR, this.fSchemaValidator);
                this.addComponent(this.fSchemaValidator);
                if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
                    XSMessageFormatter xmft = new XSMessageFormatter();
                    this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", xmft);
                }
            }
            this.fLastComponent = this.fSchemaValidator;
            this.fNamespaceBinder.setDocumentHandler(this.fSchemaValidator);
            this.fSchemaValidator.setDocumentHandler(this.fDocumentHandler);
            this.fSchemaValidator.setDocumentSource(this.fNamespaceBinder);
        }
    }

    @Override
    protected void checkFeature(String featureId) throws XMLConfigurationException {
        if (featureId.startsWith("http://apache.org/xml/features/")) {
            int suffixLength = featureId.length() - "http://apache.org/xml/features/".length();
            if (suffixLength == "validation/schema".length() && featureId.endsWith("validation/schema")) {
                return;
            }
            if (suffixLength == "validation/schema-full-checking".length() && featureId.endsWith("validation/schema-full-checking")) {
                return;
            }
            if (suffixLength == "validation/schema/normalized-value".length() && featureId.endsWith("validation/schema/normalized-value")) {
                return;
            }
            if (suffixLength == "validation/schema/element-default".length() && featureId.endsWith("validation/schema/element-default")) {
                return;
            }
        }
        super.checkFeature(featureId);
    }

    @Override
    protected void checkProperty(String propertyId) throws XMLConfigurationException {
        int suffixLength;
        if (propertyId.startsWith("http://apache.org/xml/properties/")) {
            suffixLength = propertyId.length() - "http://apache.org/xml/properties/".length();
            if (suffixLength == "schema/external-schemaLocation".length() && propertyId.endsWith("schema/external-schemaLocation")) {
                return;
            }
            if (suffixLength == "schema/external-noNamespaceSchemaLocation".length() && propertyId.endsWith("schema/external-noNamespaceSchemaLocation")) {
                return;
            }
        }
        if (propertyId.startsWith("http://java.sun.com/xml/jaxp/properties/") && (suffixLength = propertyId.length() - "http://java.sun.com/xml/jaxp/properties/".length()) == "schemaSource".length() && propertyId.endsWith("schemaSource")) {
            return;
        }
        super.checkProperty(propertyId);
    }
}

