/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.logging.Logger;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.exception.OAuthException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.io.MissingOAuthAccessTokenException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.auth.CredentialsManagerException;
import org.openstreetmap.josm.io.auth.CredentialsManagerFactory;
import org.openstreetmap.josm.io.auth.CredentialsManagerResponse;
import org.openstreetmap.josm.tools.Base64;
import org.openstreetmap.josm.tools.I18n;

public class OsmConnection {
    private static final Logger logger = Logger.getLogger(OsmConnection.class.getName());
    protected boolean cancel = false;
    protected HttpURLConnection activeConnection;
    protected OAuthParameters oauthParameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.cancel = true;
        OsmConnection osmConnection = this;
        synchronized (osmConnection) {
            if (this.activeConnection != null) {
                this.activeConnection.setConnectTimeout(100);
                this.activeConnection.setReadTimeout(100);
            }
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        osmConnection = this;
        synchronized (osmConnection) {
            if (this.activeConnection != null) {
                this.activeConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBasicAuthorizationHeader(HttpURLConnection con) throws OsmTransferException {
        CredentialsManagerResponse response;
        CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
        try {
            CredentialsManager credentialsManager = CredentialsManagerFactory.getCredentialManager();
            synchronized (credentialsManager) {
                response = CredentialsManagerFactory.getCredentialManager().getCredentials(Authenticator.RequestorType.SERVER, false);
            }
        }
        catch (CredentialsManagerException e) {
            throw new OsmTransferException(e);
        }
        if (response == null) {
            String token = ":";
        } else {
            if (response.isCanceled()) {
                this.cancel = true;
                return;
            }
            String username = response.getUsername() == null ? "" : response.getUsername();
            String password = response.getPassword() == null ? "" : String.valueOf(response.getPassword());
            String token = username + ":" + password;
            try {
                ByteBuffer bytes = encoder.encode(CharBuffer.wrap(token));
                con.addRequestProperty("Authorization", "Basic " + Base64.encode(bytes));
            }
            catch (CharacterCodingException e) {
                throw new OsmTransferException(e);
            }
        }
    }

    protected void addOAuthAuthorizationHeader(HttpURLConnection connection) throws OsmTransferException {
        if (this.oauthParameters == null) {
            this.oauthParameters = OAuthParameters.createFromPreferences(Main.pref);
        }
        OAuthConsumer consumer = this.oauthParameters.buildConsumer();
        OAuthAccessTokenHolder holder = OAuthAccessTokenHolder.getInstance();
        if (!holder.containsAccessToken()) {
            throw new MissingOAuthAccessTokenException();
        }
        consumer.setTokenWithSecret(holder.getAccessTokenKey(), holder.getAccessTokenSecret());
        try {
            consumer.sign(connection);
        }
        catch (OAuthException e) {
            throw new OsmTransferException(I18n.tr("Failed to sign a HTTP connection with an OAuth Authentication header"), e);
        }
    }

    protected void addAuth(HttpURLConnection connection) throws OsmTransferException {
        String authMethod = Main.pref.get("osm-server.auth-method", "basic");
        if (authMethod.equals("basic")) {
            this.addBasicAuthorizationHeader(connection);
        } else if (authMethod.equals("oauth")) {
            this.addOAuthAuthorizationHeader(connection);
        } else {
            String msg = I18n.tr("Warning: unexpected value for preference ''{0}''. Got ''{1}''.", "osm-server.auth-method", authMethod);
            System.err.println(msg);
            throw new OsmTransferException(msg);
        }
    }

    public boolean isCanceled() {
        return this.cancel;
    }

    static {
        try {
            HttpURLConnection.setFollowRedirects(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }
}

