/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.HashMap;
import org.openstreetmap.josm.tools.I18n;

public class Capabilities {
    private HashMap<String, HashMap<String, String>> capabilities = new HashMap();

    public boolean isDefined(String element, String attribute) {
        if (!this.capabilities.containsKey(element)) {
            return false;
        }
        HashMap<String, String> e = this.capabilities.get(element);
        if (e == null) {
            return false;
        }
        return e.get(attribute) != null;
    }

    public String get(String element, String attribute) {
        if (!this.capabilities.containsKey(element)) {
            return null;
        }
        HashMap<String, String> e = this.capabilities.get(element);
        if (e == null) {
            return null;
        }
        return e.get(attribute);
    }

    public Double getDouble(String element, String attribute) throws NumberFormatException {
        String s = this.get(element, attribute);
        if (s == null) {
            return null;
        }
        return Double.parseDouble(s);
    }

    public Long getLong(String element, String attribute) {
        String s = this.get(element, attribute);
        if (s == null) {
            return null;
        }
        return Long.parseLong(s);
    }

    public void put(String element, String attribute, String value) {
        if (this.capabilities == null) {
            this.capabilities = new HashMap();
        }
        if (!this.capabilities.containsKey(element)) {
            HashMap h = new HashMap();
            this.capabilities.put(element, h);
        }
        HashMap<String, String> e = this.capabilities.get(element);
        e.put(attribute, value);
    }

    public void clear() {
        this.capabilities = new HashMap();
    }

    public boolean supportsVersion(String version) {
        return this.get("version", "minimum").compareTo(version) <= 0 && this.get("version", "maximum").compareTo(version) >= 0;
    }

    public int getMaxChangesetSize() {
        String v = this.get("changesets", "maximum_elements");
        if (v == null) {
            return -1;
        }
        try {
            int n = Integer.parseInt(v);
            if (n <= 0) {
                System.err.println(I18n.tr("Warning: illegal value of attribute ''{0}'' of element ''{1}'' in server capabilities. Got ''{2}''", "changesets", "maximum_elements", n));
                return -1;
            }
            return n;
        }
        catch (NumberFormatException e) {
            System.err.println(I18n.tr("Warning: illegal value of attribute ''{0}'' of element ''{1}'' in server capabilities. Got ''{2}''", "changesets", "maximum_elements", v));
            return -1;
        }
    }
}

