/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Icon;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.ImageMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerProducers;
import org.openstreetmap.josm.gui.layer.markerlayer.WebMarker;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Marker
implements ActionListener {
    public final String text;
    public final Map<String, String> textMap = new HashMap<String, String>();
    public final Icon symbol;
    public final MarkerLayer parentLayer;
    public double time;
    public double offset;
    private CachedLatLon coor;
    public static LinkedList<MarkerProducers> markerProducers = new LinkedList();
    private static final IntegerProperty PROP_LABEL = new IntegerProperty("draw.rawgps.layer.wpt", 0);
    private static final String[] labelAttributes = new String[]{"name", "desc"};

    public final void setCoor(LatLon coor) {
        if (this.coor == null) {
            this.coor = new CachedLatLon(coor);
        } else {
            this.coor.setCoor(coor);
        }
    }

    public final LatLon getCoor() {
        return this.coor;
    }

    public final void setEastNorth(EastNorth eastNorth) {
        this.coor.setEastNorth(eastNorth);
    }

    public final EastNorth getEastNorth() {
        return this.coor.getEastNorth();
    }

    public Marker(LatLon ll, String text, String iconName, MarkerLayer parentLayer, double time, double offset) {
        this.setCoor(ll);
        this.text = text == null || text.length() == 0 ? null : text;
        this.offset = offset;
        this.time = time;
        this.symbol = ImageProvider.getIfAvailable("markers", iconName);
        this.parentLayer = parentLayer;
    }

    public Marker(LatLon ll, Map<String, String> textMap, String iconName, MarkerLayer parentLayer, double time, double offset) {
        this.setCoor(ll);
        if (textMap != null) {
            this.textMap.clear();
            this.textMap.putAll(textMap);
        }
        this.text = null;
        this.offset = offset;
        this.time = time;
        this.symbol = ImageProvider.getIfAvailable("markers", iconName);
        this.parentLayer = parentLayer;
    }

    public boolean containsPoint(Point p) {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
    }

    public void paint(Graphics g, MapView mv, boolean mousePressed, boolean showTextOrIcon) {
        Point screen = mv.getPoint(this.getEastNorth());
        if (this.symbol != null && showTextOrIcon) {
            this.symbol.paintIcon(mv, g, screen.x - this.symbol.getIconWidth() / 2, screen.y - this.symbol.getIconHeight() / 2);
        } else {
            g.drawLine(screen.x - 2, screen.y - 2, screen.x + 2, screen.y + 2);
            g.drawLine(screen.x + 2, screen.y - 2, screen.x - 2, screen.y + 2);
        }
        String labelText = this.getText();
        if (labelText != null && showTextOrIcon) {
            g.drawString(labelText, screen.x + 4, screen.y + 2);
        }
    }

    public static Marker createMarker(WayPoint wpt, File relativePath, MarkerLayer parentLayer, double time, double offset) {
        for (MarkerProducers maker : markerProducers) {
            Marker marker = maker.createMarker(wpt, relativePath, parentLayer, time, offset);
            if (marker == null) continue;
            return marker;
        }
        return null;
    }

    public AudioMarker audioMarkerFromMarker(String uri) {
        AudioMarker audioMarker = AudioMarker.create(this.getCoor(), this.getText(), uri, this.parentLayer, this.time, this.offset);
        return audioMarker;
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        return Marker.getText(this.textMap);
    }

    private static String getText(Map<String, String> textMap) {
        String text = "";
        if (textMap != null && !textMap.isEmpty()) {
            switch (PROP_LABEL.get()) {
                case 1: {
                    if (!textMap.containsKey("name")) break;
                    text = textMap.get("name");
                    break;
                }
                case 2: {
                    if (!textMap.containsKey("desc")) break;
                    text = textMap.get("desc");
                    break;
                }
                case 0: 
                case 3: {
                    if (textMap.containsKey("name")) {
                        text = textMap.get("name");
                        if (!textMap.containsKey("desc") || PROP_LABEL.get() == 0 && text.equals(textMap.get("desc"))) break;
                        text = text + " - " + textMap.get("desc");
                        break;
                    }
                    if (!textMap.containsKey("desc")) break;
                    text = textMap.get("desc");
                    break;
                }
                default: {
                    text = "";
                }
            }
        }
        return text;
    }

    static {
        markerProducers.add(new MarkerProducers(){

            public Marker createMarker(WayPoint wpt, File relativePath, MarkerLayer parentLayer, double time, double offset) {
                String uri = null;
                try {
                    Iterator i$ = ((Collection)wpt.attr.get("meta.links")).iterator();
                    if (i$.hasNext()) {
                        GpxLink oneLink = (GpxLink)i$.next();
                        uri = oneLink.uri;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (relativePath != null && uri != null && !this.isWellFormedAddress(uri)) {
                    uri = new File(relativePath.getParentFile(), uri).toURI().toString();
                }
                HashMap<String, String> nameDesc = new HashMap<String, String>();
                for (String attribute : labelAttributes) {
                    if (!wpt.attr.containsKey(attribute)) continue;
                    nameDesc.put(attribute, wpt.getString(attribute));
                }
                if (uri == null) {
                    String symbolName = wpt.getString("symbol");
                    if (symbolName == null) {
                        symbolName = wpt.getString("sym");
                    }
                    return new Marker(wpt.getCoor(), nameDesc, symbolName, parentLayer, time, offset);
                }
                if (uri.endsWith(".wav")) {
                    return AudioMarker.create(wpt.getCoor(), Marker.getText(nameDesc), uri, parentLayer, time, offset);
                }
                if (uri.endsWith(".png") || uri.endsWith(".jpg") || uri.endsWith(".jpeg") || uri.endsWith(".gif")) {
                    return ImageMarker.create(wpt.getCoor(), uri, parentLayer, time, offset);
                }
                return WebMarker.create(wpt.getCoor(), uri, parentLayer, time, offset);
            }

            private boolean isWellFormedAddress(String link) {
                try {
                    new URL(link);
                    return true;
                }
                catch (MalformedURLException x) {
                    return false;
                }
            }
        });
    }
}

