/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.gui.BookmarkList;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.download.BoundingBoxSelection;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class BookmarkSelection
implements DownloadSelection {
    private Bounds currentArea;
    private BookmarkList bookmarks;
    private DownloadDialog parent;
    private JMultilineLabel lblCurrentDownloadArea;
    private final JTextArea bboxDisplay = new JTextArea();
    private AddAction actAdd;

    protected JPanel buildButtonPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        RemoveAction removeAction = new RemoveAction();
        this.bookmarks.addListSelectionListener(removeAction);
        pnl.add((Component)new JButton(removeAction), gc);
        gc.gridy = 1;
        RenameAction renameAction = new RenameAction();
        this.bookmarks.addListSelectionListener(renameAction);
        pnl.add((Component)new JButton(renameAction), gc);
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.gridy = 3;
        pnl.add((Component)new JPanel(), gc);
        return pnl;
    }

    protected JPanel buildDownloadAreaAddPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.insets = new Insets(5, 5, 5, 5);
        this.lblCurrentDownloadArea = new JMultilineLabel("");
        pnl.add((Component)this.lblCurrentDownloadArea, gc);
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.bboxDisplay.setEditable(false);
        this.bboxDisplay.setBackground(pnl.getBackground());
        this.bboxDisplay.addFocusListener(new BoundingBoxSelection.SelectAllOnFocusHandler(this.bboxDisplay));
        pnl.add((Component)this.bboxDisplay, gc);
        gc.anchor = 12;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(5, 5, 5, 5);
        this.actAdd = new AddAction();
        pnl.add((Component)new JButton(this.actAdd), gc);
        return pnl;
    }

    public void addGui(final DownloadDialog gui) {
        JPanel dlg = new JPanel(new GridBagLayout());
        gui.addDownloadAreaSelector(dlg, I18n.tr("Bookmarks"));
        GridBagConstraints gc = new GridBagConstraints();
        this.bookmarks = new BookmarkList();
        this.bookmarks.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                BookmarkList.Bookmark b = (BookmarkList.Bookmark)BookmarkSelection.this.bookmarks.getSelectedValue();
                if (b != null) {
                    gui.boundingBoxChanged(b.getArea(), BookmarkSelection.this);
                }
            }
        });
        this.bookmarks.addMouseListener(new DoubleClickAdapter());
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.gridwidth = 2;
        dlg.add((Component)this.buildDownloadAreaAddPanel(), gc);
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.gridy = 1;
        gc.fill = 3;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        dlg.add((Component)this.buildButtonPanel(), gc);
        gc.gridwidth = 1;
        gc.gridx = 1;
        gc.gridy = 1;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.gridx = 1;
        dlg.add((Component)new JScrollPane(this.bookmarks), gc);
        this.parent = gui;
    }

    protected void updateDownloadAreaLabel() {
        if (this.currentArea == null) {
            this.lblCurrentDownloadArea.setText(I18n.tr("<html>There is currently no download area selected.</html>"));
        } else {
            this.lblCurrentDownloadArea.setText(I18n.tr("<html><strong>Current download area</strong> (minlon, minlat, maxlon, maxlat): </html>"));
            this.bboxDisplay.setText(this.currentArea.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES) + "," + this.currentArea.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES) + "," + this.currentArea.getMax().lonToString(CoordinateFormat.DECIMAL_DEGREES) + "," + this.currentArea.getMax().latToString(CoordinateFormat.DECIMAL_DEGREES));
        }
    }

    public void setDownloadArea(Bounds area) {
        if (area == null) {
            return;
        }
        this.currentArea = area;
        this.bookmarks.clearSelection();
        this.updateDownloadAreaLabel();
        this.actAdd.setEnabled(true);
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e) || e.getClickCount() != 2) {
                return;
            }
            int idx = BookmarkSelection.this.bookmarks.locationToIndex(e.getPoint());
            if (idx < 0 || idx >= BookmarkSelection.this.bookmarks.getModel().getSize()) {
                return;
            }
            BookmarkList.Bookmark b = (BookmarkList.Bookmark)BookmarkSelection.this.bookmarks.getModel().getElementAt(idx);
            BookmarkSelection.this.parent.startDownload(b.getArea());
        }
    }

    class RenameAction
    extends AbstractAction
    implements ListSelectionListener {
        public RenameAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.putValue("ShortDescription", I18n.tr("Rename the currently selected bookmark"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            Object[] sels = BookmarkSelection.this.bookmarks.getSelectedValues();
            if (sels == null || sels.length != 1) {
                return;
            }
            BookmarkList.Bookmark b = (BookmarkList.Bookmark)sels[0];
            Object value = JOptionPane.showInputDialog(Main.parent, I18n.tr("Please enter a name for the bookmarked download area."), I18n.tr("Name of location"), 3, null, null, b.getName());
            if (value != null) {
                b.setName(value.toString());
                BookmarkSelection.this.bookmarks.save();
                BookmarkSelection.this.bookmarks.repaint();
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(BookmarkSelection.this.bookmarks.getSelectedIndices().length == 1);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class RemoveAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("ShortDescription", I18n.tr("Remove the currently selected bookmarks"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            Object[] sels = BookmarkSelection.this.bookmarks.getSelectedValues();
            if (sels == null || sels.length == 0) {
                return;
            }
            for (Object sel : sels) {
                ((DefaultListModel)BookmarkSelection.this.bookmarks.getModel()).removeElement(sel);
            }
            BookmarkSelection.this.bookmarks.save();
        }

        protected void updateEnabledState() {
            this.setEnabled(BookmarkSelection.this.bookmarks.getSelectedIndices().length > 0);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class AddAction
    extends AbstractAction {
        public AddAction() {
            this.putValue("Name", I18n.tr("Create bookmark"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "bookmark-new"));
            this.putValue("ShortDescription", I18n.tr("Add a bookmark for the currently selected download area"));
        }

        public void actionPerformed(ActionEvent e) {
            if (BookmarkSelection.this.currentArea == null) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Currently, there is no download area selected. Please select an area first."), I18n.tr("Information"), 1);
                return;
            }
            BookmarkList.Bookmark b = new BookmarkList.Bookmark();
            b.setName(JOptionPane.showInputDialog(Main.parent, I18n.tr("Please enter a name for the bookmarked download area."), I18n.tr("Name of location"), 3));
            b.setArea(BookmarkSelection.this.currentArea);
            if (b.getName() != null && !b.getName().equals("")) {
                ((DefaultListModel)BookmarkSelection.this.bookmarks.getModel()).addElement(b);
                BookmarkSelection.this.bookmarks.save();
            }
        }
    }
}

