/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.corrector.CorrectionTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CorrectionTable<TM extends CorrectionTableModel<?>>
extends JTable {
    private static final int MAX_VISIBLE_LINES = 10;
    private static BoldRenderer boldRenderer = null;

    protected CorrectionTable(TM correctionTableModel) {
        super((TableModel)correctionTableModel);
        int correctionsSize = ((CorrectionTableModel)correctionTableModel).getCorrections().size();
        int lines = correctionsSize > 10 ? 10 : correctionsSize;
        this.setPreferredScrollableViewportSize(new Dimension(400, lines * this.getRowHeight()));
        this.getColumnModel().getColumn(((CorrectionTableModel)correctionTableModel).getApplyColumn()).setPreferredWidth(40);
        this.setRowSelectionAllowed(false);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (((CorrectionTableModel)this.getCorrectionTableModel()).isBoldCell(row, column)) {
            if (boldRenderer == null) {
                boldRenderer = new BoldRenderer();
            }
            return boldRenderer;
        }
        return super.getCellRenderer(row, column);
    }

    public TM getCorrectionTableModel() {
        return (TM)((CorrectionTableModel)this.getModel());
    }

    public static class BoldRenderer
    extends JLabel
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Font f = this.getFont();
            this.setFont(new Font(f.getName(), f.getStyle() | 1, f.getSize()));
            this.setText((String)value);
            return this;
        }
    }
}

