/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UrlLabel;

public class AboutAction
extends JosmAction {
    public AboutAction() {
        super(I18n.tr("About"), "about", I18n.tr("Display the about screen."), Shortcut.registerShortcut("system:about", I18n.tr("About"), 112, 5, 1), true);
    }

    public void actionPerformed(ActionEvent e) {
        JTabbedPane about = new JTabbedPane();
        JTextArea readme = new JTextArea();
        readme.setEditable(false);
        readme.setText(Version.loadResourceFile(Main.class.getResource("/README")));
        JTextArea contribution = new JTextArea();
        contribution.setEditable(false);
        contribution.setText(Version.loadResourceFile(Main.class.getResource("/CONTRIBUTION")));
        JTextArea license = new JTextArea();
        license.setEditable(false);
        license.setText(Version.loadResourceFile(Main.class.getResource("/LICENSE")));
        Version version = Version.getInstance();
        JPanel info = new JPanel(new GridBagLayout());
        JLabel caption = new JLabel("JOSM - " + I18n.tr("Java OpenStreetMap Editor"));
        caption.setFont(new Font("Helvetica", 1, 20));
        info.add((Component)caption, GBC.eol().fill(2).insets(10, 0, 0, 0));
        info.add(GBC.glue(0, 10), GBC.eol());
        info.add((Component)new JLabel(I18n.tr("Version {0}", version.getVersionString())), GBC.eol().fill(2).insets(10, 0, 0, 0));
        info.add(GBC.glue(0, 5), GBC.eol());
        info.add((Component)new JLabel(I18n.tr("Last change at {0}", version.getTime())), GBC.eol().fill(2).insets(10, 0, 0, 0));
        info.add(GBC.glue(0, 5), GBC.eol());
        info.add((Component)new JLabel(I18n.tr("Java Version {0}", System.getProperty("java.version"))), GBC.eol().fill(2).insets(10, 0, 0, 0));
        info.add(GBC.glue(0, 10), GBC.eol());
        info.add((Component)new JLabel(I18n.tr("Homepage")), GBC.std().insets(10, 0, 10, 0));
        info.add((Component)new UrlLabel("http://josm.openstreetmap.de"), GBC.eol().fill(2));
        info.add((Component)new JLabel(I18n.tr("Bug Reports")), GBC.std().insets(10, 0, 10, 0));
        info.add((Component)new UrlLabel("http://josm.openstreetmap.de/newticket"), GBC.eol().fill(2));
        JTextArea revision = new JTextArea();
        revision.setEditable(false);
        revision.setText(version.getReleaseAttributes());
        about.addTab(I18n.tr("Info"), info);
        about.addTab(I18n.tr("Readme"), this.createScrollPane(readme));
        about.addTab(I18n.tr("Revision"), this.createScrollPane(revision));
        about.addTab(I18n.tr("Contribution"), this.createScrollPane(contribution));
        about.addTab(I18n.tr("License"), this.createScrollPane(license));
        about.addTab(I18n.tr("Plugins"), new JScrollPane(PluginHandler.getInfoPanel()));
        about.setPreferredSize(new Dimension(500, 300));
        JOptionPane.showMessageDialog(Main.parent, about, I18n.tr("About JOSM..."), 1, ImageProvider.get("logo"));
    }

    private JScrollPane createScrollPane(JTextArea area) {
        area.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        area.setOpaque(false);
        JScrollPane sp = new JScrollPane(area);
        sp.setBorder(null);
        sp.setOpaque(false);
        return sp;
    }
}

