/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sun.java2d.pipe.AATileGenerator;
import sun.java2d.pisces.PiscesCache;
import sun.java2d.pisces.Renderer;

public final class PiscesTileGenerator
implements AATileGenerator {
    public static final int TILE_SIZE = 32;
    private static final Map<Integer, byte[]> alphaMapsCache = new ConcurrentHashMap<Integer, byte[]>();
    PiscesCache cache;
    int x;
    int y;
    final int maxalpha;
    private final int maxTileAlphaSum;
    byte[] alphaMap;

    public PiscesTileGenerator(Renderer renderer, int n) {
        this.cache = renderer.getCache();
        this.x = this.cache.bboxX0;
        this.y = this.cache.bboxY0;
        this.alphaMap = PiscesTileGenerator.getAlphaMap(n);
        this.maxalpha = n;
        this.maxTileAlphaSum = 1024 * n;
    }

    private static byte[] buildAlphaMap(int n) {
        byte[] byArray = new byte[n + 1];
        int n2 = n >> 2;
        for (int i = 0; i <= n; ++i) {
            byArray[i] = (byte)((i * 255 + n2) / n);
        }
        return byArray;
    }

    public static byte[] getAlphaMap(int n) {
        if (!alphaMapsCache.containsKey(n)) {
            alphaMapsCache.put(n, PiscesTileGenerator.buildAlphaMap(n));
        }
        return alphaMapsCache.get(n);
    }

    public void getBbox(int[] nArray) {
        nArray[0] = this.cache.bboxX0;
        nArray[1] = this.cache.bboxY0;
        nArray[2] = this.cache.bboxX1;
        nArray[3] = this.cache.bboxY1;
    }

    @Override
    public int getTileWidth() {
        return 32;
    }

    @Override
    public int getTileHeight() {
        return 32;
    }

    @Override
    public int getTypicalAlpha() {
        int n = this.cache.alphaSumInTile(this.x, this.y);
        return n == 0 ? 0 : (n == this.maxTileAlphaSum ? 255 : 128);
    }

    @Override
    public void nextTile() {
        if ((this.x += 32) >= this.cache.bboxX1) {
            this.x = this.cache.bboxX0;
            this.y += 32;
        }
    }

    @Override
    public void getAlpha(byte[] byArray, int n, int n2) {
        int n3 = this.x;
        int n4 = n3 + 32;
        int n5 = this.y;
        int n6 = n5 + 32;
        if (n4 > this.cache.bboxX1) {
            n4 = this.cache.bboxX1;
        }
        if (n6 > this.cache.bboxY1) {
            n6 = this.cache.bboxY1;
        }
        n6 -= this.cache.bboxY0;
        int n7 = n;
        for (int i = n5 -= this.cache.bboxY0; i < n6; ++i) {
            int n8;
            int[] nArray = this.cache.rowAARLE[i];
            assert (nArray != null);
            int n9 = this.cache.minTouched(i);
            if (n9 > n4) {
                n9 = n4;
            }
            for (n8 = n3; n8 < n9; ++n8) {
                byArray[n7++] = 0;
            }
            for (n8 = 2; n9 < n4 && n8 < nArray[1]; n8 += 2) {
                byte by;
                int n10 = 0;
                assert (nArray[1] > 2);
                try {
                    by = this.alphaMap[nArray[n8]];
                    n10 = nArray[n8 + 1];
                    assert (n10 > 0);
                }
                catch (RuntimeException runtimeException) {
                    System.out.println("maxalpha = " + this.maxalpha);
                    System.out.println("tile[" + n3 + ", " + n5 + " => " + n4 + ", " + n6 + "]");
                    System.out.println("cx = " + n9 + ", cy = " + i);
                    System.out.println("idx = " + n7 + ", pos = " + n8);
                    System.out.println("len = " + n10);
                    System.out.print(this.cache.toString());
                    runtimeException.printStackTrace();
                    System.exit(1);
                    return;
                }
                int n11 = n9;
                int n12 = n9 += n10;
                if (n11 < n3) {
                    n11 = n3;
                }
                if (n12 > n4) {
                    n12 = n4;
                }
                n10 = n12 - n11;
                while (--n10 >= 0) {
                    try {
                        byArray[n7++] = by;
                    }
                    catch (RuntimeException runtimeException) {
                        System.out.println("maxalpha = " + this.maxalpha);
                        System.out.println("tile[" + n3 + ", " + n5 + " => " + n4 + ", " + n6 + "]");
                        System.out.println("cx = " + n9 + ", cy = " + i);
                        System.out.println("idx = " + n7 + ", pos = " + n8);
                        System.out.println("rx0 = " + n11 + ", rx1 = " + n12);
                        System.out.println("len = " + n10);
                        System.out.print(this.cache.toString());
                        runtimeException.printStackTrace();
                        System.exit(1);
                        return;
                    }
                }
            }
            if (n9 < n3) {
                n9 = n3;
            }
            while (n9 < n4) {
                byArray[n7++] = 0;
                ++n9;
            }
            n7 += n2 - (n4 - n3);
        }
        this.nextTile();
    }

    static String hex(int n, int n2) {
        String string = Integer.toHexString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string.substring(0, n2);
    }

    @Override
    public void dispose() {
    }
}

