/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file.attribute;

import java.io.IOException;
import java.nio.file.FileRef;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileStoreSpaceAttributeView;
import java.nio.file.attribute.FileStoreSpaceAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.List;
import java.util.Set;

public final class Attributes {
    private Attributes() {
    }

    public static BasicFileAttributes readBasicFileAttributes(FileRef fileRef, LinkOption ... linkOptionArray) throws IOException {
        return fileRef.getFileAttributeView(BasicFileAttributeView.class, linkOptionArray).readAttributes();
    }

    public static PosixFileAttributes readPosixFileAttributes(FileRef fileRef, LinkOption ... linkOptionArray) throws IOException {
        PosixFileAttributeView posixFileAttributeView = fileRef.getFileAttributeView(PosixFileAttributeView.class, linkOptionArray);
        if (posixFileAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        return posixFileAttributeView.readAttributes();
    }

    public static DosFileAttributes readDosFileAttributes(FileRef fileRef, LinkOption ... linkOptionArray) throws IOException {
        DosFileAttributeView dosFileAttributeView = fileRef.getFileAttributeView(DosFileAttributeView.class, linkOptionArray);
        if (dosFileAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        return dosFileAttributeView.readAttributes();
    }

    public static UserPrincipal getOwner(FileRef fileRef) throws IOException {
        FileOwnerAttributeView fileOwnerAttributeView = fileRef.getFileAttributeView(FileOwnerAttributeView.class, new LinkOption[0]);
        if (fileOwnerAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        return fileOwnerAttributeView.getOwner();
    }

    public static void setOwner(FileRef fileRef, UserPrincipal userPrincipal) throws IOException {
        FileOwnerAttributeView fileOwnerAttributeView = fileRef.getFileAttributeView(FileOwnerAttributeView.class, new LinkOption[0]);
        if (fileOwnerAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        fileOwnerAttributeView.setOwner(userPrincipal);
    }

    public static List<AclEntry> getAcl(FileRef fileRef) throws IOException {
        AclFileAttributeView aclFileAttributeView = fileRef.getFileAttributeView(AclFileAttributeView.class, new LinkOption[0]);
        if (aclFileAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        return aclFileAttributeView.getAcl();
    }

    public static void setAcl(FileRef fileRef, List<AclEntry> list) throws IOException {
        AclFileAttributeView aclFileAttributeView = fileRef.getFileAttributeView(AclFileAttributeView.class, new LinkOption[0]);
        if (aclFileAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        aclFileAttributeView.setAcl(list);
    }

    public static void setLastModifiedTime(FileRef fileRef, FileTime fileTime) throws IOException {
        if (fileTime == null) {
            throw new NullPointerException("'lastModifiedTime' is null");
        }
        fileRef.getFileAttributeView(BasicFileAttributeView.class, new LinkOption[0]).setTimes(fileTime, null, null);
    }

    public static void setLastAccessTime(FileRef fileRef, FileTime fileTime) throws IOException {
        if (fileTime == null) {
            throw new NullPointerException("'lastAccessTime' is null");
        }
        fileRef.getFileAttributeView(BasicFileAttributeView.class, new LinkOption[0]).setTimes(null, fileTime, null);
    }

    public static void setPosixFilePermissions(FileRef fileRef, Set<PosixFilePermission> set) throws IOException {
        PosixFileAttributeView posixFileAttributeView = fileRef.getFileAttributeView(PosixFileAttributeView.class, new LinkOption[0]);
        if (posixFileAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        posixFileAttributeView.setPermissions(set);
    }

    public static FileStoreSpaceAttributes readFileStoreSpaceAttributes(FileStore fileStore) throws IOException {
        FileStoreSpaceAttributeView fileStoreSpaceAttributeView = fileStore.getFileStoreAttributeView(FileStoreSpaceAttributeView.class);
        if (fileStoreSpaceAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        return fileStoreSpaceAttributeView.readAttributes();
    }
}

