/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.nio.BufferPoolMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.PlatformLoggingMXBean;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import sun.management.ManagementFactoryHelper;
import sun.management.Util;

enum PlatformComponent {
    CLASS_LOADING("java.lang.management.ClassLoadingMXBean", "java.lang", "ClassLoading", PlatformComponent.defaultKeyProperties(), new MXBeanFetcher<ClassLoadingMXBean>(){

        @Override
        public List<ClassLoadingMXBean> getMXBeans() {
            return Collections.singletonList(ManagementFactoryHelper.getClassLoadingMXBean());
        }
    }),
    COMPILATION("java.lang.management.CompilationMXBean", "java.lang", "Compilation", PlatformComponent.defaultKeyProperties(), new MXBeanFetcher<CompilationMXBean>(){

        @Override
        public List<CompilationMXBean> getMXBeans() {
            CompilationMXBean compilationMXBean = ManagementFactoryHelper.getCompilationMXBean();
            if (compilationMXBean == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(compilationMXBean);
        }
    }),
    MEMORY("java.lang.management.MemoryMXBean", "java.lang", "Memory", PlatformComponent.defaultKeyProperties(), new MXBeanFetcher<MemoryMXBean>(){

        @Override
        public List<MemoryMXBean> getMXBeans() {
            return Collections.singletonList(ManagementFactoryHelper.getMemoryMXBean());
        }
    }),
    GARBAGE_COLLECTOR("java.lang.management.GarbageCollectorMXBean", "java.lang", "GarbageCollector", PlatformComponent.keyProperties("name"), new MXBeanFetcher<GarbageCollectorMXBean>(){

        @Override
        public List<GarbageCollectorMXBean> getMXBeans() {
            return ManagementFactoryHelper.getGarbageCollectorMXBeans();
        }
    }),
    MEMORY_MANAGER("java.lang.management.MemoryManagerMXBean", "java.lang", "MemoryManager", PlatformComponent.keyProperties("name"), new MXBeanFetcher<MemoryManagerMXBean>(){

        @Override
        public List<MemoryManagerMXBean> getMXBeans() {
            return ManagementFactoryHelper.getMemoryManagerMXBeans();
        }
    }, GARBAGE_COLLECTOR),
    MEMORY_POOL("java.lang.management.MemoryPoolMXBean", "java.lang", "MemoryPool", PlatformComponent.keyProperties("name"), new MXBeanFetcher<MemoryPoolMXBean>(){

        @Override
        public List<MemoryPoolMXBean> getMXBeans() {
            return ManagementFactoryHelper.getMemoryPoolMXBeans();
        }
    }),
    OPERATING_SYSTEM("java.lang.management.OperatingSystemMXBean", "java.lang", "OperatingSystem", PlatformComponent.defaultKeyProperties(), new MXBeanFetcher<OperatingSystemMXBean>(){

        @Override
        public List<OperatingSystemMXBean> getMXBeans() {
            return Collections.singletonList(ManagementFactoryHelper.getOperatingSystemMXBean());
        }
    }),
    RUNTIME("java.lang.management.RuntimeMXBean", "java.lang", "Runtime", PlatformComponent.defaultKeyProperties(), new MXBeanFetcher<RuntimeMXBean>(){

        @Override
        public List<RuntimeMXBean> getMXBeans() {
            return Collections.singletonList(ManagementFactoryHelper.getRuntimeMXBean());
        }
    }),
    THREADING("java.lang.management.ThreadMXBean", "java.lang", "Threading", PlatformComponent.defaultKeyProperties(), new MXBeanFetcher<ThreadMXBean>(){

        @Override
        public List<ThreadMXBean> getMXBeans() {
            return Collections.singletonList(ManagementFactoryHelper.getThreadMXBean());
        }
    }),
    LOGGING("java.util.logging.PlatformLoggingMXBean", "java.util.logging", "Logging", PlatformComponent.defaultKeyProperties(), new MXBeanFetcher<PlatformLoggingMXBean>(){

        @Override
        public List<PlatformLoggingMXBean> getMXBeans() {
            return ManagementFactoryHelper.getLoggingMXBean();
        }
    }),
    BUFFER_POOL("java.nio.BufferPoolMXBean", "java.nio", "BufferPool", PlatformComponent.keyProperties("name"), new MXBeanFetcher<BufferPoolMXBean>(){

        @Override
        public List<BufferPoolMXBean> getMXBeans() {
            return ManagementFactoryHelper.getBufferPoolMXBeans();
        }
    }),
    SUN_GARBAGE_COLLECTOR("com.sun.management.GarbageCollectorMXBean", "java.lang", "GarbageCollector", PlatformComponent.keyProperties("name"), new MXBeanFetcher<com.sun.management.GarbageCollectorMXBean>(){

        @Override
        public List<com.sun.management.GarbageCollectorMXBean> getMXBeans() {
            return PlatformComponent.getGcMXBeanList(com.sun.management.GarbageCollectorMXBean.class);
        }
    }),
    SUN_OPERATING_SYSTEM("com.sun.management.OperatingSystemMXBean", "java.lang", "OperatingSystem", PlatformComponent.defaultKeyProperties(), new MXBeanFetcher<com.sun.management.OperatingSystemMXBean>(){

        @Override
        public List<com.sun.management.OperatingSystemMXBean> getMXBeans() {
            return PlatformComponent.getOSMXBeanList(com.sun.management.OperatingSystemMXBean.class);
        }
    }),
    SUN_UNIX_OPERATING_SYSTEM("com.sun.management.UnixOperatingSystemMXBean", "java.lang", "OperatingSystem", PlatformComponent.defaultKeyProperties(), new MXBeanFetcher<UnixOperatingSystemMXBean>(){

        @Override
        public List<UnixOperatingSystemMXBean> getMXBeans() {
            return PlatformComponent.getOSMXBeanList(UnixOperatingSystemMXBean.class);
        }
    }),
    HOTSPOT_DIAGNOSTIC("com.sun.management.HotSpotDiagnosticMXBean", "com.sun.management", "HotSpotDiagnostic", PlatformComponent.defaultKeyProperties(), new MXBeanFetcher<HotSpotDiagnosticMXBean>(){

        @Override
        public List<HotSpotDiagnosticMXBean> getMXBeans() {
            return Collections.singletonList(ManagementFactoryHelper.getDiagnosticMXBean());
        }
    });

    private final String mxbeanInterfaceName;
    private final String domain;
    private final String type;
    private final Set<String> keyProperties;
    private final MXBeanFetcher fetcher;
    private final PlatformComponent[] subComponents;
    private static Set<String> defaultKeyProps;
    private static final long serialVersionUID = 6992337162326171013L;

    private static <T extends GarbageCollectorMXBean> List<T> getGcMXBeanList(Class<T> clazz) {
        List<GarbageCollectorMXBean> list = ManagementFactoryHelper.getGarbageCollectorMXBeans();
        ArrayList<T> arrayList = new ArrayList<T>(list.size());
        for (GarbageCollectorMXBean garbageCollectorMXBean : list) {
            if (!clazz.isInstance(garbageCollectorMXBean)) continue;
            arrayList.add(clazz.cast(garbageCollectorMXBean));
        }
        return arrayList;
    }

    private static <T extends OperatingSystemMXBean> List<T> getOSMXBeanList(Class<T> clazz) {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactoryHelper.getOperatingSystemMXBean();
        if (clazz.isInstance(operatingSystemMXBean)) {
            return Collections.singletonList(clazz.cast(operatingSystemMXBean));
        }
        return Collections.emptyList();
    }

    private PlatformComponent(String string2, String string3, String string4, Set<String> set, MXBeanFetcher mXBeanFetcher) {
        this.mxbeanInterfaceName = string2;
        this.domain = string3;
        this.type = string4;
        this.keyProperties = set;
        this.fetcher = mXBeanFetcher;
        this.subComponents = new PlatformComponent[0];
    }

    private PlatformComponent(String string2, String string3, String string4, Set<String> set, MXBeanFetcher mXBeanFetcher, PlatformComponent ... platformComponentArray) {
        this.mxbeanInterfaceName = string2;
        this.domain = string3;
        this.type = string4;
        this.keyProperties = set;
        this.fetcher = mXBeanFetcher;
        this.subComponents = platformComponentArray;
    }

    private static Set<String> defaultKeyProperties() {
        if (defaultKeyProps == null) {
            defaultKeyProps = Collections.singleton("type");
        }
        return defaultKeyProps;
    }

    private static Set<String> keyProperties(String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("type");
        for (String string : stringArray) {
            hashSet.add(string);
        }
        return hashSet;
    }

    String getMXBeanInterfaceName() {
        return this.mxbeanInterfaceName;
    }

    Class<? extends PlatformManagedObject> getMXBeanInterface() {
        try {
            return Class.forName(this.mxbeanInterfaceName, false, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
    }

    <T extends PlatformManagedObject> List<T> getMXBeans(Class<T> clazz) {
        return this.fetcher.getMXBeans();
    }

    <T extends PlatformManagedObject> List<T> getMXBeans(MBeanServerConnection mBeanServerConnection, Class<T> clazz) throws IOException {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (ObjectName objectName : this.getObjectNames(mBeanServerConnection)) {
            arrayList.add(ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, objectName.getCanonicalName(), clazz));
        }
        return arrayList;
    }

    private Set<ObjectName> getObjectNames(MBeanServerConnection mBeanServerConnection) throws IOException {
        String string = this.domain + ":type=" + this.type;
        if (this.keyProperties.size() > 1) {
            string = string + ",*";
        }
        ObjectName objectName = Util.newObjectName(string);
        Set<ObjectName> set = mBeanServerConnection.queryNames(objectName, null);
        for (PlatformComponent platformComponent : this.subComponents) {
            set.addAll(platformComponent.getObjectNames(mBeanServerConnection));
        }
        return set;
    }

    static interface MXBeanFetcher<T extends PlatformManagedObject> {
        public List<T> getMXBeans();
    }
}

