/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.encoding.CDRInputObject;
import com.sun.corba.se.impl.encoding.CDROutputObject;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.protocol.CorbaMessageMediatorImpl;
import com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.se.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.se.pept.broker.Broker;
import com.sun.corba.se.pept.encoding.InputObject;
import com.sun.corba.se.pept.encoding.OutputObject;
import com.sun.corba.se.pept.protocol.ClientRequestDispatcher;
import com.sun.corba.se.pept.protocol.MessageMediator;
import com.sun.corba.se.pept.transport.Connection;
import com.sun.corba.se.pept.transport.ContactInfo;
import com.sun.corba.se.pept.transport.ContactInfoList;
import com.sun.corba.se.pept.transport.OutboundConnectionCache;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.ior.iiop.IIOPProfile;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.protocol.CorbaMessageMediator;
import com.sun.corba.se.spi.protocol.RequestDispatcherRegistry;
import com.sun.corba.se.spi.transport.CorbaConnection;
import com.sun.corba.se.spi.transport.CorbaContactInfo;
import com.sun.corba.se.spi.transport.CorbaContactInfoList;
import java.nio.ByteBuffer;

public abstract class CorbaContactInfoBase
implements CorbaContactInfo {
    protected ORB orb;
    protected CorbaContactInfoList contactInfoList;
    protected IOR effectiveTargetIOR;
    protected short addressingDisposition;
    protected OutboundConnectionCache connectionCache;

    @Override
    public Broker getBroker() {
        return this.orb;
    }

    @Override
    public ContactInfoList getContactInfoList() {
        return this.contactInfoList;
    }

    @Override
    public ClientRequestDispatcher getClientRequestDispatcher() {
        int n = this.getEffectiveProfile().getObjectKeyTemplate().getSubcontractId();
        RequestDispatcherRegistry requestDispatcherRegistry = this.orb.getRequestDispatcherRegistry();
        return requestDispatcherRegistry.getClientRequestDispatcher(n);
    }

    @Override
    public void setConnectionCache(OutboundConnectionCache outboundConnectionCache) {
        this.connectionCache = outboundConnectionCache;
    }

    @Override
    public OutboundConnectionCache getConnectionCache() {
        return this.connectionCache;
    }

    @Override
    public MessageMediator createMessageMediator(Broker broker, ContactInfo contactInfo, Connection connection, String string, boolean bl) {
        CorbaMessageMediatorImpl corbaMessageMediatorImpl = new CorbaMessageMediatorImpl((ORB)broker, contactInfo, connection, GIOPVersion.chooseRequestVersion((ORB)broker, this.effectiveTargetIOR), this.effectiveTargetIOR, ((CorbaConnection)connection).getNextRequestId(), this.getAddressingDisposition(), string, bl);
        return corbaMessageMediatorImpl;
    }

    @Override
    public MessageMediator createMessageMediator(Broker broker, Connection connection) {
        ORB oRB = (ORB)broker;
        CorbaConnection corbaConnection = (CorbaConnection)connection;
        if (oRB.transportDebugFlag) {
            if (corbaConnection.shouldReadGiopHeaderOnly()) {
                this.dprint(".createMessageMediator: waiting for message header on connection: " + corbaConnection);
            } else {
                this.dprint(".createMessageMediator: waiting for message on connection: " + corbaConnection);
            }
        }
        MessageBase messageBase = null;
        messageBase = corbaConnection.shouldReadGiopHeaderOnly() ? MessageBase.readGIOPHeader(oRB, corbaConnection) : MessageBase.readGIOPMessage(oRB, corbaConnection);
        ByteBuffer byteBuffer = messageBase.getByteBuffer();
        messageBase.setByteBuffer(null);
        CorbaMessageMediatorImpl corbaMessageMediatorImpl = new CorbaMessageMediatorImpl(oRB, corbaConnection, messageBase, byteBuffer);
        return corbaMessageMediatorImpl;
    }

    @Override
    public MessageMediator finishCreatingMessageMediator(Broker broker, Connection connection, MessageMediator messageMediator) {
        ORB oRB = (ORB)broker;
        CorbaConnection corbaConnection = (CorbaConnection)connection;
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        if (oRB.transportDebugFlag) {
            this.dprint(".finishCreatingMessageMediator: waiting for message body on connection: " + corbaConnection);
        }
        Message message = corbaMessageMediator.getDispatchHeader();
        message.setByteBuffer(corbaMessageMediator.getDispatchBuffer());
        message = MessageBase.readGIOPBody(oRB, corbaConnection, message);
        ByteBuffer byteBuffer = message.getByteBuffer();
        message.setByteBuffer(null);
        corbaMessageMediator.setDispatchHeader(message);
        corbaMessageMediator.setDispatchBuffer(byteBuffer);
        return corbaMessageMediator;
    }

    @Override
    public OutputObject createOutputObject(MessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        CDROutputObject cDROutputObject = new CDROutputObject(this.orb, messageMediator, corbaMessageMediator.getRequestHeader(), corbaMessageMediator.getStreamFormatVersion());
        messageMediator.setOutputObject(cDROutputObject);
        return cDROutputObject;
    }

    @Override
    public InputObject createInputObject(Broker broker, MessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        return new CDRInputObject((ORB)broker, (CorbaConnection)messageMediator.getConnection(), corbaMessageMediator.getDispatchBuffer(), corbaMessageMediator.getDispatchHeader());
    }

    @Override
    public short getAddressingDisposition() {
        return this.addressingDisposition;
    }

    @Override
    public void setAddressingDisposition(short s) {
        this.addressingDisposition = s;
    }

    @Override
    public IOR getTargetIOR() {
        return this.contactInfoList.getTargetIOR();
    }

    @Override
    public IOR getEffectiveTargetIOR() {
        return this.effectiveTargetIOR;
    }

    @Override
    public IIOPProfile getEffectiveProfile() {
        return this.effectiveTargetIOR.getProfile();
    }

    public String toString() {
        return "CorbaContactInfoBase[]";
    }

    protected void dprint(String string) {
        ORBUtility.dprint("CorbaContactInfoBase", string);
    }
}

