/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.ui.EditableAtEndDocument;
import sun.jvm.hotspot.ui.GraphicsUtilities;
import sun.jvm.hotspot.utilities.Assert;

public class DebuggerConsolePanel
extends JPanel {
    private Debugger debugger;
    private JTextComponent editor;
    private boolean updating;
    private int mark;
    private String curText;
    private static final boolean DEBUGGING = false;

    public DebuggerConsolePanel(Debugger debugger) {
        this.debugger = debugger;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(debugger.hasConsole(), "should not create a DebuggerConsolePanel for non-console debuggers");
        }
        this.setLayout(new BorderLayout());
        this.editor = new JTextArea();
        this.editor.setDocument(new EditableAtEndDocument());
        this.editor.setFont(GraphicsUtilities.lookupFont("Courier"));
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(this.editor);
        this.add((Component)scroller, "Center");
        this.editor.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                if (DebuggerConsolePanel.this.updating) {
                    return;
                }
                DebuggerConsolePanel.this.beginUpdate();
                DebuggerConsolePanel.this.editor.setCaretPosition(DebuggerConsolePanel.this.editor.getDocument().getLength());
                if (DebuggerConsolePanel.this.insertContains(e, '\n')) {
                    String cmd = DebuggerConsolePanel.this.getMarkedText();
                    if (cmd.length() == 0 || cmd.charAt(cmd.length() - 1) != '\\') {
                        cmd = DebuggerConsolePanel.this.trimContinuations(cmd);
                        final String result = DebuggerConsolePanel.this.debugger.consoleExecuteCommand(cmd);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                DebuggerConsolePanel.this.print(result);
                                DebuggerConsolePanel.this.printPrompt();
                                DebuggerConsolePanel.this.setMark();
                                DebuggerConsolePanel.this.endUpdate();
                            }
                        });
                    }
                } else {
                    DebuggerConsolePanel.this.endUpdate();
                }
            }

            public void removeUpdate(DocumentEvent e) {
            }
        });
        this.editor.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                int len = DebuggerConsolePanel.this.editor.getDocument().getLength();
                if (e.getDot() > len) {
                    DebuggerConsolePanel.this.editor.setCaretPosition(len);
                }
            }
        });
        Box hbox = Box.createHorizontalBox();
        hbox.add(Box.createGlue());
        JButton button = new JButton("Clear Saved Text");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebuggerConsolePanel.this.clear();
            }
        });
        hbox.add(button);
        hbox.add(Box.createGlue());
        this.add((Component)hbox, "South");
        this.clear();
    }

    public void requestFocus() {
        this.editor.requestFocus();
    }

    public void clear() {
        EditableAtEndDocument d = (EditableAtEndDocument)this.editor.getDocument();
        d.clear();
        this.printPrompt();
        this.setMark();
        this.editor.requestFocus();
    }

    public void setMark() {
        ((EditableAtEndDocument)this.editor.getDocument()).setMark();
    }

    public String getMarkedText() {
        try {
            int i;
            String s = ((EditableAtEndDocument)this.editor.getDocument()).getMarkedText();
            for (i = s.length(); i > 0 && s.charAt(i - 1) == '\n'; --i) {
            }
            return s.substring(0, i);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void beginUpdate() {
        this.updating = true;
    }

    private void endUpdate() {
        this.updating = false;
    }

    private void print(String s) {
        Document d = this.editor.getDocument();
        try {
            d.insertString(d.getLength(), s, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void printPrompt() {
        this.print(this.debugger.getConsolePrompt());
    }

    private boolean insertContains(DocumentEvent e, char c) {
        String s = null;
        try {
            s = this.editor.getText(e.getOffset(), e.getLength());
            for (int i = 0; i < e.getLength(); ++i) {
                if (s.charAt(i) != c) continue;
                return true;
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private String trimContinuations(String text) {
        int i;
        while ((i = text.indexOf("\\\n")) >= 0) {
            text = text.substring(0, i) + text.substring(i + 2, text.length());
        }
        return text;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        DebuggerConsolePanel panel = new DebuggerConsolePanel(null);
        frame.getContentPane().add((Component)panel, "Center");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setSize(500, 500);
        frame.setVisible(true);
        panel.requestFocus();
    }
}

