/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import sun.jvm.hotspot.oops.BooleanField;
import sun.jvm.hotspot.oops.ByteField;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.CharField;
import sun.jvm.hotspot.oops.DoubleField;
import sun.jvm.hotspot.oops.Field;
import sun.jvm.hotspot.oops.FloatField;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.NarrowOopField;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.oops.ShortField;

public class OopPrinter
implements OopVisitor {
    PrintStream tty;
    private Oop obj;

    public OopPrinter(PrintStream tty) {
        this.tty = tty;
    }

    public void prologue() {
        Oop.printOopValueOn(this.getObj(), this.tty);
        this.tty.println(" (object size = " + this.getObj().getObjectSize() + ")");
    }

    public void epilogue() {
        this.tty.println();
    }

    public void setObj(Oop obj) {
        this.obj = obj;
    }

    public Oop getObj() {
        return this.obj;
    }

    private void printField(Field field) {
        field.printOn(this.tty);
    }

    public void doOop(OopField field, boolean isVMField) {
        this.printField(field);
        Oop.printOopValueOn(field.getValue(this.getObj()), this.tty);
        this.tty.println();
    }

    public void doOop(NarrowOopField field, boolean isVMField) {
        this.printField(field);
        Oop.printOopValueOn(field.getValue(this.getObj()), this.tty);
        this.tty.println();
    }

    public void doChar(CharField field, boolean isVMField) {
        this.printField(field);
        char c = field.getValue(this.getObj());
        if (Character.isLetterOrDigit(c)) {
            this.tty.println(c);
        } else {
            this.tty.println((int)c);
        }
    }

    public void doByte(ByteField field, boolean isVMField) {
        this.printField(field);
        this.tty.println(field.getValue(this.getObj()));
    }

    public void doBoolean(BooleanField field, boolean isVMField) {
        this.printField(field);
        this.tty.println(field.getValue(this.getObj()));
    }

    public void doShort(ShortField field, boolean isVMField) {
        this.printField(field);
        this.tty.println(field.getValue(this.getObj()));
    }

    public void doInt(IntField field, boolean isVMField) {
        this.printField(field);
        this.tty.println(field.getValue(this.getObj()));
    }

    public void doLong(LongField field, boolean isVMField) {
        this.printField(field);
        this.tty.println(field.getValue(this.getObj()));
    }

    public void doFloat(FloatField field, boolean isVMField) {
        this.printField(field);
        this.tty.println(field.getValue(this.getObj()));
    }

    public void doDouble(DoubleField field, boolean isVMField) {
        this.printField(field);
        this.tty.println(field.getValue(this.getObj()));
    }

    public void doCInt(CIntField field, boolean isVMField) {
        this.printField(field);
        this.tty.println(field.getValue(this.getObj()));
    }
}

