/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.InternalException;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.jdi.SAJDIClassLoader;

abstract class ConnectorImpl
implements Connector {
    Map defaultArguments = new LinkedHashMap();
    static String trueString = null;
    static String falseString;
    private static List freeVMClasses;
    private static ClassLoader myLoader;
    protected static final boolean DEBUG;

    ConnectorImpl() {
    }

    private static synchronized void addFreeVMImplClass(Class clazz) {
        if (DEBUG) {
            System.out.println("adding free VirtualMachineImpl class");
        }
        freeVMClasses.add(new SoftReference<Class>(clazz));
    }

    private static synchronized Class getFreeVMImplClass() {
        while (!freeVMClasses.isEmpty()) {
            SoftReference ref = (SoftReference)freeVMClasses.remove(0);
            Object o = ref.get();
            if (o == null) continue;
            if (DEBUG) {
                System.out.println("re-using loaded VirtualMachineImpl");
            }
            return (Class)o;
        }
        return null;
    }

    private static Class getVMImplClassFrom(ClassLoader cl) throws ClassNotFoundException {
        return Class.forName("sun.jvm.hotspot.jdi.VirtualMachineImpl", true, cl);
    }

    protected static Class loadVirtualMachineImplClass() throws ClassNotFoundException {
        Class vmImplClass = ConnectorImpl.getFreeVMImplClass();
        if (vmImplClass == null) {
            SAJDIClassLoader cl = new SAJDIClassLoader(myLoader);
            vmImplClass = ConnectorImpl.getVMImplClassFrom(cl);
        }
        return vmImplClass;
    }

    private static String getSAClassPathForVM(String vmVersion) {
        String prefix = "sun.jvm.hotspot.jdi.";
        String jvmHome = System.getProperty("sun.jvm.hotspot.jdi." + vmVersion);
        if (DEBUG) {
            System.out.println("looking for System property sun.jvm.hotspot.jdi." + vmVersion);
        }
        if (jvmHome == null) {
            int index = vmVersion.indexOf(45);
            if (index != -1) {
                vmVersion = vmVersion.substring(0, index);
                if (DEBUG) {
                    System.out.println("looking for System property sun.jvm.hotspot.jdi." + vmVersion);
                }
                jvmHome = System.getProperty("sun.jvm.hotspot.jdi." + vmVersion);
            }
            if (jvmHome == null) {
                if (DEBUG) {
                    System.out.println("can't locate JDK home for " + vmVersion);
                }
                return null;
            }
        }
        if (DEBUG) {
            System.out.println("JDK home for " + vmVersion + " is " + jvmHome);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(jvmHome);
        buf.append(File.separatorChar);
        buf.append("lib");
        buf.append(File.separatorChar);
        buf.append("sa-jdi.jar");
        return buf.toString();
    }

    protected static Class loadVirtualMachineImplClass(String vmVersion) throws ClassNotFoundException {
        String classPath;
        if (DEBUG) {
            System.out.println("attemping to load sa-jdi.jar for version " + vmVersion);
        }
        if ((classPath = ConnectorImpl.getSAClassPathForVM(vmVersion)) != null) {
            SAJDIClassLoader cl = new SAJDIClassLoader(myLoader, classPath);
            return ConnectorImpl.getVMImplClassFrom(cl);
        }
        return null;
    }

    private static boolean isVMVersionMismatch(Throwable throwable) {
        String className = throwable.getClass().getName();
        return className.equals("sun.jvm.hotspot.runtime.VMVersionMismatchException");
    }

    private static String getVMVersion(Throwable throwable) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> expClass = throwable.getClass();
        Method targetVersionMethod = expClass.getMethod("getTargetVersion", new Class[0]);
        return (String)targetVersionMethod.invoke((Object)throwable, null);
    }

    protected static Class handleVMVersionMismatch(InvocationTargetException ite) {
        Throwable cause = ite.getCause();
        if (DEBUG) {
            System.out.println("checking for version mismatch...");
        }
        while (cause != null) {
            try {
                if (ConnectorImpl.isVMVersionMismatch(cause)) {
                    if (DEBUG) {
                        System.out.println("Triggering cross VM version support...");
                    }
                    return ConnectorImpl.loadVirtualMachineImplClass(ConnectorImpl.getVMVersion(cause));
                }
            }
            catch (Exception exp) {
                if (DEBUG) {
                    System.out.println("failed to load VirtualMachineImpl class");
                    exp.printStackTrace();
                }
                return null;
            }
            cause = cause.getCause();
        }
        return null;
    }

    protected void checkNativeLink(SecurityManager sm, String os) {
        if (os.equals("SunOS") || os.equals("Linux")) {
            sm.checkLink("saproc");
        } else if (os.startsWith("Windows")) {
            sm.checkLink("sawindbg");
        } else {
            throw new RuntimeException(os + " is not yet supported");
        }
    }

    protected static void setVMDisposeObserver(final Object vm) {
        block2: {
            try {
                Method setDisposeObserverMethod = vm.getClass().getDeclaredMethod("setDisposeObserver", Observer.class);
                setDisposeObserverMethod.setAccessible(true);
                setDisposeObserverMethod.invoke(vm, new Observer(){

                    public void update(Observable o, Object data) {
                        if (DEBUG) {
                            System.out.println("got VM.dispose notification");
                        }
                        ConnectorImpl.addFreeVMImplClass(vm.getClass());
                    }
                });
            }
            catch (Exception exp) {
                if (!DEBUG) break block2;
                System.out.println("setVMDisposeObserver() got an exception:");
                exp.printStackTrace();
            }
        }
    }

    public Map defaultArguments() {
        LinkedHashMap<String, Object> defaults = new LinkedHashMap<String, Object>();
        Collection values = this.defaultArguments.values();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            ArgumentImpl argument = (ArgumentImpl)iter.next();
            defaults.put(argument.name(), argument.clone());
        }
        return defaults;
    }

    void addStringArgument(String name, String label, String description, String defaultValue, boolean mustSpecify) {
        this.defaultArguments.put(name, new StringArgumentImpl(name, label, description, defaultValue, mustSpecify));
    }

    void addBooleanArgument(String name, String label, String description, boolean defaultValue, boolean mustSpecify) {
        this.defaultArguments.put(name, new BooleanArgumentImpl(name, label, description, defaultValue, mustSpecify));
    }

    void addIntegerArgument(String name, String label, String description, String defaultValue, boolean mustSpecify, int min, int max) {
        this.defaultArguments.put(name, new IntegerArgumentImpl(name, label, description, defaultValue, mustSpecify, min, max));
    }

    void addSelectedArgument(String name, String label, String description, String defaultValue, boolean mustSpecify, List list) {
        this.defaultArguments.put(name, new SelectedArgumentImpl(name, label, description, defaultValue, mustSpecify, list));
    }

    ArgumentImpl argument(String name, Map arguments) throws IllegalConnectorArgumentsException {
        ArgumentImpl argument = (ArgumentImpl)arguments.get(name);
        if (argument == null) {
            throw new IllegalConnectorArgumentsException("Argument missing", name);
        }
        String value = argument.value();
        if (value == null || value.length() == 0) {
            if (argument.mustSpecify()) {
                throw new IllegalConnectorArgumentsException("Argument unspecified", name);
            }
        } else if (!argument.isValid(value)) {
            throw new IllegalConnectorArgumentsException("Argument invalid", name);
        }
        return argument;
    }

    String getString(String key) {
        return key;
    }

    public String toString() {
        String string = this.name() + " (defaults: ";
        Iterator iter = this.defaultArguments().values().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            ArgumentImpl argument = (ArgumentImpl)iter.next();
            if (!first) {
                string = string + ", ";
            }
            string = string + argument.toString();
            first = false;
        }
        return string + ")";
    }

    static {
        myLoader = ConnectorImpl.class.getClassLoader();
        freeVMClasses = new ArrayList(0);
        DEBUG = System.getProperty("sun.jvm.hotspot.jdi.ConnectorImpl.DEBUG") != null;
    }

    class SelectedArgumentImpl
    extends ArgumentImpl
    implements Connector.SelectedArgument {
        private final List choices;

        SelectedArgumentImpl(String name, String label, String description, String value, boolean mustSpecify, List choices) {
            super(name, label, description, value, mustSpecify);
            this.choices = Collections.unmodifiableList(new ArrayList(choices));
        }

        public List choices() {
            return this.choices;
        }

        public boolean isValid(String value) {
            return this.choices.contains(value);
        }
    }

    class StringArgumentImpl
    extends ArgumentImpl
    implements Connector.StringArgument {
        StringArgumentImpl(String name, String label, String description, String value, boolean mustSpecify) {
            super(name, label, description, value, mustSpecify);
        }

        public boolean isValid(String value) {
            return true;
        }
    }

    class IntegerArgumentImpl
    extends ArgumentImpl
    implements Connector.IntegerArgument {
        private final int min;
        private final int max;

        IntegerArgumentImpl(String name, String label, String description, String value, boolean mustSpecify, int min, int max) {
            super(name, label, description, value, mustSpecify);
            this.min = min;
            this.max = max;
        }

        public void setValue(int value) {
            this.setValue(this.stringValueOf(value));
        }

        public boolean isValid(String value) {
            if (value == null) {
                return false;
            }
            try {
                return this.isValid(Integer.decode(value));
            }
            catch (NumberFormatException exc) {
                return false;
            }
        }

        public boolean isValid(int value) {
            return this.min <= value && value <= this.max;
        }

        public String stringValueOf(int value) {
            return "" + value;
        }

        public int intValue() {
            if (this.value() == null) {
                return 0;
            }
            try {
                return Integer.decode(this.value());
            }
            catch (NumberFormatException exc) {
                return 0;
            }
        }

        public int max() {
            return this.max;
        }

        public int min() {
            return this.min;
        }
    }

    class BooleanArgumentImpl
    extends ArgumentImpl
    implements Connector.BooleanArgument {
        BooleanArgumentImpl(String name, String label, String description, boolean value, boolean mustSpecify) {
            super(name, label, description, null, mustSpecify);
            if (trueString == null) {
                trueString = ConnectorImpl.this.getString("true");
                falseString = ConnectorImpl.this.getString("false");
            }
            this.setValue(value);
        }

        public void setValue(boolean value) {
            this.setValue(this.stringValueOf(value));
        }

        public boolean isValid(String value) {
            return value.equals(trueString) || value.equals(falseString);
        }

        public String stringValueOf(boolean value) {
            return value ? trueString : falseString;
        }

        public boolean booleanValue() {
            return this.value().equals(trueString);
        }
    }

    abstract class ArgumentImpl
    implements Connector.Argument,
    Cloneable,
    Serializable {
        private String name;
        private String label;
        private String description;
        private String value;
        private boolean mustSpecify;

        ArgumentImpl(String name, String label, String description, String value, boolean mustSpecify) {
            this.name = name;
            this.label = label;
            this.description = description;
            this.value = value;
            this.mustSpecify = mustSpecify;
        }

        public abstract boolean isValid(String var1);

        public String name() {
            return this.name;
        }

        public String label() {
            return this.label;
        }

        public String description() {
            return this.description;
        }

        public String value() {
            return this.value;
        }

        public void setValue(String value) {
            if (value == null) {
                throw new NullPointerException("Can't set null value");
            }
            this.value = value;
        }

        public boolean mustSpecify() {
            return this.mustSpecify;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof Connector.Argument) {
                Connector.Argument other = (Connector.Argument)obj;
                return this.name().equals(other.name()) && this.description().equals(other.description()) && this.mustSpecify() == other.mustSpecify() && this.value().equals(other.value());
            }
            return false;
        }

        public int hashCode() {
            return this.description().hashCode();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw (InternalException)new InternalException().initCause(e);
            }
        }

        public String toString() {
            return this.name() + "=" + this.value();
        }
    }
}

