/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.cdbg.DebugEvent;

public class BasicDebugEvent
implements DebugEvent {
    private DebugEvent.Type type;
    private ThreadProxy thread;
    private Address pc;
    private Address address;
    private boolean wasWrite;
    private String detail;

    public BasicDebugEvent(DebugEvent.Type type, ThreadProxy thread) {
        this.type = type;
        this.thread = thread;
    }

    public DebugEvent.Type getType() {
        return this.type;
    }

    public ThreadProxy getThread() {
        return this.thread;
    }

    public Address getPC() {
        return this.pc;
    }

    public boolean getWasWrite() {
        return this.wasWrite;
    }

    public Address getAddress() {
        return this.address;
    }

    public String getUnknownEventDetail() {
        return this.detail;
    }

    public void setType(DebugEvent.Type type) {
        this.type = type;
    }

    public void setThread(ThreadProxy thread) {
        this.thread = thread;
    }

    public void setPC(Address pc) {
        this.pc = pc;
    }

    public void setWasWrite(boolean val) {
        this.wasWrite = val;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setUnknownEventDetail(String msg) {
        this.detail = msg;
    }

    public static BasicDebugEvent newLoadObjectLoadEvent(ThreadProxy thread, Address base) {
        return BasicDebugEvent.newAddressEvent(DebugEvent.Type.LOADOBJECT_LOAD, thread, base);
    }

    public static BasicDebugEvent newLoadObjectUnloadEvent(ThreadProxy thread, Address base) {
        return BasicDebugEvent.newAddressEvent(DebugEvent.Type.LOADOBJECT_UNLOAD, thread, base);
    }

    public static BasicDebugEvent newBreakpointEvent(ThreadProxy thread, Address pc) {
        return BasicDebugEvent.newPCEvent(DebugEvent.Type.BREAKPOINT, thread, pc);
    }

    public static BasicDebugEvent newSingleStepEvent(ThreadProxy thread, Address pc) {
        return BasicDebugEvent.newPCEvent(DebugEvent.Type.BREAKPOINT, thread, pc);
    }

    public static BasicDebugEvent newAccessViolationEvent(ThreadProxy thread, Address pc, boolean wasWrite, Address addr) {
        BasicDebugEvent ev = BasicDebugEvent.newPCEvent(DebugEvent.Type.ACCESS_VIOLATION, thread, pc);
        ev.setWasWrite(wasWrite);
        ev.setAddress(addr);
        return ev;
    }

    public static BasicDebugEvent newUnknownEvent(ThreadProxy thread, String detail) {
        BasicDebugEvent ev = new BasicDebugEvent(DebugEvent.Type.UNKNOWN, thread);
        ev.setUnknownEventDetail(detail);
        return ev;
    }

    private static BasicDebugEvent newAddressEvent(DebugEvent.Type type, ThreadProxy thread, Address addr) {
        BasicDebugEvent ev = new BasicDebugEvent(type, thread);
        ev.setAddress(addr);
        return ev;
    }

    private static BasicDebugEvent newPCEvent(DebugEvent.Type type, ThreadProxy thread, Address pc) {
        BasicDebugEvent ev = new BasicDebugEvent(type, thread);
        ev.setPC(pc);
        return ev;
    }
}

