/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.PCRelativeAddress;
import sun.jvm.hotspot.asm.sparc.InstructionDecoder;
import sun.jvm.hotspot.asm.sparc.SPARCInstructionFactory;

abstract class BranchDecoder
extends InstructionDecoder {
    static final String[] integerConditionNames = new String[]{"bn", "be", "ble", "bl", "bleu", "bcs", "bneg", "bvs", "ba", "bne", "bg", "bge", "bgu", "bcc", "bpos", "bvc"};
    static final String[] integerAnnuledConditionNames = new String[]{"bn,a", "be,a", "ble,a", "bl,a", "bleu,a", "bcs,a", "bneg,a", "bvs,a", "ba,a", "bne,a", "bg,a", "bge,a", "bgu,a", "bcc,a", "bpos,a", "bvc,a"};
    static final String[] floatConditionNames = new String[]{"fbn", "fbne", "fblg", "fbul", "fbl", "fbug", "fbg", "fbu", "fba", "fbe", "fbue", "fbge", "fbuge", "fble", "fbule", "fbo"};
    static final String[] floatAnnuledConditionNames = new String[]{"fbn,a", "fbne,a", "fblg,a", "fbul,a", "fbl,a", "fbug,a", "fbg,a", "fbu,a", "fba,a", "fbe,a", "fbue,a", "fbge,a", "fbuge,a", "fble,a", "fbule,a", "fbo,a"};

    BranchDecoder() {
    }

    static boolean getAnnuledBit(int instruction) {
        return (instruction & 0x20000000) != 0;
    }

    Instruction decode(int instruction, SPARCInstructionFactory factory) {
        boolean isAnnuled = BranchDecoder.getAnnuledBit(instruction);
        int conditionCode = BranchDecoder.getConditionCode(instruction);
        String conditionName = this.getConditionName(conditionCode, isAnnuled);
        int offset = BranchDecoder.extractSignedIntFromNBits(instruction, 22);
        PCRelativeAddress addr = new PCRelativeAddress(offset <<= 2);
        return factory.newBranchInstruction(conditionName, addr, isAnnuled, conditionCode);
    }

    abstract String getConditionName(int var1, boolean var2);
}

