/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;

public class SALauncherLoader
extends URLClassLoader {
    private String[] libpaths;

    public String findLibrary(String name) {
        name = System.mapLibraryName(name);
        for (int i = 0; i < this.libpaths.length; ++i) {
            File file = new File(new File(this.libpaths[i]), name);
            if (!file.exists()) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    public SALauncherLoader(ClassLoader parent) {
        super(SALauncherLoader.getClassPath(), parent);
        String salibpath = System.getProperty("sa.library.path");
        this.libpaths = salibpath != null ? salibpath.split(File.pathSeparator) : new String[0];
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz;
        SecurityManager sm;
        int i = name.lastIndexOf(46);
        if (i != -1 && (sm = System.getSecurityManager()) != null) {
            sm.checkPackageAccess(name.substring(0, i));
        }
        if ((clazz = this.findLoadedClass(name)) != null) {
            return clazz;
        }
        try {
            return this.findClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            return super.loadClass(name, resolve);
        }
    }

    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection perms = super.getPermissions(codesource);
        perms.add(new RuntimePermission("exitVM"));
        return perms;
    }

    private static URL[] getClassPath() {
        String s = System.getProperty("java.class.path");
        File[] path = s == null ? new File[]{} : SALauncherLoader.getClassPath(s);
        return SALauncherLoader.pathToURLs(path);
    }

    private static URL[] pathToURLs(File[] path) {
        URL[] urls = new URL[path.length];
        for (int i = 0; i < path.length; ++i) {
            urls[i] = SALauncherLoader.getFileURL(path[i]);
        }
        return urls;
    }

    private static File[] getClassPath(String cp) {
        String[] tmp = cp.split(File.pathSeparator);
        File[] paths = new File[tmp.length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = new File(tmp[i].equals("") ? "." : tmp[i]);
        }
        return paths;
    }

    private static URL getFileURL(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException mue) {
            throw new InternalError(mue.getMessage());
        }
    }
}

