/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import gnu.classpath.SystemProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class BasicMenuItemUI
extends MenuItemUI {
    protected Font acceleratorFont;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    protected Icon arrowIcon;
    protected Icon checkIcon;
    protected int defaultTextIconGap;
    protected Color disabledForeground;
    protected MenuDragMouseListener menuDragMouseListener;
    protected JMenuItem menuItem;
    protected MenuKeyListener menuKeyListener;
    protected MouseInputListener mouseInputListener;
    protected boolean oldBorderPainted;
    protected Color selectionBackground;
    protected Color selectionForeground;
    private String acceleratorDelimiter;
    private ItemListener itemListener;
    private int defaultAcceleratorLabelGap;
    private int MenuGap;
    PropertyChangeHandler propertyChangeListener;
    private Rectangle viewRect;
    private Rectangle textRect;
    private Rectangle accelRect;
    private Rectangle iconRect;
    private Rectangle arrowIconRect;
    private Rectangle checkIconRect;
    private Rectangle cachedRect;

    private /* synthetic */ void finit$() {
        this.defaultTextIconGap = 4;
        this.defaultAcceleratorLabelGap = 10;
        this.MenuGap = 10;
    }

    public BasicMenuItemUI() {
        this.finit$();
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem);
        this.menuKeyListener = this.createMenuKeyListener(this.menuItem);
        this.itemListener = new ItemHandler(this);
        this.propertyChangeListener = new PropertyChangeHandler(this);
        this.viewRect = new Rectangle();
        this.textRect = new Rectangle();
        this.iconRect = new Rectangle();
        this.arrowIconRect = new Rectangle();
        this.checkIconRect = new Rectangle();
        this.accelRect = new Rectangle();
        this.cachedRect = new Rectangle();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler(this);
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler(this);
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler(this);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuItemUI();
    }

    protected void doClick(MenuSelectionManager menuSelectionManager) {
        this.menuItem.doClick();
        menuSelectionManager.clearSelectedPath();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public MenuElement[] getPath() {
        ArrayList arrayList = new ArrayList();
        if (this.menuItem instanceof JMenu) {
            arrayList.add(((JMenu)this.menuItem).getPopupMenu());
        }
        Component component = this.menuItem;
        while (component instanceof MenuElement) {
            arrayList.add(0, component);
            if (component instanceof JPopupMenu) {
                component = ((JPopupMenu)component).getInvoker();
                continue;
            }
            component = component.getParent();
        }
        Object[] objectArray = new MenuElement[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        Serializable serializable;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        String string = this.getAcceleratorString(jMenuItem);
        this.layoutMenuItem(jMenuItem, string);
        this.cachedRect.setBounds(this.textRect);
        Rectangle rectangle = SwingUtilities.computeUnion(this.iconRect.x, this.iconRect.y, this.iconRect.width, this.iconRect.height, this.cachedRect);
        Container container = jMenuItem.getParent();
        if (!(container == null || !(container instanceof JComponent) || jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isTopLevelMenu())) {
            int n2;
            int n3;
            serializable = (JComponent)container;
            Integer n4 = (Integer)((JComponent)serializable).getClientProperty("maxTextWidth");
            int n5 = n3 = n4 == null ? 0 : n4;
            if (rectangle.width < n3) {
                rectangle.width = n3;
            } else {
                ((JComponent)serializable).putClientProperty("maxTextWidth", new Integer(rectangle.width));
            }
            Integer n6 = (Integer)((JComponent)serializable).getClientProperty("maxAccelWidth");
            int n7 = n2 = n6 == null ? 0 : n6;
            if (this.accelRect.width > n2) {
                n2 = this.accelRect.width;
                ((JComponent)serializable).putClientProperty("maxAccelWidth", new Integer(this.accelRect.width));
            }
            rectangle.width += n2;
            rectangle.width += n;
        }
        if (!(jMenuItem instanceof JMenu) || !((JMenu)jMenuItem).isTopLevelMenu()) {
            rectangle.width += this.checkIconRect.width;
            rectangle.width += n;
            rectangle.width += this.arrowIconRect.width;
            rectangle.width += n;
        }
        rectangle.width += 2 * n;
        serializable = jMenuItem.getInsets();
        rectangle.width += ((Insets)serializable).left + ((Insets)serializable).right;
        rectangle.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        return rectangle.getSize();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredMenuItemSize(jComponent, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installComponents(JMenuItem jMenuItem) {
    }

    protected void installDefaults() {
        String string = this.getPropertyPrefix();
        LookAndFeel.installBorder(this.menuItem, string + ".border");
        LookAndFeel.installColorsAndFont(this.menuItem, string + ".background", string + ".foreground", string + ".font");
        this.menuItem.setMargin(UIManager.getInsets(string + ".margin"));
        this.acceleratorFont = UIManager.getFont(string + ".acceleratorFont");
        this.acceleratorForeground = UIManager.getColor(string + ".acceleratorForeground");
        this.acceleratorSelectionForeground = UIManager.getColor(string + ".acceleratorSelectionForeground");
        this.selectionBackground = UIManager.getColor(string + ".selectionBackground");
        this.selectionForeground = UIManager.getColor(string + ".selectionForeground");
        this.acceleratorDelimiter = UIManager.getString(string + ".acceleratorDelimiter");
        this.checkIcon = UIManager.getIcon(string + ".checkIcon");
        this.menuItem.setHorizontalTextPosition(11);
        this.menuItem.setHorizontalAlignment(10);
    }

    protected void installKeyboardActions() {
        KeyStroke keyStroke;
        InputMap inputMap = SwingUtilities.getUIInputMap(this.menuItem, 2);
        if (inputMap == null) {
            inputMap = new ComponentInputMapUIResource(this.menuItem);
        }
        if ((keyStroke = this.menuItem.getAccelerator()) != null) {
            inputMap.put(keyStroke, "doClick");
        }
        SwingUtilities.replaceUIInputMap(this.menuItem, 2, inputMap);
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.menuItem);
        if (actionMap == null) {
            actionMap = new ActionMapUIResource();
        }
        actionMap.put("doClick", new ClickAction(this));
        SwingUtilities.replaceUIActionMap(this.menuItem, actionMap);
    }

    protected void installListeners() {
        this.menuItem.addMouseListener(this.mouseInputListener);
        this.menuItem.addMouseMotionListener(this.mouseInputListener);
        this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.addMenuKeyListener(this.menuKeyListener);
        this.menuItem.addItemListener(this.itemListener);
        this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.menuItem = (JMenuItem)jComponent;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintMenuItem(graphics, jComponent, this.checkIcon, this.arrowIcon, this.selectionBackground, jComponent.getForeground(), this.defaultTextIconGap);
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color2 = graphics.getColor();
        if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, jMenuItem.getWidth(), jMenuItem.getHeight());
        } else if (jMenuItem.isOpaque()) {
            graphics.setColor(jMenuItem.getBackground());
            graphics.fillRect(0, 0, jMenuItem.getWidth(), jMenuItem.getHeight());
        }
        graphics.setColor(color2);
    }

    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        Object object;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Font font = graphics.getFont();
        Font font2 = jComponent.getFont();
        graphics.setFont(font2);
        FontMetrics fontMetrics = jMenuItem.getFontMetrics(this.acceleratorFont);
        String string = this.getAcceleratorString(jMenuItem);
        this.layoutMenuItem(jMenuItem, string);
        this.paintBackground(graphics, jMenuItem, color);
        Color color3 = graphics.getColor();
        if (icon != null) {
            icon.paintIcon(jMenuItem, graphics, this.checkIconRect.x, this.checkIconRect.y);
        }
        ButtonModel buttonModel = jMenuItem.getModel();
        if (jMenuItem.getIcon() != null) {
            if (!jMenuItem.isEnabled()) {
                object = jMenuItem.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                object = jMenuItem.getPressedIcon();
                if (object == null) {
                    object = jMenuItem.getIcon();
                }
            } else {
                object = jMenuItem.getIcon();
            }
            if (object != null) {
                object.paintIcon(jMenuItem, graphics, this.iconRect.x, this.iconRect.y);
            }
        }
        if ((object = jMenuItem.getText()) != null) {
            View view = (View)jMenuItem.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, this.textRect);
            } else {
                this.paintText(graphics, jMenuItem, this.textRect, (String)object);
            }
        }
        if (!string.equals("")) {
            int n2 = 0;
            Container container = jMenuItem.getParent();
            if (container != null && container instanceof JComponent) {
                JComponent jComponent2 = (JComponent)container;
                Integer n3 = (Integer)jComponent2.getClientProperty("maxAccelWidth");
                int n4 = n3 == null ? 0 : n3;
                n2 = n4 - this.accelRect.width;
            }
            graphics.setFont(this.acceleratorFont);
            if (!jMenuItem.isEnabled()) {
                graphics.setColor(this.disabledForeground);
            } else if (jMenuItem.isArmed() || jMenuItem instanceof JMenu && jMenuItem.isSelected()) {
                graphics.setColor(this.acceleratorSelectionForeground);
            } else {
                graphics.setColor(this.acceleratorForeground);
            }
            graphics.drawString(string, this.accelRect.x - n2, this.accelRect.y + fontMetrics.getAscent());
        }
        if (!(icon2 == null || jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isTopLevelMenu())) {
            icon2.paintIcon(jMenuItem, graphics, this.arrowIconRect.x, this.arrowIconRect.y);
        }
        graphics.setFont(font);
        graphics.setColor(color3);
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        Font font = jMenuItem.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        if (string != null && !string.equals("")) {
            if (jMenuItem.isEnabled()) {
                ButtonModel buttonModel = jMenuItem.getModel();
                if (jMenuItem.isSelected() && this.checkIcon == null || buttonModel != null && buttonModel.isArmed() && jMenuItem.getParent() instanceof MenuElement) {
                    graphics.setColor(this.selectionForeground);
                } else {
                    graphics.setColor(jMenuItem.getForeground());
                }
            } else {
                graphics.setColor(Color.gray);
            }
            int n = jMenuItem.getDisplayedMnemonicIndex();
            if (n != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                BasicGraphicsUtils.drawString(jMenuItem, graphics, string, 0, rectangle.x, rectangle.y + fontMetrics.getAscent());
            }
        }
    }

    protected void uninstallComponents(JMenuItem jMenuItem) {
    }

    protected void uninstallDefaults() {
        this.menuItem.setForeground(null);
        this.menuItem.setBackground(null);
        this.menuItem.setBorder(null);
        this.menuItem.setMargin(null);
        this.menuItem.setBackground(null);
        this.menuItem.setBorder(null);
        this.menuItem.setFont(null);
        this.menuItem.setForeground(null);
        this.menuItem.setMargin(null);
        this.acceleratorFont = null;
        this.acceleratorForeground = null;
        this.acceleratorSelectionForeground = null;
        this.arrowIcon = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.acceleratorDelimiter = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
    }

    protected void uninstallListeners() {
        this.menuItem.removeMouseListener(this.mouseInputListener);
        this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        this.menuItem.removeItemListener(this.itemListener);
        this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.menuItem = null;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    private String getAcceleratorText(KeyStroke keyStroke) {
        String string = "";
        int n = keyStroke.getModifiers();
        char c = keyStroke.getKeyChar();
        int n2 = keyStroke.getKeyCode();
        if (n != 0) {
            string = KeyEvent.getKeyModifiersText(n) + this.acceleratorDelimiter;
        }
        if (n2 == 0) {
            return string + c;
        }
        return string + KeyEvent.getKeyText(n2);
    }

    private Rectangle getAcceleratorRect(KeyStroke keyStroke, FontMetrics fontMetrics) {
        int n = fontMetrics.stringWidth(this.getAcceleratorText(keyStroke));
        int n2 = fontMetrics.getHeight();
        return new Rectangle(0, 0, n, n2);
    }

    private String getAcceleratorString(JMenuItem jMenuItem) {
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string = "";
        if (keyStroke != null) {
            int n;
            int n2 = keyStroke.getModifiers();
            if (n2 > 0) {
                string = KeyEvent.getKeyModifiersText(n2);
                string = string + this.acceleratorDelimiter;
            }
            string = (n = keyStroke.getKeyCode()) != 0 ? string + KeyEvent.getKeyText(n) : string + keyStroke.getKeyChar();
        }
        return string;
    }

    private void layoutMenuItem(JMenuItem jMenuItem, String string) {
        int n = jMenuItem.getWidth();
        int n2 = jMenuItem.getHeight();
        this.iconRect.setBounds(0, 0, 0, 0);
        this.textRect.setBounds(0, 0, 0, 0);
        this.accelRect.setBounds(0, 0, 0, 0);
        this.checkIconRect.setBounds(0, 0, 0, 0);
        this.arrowIconRect.setBounds(0, 0, 0, 0);
        this.viewRect.setBounds(0, 0, n, n2);
        Insets insets = jMenuItem.getInsets();
        this.viewRect.x += insets.left;
        this.viewRect.y += insets.top;
        this.viewRect.width -= insets.left + insets.right;
        this.viewRect.height -= insets.top + insets.bottom;
        Font font = jMenuItem.getFont();
        FontMetrics fontMetrics = jMenuItem.getFontMetrics(font);
        FontMetrics fontMetrics2 = jMenuItem.getFontMetrics(this.acceleratorFont);
        String string2 = jMenuItem.getText();
        SwingUtilities.layoutCompoundLabel(jMenuItem, fontMetrics, string2, jMenuItem.getIcon(), jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, this.defaultTextIconGap);
        if (!string.equals("")) {
            this.accelRect.width = fontMetrics2.stringWidth(string);
            this.accelRect.height = fontMetrics2.getHeight();
        }
        if (!(jMenuItem instanceof JMenu) || !((JMenu)jMenuItem).isTopLevelMenu()) {
            if (this.checkIcon != null) {
                this.checkIconRect.width = this.checkIcon.getIconWidth();
                this.checkIconRect.height = this.checkIcon.getIconHeight();
            }
            if (this.arrowIcon != null) {
                this.arrowIconRect.width = this.arrowIcon.getIconWidth();
                this.arrowIconRect.height = this.arrowIcon.getIconHeight();
            }
        }
        this.cachedRect.setBounds(this.textRect);
        Rectangle rectangle = SwingUtilities.computeUnion(this.iconRect.x, this.iconRect.y, this.iconRect.width, this.iconRect.height, this.cachedRect);
        this.textRect.x += this.defaultTextIconGap;
        this.iconRect.x += this.defaultTextIconGap;
        this.accelRect.x = this.viewRect.x + this.viewRect.width - this.arrowIconRect.width - this.defaultTextIconGap - this.accelRect.width;
        if (!(jMenuItem instanceof JMenu) || !((JMenu)jMenuItem).isTopLevelMenu()) {
            this.checkIconRect.x = this.viewRect.x + this.defaultTextIconGap;
            this.textRect.x += this.defaultTextIconGap + this.checkIconRect.width;
            this.iconRect.x += this.defaultTextIconGap + this.checkIconRect.width;
            this.arrowIconRect.x = this.viewRect.x + this.viewRect.width - this.defaultTextIconGap - this.arrowIconRect.width;
        }
        this.accelRect.y = rectangle.y + rectangle.height / 2 - this.accelRect.height / 2;
        if (!(jMenuItem instanceof JMenu) || !((JMenu)jMenuItem).isTopLevelMenu()) {
            this.arrowIconRect.y = rectangle.y + rectangle.height / 2 - this.arrowIconRect.height / 2;
            this.checkIconRect.y = rectangle.y + rectangle.height / 2 - this.checkIconRect.height / 2;
        }
    }

    private class ItemHandler
    implements ItemListener {
        private /* synthetic */ BasicMenuItemUI this$0;

        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = false;
            if (this.this$0.menuItem instanceof JCheckBoxMenuItem) {
                if (itemEvent.getStateChange() == 1) {
                    bl = true;
                }
                ((JCheckBoxMenuItem)this.this$0.menuItem).setState(bl);
            }
            this.this$0.menuItem.revalidate();
            this.this$0.menuItem.repaint();
        }

        ItemHandler(BasicMenuItemUI basicMenuItemUI) {
            this.this$0 = basicMenuItemUI;
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private /* synthetic */ BasicMenuItemUI this$0;

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
        }

        MenuKeyHandler(BasicMenuItemUI basicMenuItemUI) {
            this.this$0 = basicMenuItemUI;
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private /* synthetic */ BasicMenuItemUI this$0;

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.setSelectedPath(menuDragMouseEvent.getPath());
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.setSelectedPath(menuDragMouseEvent.getPath());
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            if (menuElementArray[menuElementArray.length - 1] instanceof JMenuItem) {
                ((JMenuItem)menuElementArray[menuElementArray.length - 1]).doClick();
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }

        MenuDragMouseHandler(BasicMenuItemUI basicMenuItemUI) {
            this.this$0 = basicMenuItemUI;
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ BasicMenuItemUI this$0;

        protected MouseInputHandler(BasicMenuItemUI basicMenuItemUI) {
            this.this$0 = basicMenuItemUI;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            if (component.getParent() instanceof MenuElement) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                menuSelectionManager.setSelectedPath(this.this$0.getPath());
                menuSelectionManager.processMouseEvent(mouseEvent);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Rectangle rectangle = this.this$0.menuItem.getBounds();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (mouseEvent.getX() > 0 && mouseEvent.getX() < rectangle.width && mouseEvent.getY() > 0 && mouseEvent.getY() < rectangle.height) {
                menuSelectionManager.clearSelectedPath();
                this.this$0.menuItem.doClick();
            } else {
                menuSelectionManager.processMouseEvent(mouseEvent);
            }
        }
    }

    class ClickAction
    extends AbstractAction {
        private /* synthetic */ BasicMenuItemUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            this.this$0.doClick(MenuSelectionManager.defaultManager());
        }

        ClickAction(BasicMenuItemUI basicMenuItemUI) {
            this.this$0 = basicMenuItemUI;
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicMenuItemUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("accelerator")) {
                InputMap inputMap = SwingUtilities.getUIInputMap(this.this$0.menuItem, 2);
                if (inputMap != null) {
                    inputMap.remove((KeyStroke)propertyChangeEvent.getOldValue());
                } else {
                    inputMap = new ComponentInputMapUIResource(this.this$0.menuItem);
                }
                KeyStroke keyStroke = (KeyStroke)propertyChangeEvent.getNewValue();
                if (keyStroke != null) {
                    inputMap.put(keyStroke, "doClick");
                }
            } else if ((string.equals("text") || string.equals("font")) && SystemProperties.getProperty("gnu.javax.swing.noGraphics2D") == null) {
                AbstractButton abstractButton = (AbstractButton)propertyChangeEvent.getSource();
                String string2 = abstractButton.getText();
                if (string2 == null) {
                    string2 = "";
                }
                FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
                TextLayout textLayout = new TextLayout(string2, abstractButton.getFont(), fontRenderContext);
                abstractButton.putClientProperty("BasicGraphicsUtils.cachedTextLayout", textLayout);
            }
        }

        PropertyChangeHandler(BasicMenuItemUI basicMenuItemUI) {
            this.this$0 = basicMenuItemUI;
        }
    }
}

