/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.accessibility.Accessible;
import javax.swing.JComponent;

public abstract class ComponentUI {
    public void installUI(JComponent jComponent) {
    }

    public void uninstallUI(JComponent jComponent) {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            Color color = graphics.getColor();
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            graphics.setColor(color);
        }
        this.paint(graphics, jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public boolean contains(JComponent jComponent, int n, int n2) {
        return n >= 0 && n < jComponent.getWidth() && n2 >= 0 && n2 < jComponent.getHeight();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        throw new Error("javax.swing.plaf.ComponentUI does not implement createUI; call createUI on a subclass.");
    }

    public int getAccessibleChildrenCount(JComponent jComponent) {
        return jComponent.getAccessibleContext().getAccessibleChildrenCount();
    }

    public Accessible getAccessibleChild(JComponent jComponent, int n) {
        return jComponent.getAccessibleContext().getAccessibleChild(n);
    }
}

