/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.io.PrintStream;
import java.text.AttributedCharacterIterator;
import javax.swing.JComponent;

public class DebugGraphics
extends Graphics {
    public static final int LOG_OPTION = 1;
    public static final int FLASH_OPTION = 2;
    public static final int BUFFERED_OPTION = 4;
    public static final int NONE_OPTION = -1;
    static Color debugFlashColor = Color.RED;
    static int debugFlashCount = 10;
    static int debugFlashTime = 1000;
    static PrintStream debugLogStream = System.out;
    static int counter = 0;
    Graphics graphics;
    Image buffer;
    int debugOptions;
    int graphicsID;
    int xOffset;
    int yOffset;

    public DebugGraphics() {
        ++counter;
    }

    public DebugGraphics(Graphics graphics, JComponent jComponent) {
        this(graphics);
    }

    public DebugGraphics(Graphics graphics) {
        this();
        this.graphics = graphics;
    }

    public void setColor(Color color) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Setting color: " + color);
        }
        this.graphics.setColor(color);
    }

    public Graphics create() {
        DebugGraphics debugGraphics = new DebugGraphics(this.graphics.create());
        debugGraphics.debugOptions = this.debugOptions;
        return debugGraphics;
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        DebugGraphics debugGraphics = new DebugGraphics(this.graphics.create(n, n2, n3, n4));
        debugGraphics.debugOptions = this.debugOptions;
        return debugGraphics;
    }

    public static Color flashColor() {
        return debugFlashColor;
    }

    public static void setFlashColor(Color color) {
        debugFlashColor = color;
    }

    public static int flashTime() {
        return debugFlashTime;
    }

    public static void setFlashTime(int n) {
        debugFlashTime = n;
    }

    public static int flashCount() {
        return debugFlashCount;
    }

    public static void setFlashCount(int n) {
        debugFlashCount = n;
    }

    public static PrintStream logStream() {
        return debugLogStream;
    }

    public static void setLogStream(PrintStream printStream) {
        debugLogStream = printStream;
    }

    public Font getFont() {
        return this.graphics.getFont();
    }

    public void setFont(Font font) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Setting font: " + font);
        }
        this.graphics.setFont(font);
    }

    public Color getColor() {
        return this.graphics.getColor();
    }

    public FontMetrics getFontMetrics() {
        return this.graphics.getFontMetrics();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.graphics.getFontMetrics(font);
    }

    public void translate(int n, int n2) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Translating by: " + new Point(n, n2));
        }
        this.graphics.translate(n, n2);
    }

    public void setPaintMode() {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Setting paint mode");
        }
        this.graphics.setPaintMode();
    }

    public void setXORMode(Color color) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Setting XOR mode: " + color);
        }
        this.graphics.setXORMode(color);
    }

    public Rectangle getClipBounds() {
        return this.graphics.getClipBounds();
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().print(this.prefix() + " Setting clipRect: " + new Rectangle(n, n2, n3, n4));
        }
        this.graphics.clipRect(n, n2, n3, n4);
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(" Netting clipRect: " + this.graphics.getClipBounds());
        }
    }

    public void setClip(int n, int n2, int n3, int n4) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Setting new clipRect: " + new Rectangle(n, n2, n3, n4));
        }
        this.graphics.setClip(n, n2, n3, n4);
    }

    public Shape getClip() {
        return this.graphics.getClip();
    }

    public void setClip(Shape shape) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Setting new clipRect: " + shape);
        }
        this.graphics.setClip(shape);
    }

    private void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing rect: " + new Rectangle(n, n2, n3, n4));
        }
        if ((this.debugOptions & 2) != 0) {
            Color color = this.graphics.getColor();
            for (int i = 0; i < debugFlashCount - 1; ++i) {
                this.graphics.setColor(color);
                this.graphics.drawRect(n, n2, n3, n4);
                this.sleep(debugFlashTime);
                this.graphics.setColor(debugFlashColor);
                this.graphics.drawRect(n, n2, n3, n4);
                this.sleep(debugFlashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawRect(n, n2, n3, n4);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Filling rect: " + new Rectangle(n, n2, n3, n4));
        }
        if ((this.debugOptions & 2) != 0) {
            Color color = this.graphics.getColor();
            for (int i = 0; i < debugFlashCount - 1; ++i) {
                this.graphics.setColor(color);
                this.graphics.fillRect(n, n2, n3, n4);
                this.sleep(debugFlashTime);
                this.graphics.setColor(debugFlashColor);
                this.graphics.fillRect(n, n2, n3, n4);
                this.sleep(debugFlashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.fillRect(n, n2, n3, n4);
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Clearing rect: " + new Rectangle(n, n2, n3, n4));
        }
        this.graphics.clearRect(n, n2, n3, n4);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing round rect: " + new Rectangle(n, n2, n3, n4) + " arcWidth: " + n5 + " arcHeight: " + n6);
        }
        this.graphics.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Filling round rect: " + new Rectangle(n, n2, n3, n4) + " arcWidth: " + n5 + " arcHeight: " + n6);
        }
        this.graphics.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing line: from (" + n + ", " + n2 + ") to (" + n3 + ", " + n4 + ")");
        }
        this.graphics.drawLine(n, n2, n3, n4);
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing 3D rect: " + new Rectangle(n, n2, n3, n4) + "Raised bezel: " + bl);
        }
        this.graphics.draw3DRect(n, n2, n3, n4, bl);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Filling 3D rect: " + new Rectangle(n, n2, n3, n4) + "Raised bezel: " + bl);
        }
        this.graphics.fill3DRect(n, n2, n3, n4, bl);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing oval: " + new Rectangle(n, n2, n3, n4));
        }
        this.graphics.drawOval(n, n2, n3, n4);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Filling oval: " + new Rectangle(n, n2, n3, n4));
        }
        this.graphics.fillOval(n, n2, n3, n4);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing arc: " + new Rectangle(n, n2, n3, n4) + " startAngle: " + n5 + " arcAngle: " + n6);
        }
        this.graphics.drawArc(n, n2, n3, n4, n5, n6);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Filling arc: " + new Rectangle(n, n2, n3, n4) + " startAngle: " + n5 + " arcAngle: " + n6);
        }
        this.graphics.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing polyline: nPoints: " + n + " X's: " + nArray + " Y's: " + nArray2);
        }
        this.graphics.drawPolyline(nArray, nArray2, n);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing polygon: nPoints: " + n + " X's: " + nArray + " Y's: " + nArray2);
        }
        this.graphics.drawPolygon(nArray, nArray2, n);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing polygon: nPoints: " + n + " X's: " + nArray + " Y's: " + nArray2);
        }
        this.graphics.fillPolygon(nArray, nArray2, n);
    }

    public void drawString(String string, int n, int n2) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing string: \"" + string + "\" at: " + new Point(n, n2));
        }
        this.graphics.drawString(string, n, n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing string: \"" + attributedCharacterIterator + "\" at: " + new Point(n, n2));
        }
        this.graphics.drawString(attributedCharacterIterator, n, n2);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing bytes at: " + new Point(n3, n4));
        }
        this.graphics.drawBytes(byArray, n, n2, n3, n4);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing chars at: " + new Point(n3, n4));
        }
        if ((this.debugOptions & 2) != 0) {
            Color color = this.graphics.getColor();
            for (int i = 0; i < debugFlashCount - 1; ++i) {
                this.graphics.setColor(color);
                this.graphics.drawChars(cArray, n, n2, n3, n4);
                this.sleep(debugFlashTime);
                this.graphics.setColor(debugFlashColor);
                this.graphics.drawChars(cArray, n, n2, n3, n4);
                this.sleep(debugFlashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawChars(cArray, n, n2, n3, n4);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing image: " + image + " at: " + new Point(n, n2));
        }
        return this.graphics.drawImage(image, n, n2, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing image: " + image + " at: " + new Rectangle(n, n2, n3, n4));
        }
        return this.graphics.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing image: " + image + " at: " + new Point(n, n2) + ", bgcolor: " + color);
        }
        return this.graphics.drawImage(image, n, n2, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing image: " + image + " at: " + new Rectangle(n, n2, n3, n4) + ", bgcolor: " + color);
        }
        return this.graphics.drawImage(image, n, n2, n3, n4, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing image: " + image + " destination: " + new Rectangle(n, n2, n3, n4) + " source: " + new Rectangle(n5, n6, n7, n8));
        }
        return this.graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing image: " + image + " destination: " + new Rectangle(n, n2, n3, n4) + " source: " + new Rectangle(n5, n6, n7, n8) + ", bgcolor: " + color);
        }
        return this.graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Copying area from: " + new Rectangle(n, n2, n3, n4) + " to: " + new Point(n5, n6));
        }
        this.graphics.copyArea(n, n2, n3, n4, n5, n6);
    }

    public void dispose() {
        this.graphics.dispose();
        this.graphics = null;
    }

    public boolean isDrawingBuffer() {
        return false;
    }

    public void setDebugOptions(int n) {
        this.debugOptions = n;
        if ((this.debugOptions & 1) != 0) {
            if (n == -1) {
                DebugGraphics.logStream().println(this.prefix() + "Disabling debug");
            } else {
                DebugGraphics.logStream().println(this.prefix() + "Enabling debug");
            }
        }
    }

    public int getDebugOptions() {
        return this.debugOptions;
    }

    private String prefix() {
        return "Graphics(" + counter + "-1)";
    }
}

