/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

final class ConcreteProcess
extends Process {
    private String[] progarray;
    private String[] envp;
    private File dir;
    private Throwable exception;
    private long pid;
    static final int STATE_WAITING_TO_START = 0;
    static final int STATE_RUNNING = 1;
    static final int STATE_TERMINATED = 2;
    int state;
    int status;
    private InputStream errorStream;
    private InputStream inputStream;
    private OutputStream outputStream;
    private InputStream returnedErrorStream;
    private InputStream returnedInputStream;
    private static Object queueLock = new Object();
    private static ProcessManager processManager;

    static /* synthetic */ ProcessManager access$2() {
        return processManager;
    }

    static /* synthetic */ Object access$1(Object object) {
        queueLock = object;
        return queueLock;
    }

    public void destroy() {
        Object object = queueLock;
        synchronized (object) {
            try {
                Object var3_3;
                ConcreteProcess concreteProcess = this;
                synchronized (concreteProcess) {
                    block7: {
                        try {
                            if (this.state == 2) break block7;
                            if (processManager == null) {
                                throw new InternalError();
                            }
                            this.nativeDestroy();
                        }
                        catch (Throwable throwable) {
                            Object var3_4 = null;
                            throw throwable;
                        }
                    }
                    var3_3 = null;
                }
                var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                throw throwable;
            }
        }
    }

    private native void nativeDestroy();

    public int exitValue() {
        ConcreteProcess concreteProcess = this;
        synchronized (concreteProcess) {
            try {
                if (this.state != 2) {
                    throw new IllegalThreadStateException("Process has not exited");
                }
                Object var2_2 = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                throw throwable;
            }
        }
        int n = this.status;
        return n;
    }

    void processTerminationCleanup() {
        try {
            this.outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.returnedErrorStream == null && this.errorStream.available() == 0) {
                this.errorStream.close();
                this.errorStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.returnedInputStream == null && this.inputStream.available() == 0) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized InputStream getErrorStream() {
        if (this.returnedErrorStream != null) {
            return this.returnedErrorStream;
        }
        this.returnedErrorStream = this.errorStream == null ? EOFInputStream.instance : this.errorStream;
        return this.returnedErrorStream;
    }

    public synchronized InputStream getInputStream() {
        if (this.returnedInputStream != null) {
            return this.returnedInputStream;
        }
        this.returnedInputStream = this.inputStream == null ? EOFInputStream.instance : this.inputStream;
        return this.returnedInputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public int waitFor() throws InterruptedException {
        ConcreteProcess concreteProcess = this;
        synchronized (concreteProcess) {
            try {
                while (this.state != 2) {
                    this.wait();
                }
                Object var2_2 = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                throw throwable;
            }
        }
        int n = this.status;
        return n;
    }

    void spawn(ProcessManager processManager) {
        ConcreteProcess concreteProcess = this;
        synchronized (concreteProcess) {
            try {
                this.nativeSpawn();
                processManager.addProcessToMap(this);
                this.state = 1;
                this.notifyAll();
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    private native void nativeSpawn();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ConcreteProcess(String[] stringArray, String[] stringArray2, File file) throws IOException {
        if (stringArray[0] == null) {
            throw new NullPointerException();
        }
        this.progarray = stringArray;
        this.envp = stringArray2;
        this.dir = file;
        Object object = queueLock;
        synchronized (object) {
            Throwable throwable;
            ConcreteProcess concreteProcess;
            try {
                if (processManager == null) {
                    processManager = new ProcessManager();
                    processManager.start();
                    processManager.waitUntilReady();
                }
                processManager.startExecuting(this);
            }
            finally {
                concreteProcess = null;
            }
            concreteProcess = this;
            synchronized (concreteProcess) {
                try {
                    while (this.state == 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    throwable = null;
                }
                catch (Throwable throwable2) {
                    Object var6_10 = null;
                    throw throwable2;
                }
            }
            if (this.exception == null) return;
            if (!(this.exception instanceof IOException)) {
                throwable = new InternalError(this.exception.toString());
                throwable.initCause(this.exception);
                throw throwable;
            }
            throwable = new IOException(this.exception.toString());
            throwable.initCause(this.exception);
            throw throwable;
        }
    }

    static class EOFInputStream
    extends InputStream {
        static EOFInputStream instance = new EOFInputStream();

        public int read() {
            return -1;
        }

        EOFInputStream() {
        }
    }

    static class ProcessManager
    extends Thread {
        List queue;
        private Map pidToProcess;
        private boolean ready;
        private long reaperPID;

        private /* synthetic */ void finit$() {
            this.queue = new LinkedList();
            this.pidToProcess = new HashMap();
            this.ready = false;
        }

        ProcessManager() {
            super("ProcessManager");
            this.finit$();
            this.setDaemon(true);
        }

        private ConcreteProcess removeProcessFromMap(long l) {
            return (ConcreteProcess)this.pidToProcess.remove(new Long(l));
        }

        void addProcessToMap(ConcreteProcess concreteProcess) {
            this.pidToProcess.put(new Long(concreteProcess.pid), concreteProcess);
        }

        void startExecuting(ConcreteProcess concreteProcess) {
            Object object = queueLock;
            synchronized (object) {
                try {
                    this.queue.add(concreteProcess);
                    this.signalReaper();
                    queueLock.notifyAll();
                }
                finally {
                    Object var3_3 = null;
                }
                return;
            }
        }

        void waitUntilReady() {
            ProcessManager processManager = this;
            synchronized (processManager) {
                try {
                    try {
                        while (!this.ready) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    Object var2_3 = null;
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    throw throwable;
                }
            }
        }

        public void run() {
            this.init();
            ProcessManager processManager = this;
            synchronized (processManager) {
                Object object;
                try {
                    this.ready = true;
                    this.notifyAll();
                }
                finally {
                    object = null;
                }
                while (true) {
                    try {
                        object = queueLock;
                        synchronized (object) {
                            ConcreteProcess concreteProcess;
                            try {
                                boolean bl = this.reap();
                                if (!bl && this.queue.size() == 0) {
                                    try {
                                        queueLock.wait(1000);
                                        if (this.queue.size() == 0) {
                                            ConcreteProcess.processManager = null;
                                            concreteProcess = null;
                                            return;
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        concreteProcess = null;
                                        return;
                                    }
                                }
                                while (this.queue.size() > 0) {
                                    concreteProcess = (ConcreteProcess)this.queue.remove(0);
                                    concreteProcess.spawn(this);
                                }
                            }
                            catch (Throwable throwable) {
                                concreteProcess = null;
                                throw throwable;
                            }
                            concreteProcess = null;
                        }
                        this.waitForSignal();
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                        continue;
                    }
                    break;
                }
            }
        }

        private native void init();

        private native void waitForSignal();

        private native boolean reap();

        private native void signalReaper();
    }
}

