/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.DOMSourceLocator;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class LiteralNode
extends TemplateNode {
    final Node source;
    final Collection elementExcludeResultPrefixes;

    LiteralNode(Node node2) {
        this.source = node2;
        if (node2.getNodeType() == 1) {
            NamedNodeMap namedNodeMap = node2.getAttributes();
            Node node3 = namedNodeMap.getNamedItemNS("http://www.w3.org/1999/XSL/Transform", "exclude-result-prefixes");
            if (node3 != null) {
                this.elementExcludeResultPrefixes = new HashSet();
                StringTokenizer stringTokenizer = new StringTokenizer(node3.getNodeValue());
                while (stringTokenizer.hasMoreTokens()) {
                    this.elementExcludeResultPrefixes.add(stringTokenizer.nextToken());
                }
            } else {
                this.elementExcludeResultPrefixes = Collections.EMPTY_SET;
            }
        } else {
            this.elementExcludeResultPrefixes = null;
        }
    }

    TemplateNode clone(Stylesheet stylesheet) {
        LiteralNode literalNode = new LiteralNode(this.source);
        if (this.children != null) {
            literalNode.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            literalNode.next = this.next.clone(stylesheet);
        }
        return literalNode;
    }

    void doApply(Stylesheet stylesheet, QName qName, Node node2, int n, int n2, Node node3, Node node4) throws TransformerException {
        Node node5 = null;
        Document document = node3 instanceof Document ? (Document)node3 : node3.getOwnerDocument();
        short s = this.source.getNodeType();
        if (s != 2 || node3.getFirstChild() == null) {
            Object object;
            String string;
            Object object2;
            if (s == 1) {
                String string2;
                object2 = this.source.getPrefix();
                if (object2 == null) {
                    object2 = "#default";
                }
                if ((string2 = (String)stylesheet.namespaceAliases.get(object2)) != null) {
                    if ("#default".equals(string2)) {
                        string2 = null;
                    }
                    string = this.source.lookupNamespaceURI(string2);
                    object = this.source.getNodeName();
                    node5 = document.createElementNS(string, (String)object);
                    NamedNodeMap namedNodeMap = this.source.getAttributes();
                    NamedNodeMap namedNodeMap2 = node5.getAttributes();
                    int n3 = namedNodeMap.getLength();
                    for (int i = 0; i < n3; ++i) {
                        Node node6 = namedNodeMap.item(i);
                        if (Stylesheet.XSL_NS.equals(node6.getNamespaceURI())) continue;
                        node6 = node6.cloneNode(true);
                        node6 = document.adoptNode(node6);
                        namedNodeMap2.setNamedItemNS(node6);
                    }
                }
            }
            if (node5 == null) {
                Node node7;
                node5 = this.source.cloneNode(false);
                object2 = node5.getAttributes();
                if (object2 != null) {
                    int n4 = object2.getLength();
                    for (int i = 0; i < n4; ++i) {
                        object = object2.item(i);
                        if (!Stylesheet.XSL_NS.equals(object.getNamespaceURI())) continue;
                        object2.removeNamedItem(object.getNodeName());
                        --i;
                        --n4;
                    }
                }
                if ((node7 = document.adoptNode(node5)) == null) {
                    string = "Error adopting node to result tree: " + node5 + " (" + node5.getClass().getName() + ")";
                    object = new DOMSourceLocator(node2);
                    throw new TransformerException(string, (SourceLocator)object);
                }
                node5 = node7;
            }
            if (node4 != null) {
                node3.insertBefore(node5, node4);
            } else {
                node3.appendChild(node5);
            }
            if (s == 1) {
                stylesheet.addNamespaceNodes(this.source, node5, document, this.elementExcludeResultPrefixes);
            }
            if (this.children != null) {
                this.children.apply(stylesheet, qName, node2, n, n2, node5, null);
            }
        }
        if (this.next != null) {
            this.next.apply(stylesheet, qName, node2, n, n2, node3, node4);
        }
    }

    public String toString() {
        return this.source.toString();
    }
}

