/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import gnu.xml.stream.UnicodeReader;
import gnu.xml.stream.XMLParser;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.LinkedList;
import javax.xml.XMLConstants;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.helpers.NamespaceSupport;

public class XMLStreamWriterImpl
implements XMLStreamWriter {
    protected final Writer writer;
    protected final String encoding;
    protected final boolean prefixDefaulting;
    protected NamespaceContext namespaceContext;
    private LinkedList elements;
    private boolean inStartElement;
    private boolean emptyElement;
    private NamespaceSupport namespaces;
    private int count;
    private boolean xml11;
    private boolean hasXML11RestrictedChars;

    private /* synthetic */ void finit$() {
        this.count = 0;
    }

    protected XMLStreamWriterImpl(Writer writer, String string, boolean bl) {
        this.finit$();
        this.writer = writer;
        this.encoding = string;
        this.prefixDefaulting = bl;
        this.elements = new LinkedList();
        this.namespaces = new NamespaceSupport();
    }

    private void endStartElement() throws IOException {
        if (!this.inStartElement) {
            return;
        }
        if (this.emptyElement) {
            this.writer.write(47);
            this.elements.removeLast();
            this.namespaces.popContext();
            this.emptyElement = false;
        }
        this.writer.write(62);
        this.inStartElement = false;
    }

    public void writeStartElement(String string) throws XMLStreamException {
        try {
            if (!this.isName(string)) {
                throw new IllegalArgumentException("illegal Name: " + string);
            }
            this.endStartElement();
            this.namespaces.pushContext();
            this.writer.write(60);
            this.writer.write(string);
            this.elements.addLast(new String[]{null, string});
            this.inStartElement = true;
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException(iOException);
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
    }

    public void writeStartElement(String string, String string2) throws XMLStreamException {
        try {
            boolean bl;
            if (string != null && !this.isURI(string)) {
                throw new IllegalArgumentException("illegal URI: " + string);
            }
            if (!this.isName(string2)) {
                throw new IllegalArgumentException("illegal Name: " + string2);
            }
            this.endStartElement();
            this.namespaces.pushContext();
            String string3 = this.getPrefix(string);
            boolean bl2 = bl = string3 != null;
            if (!bl) {
                if (this.prefixDefaulting) {
                    string3 = this.createPrefix(string);
                } else {
                    throw new XMLStreamException("namespace " + string + " has not been declared");
                }
            }
            this.writer.write(60);
            if (!"".equals(string3)) {
                this.writer.write(string3);
                this.writer.write(58);
            }
            this.writer.write(string2);
            this.inStartElement = true;
            if (!bl) {
                this.writeNamespaceImpl(string3, string);
            }
            this.elements.addLast(new String[]{string3, string2});
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException(iOException);
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
    }

    protected String createPrefix(String string) {
        HashSet hashSet = new HashSet();
        Object object = this.namespaces.getPrefixes();
        while (object.hasMoreElements()) {
            hashSet.add(object.nextElement());
        }
        while (hashSet.contains(object = "ns" + this.count++)) {
        }
        return object;
    }

    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        try {
            if (string3 != null && !this.isURI(string3)) {
                throw new IllegalArgumentException("illegal URI: " + string3);
            }
            if (string != null && !this.isNCName(string)) {
                throw new IllegalArgumentException("illegal NCName: " + string);
            }
            if (!this.isNCName(string2)) {
                throw new IllegalArgumentException("illegal NCName: " + string2);
            }
            this.endStartElement();
            this.namespaces.pushContext();
            String string4 = this.getPrefix(string3);
            boolean bl = string.equals(string4);
            this.writer.write(60);
            if (!"".equals(string)) {
                this.writer.write(string);
                this.writer.write(58);
            }
            this.writer.write(string2);
            if (this.prefixDefaulting && !bl) {
                this.writeNamespaceImpl(string, string3);
            }
            this.elements.addLast(new String[]{string, string2});
            this.inStartElement = true;
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException(iOException);
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
    }

    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.writeStartElement(string, string2);
        this.emptyElement = true;
    }

    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        this.writeStartElement(string, string2, string3);
        this.emptyElement = true;
    }

    public void writeEmptyElement(String string) throws XMLStreamException {
        this.writeStartElement(string);
        this.emptyElement = true;
    }

    public void writeEndElement() throws XMLStreamException {
        if (this.elements.isEmpty()) {
            throw new IllegalStateException("no matching start element");
        }
        try {
            this.endStartElement();
            String[] stringArray = (String[])this.elements.removeLast();
            this.namespaces.popContext();
            this.writer.write(60);
            this.writer.write(47);
            if (stringArray[0] != null && !"".equals(stringArray[0])) {
                this.writer.write(stringArray[0]);
                this.writer.write(58);
            }
            this.writer.write(stringArray[1]);
            this.writer.write(62);
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException(iOException);
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
    }

    public void writeEndDocument() throws XMLStreamException {
        while (!this.elements.isEmpty()) {
            this.writeEndElement();
        }
    }

    public void close() throws XMLStreamException {
        this.flush();
    }

    public void flush() throws XMLStreamException {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException(iOException);
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
    }

    public void writeAttribute(String string, String string2) throws XMLStreamException {
        if (!this.inStartElement) {
            throw new IllegalStateException();
        }
        try {
            if (!this.isName(string)) {
                throw new IllegalArgumentException("illegal Name: " + string);
            }
            if (!this.isChars(string2)) {
                throw new IllegalArgumentException("illegal character: " + string2);
            }
            this.writer.write(32);
            this.writer.write(string);
            this.writer.write(61);
            this.writer.write(34);
            if (this.hasXML11RestrictedChars) {
                this.writeEncodedWithRestrictedChars(string2, true);
            } else {
                this.writeEncoded(string2, true);
            }
            this.writer.write(34);
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException(iOException);
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        if (!this.inStartElement) {
            throw new IllegalStateException();
        }
        try {
            if (string2 != null && !this.isURI(string2)) {
                throw new IllegalArgumentException("illegal URI: " + string2);
            }
            if (string != null && !this.isNCName(string)) {
                throw new IllegalArgumentException("illegal NCName: " + string);
            }
            if (!this.isNCName(string3)) {
                throw new IllegalArgumentException("illegal NCName: " + string3);
            }
            if (!this.isChars(string4)) {
                throw new IllegalArgumentException("illegal character: " + string4);
            }
            String string5 = this.getPrefix(string2);
            if (string5 == null) {
                if (!this.prefixDefaulting) throw new XMLStreamException("namespace " + string2 + " is not bound");
                this.writeNamespaceImpl(string, string2);
            } else if (!string5.equals(string)) {
                throw new XMLStreamException("namespace " + string2 + " is bound to prefix " + string5);
            }
            this.writer.write(32);
            if (!"".equals(string)) {
                this.writer.write(string);
                this.writer.write(58);
            }
            this.writer.write(string3);
            this.writer.write(61);
            this.writer.write(34);
            if (this.hasXML11RestrictedChars) {
                this.writeEncodedWithRestrictedChars(string4, true);
            } else {
                this.writeEncoded(string4, true);
            }
            this.writer.write(34);
            return;
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException(iOException);
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
    }

    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        if (!this.inStartElement) {
            throw new IllegalStateException();
        }
        try {
            if (string != null && !this.isURI(string)) {
                throw new IllegalArgumentException("illegal URI: " + string);
            }
            if (!this.isName(string2)) {
                throw new IllegalArgumentException("illegal Name: " + string2);
            }
            if (!this.isChars(string3)) {
                throw new IllegalArgumentException("illegal character: " + string3);
            }
            String string4 = this.getPrefix(string);
            if (string4 == null) {
                if (this.prefixDefaulting) {
                    string4 = "";
                    this.writeNamespaceImpl(string4, string);
                } else {
                    throw new XMLStreamException("namespace " + string + " is not bound");
                }
            }
            this.writer.write(32);
            if (!"".equals(string4)) {
                this.writer.write(string4);
                this.writer.write(58);
            }
            this.writer.write(string2);
            this.writer.write(61);
            this.writer.write(34);
            if (this.hasXML11RestrictedChars) {
                this.writeEncodedWithRestrictedChars(string3, true);
            } else {
                this.writeEncoded(string3, true);
            }
            this.writer.write(34);
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException(iOException);
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
    }

    public void writeNamespace(String string, String string2) throws XMLStreamException {
        if (!this.inStartElement) {
            throw new IllegalStateException();
        }
        try {
            if (!this.isURI(string2)) {
                throw new IllegalArgumentException("illegal URI: " + string2);
            }
            if (!this.isNCName(string)) {
                throw new IllegalArgumentException("illegal NCName: " + string);
            }
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException(iOException);
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
        this.writeNamespaceImpl(string, string2);
    }

    private void writeNamespaceImpl(String string, String string2) throws XMLStreamException {
        try {
            if (string == null) {
                string = "";
            }
            this.setPrefix(string, string2);
            this.writer.write(32);
            this.writer.write("xmlns");
            if (!XMLConstants.DEFAULT_NS_PREFIX.equals(string)) {
                this.writer.write(58);
                this.writer.write(string);
            }
            this.writer.write(61);
            this.writer.write(34);
            this.writer.write(string2);
            this.writer.write(34);
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException(iOException);
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
    }

    public void writeDefaultNamespace(String string) throws XMLStreamException {
        if (!this.inStartElement) {
            throw new IllegalStateException();
        }
        if (!this.isURI(string)) {
            throw new IllegalArgumentException("illegal URI: " + string);
        }
        this.writeNamespaceImpl("", string);
    }

    public void writeComment(String string) throws XMLStreamException {
        if (string == null) {
            return;
        }
        try {
            if (!this.isChars(string)) {
                throw new IllegalArgumentException("illegal XML character: " + string);
            }
            if (string.indexOf("--") != -1) {
                throw new IllegalArgumentException("illegal comment: " + string);
            }
            this.endStartElement();
            this.writer.write("<!--");
            if (this.hasXML11RestrictedChars) {
                int[] nArray = UnicodeReader.toCodePointArray(string);
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    if (XMLParser.isXML11RestrictedChar(n)) {
                        this.writer.write("&#x" + Integer.toHexString(n) + ";");
                        continue;
                    }
                    this.writer.write(Character.toChars(i));
                }
            } else {
                this.writer.write(string);
            }
            this.writer.write("-->");
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException(iOException);
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
    }

    public void writeProcessingInstruction(String string) throws XMLStreamException {
        this.writeProcessingInstruction(string, null);
    }

    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        try {
            if (!this.isName(string) || "xml".equalsIgnoreCase(string)) {
                throw new IllegalArgumentException("illegal PITarget: " + string);
            }
            if (string2 != null && !this.isChars(string2)) {
                throw new IllegalArgumentException("illegal XML character: " + string2);
            }
            this.endStartElement();
            this.writer.write(60);
            this.writer.write(63);
            this.writer.write(string);
            if (string2 != null) {
                this.writer.write(32);
                if (this.hasXML11RestrictedChars) {
                    int[] nArray = UnicodeReader.toCodePointArray(string2);
                    for (int i = 0; i < nArray.length; ++i) {
                        int n = nArray[i];
                        if (XMLParser.isXML11RestrictedChar(n)) {
                            this.writer.write("&#x" + Integer.toHexString(n) + ";");
                            continue;
                        }
                        this.writer.write(Character.toChars(i));
                    }
                } else {
                    this.writer.write(string2);
                }
            }
            this.writer.write(63);
            this.writer.write(62);
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException(iOException);
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
    }

    public void writeCData(String string) throws XMLStreamException {
        try {
            if (!this.isChars(string) || this.hasXML11RestrictedChars) {
                throw new IllegalArgumentException("illegal XML character: " + string);
            }
            if (string.indexOf("]]") != -1) {
                throw new IllegalArgumentException("illegal CDATA section: " + string);
            }
            this.endStartElement();
            this.writer.write("<![CDATA[");
            this.writer.write(string);
            this.writer.write("]]>");
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException(iOException);
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
    }

    public void writeDTD(String string) throws XMLStreamException {
        try {
            if (!this.isName(string)) {
                throw new IllegalArgumentException("illegal Name: " + string);
            }
            this.writer.write("<!DOCTYPE ");
            this.writer.write(string);
            this.writer.write(62);
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException(iOException);
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
    }

    public void writeEntityRef(String string) throws XMLStreamException {
        try {
            if (!this.isName(string)) {
                throw new IllegalArgumentException("illegal Name: " + string);
            }
            this.endStartElement();
            this.writer.write(38);
            this.writer.write(string);
            this.writer.write(59);
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException(iOException);
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
    }

    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument(null, null);
    }

    public void writeStartDocument(String string) throws XMLStreamException {
        this.writeStartDocument(null, string);
    }

    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        if (string2 == null) {
            string2 = "1.0";
        } else if ("1.1".equals(string2)) {
            this.xml11 = true;
        }
        string = this.encoding;
        if (string == null) {
            string = "UTF-8";
        }
        if (!"1.0".equals(string2) && !"1.1".equals(string2)) {
            throw new IllegalArgumentException(string2);
        }
        try {
            this.writer.write("<?xml version=\"");
            this.writer.write(string2);
            this.writer.write("\" encoding=\"");
            this.writer.write(string);
            this.writer.write("\"?>");
            this.writer.write(System.getProperty("line.separator"));
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException(iOException);
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
    }

    public void writeCharacters(String string) throws XMLStreamException {
        if (string == null) {
            return;
        }
        try {
            if (!this.isChars(string)) {
                throw new IllegalArgumentException("illegal XML character: " + string);
            }
            this.endStartElement();
            if (this.hasXML11RestrictedChars) {
                this.writeEncodedWithRestrictedChars(string, false);
            } else {
                this.writeEncoded(string, false);
            }
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException(iOException);
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
    }

    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        this.writeCharacters(new String(cArray, n, n2));
    }

    public String getPrefix(String string) throws XMLStreamException {
        String string2 = this.namespaces.getPrefix(string);
        if (string2 == null && this.namespaceContext != null) {
            string2 = this.namespaceContext.getPrefix(string);
        }
        return string2;
    }

    public void setPrefix(String string, String string2) throws XMLStreamException {
        try {
            if (!this.isURI(string2)) {
                throw new IllegalArgumentException("illegal URI: " + string2);
            }
            if (!this.isNCName(string)) {
                throw new IllegalArgumentException("illegal NCName: " + string);
            }
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException(iOException);
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
        if (!this.namespaces.declarePrefix(string, string2)) {
            throw new XMLStreamException("illegal prefix " + string);
        }
    }

    public void setDefaultNamespace(String string) throws XMLStreamException {
        if (!this.isURI(string)) {
            throw new IllegalArgumentException("illegal URI: " + string);
        }
        if (!this.namespaces.declarePrefix("", string)) {
            throw new XMLStreamException("illegal default namespace prefix");
        }
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.namespaceContext = namespaceContext;
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException(string);
    }

    private void writeEncoded(String string, boolean bl) throws IOException {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = cArray.length;
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            if (c == '<' || c == '>' || c == '&') {
                this.writer.write(cArray, n, n3);
                if (c == '<') {
                    this.writer.write("&lt;");
                } else if (c == '>') {
                    this.writer.write("&gt;");
                } else {
                    this.writer.write("&amp;");
                }
                n = i + 1;
                n3 = 0;
                continue;
            }
            if (bl && (c == '\"' || c == '\'')) {
                this.writer.write(cArray, n, n3);
                if (c == '\"') {
                    this.writer.write("&quot;");
                } else {
                    this.writer.write("&apos;");
                }
                n = i + 1;
                n3 = 0;
                continue;
            }
            ++n3;
        }
        if (n3 > 0) {
            this.writer.write(cArray, n, n3);
        }
    }

    private void writeEncodedWithRestrictedChars(String string, boolean bl) throws IOException {
        int[] nArray = UnicodeReader.toCodePointArray(string);
        block7: for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            switch (n) {
                case 60: {
                    this.writer.write("&lt;");
                    continue block7;
                }
                case 62: {
                    this.writer.write("&gt;");
                    continue block7;
                }
                case 38: {
                    this.writer.write("&amp;");
                    continue block7;
                }
                case 34: {
                    if (bl) {
                        this.writer.write("&quot;");
                        continue block7;
                    }
                    this.writer.write(n);
                    continue block7;
                }
                case 39: {
                    if (bl) {
                        this.writer.write("&apos;");
                        continue block7;
                    }
                    this.writer.write(n);
                    continue block7;
                }
                default: {
                    if (XMLParser.isXML11RestrictedChar(n)) {
                        this.writer.write("&#x" + Integer.toHexString(n) + ";");
                        continue block7;
                    }
                    char[] cArray = Character.toChars(n);
                    this.writer.write(cArray, 0, cArray.length);
                }
            }
        }
    }

    private boolean isName(String string) throws IOException {
        if (string == null) {
            return false;
        }
        int[] nArray = UnicodeReader.toCodePointArray(string);
        if (nArray.length < 1) {
            return false;
        }
        if (!XMLParser.isNameStartCharacter(nArray[0], this.xml11)) {
            return false;
        }
        for (int i = 1; i < nArray.length; ++i) {
            if (XMLParser.isNameCharacter(nArray[i], this.xml11)) continue;
            return false;
        }
        return true;
    }

    private boolean isNCName(String string) throws IOException {
        if (string == null) {
            return false;
        }
        int[] nArray = UnicodeReader.toCodePointArray(string);
        if (nArray.length < 1) {
            return false;
        }
        if (!XMLParser.isNameStartCharacter(nArray[0], this.xml11) || nArray[0] == 58) {
            return false;
        }
        for (int i = 1; i < nArray.length; ++i) {
            if (XMLParser.isNameCharacter(nArray[i], this.xml11) && nArray[i] != 58) continue;
            return false;
        }
        return true;
    }

    private boolean isChars(String string) throws IOException {
        if (string == null) {
            return false;
        }
        int[] nArray = UnicodeReader.toCodePointArray(string);
        this.hasXML11RestrictedChars = false;
        if (this.xml11) {
            for (int i = 0; i < nArray.length; ++i) {
                if (!XMLParser.isXML11Char(nArray[i])) {
                    return false;
                }
                if (!XMLParser.isXML11RestrictedChar(nArray[i])) continue;
                this.hasXML11RestrictedChars = true;
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                if (XMLParser.isChar(nArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isURI(String string) {
        if (string == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (cArray.length < 1) {
            return false;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= ' ' && cArray[i] < '\u007f') continue;
            return false;
        }
        return true;
    }
}

