/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.libxmlj.util;

import gnu.xml.dom.ls.ReaderInputStream;
import gnu.xml.dom.ls.WriterOutputStream;
import gnu.xml.libxmlj.transform.GnomeTransformerFactory;
import gnu.xml.libxmlj.util.NamedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;

public final class XMLJ {
    private static boolean initialised = false;
    private static final int LOOKAHEAD = 50;

    public static void init() {
        if (!initialised) {
            System.loadLibrary("xmlj");
            XMLJShutdownHook xMLJShutdownHook = new XMLJShutdownHook();
            Runtime.getRuntime().addShutdownHook(new Thread(xMLJShutdownHook));
        }
        initialised = true;
    }

    public static NamedInputStream getInputStream(InputSource inputSource) throws IOException {
        Reader reader;
        InputStream inputStream = inputSource.getByteStream();
        String string = inputSource.getSystemId();
        if (inputStream == null && (reader = inputSource.getCharacterStream()) != null) {
            inputStream = new ReaderInputStream(reader);
        }
        if (inputStream == null) {
            inputStream = XMLJ.getInputStream(string);
        }
        return new NamedInputStream(string, inputStream, 50);
    }

    public static NamedInputStream getInputStream(Source source) throws IOException {
        if (source instanceof SAXSource) {
            return XMLJ.getInputStream(((SAXSource)source).getInputSource());
        }
        InputStream inputStream = null;
        String string = source.getSystemId();
        if (source instanceof StreamSource) {
            inputStream = ((StreamSource)source).getInputStream();
        }
        if (inputStream == null) {
            inputStream = XMLJ.getInputStream(string);
        }
        return new NamedInputStream(string, inputStream, 50);
    }

    private static InputStream getInputStream(String string) throws IOException {
        if (string == null) {
            throw new IOException("no system ID");
        }
        try {
            return new URL(string).openStream();
        }
        catch (MalformedURLException malformedURLException) {
            return new FileInputStream(string);
        }
    }

    public static NamedInputStream getInputStream(URL uRL) throws IOException {
        return new NamedInputStream(uRL.toString(), uRL.openStream(), 50);
    }

    static NamedInputStream xmljGetInputStream(String string, String string2) throws IOException {
        try {
            if (string != null) {
                string2 = new URL(new URL(string), string2).toString();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        InputStream inputStream = XMLJ.getInputStream(string2);
        return new NamedInputStream(string2, inputStream, 50);
    }

    public static OutputStream getOutputStream(Result result) throws IOException {
        Object object;
        OutputStream outputStream = null;
        if (result instanceof StreamResult) {
            outputStream = ((StreamResult)result).getOutputStream();
        }
        if (outputStream == null && (object = ((StreamResult)result).getWriter()) != null) {
            outputStream = new WriterOutputStream((Writer)object);
        }
        if (outputStream == null) {
            object = result.getSystemId();
            if (object == null) {
                throw new IOException("no system ID");
            }
            try {
                URL uRL = new URL((String)object);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setDoOutput(true);
                outputStream = uRLConnection.getOutputStream();
            }
            catch (MalformedURLException malformedURLException) {
                outputStream = new FileOutputStream((String)object);
            }
        }
        return outputStream;
    }

    public static String getAbsoluteURI(String string, String string2) {
        if (string2 != null && string != null && string2.length() > 0 && string2.indexOf(58) == -1 && string2.charAt(0) != '/') {
            if (string.charAt(string.length() - 1) != '/') {
                int n = string.lastIndexOf(47);
                string = string.substring(0, n + 1);
            }
            return string + string2;
        }
        return string2;
    }

    public static String getBaseURI(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(47)) != -1) {
            string = string.substring(0, n + 1);
        }
        return string;
    }

    static class XMLJShutdownHook
    implements Runnable {
        public void run() {
            System.gc();
            Runtime.getRuntime().runFinalization();
            GnomeTransformerFactory.freeLibxsltGlobal();
        }

        XMLJShutdownHook() {
        }
    }
}

