/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mac;

import gnu.javax.crypto.mac.IMac;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MacInputStream
extends FilterInputStream {
    private boolean digesting;
    private IMac mac;

    public MacInputStream(InputStream inputStream, IMac iMac) {
        super(inputStream);
        if (iMac == null) {
            throw new NullPointerException();
        }
        this.mac = iMac;
        this.digesting = true;
    }

    public IMac getMac() {
        return this.mac;
    }

    public void setMac(IMac iMac) {
        if (iMac == null) {
            throw new NullPointerException();
        }
        this.mac = iMac;
    }

    public void on(boolean bl) {
        this.digesting = bl;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (this.digesting && n != -1) {
            this.mac.update((byte)n);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (this.digesting && n3 != -1) {
            this.mac.update(byArray, n, n3);
        }
        return n3;
    }
}

