/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.kwa;

import gnu.java.security.util.PRNG;
import gnu.javax.crypto.kwa.IKeyWrappingAlgorithm;
import gnu.javax.crypto.kwa.KeyUnwrappingException;
import java.security.InvalidKeyException;
import java.util.Collections;
import java.util.Map;
import javax.crypto.ShortBufferException;

public abstract class BaseKeyWrappingAlgorithm
implements IKeyWrappingAlgorithm {
    protected String name;
    private PRNG prng;

    protected BaseKeyWrappingAlgorithm(String string) {
    }

    public String name() {
        return this.name;
    }

    public void init(Map map) throws InvalidKeyException {
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        this.engineInit(map);
    }

    public int wrap(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (n3 < 0) {
            throw new IllegalArgumentException("Output offset MUST NOT be negative");
        }
        byte[] byArray3 = this.wrap(byArray, n, n2);
        if (n3 + byArray3.length > byArray2.length) {
            throw new ShortBufferException();
        }
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    public byte[] wrap(byte[] byArray, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Input offset MUST NOT be negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Input length MUST NOT be negative");
        }
        return this.engineWrap(byArray, n, n2);
    }

    public int unwrap(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, KeyUnwrappingException {
        if (n3 < 0) {
            throw new IllegalArgumentException("Output offset MUST NOT be negative");
        }
        byte[] byArray3 = this.engineUnwrap(byArray, n, n2);
        if (n3 + byArray3.length > byArray2.length) {
            throw new ShortBufferException();
        }
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    public byte[] unwrap(byte[] byArray, int n, int n2) throws KeyUnwrappingException {
        if (n < 0) {
            throw new IllegalArgumentException("Input offset MUST NOT be negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Input length MUST NOT be negative");
        }
        return this.engineUnwrap(byArray, n, n2);
    }

    protected abstract void engineInit(Map var1) throws InvalidKeyException;

    protected abstract byte[] engineWrap(byte[] var1, int var2, int var3);

    protected abstract byte[] engineUnwrap(byte[] var1, int var2, int var3) throws KeyUnwrappingException;

    protected PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }
}

