/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.CairoGraphics2D;
import gnu.java.awt.peer.gtk.CairoSurface;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.util.WeakHashMap;

public class BufferedImageGraphics
extends CairoGraphics2D {
    private BufferedImage image;
    private int imageWidth;
    private int imageHeight;
    CairoSurface surface;
    static WeakHashMap bufferedImages = new WeakHashMap();
    private long cairo_t;
    static ColorModel rgb32 = new DirectColorModel(32, 0xFF0000, 65280, 255);
    static ColorModel argb32 = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    private boolean hasFastCM;
    private boolean hasAlpha;

    public BufferedImageGraphics(BufferedImage bufferedImage) {
        int[] nArray;
        this.image = bufferedImage;
        this.imageWidth = bufferedImage.getWidth();
        this.imageHeight = bufferedImage.getHeight();
        if (bufferedImage.getColorModel().equals(rgb32)) {
            this.hasFastCM = true;
            this.hasAlpha = false;
        } else if (bufferedImage.getColorModel().equals(argb32)) {
            this.hasFastCM = true;
            this.hasAlpha = false;
        } else {
            this.hasFastCM = false;
        }
        if (bufferedImages.get(bufferedImage) != null) {
            this.surface = (CairoSurface)bufferedImages.get(bufferedImage);
        } else {
            this.surface = new CairoSurface(this.imageWidth, this.imageHeight);
            bufferedImages.put(bufferedImage, this.surface);
        }
        this.cairo_t = this.surface.newCairoContext();
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        if (dataBuffer instanceof CairoSurface) {
            nArray = ((CairoSurface)dataBuffer).getPixels(this.imageWidth * this.imageHeight);
        } else if (this.hasFastCM) {
            nArray = ((DataBufferInt)dataBuffer).getData();
            if (!this.hasAlpha) {
                int n = 0;
                while (n < nArray.length) {
                    int n2 = n++;
                    nArray[n2] = nArray[n2] & 0xFFFFFFFF;
                }
            }
        } else {
            nArray = CairoGraphics2D.findSimpleIntegerArray(this.image.getColorModel(), this.image.getData());
        }
        this.surface.setPixels(nArray);
        this.setup(this.cairo_t);
        this.setClip(0, 0, this.imageWidth, this.imageHeight);
    }

    BufferedImageGraphics(BufferedImageGraphics bufferedImageGraphics) {
        this.surface = bufferedImageGraphics.surface;
        this.cairo_t = this.surface.newCairoContext();
        this.imageWidth = bufferedImageGraphics.imageWidth;
        this.imageHeight = bufferedImageGraphics.imageHeight;
        this.copy(bufferedImageGraphics, this.cairo_t);
        this.setClip(0, 0, this.surface.width, this.surface.height);
    }

    private void updateBufferedImage(int n, int n2, int n3, int n4) {
        int[] nArray = this.surface.getPixels(this.imageWidth * this.imageHeight);
        if (n > this.imageWidth || n2 > this.imageHeight) {
            return;
        }
        if (n < 0) {
            n3 += n;
            n = 0;
        }
        if (n2 < 0) {
            n4 += n2;
            n2 = 0;
        }
        if (n + n3 > this.imageWidth) {
            n3 = this.imageWidth - n;
        }
        if (n2 + n4 > this.imageHeight) {
            n4 = this.imageHeight - n2;
        }
        if (!this.hasFastCM) {
            this.image.setRGB(n, n2, n3, n4, nArray, n + n2 * this.imageWidth, this.imageWidth);
        } else {
            System.arraycopy(nArray, n2 * this.imageWidth, ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData(), n2 * this.imageWidth, n4 * this.imageWidth);
        }
    }

    public Graphics create() {
        return new BufferedImageGraphics(this);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    protected Rectangle2D getRealBounds() {
        return new Rectangle2D.Double(0.0, 0.0, this.imageWidth, this.imageHeight);
    }

    public void copyAreaImpl(int n, int n2, int n3, int n4, int n5, int n6) {
        this.surface.copyAreaNative(n, n2, n3, n4, n5, n6, this.surface.width);
        this.updateBufferedImage(n + n5, n2 + n6, n3, n4);
    }

    public void draw(Shape shape) {
        super.draw(shape);
        Rectangle rectangle = shape.getBounds();
        this.updateBufferedImage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void fill(Shape shape) {
        super.fill(shape);
        Rectangle rectangle = shape.getBounds();
        this.updateBufferedImage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        super.drawRenderedImage(renderedImage, affineTransform);
        this.updateBufferedImage(0, 0, this.imageWidth, this.imageHeight);
    }

    protected boolean drawImage(Image image, AffineTransform affineTransform, Color color, ImageObserver imageObserver) {
        boolean bl = super.drawImage(image, affineTransform, color, imageObserver);
        this.updateBufferedImage(0, 0, this.imageWidth, this.imageHeight);
        return bl;
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        super.drawGlyphVector(glyphVector, f, f2);
        this.updateBufferedImage(0, 0, this.imageWidth, this.imageHeight);
    }
}

