/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype;

import gnu.java.awt.font.FontDelegate;
import gnu.java.awt.font.opentype.MacResourceFork;
import gnu.java.awt.font.opentype.OpenTypeFont;
import java.awt.FontFormatException;
import java.nio.ByteBuffer;

public final class OpenTypeFontFactory {
    private OpenTypeFontFactory() {
    }

    public static FontDelegate[] createFonts(ByteBuffer byteBuffer) throws FontFormatException {
        int n = byteBuffer.getInt(0);
        switch (n) {
            case 65536: 
            case 0x4F54544F: 
            case 1936092788: 
            case 1953658213: 
            case 1954115633: {
                return new OpenTypeFont[]{new OpenTypeFont(byteBuffer, 0)};
            }
        }
        if (n == 1953784678) {
            FontDelegate[] fontDelegateArray = new OpenTypeFont[byteBuffer.getInt(8)];
            for (int i = 0; i < fontDelegateArray.length; ++i) {
                fontDelegateArray[i] = new OpenTypeFont(byteBuffer, byteBuffer.getInt(16 + 4 * i));
            }
            return fontDelegateArray;
        }
        try {
            MacResourceFork macResourceFork = new MacResourceFork(byteBuffer);
            MacResourceFork.Resource[] resourceArray = macResourceFork.getResources(1936092788);
            FontDelegate[] fontDelegateArray = new OpenTypeFont[resourceArray.length];
            for (int i = 0; i < fontDelegateArray.length; ++i) {
                fontDelegateArray[i] = new OpenTypeFont(resourceArray[i].getContent(), 0);
            }
            return fontDelegateArray;
        }
        catch (Exception exception) {
            throw new FontFormatException("not in OpenType or TrueType format");
        }
    }
}

