/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.ICache;
import org.eclipse.team.core.ICacheListener;
import org.eclipse.team.core.mapping.ISynchronizationContext;

public class ImageManager {
    private static final String PROP_IMAGE_MANAGER = "org.eclipse.team.ui.imageManager";
    private Map fgImageCache = new HashMap(10);
    private CompareConfiguration compareConfig = new CompareConfiguration();
    private boolean disposed = false;

    public static synchronized ImageManager getImageManager(ISynchronizationContext context) {
        ImageManager manager = (ImageManager)context.getCache().get(PROP_IMAGE_MANAGER);
        if (manager == null) {
            ImageManager newRegistry = new ImageManager();
            context.getCache().put(PROP_IMAGE_MANAGER, (Object)newRegistry);
            context.getCache().addCacheListener(new ICacheListener(){

                public void cacheDisposed(ICache cache) {
                    ImageManager.this.dispose();
                }
            });
            manager = newRegistry;
        }
        return manager;
    }

    public Image getImage(ImageDescriptor descriptor) {
        if (descriptor == null || this.disposed) {
            return null;
        }
        Image image = (Image)this.fgImageCache.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.fgImageCache.put(descriptor, image);
        }
        return image;
    }

    public void dispose() {
        this.disposed = true;
        this.compareConfig.dispose();
        if (this.fgImageCache != null) {
            for (Image element : this.fgImageCache.values()) {
                element.dispose();
            }
        }
    }

    public Image getImage(Image base, int compareKind) {
        if (this.disposed) {
            return null;
        }
        return this.compareConfig.getImage(base, compareKind);
    }
}

