/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.browser.AbstractWebBrowser;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.DefaultBrowserSupport;
import org.eclipse.ui.internal.browser.WebBrowserUtil;

public abstract class InternalBrowserInstance
extends AbstractWebBrowser {
    protected int style;
    protected String name;
    protected String tooltip;
    protected IWorkbenchPart part;
    protected IPartListener listener;
    private Integer windowKey;

    public InternalBrowserInstance(String id, int style, String name, String tooltip) {
        super(WebBrowserUtil.encodeStyle(id, style));
        this.style = style;
        this.name = name;
        this.tooltip = tooltip;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    protected void hookPart(final IWorkbenchPage page, IWorkbenchPart part2) {
        this.part = part2;
        this.listener = new IPartListener(){

            public void partActivated(IWorkbenchPart part3) {
            }

            public void partBroughtToTop(IWorkbenchPart part3) {
            }

            public void partClosed(IWorkbenchPart part3) {
                if (InternalBrowserInstance.this.part.equals(InternalBrowserInstance.this.part)) {
                    InternalBrowserInstance.this.part = null;
                    page.removePartListener(InternalBrowserInstance.this.listener);
                    DefaultBrowserSupport.getInstance().removeBrowser((IWebBrowser)InternalBrowserInstance.this);
                }
            }

            public void partDeactivated(IWorkbenchPart part3) {
            }

            public void partOpened(IWorkbenchPart part3) {
            }
        };
        page.addPartListener(this.listener);
        IWorkbenchWindow window = this.part.getSite().getWorkbenchWindow();
        this.windowKey = new Integer(window.hashCode());
    }

    public Integer getWindowKey() {
        return this.windowKey;
    }
}

