/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryImplementation;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryCollection;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryDate;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryEntry;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryNode;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryProject;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryContentProvider;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;

public final class BrowseRefactoringHistoryContentProvider
extends RefactoringHistoryContentProvider {
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final String WORKSPACE_PROJECT = ".workspace";
    private final RefactoringHistoryControlConfiguration fControlConfiguration;
    private Map fProjectContentProviders = null;
    private Map fProjectRefactoringHistories = null;
    private RefactoringHistory fRefactoringHistory = null;
    private boolean fSortProjects = true;

    public BrowseRefactoringHistoryContentProvider(RefactoringHistoryControlConfiguration configuration) {
        super(configuration);
        Assert.isNotNull((Object)configuration);
        this.fControlConfiguration = configuration;
    }

    public Object[] getChildren(Object element) {
        if (this.fSortProjects && element instanceof RefactoringHistoryNode) {
            RefactoringHistoryNode node = (RefactoringHistoryNode)element;
            if (node instanceof RefactoringHistoryProject) {
                return this.getRefactoringHistoryEntries((RefactoringHistoryProject)node);
            }
            RefactoringHistoryContentProvider provider = this.getRefactoringHistoryContentProvider(node);
            if (provider != null) {
                return provider.getChildren(element);
            }
            return NO_ELEMENTS;
        }
        return super.getChildren(element);
    }

    public Object[] getElements(Object element) {
        if (this.fSortProjects && element instanceof RefactoringHistory) {
            return this.getRootElements();
        }
        return super.getElements(element);
    }

    public Object getParent(Object element) {
        if (this.fSortProjects && element instanceof RefactoringHistoryNode) {
            RefactoringHistoryContentProvider provider = this.getRefactoringHistoryContentProvider((RefactoringHistoryNode)element);
            if (provider != null) {
                return provider.getParent(element);
            }
            return null;
        }
        return super.getParent(element);
    }

    private Map getRefactoringHistories() {
        if (this.fProjectRefactoringHistories == null) {
            this.fProjectRefactoringHistories = new HashMap();
            if (this.fRefactoringHistory != null && !this.fRefactoringHistory.isEmpty()) {
                RefactoringDescriptorProxy[] proxies = this.fRefactoringHistory.getDescriptors();
                int index = 0;
                while (index < proxies.length) {
                    HashSet<RefactoringDescriptorProxy> collection;
                    RefactoringDescriptorProxy proxy = proxies[index];
                    String current = proxy.getProject();
                    if (current == null || current.length() == 0) {
                        current = WORKSPACE_PROJECT;
                    }
                    if ((collection = (HashSet<RefactoringDescriptorProxy>)this.fProjectRefactoringHistories.get(current)) == null) {
                        collection = new HashSet<RefactoringDescriptorProxy>();
                        this.fProjectRefactoringHistories.put(current, collection);
                    }
                    collection.add(proxy);
                    ++index;
                }
                for (String current : new ArrayList(this.fProjectRefactoringHistories.keySet())) {
                    Collection collection = (Collection)this.fProjectRefactoringHistories.get(current);
                    if (collection == null) continue;
                    this.fProjectRefactoringHistories.put(current, new RefactoringHistoryImplementation(collection.toArray(new RefactoringDescriptorProxy[collection.size()])));
                }
            }
        }
        return this.fProjectRefactoringHistories;
    }

    private RefactoringHistory getRefactoringHistory(String project) {
        this.getRefactoringHistories();
        return (RefactoringHistory)this.fProjectRefactoringHistories.get(project);
    }

    private RefactoringHistoryContentProvider getRefactoringHistoryContentProvider(RefactoringHistoryNode node) {
        Assert.isNotNull((Object)node);
        RefactoringHistoryNode root = this.getRootNode(node);
        if (root instanceof RefactoringHistoryProject) {
            RefactoringHistoryContentProvider provider;
            RefactoringHistoryProject extended = (RefactoringHistoryProject)root;
            RefactoringHistory history = this.getRefactoringHistory(extended.getProject());
            if (history != null && (provider = this.getRefactoringHistoryContentProvider(extended.getProject())) != null) {
                provider.inputChanged(null, null, history);
                return provider;
            }
        } else if (!(node instanceof RefactoringHistoryEntry)) {
            return this.getRefactoringHistoryContentProvider(WORKSPACE_PROJECT);
        }
        return null;
    }

    private RefactoringHistoryContentProvider getRefactoringHistoryContentProvider(String project) {
        RefactoringHistoryContentProvider provider;
        if (this.fProjectContentProviders == null) {
            this.fProjectContentProviders = new HashMap();
        }
        if ((provider = (RefactoringHistoryContentProvider)this.fProjectContentProviders.get(project)) == null) {
            provider = this.fControlConfiguration.getContentProvider();
            this.fProjectContentProviders.put(project, provider);
        }
        return provider;
    }

    private Object[] getRefactoringHistoryEntries(RefactoringHistoryProject project) {
        String name = project.getProject();
        RefactoringHistory history = this.getRefactoringHistory(name);
        if (history != null) {
            if (this.fControlConfiguration.isTimeDisplayed()) {
                RefactoringHistoryContentProvider provider = this.getRefactoringHistoryContentProvider(project);
                if (provider != null) {
                    provider.inputChanged(null, null, history);
                    Object[] elements = provider.getRootElements();
                    if (!WORKSPACE_PROJECT.equals(name)) {
                        int index = 0;
                        while (index < elements.length) {
                            if (elements[index] instanceof RefactoringHistoryDate) {
                                RefactoringHistoryDate date = (RefactoringHistoryDate)elements[index];
                                elements[index] = new RefactoringHistoryDate(project, date.getTimeStamp(), date.getKind());
                            }
                            ++index;
                        }
                    }
                    return elements;
                }
            } else {
                RefactoringDescriptorProxy[] proxies = history.getDescriptors();
                Object[] entries = new RefactoringHistoryEntry[proxies.length];
                int index = 0;
                while (index < proxies.length) {
                    entries[index] = new RefactoringHistoryEntry(project, proxies[index]);
                    ++index;
                }
                return entries;
            }
        }
        return NO_ELEMENTS;
    }

    public Object[] getRootElements() {
        if (this.fSortProjects) {
            ArrayList<RefactoringHistoryProject> list = new ArrayList<RefactoringHistoryProject>(32);
            for (String project : this.getRefactoringHistories().keySet()) {
                if (project.equals(WORKSPACE_PROJECT)) {
                    RefactoringHistory history = this.getRefactoringHistory(project);
                    if (project == null) continue;
                    if (this.fControlConfiguration.isTimeDisplayed()) {
                        RefactoringHistoryContentProvider provider = this.getRefactoringHistoryContentProvider(project);
                        if (provider == null) continue;
                        provider.inputChanged(null, null, history);
                        list.addAll((Collection)Arrays.asList(provider.getRootElements()));
                        continue;
                    }
                    RefactoringDescriptorProxy[] proxies = history.getDescriptors();
                    RefactoringHistoryEntry[] entries = new RefactoringHistoryEntry[proxies.length];
                    int index = 0;
                    while (index < proxies.length) {
                        entries[index] = new RefactoringHistoryEntry(null, proxies[index]);
                        ++index;
                    }
                    list.addAll((Collection)Arrays.asList(entries));
                    continue;
                }
                list.add(new RefactoringHistoryProject(project));
            }
            return list.toArray();
        }
        if (this.fControlConfiguration.isTimeDisplayed()) {
            return super.getRootElements();
        }
        return new Object[]{new RefactoringHistoryCollection()};
    }

    private RefactoringHistoryNode getRootNode(RefactoringHistoryNode node) {
        RefactoringHistoryNode current = node;
        RefactoringHistoryNode parent = current.getParent();
        while (parent != null) {
            current = parent;
            parent = current.getParent();
        }
        return current;
    }

    public void inputChanged(Viewer viewer, Object predecessor, Object successor) {
        super.inputChanged(viewer, predecessor, successor);
        if (predecessor == successor) {
            return;
        }
        this.fRefactoringHistory = successor instanceof RefactoringHistory ? (RefactoringHistory)successor : null;
        this.fProjectRefactoringHistories = null;
        this.fProjectContentProviders = null;
    }

    public boolean isSortProjects() {
        return this.fSortProjects;
    }

    public void setSortProjects(boolean sort) {
        if (sort != this.fSortProjects) {
            this.fProjectRefactoringHistories = null;
            this.fProjectContentProviders = null;
        }
        this.fSortProjects = sort;
    }
}

