/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.elements.adapters;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.elements.adapters.AsynchronousDebugLabelAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;

public class MemoryBlockLabelAdapter
extends AsynchronousDebugLabelAdapter {
    protected ImageDescriptor[] getImageDescriptors(Object element, IPresentationContext context) throws CoreException {
        if (element instanceof IMemoryBlock) {
            return new ImageDescriptor[]{DebugPluginImages.getImageDescriptor("IMG_OBJS_VARIABLE")};
        }
        return new ImageDescriptor[0];
    }

    private String getLabel(IMemoryBlock memoryBlock) {
        String memoryBlockLabel = " ";
        if (memoryBlock instanceof IMemoryBlockExtension) {
            if (((IMemoryBlockExtension)memoryBlock).getExpression() != null) {
                memoryBlockLabel = String.valueOf(memoryBlockLabel) + ((IMemoryBlockExtension)memoryBlock).getExpression();
            }
        } else {
            long address = memoryBlock.getStartAddress();
            memoryBlockLabel = Long.toHexString(address);
        }
        return memoryBlockLabel;
    }

    protected String[] getLabels(Object element, IPresentationContext context) throws CoreException {
        if (element instanceof IMemoryBlock) {
            return new String[]{this.getLabel((IMemoryBlock)element)};
        }
        return super.getLabels(element, context);
    }
}

