/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import org.eclipse.debug.internal.ui.actions.context.AbstractDebugContextAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class AbstractDebugContextActionDelegate
implements IWorkbenchWindowActionDelegate,
IActionDelegate2 {
    private AbstractDebugContextAction fDebugAction;
    private IAction fWindowAction;
    private boolean fInitialized = false;

    public void dispose() {
        this.fDebugAction.dispose();
    }

    public void init(IAction action) {
        this.fWindowAction = action;
    }

    public void init(IWorkbenchWindow window) {
        this.setWindow(window);
        this.fDebugAction.init(window);
    }

    public synchronized void run(IAction action) {
        if (!this.fInitialized) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fDebugAction.run();
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void selectionChanged(IAction action, ISelection s) {
    }

    protected AbstractDebugContextAction getAction() {
        return this.fDebugAction;
    }

    protected void setAction(AbstractDebugContextAction action) {
        this.fDebugAction = action;
        action.setDelegate(this);
    }

    protected IWorkbenchWindow getWindow() {
        return this.fDebugAction.getWindow();
    }

    protected void setWindow(IWorkbenchWindow window) {
        this.fDebugAction.setWindow(window);
    }

    public synchronized void setEnabled(boolean enabled) {
        if (!this.fInitialized) {
            this.fInitialized = true;
            this.notifyAll();
        }
        this.fWindowAction.setEnabled(enabled);
    }

    protected IAction getWindowAction() {
        return this.fWindowAction;
    }
}

