/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.xhtml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.xhtml.BundleUtil;
import org.eclipse.help.internal.xhtml.XHTMLCharsetParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UAContentParser {
    private static String TAG_HTML = "html";
    protected static String XHTML1_TRANSITIONAL = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
    protected static String XHTML1_STRICT = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
    protected static String XHTML1_FRAMESET = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd";
    protected static Hashtable dtdMap = new Hashtable();
    private Document document;
    private boolean hasXHTMLContent;

    static {
        String dtdBaseLocation = "dtds/xhtml1-20020801/";
        String dtdLocation = String.valueOf(dtdBaseLocation) + "xhtml1-transitional.dtd";
        URL dtdURL_T = BundleUtil.getResourceAsURL(dtdLocation, "org.eclipse.ui.intro");
        dtdMap.put(XHTML1_TRANSITIONAL, dtdURL_T);
        dtdLocation = String.valueOf(dtdBaseLocation) + "xhtml1-strict.dtd";
        URL dtdURL_S = BundleUtil.getResourceAsURL(dtdLocation, "org.eclipse.ui.intro");
        dtdMap.put(XHTML1_STRICT, dtdURL_S);
        dtdLocation = String.valueOf(dtdBaseLocation) + "xhtml1-frameset.dtd";
        URL dtdURL_F = BundleUtil.getResourceAsURL(dtdLocation, "org.eclipse.ui.intro");
        dtdMap.put(XHTML1_FRAMESET, dtdURL_F);
    }

    public UAContentParser(String content) {
        this.parseDocument(content);
    }

    public UAContentParser(InputStream content) {
        this.parseDocument(content);
    }

    public void parseDocument(Object content) {
        Element rootElement;
        this.document = this.doParse(content);
        if (this.document != null && (rootElement = this.document.getDocumentElement()).getTagName().equals(TAG_HTML)) {
            this.hasXHTMLContent = true;
        }
    }

    private DocumentBuilder createParser() {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setValidating(false);
            docFactory.setNamespaceAware(true);
            docFactory.setExpandEntityReferences(false);
            DocumentBuilder parser = docFactory.newDocumentBuilder();
            parser.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId.equals(XHTML1_TRANSITIONAL) || systemId.equals(XHTML1_STRICT) || systemId.equals(XHTML1_FRAMESET)) {
                        URL dtdURL = (URL)dtdMap.get(systemId);
                        InputSource in = new InputSource(dtdURL.openStream());
                        in.setSystemId(dtdURL.toExternalForm());
                        return in;
                    }
                    return null;
                }
            });
            return parser;
        }
        catch (ParserConfigurationException pce) {
            HelpPlugin.logError(pce.getMessage(), pce);
            return null;
        }
    }

    private Document doParse(Object fileObject) {
        try {
            DocumentBuilder parser = this.createParser();
            if (fileObject instanceof String) {
                return parser.parse((String)fileObject);
            }
            if (fileObject instanceof InputStream) {
                BufferedInputStream in = new BufferedInputStream((InputStream)fileObject);
                String charset = UAContentParser.getCharset(in);
                InputSource input = null;
                input = charset != null ? new InputSource(new InputStreamReader((InputStream)in, charset)) : new InputSource(in);
                return parser.parse(input);
            }
            return null;
        }
        catch (Exception e) {
            HelpPlugin.logError("An error occured while parsing: " + fileObject, e);
            throw new UndeclaredThrowableException(e);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public boolean hasXHTMLContent() {
        return this.hasXHTMLContent;
    }

    private static String getCharset(BufferedInputStream in) throws IOException {
        in.mark(2048);
        byte[] buf = new byte[2048];
        in.read(buf);
        in.reset();
        return XHTMLCharsetParser.getCharsetFromHTML(new ByteArrayInputStream(buf));
    }
}

