/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;

public class SVNMenuIconsPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button useDefault;
    private Button useTortoiseSVN;
    private Button useSubversive;

    private Label createLabel(Composite parent, String text, int horizontalSpan) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = horizontalSpan;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private Button createRadio(Composite group, String label, int horizontalSpan) {
        Button button = new Button(group, 16);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = horizontalSpan;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Group group = new Group(composite, 0);
        group.setText(Policy.bind("MenuIconsPreferencePage.iconSet"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        this.useDefault = this.createRadio((Composite)group, Policy.bind("MenuIconsPreferencePage.default"), 1);
        this.useTortoiseSVN = this.createRadio((Composite)group, "TortoiseSVN", 1);
        this.useSubversive = this.createRadio((Composite)group, "Subversive", 1);
        this.createLabel(composite, "", 2);
        this.createLabel(composite, Policy.bind("MenuIconsPreferencePage.restart"), 2);
        this.initializeValues();
        this.verifyValidation();
        return composite;
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        int iconSet = store.getInt("pref_menu_icon_set");
        this.useTortoiseSVN.setSelection(2 == iconSet);
        this.useDefault.setSelection(1 == iconSet);
        this.useSubversive.setSelection(3 == iconSet);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.useDefault.getSelection()) {
            store.setValue("pref_menu_icon_set", 1);
        } else if (this.useTortoiseSVN.getSelection()) {
            store.setValue("pref_menu_icon_set", 2);
        } else if (this.useSubversive.getSelection()) {
            store.setValue("pref_menu_icon_set", 3);
        }
        SVNUIPlugin.getPlugin().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = this.getPreferenceStore();
        int iconSet = store.getDefaultInt("pref_menu_icon_set");
        this.useTortoiseSVN.setSelection(2 == iconSet);
        this.useDefault.setSelection(1 == iconSet);
        this.useDefault.setSelection(3 == iconSet);
        this.verifyValidation();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return SVNUIPlugin.getPlugin().getPreferenceStore();
    }

    private void verifyValidation() {
        this.setErrorMessage(null);
        this.setValid(this.getErrorMessage() == null);
    }
}

