/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.util;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.ExternalRubyFileEditorInput;

public abstract class EditorOpener {
    private final String filename;

    public EditorOpener(String string) {
        this.filename = string;
    }

    public void open() {
        try {
            IEditorInput iEditorInput = this.createEditorInput(this.filename);
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            IEditorRegistry iEditorRegistry = iWorkbench.getEditorRegistry();
            IWorkbenchPage iWorkbenchPage = iWorkbench.getActiveWorkbenchWindow().getActivePage();
            IEditorDescriptor iEditorDescriptor = iEditorRegistry.getDefaultEditor(this.filename);
            if (iEditorDescriptor == null) {
                return;
            }
            ITextEditor iTextEditor = (ITextEditor)iWorkbenchPage.openEditor(iEditorInput, this.editorId(iEditorDescriptor));
            this.setEditorPosition(iTextEditor);
        }
        catch (PartInitException partInitException) {
            RubyPlugin.log(partInitException);
        }
    }

    protected abstract void setEditorPosition(ITextEditor var1);

    private String editorId(IEditorDescriptor iEditorDescriptor) {
        String string = iEditorDescriptor == null ? "org.eclipse.ui.DefaultTextEditor" : iEditorDescriptor.getId();
        return string;
    }

    private IEditorInput createEditorInput(String string) {
        IFile iFile = this.getWorkspaceFile(string);
        if (iFile == null) {
            return new ExternalRubyFileEditorInput(new File(string));
        }
        return new FileEditorInput(iFile);
    }

    private IFile getWorkspaceFile(String string) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        Path path = new Path(string);
        IFile iFile = iWorkspaceRoot.getFileForLocation((IPath)path);
        return iFile;
    }
}

