/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.browsing;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.CompositeActionGroup;
import org.rubypeople.rdt.internal.ui.browsing.MembersView;
import org.rubypeople.rdt.internal.ui.browsing.PatchedOpenInNewWindowAction;
import org.rubypeople.rdt.internal.ui.browsing.RubyBrowsingContentProvider;
import org.rubypeople.rdt.internal.ui.browsing.RubyElementTypeComparator;
import org.rubypeople.rdt.internal.ui.browsing.ToggleLinkingAction;
import org.rubypeople.rdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.DecoratingRubyLabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyUILabelProvider;
import org.rubypeople.rdt.ui.IWorkingCopyManager;
import org.rubypeople.rdt.ui.PreferenceConstants;
import org.rubypeople.rdt.ui.RubyElementLabelProvider;
import org.rubypeople.rdt.ui.RubyElementLabels;
import org.rubypeople.rdt.ui.RubyElementSorter;
import org.rubypeople.rdt.ui.StandardRubyElementContentProvider;
import org.rubypeople.rdt.ui.actions.CustomFiltersActionGroup;
import org.rubypeople.rdt.ui.actions.OpenEditorActionGroup;

public abstract class RubyBrowsingPart
extends ViewPart
implements ISelectionListener {
    private StructuredViewer fViewer;
    private IMemento fMemento;
    private RubyUILabelProvider fLabelProvider;
    protected IWorkbenchPart fPreviousSelectionProvider;
    protected Object fPreviousSelectedElement;
    private ILabelProvider fTitleProvider;
    private boolean fHasCustomFilter = true;
    private OpenEditorActionGroup fOpenEditorGroup;
    protected CompositeActionGroup fActionGroups;
    private ToggleLinkingAction fToggleLinkingAction;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    private boolean fLinkingEnabled;
    private boolean fProcessSelectionEvents = true;
    private RubyElementTypeComparator fTypeComparator;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            if (iWorkbenchPartReference != null && iWorkbenchPartReference.getId() == RubyBrowsingPart.this.getSite().getId()) {
                RubyBrowsingPart.this.fProcessSelectionEvents = true;
                IWorkbenchPage iWorkbenchPage = RubyBrowsingPart.this.getSite().getWorkbenchWindow().getActivePage();
                if (iWorkbenchPage != null) {
                    RubyBrowsingPart.this.selectionChanged(iWorkbenchPage.getActivePart(), iWorkbenchPage.getSelection());
                }
            }
        }

        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
            if (iWorkbenchPartReference != null && iWorkbenchPartReference.getId() == RubyBrowsingPart.this.getSite().getId()) {
                RubyBrowsingPart.this.fProcessSelectionEvents = false;
            }
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public RubyBrowsingPart() {
        this.initLinkingEnabled();
    }

    protected void createActions() {
        ActionGroup[] actionGroupArray = new ActionGroup[1];
        this.fOpenEditorGroup = new OpenEditorActionGroup((IViewPart)this);
        actionGroupArray[0] = this.fOpenEditorGroup;
        this.fActionGroups = new CompositeActionGroup(actionGroupArray);
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup = new CustomFiltersActionGroup((IViewPart)this, this.fViewer);
        }
        this.fToggleLinkingAction = new ToggleLinkingAction(this);
    }

    protected void hookViewerListeners() {
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent openEvent) {
                IAction iAction = RubyBrowsingPart.this.fOpenEditorGroup.getOpenAction();
                if (iAction.isEnabled()) {
                    iAction.run();
                    RubyBrowsingPart.this.restoreSelection();
                }
            }
        });
    }

    void setHasCustomSetFilter(boolean bl) {
        this.fHasCustomFilter = bl;
    }

    protected boolean hasCustomFilter() {
        return this.fHasCustomFilter;
    }

    protected void setCustomFiltersActionGroup(CustomFiltersActionGroup customFiltersActionGroup) {
        this.fCustomFiltersActionGroup = customFiltersActionGroup;
    }

    void restoreSelection() {
    }

    protected void setOpenEditorGroup(OpenEditorActionGroup openEditorActionGroup) {
        this.fOpenEditorGroup = openEditorActionGroup;
    }

    protected OpenEditorActionGroup getOpenEditorGroup() {
        return this.fOpenEditorGroup;
    }

    public void createPartControl(Composite composite) {
        Assert.isTrue((this.fViewer == null ? 1 : 0) != 0);
        this.fViewer = this.createViewer(composite);
        this.fTypeComparator = new RubyElementTypeComparator();
        this.fLabelProvider = this.createLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)new DecoratingRubyLabelProvider(this.fLabelProvider));
        this.fViewer.setSorter((ViewerSorter)this.createRubyElementSorter());
        this.fViewer.setUseHashlookup(true);
        this.fTitleProvider = this.createTitleProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        if (this.fMemento != null) {
            this.restoreLinkingEnabled(this.fMemento);
        }
        this.createActions();
        if (this.fMemento != null) {
            this.restoreState(this.fMemento);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        this.hookViewerListeners();
        this.fViewer.setContentProvider(this.createContentProvider());
        this.setInitialInput();
        this.setInitialSelection();
        this.getViewSite().getPage().addPostSelectionListener((ISelectionListener)this);
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        this.fillActionBars(this.getViewSite().getActionBars());
    }

    protected ILabelProvider createTitleProvider() {
        return new RubyElementLabelProvider(8);
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.fMemento = iMemento;
    }

    private void restoreLinkingEnabled(IMemento iMemento) {
        Integer n = iMemento.getInteger(this.getLinkToEditorKey());
        if (n != null) {
            this.fLinkingEnabled = n != 0;
        }
    }

    protected void restoreState(IMemento iMemento) {
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup.restoreState(iMemento);
        }
        if (this.fHasCustomFilter) {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.refresh();
            this.fViewer.getControl().setRedraw(true);
        }
    }

    protected StructuredViewer createViewer(Composite composite) {
        return new TreeViewer(composite);
    }

    protected void fillActionBars(IActionBars iActionBars) {
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        this.fillToolBar(iToolBarManager);
        iActionBars.updateActionBars();
        this.fActionGroups.fillActionBars(iActionBars);
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup.fillActionBars(iActionBars);
        }
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        iMenuManager.add((IAction)this.fToggleLinkingAction);
    }

    protected void fillToolBar(IToolBarManager iToolBarManager) {
    }

    protected IContentProvider createContentProvider() {
        return new RubyBrowsingContentProvider(true, this);
    }

    protected final StructuredViewer getViewer() {
        return this.fViewer;
    }

    protected void setInitialInput() {
        ISelection iSelection = this.getSite().getPage().getSelection();
        Object object = this.getSingleElementFromSelection(iSelection);
        if (!(object instanceof IRubyElement) && !((object = this.getSite().getPage().getInput()) instanceof IRubyElement) && object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.rubypeople.rdt.core.IRubyElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object = iAdaptable.getAdapter((Class)clazz);
        }
        this.setInput(this.findInputForRubyElement((IRubyElement)object));
    }

    protected RubyUILabelProvider createLabelProvider() {
        return new AppearanceAwareLabelProvider(0x210000000002L, 3);
    }

    protected void setInput(Object object) {
        this.setViewerInput(object);
        this.updateTitle();
    }

    void updateTitle() {
        this.setTitleToolTip(this.getToolTipText(this.fViewer.getInput()));
    }

    String getToolTipText(Object object) {
        IPath iPath;
        String string = !(object instanceof IResource) ? RubyElementLabels.getTextLabel(object, 0x210000000002L) : ((iPath = ((IResource)object).getFullPath()).isRoot() ? this.getConfigurationElement().getAttribute("name") : iPath.makeRelative().toString());
        return string;
    }

    protected final void setViewer(StructuredViewer structuredViewer) {
        this.fViewer = structuredViewer;
    }

    private void setViewerInput(Object object) {
        this.fProcessSelectionEvents = false;
        this.fViewer.setInput(object);
        this.fProcessSelectionEvents = true;
    }

    private boolean isSearchResultView(IWorkbenchPart iWorkbenchPart) {
        return RubyBrowsingPart.isSearchPlugInActivated() && (iWorkbenchPart instanceof ISearchResultView || iWorkbenchPart instanceof ISearchResultViewPart);
    }

    public static boolean isSearchPlugInActivated() {
        return Platform.getBundle((String)"org.eclipse.search").getState() == 32;
    }

    protected boolean needsToProcessSelectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (!this.fProcessSelectionEvents || iWorkbenchPart == this || this.isSearchResultView(iWorkbenchPart)) {
            if (iWorkbenchPart == this) {
                this.fPreviousSelectionProvider = iWorkbenchPart;
            }
            return false;
        }
        return true;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (!this.needsToProcessSelectionChanged(iWorkbenchPart, iSelection)) {
            return;
        }
        if (this.fToggleLinkingAction.isChecked() && iWorkbenchPart instanceof ITextEditor) {
            this.setSelectionFromEditor(iWorkbenchPart, iSelection);
            return;
        }
        if (!(iSelection instanceof IStructuredSelection)) {
            return;
        }
        Object object = this.getSingleElementFromSelection(iSelection);
        if (object != null && (iWorkbenchPart == null || iWorkbenchPart.equals(this.fPreviousSelectionProvider)) && object.equals(this.fPreviousSelectedElement)) {
            return;
        }
        this.fPreviousSelectedElement = object;
        Object object2 = this.getViewer().getInput();
        if (object != null && object.equals(object2)) {
            IRubyElement iRubyElement = this.findElementToSelect(object);
            if (iRubyElement != null && this.getTypeComparator().compare(object, iRubyElement) < 0) {
                this.setSelection((ISelection)new StructuredSelection((Object)iRubyElement), true);
            } else if (iRubyElement == null && this instanceof MembersView) {
                this.setSelection((ISelection)StructuredSelection.EMPTY, true);
                this.fPreviousSelectedElement = StructuredSelection.EMPTY;
            }
            this.fPreviousSelectionProvider = iWorkbenchPart;
            return;
        }
        if (iWorkbenchPart != this.fPreviousSelectionProvider && object != null && !object.equals(object2) && this.isInputResetBy(object, object2, iWorkbenchPart)) {
            if (!this.isAncestorOf(object, object2)) {
                this.setInput(null);
            }
            this.fPreviousSelectionProvider = iWorkbenchPart;
            return;
        }
        if (iSelection.isEmpty() && !this.isInputResetBy(iWorkbenchPart)) {
            this.fPreviousSelectionProvider = iWorkbenchPart;
            return;
        }
        if (object == null && iWorkbenchPart == this.fPreviousSelectionProvider) {
            this.setInput(null);
            this.fPreviousSelectionProvider = iWorkbenchPart;
            return;
        }
        this.fPreviousSelectionProvider = iWorkbenchPart;
        this.adjustInputAndSetSelection(object);
    }

    void setSelection(ISelection iSelection, boolean bl) {
        if (iSelection != null && iSelection.equals(this.fViewer.getSelection())) {
            return;
        }
        this.fProcessSelectionEvents = false;
        this.fViewer.setSelection(iSelection, bl);
        this.fProcessSelectionEvents = true;
    }

    protected Object getInput() {
        return this.fViewer.getInput();
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return this.getShowInSource();
        }
        return super.getAdapter(clazz);
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(null, RubyBrowsingPart.this.getSite().getSelectionProvider().getSelection());
            }
        };
    }

    void adjustInputAndSetSelection(Object object) {
        if (!(object instanceof IRubyElement)) {
            if (object == null) {
                this.setInput(null);
            }
            this.setSelection((ISelection)StructuredSelection.EMPTY, true);
            return;
        }
        IRubyElement iRubyElement = (IRubyElement)object;
        IRubyElement iRubyElement2 = this.getSuitableRubyElement(this.findElementToSelect(iRubyElement));
        IRubyElement iRubyElement3 = this.findInputForRubyElement(iRubyElement);
        IRubyElement iRubyElement4 = null;
        if (this.getInput() instanceof IRubyElement) {
            iRubyElement4 = (IRubyElement)this.getInput();
        }
        if (iRubyElement2 == null && !this.isValidInput(iRubyElement3) && iRubyElement3 == null && !this.isAncestorOf(iRubyElement, iRubyElement4)) {
            this.setInput(null);
        } else if (this.mustSetNewInput(iRubyElement2, iRubyElement4, iRubyElement3)) {
            this.setInput(iRubyElement3);
            iRubyElement2 = this.getSuitableRubyElement(iRubyElement2);
        }
        if (iRubyElement2 != null && iRubyElement2.exists()) {
            this.setSelection((ISelection)new StructuredSelection((Object)iRubyElement2), true);
        } else {
            this.setSelection((ISelection)StructuredSelection.EMPTY, true);
        }
    }

    IRubyElement getSuitableRubyElement(Object object) {
        if (!(object instanceof IRubyElement)) {
            return null;
        }
        IRubyElement iRubyElement = (IRubyElement)object;
        if (this.fTypeComparator.compare((Object)iRubyElement, 2) > 0) {
            return iRubyElement;
        }
        if (this.isInputAWorkingCopy()) {
            IRubyElement iRubyElement2 = RubyBrowsingPart.getWorkingCopy(iRubyElement);
            if (iRubyElement2 != null) {
                iRubyElement = iRubyElement2;
            }
            return iRubyElement;
        }
        return iRubyElement.getPrimaryElement();
    }

    boolean isInputAWorkingCopy() {
        return ((StandardRubyElementContentProvider)this.getViewer().getContentProvider()).getProvideWorkingCopy();
    }

    protected static IRubyElement getWorkingCopy(IRubyElement iRubyElement) {
        return iRubyElement;
    }

    private boolean mustSetNewInput(IRubyElement iRubyElement, IRubyElement iRubyElement2, IRubyElement iRubyElement3) {
        if (iRubyElement3 == null || !iRubyElement3.equals(iRubyElement2)) {
            if (iRubyElement == null || iRubyElement2 != null) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    protected Comparator getTypeComparator() {
        return this.fTypeComparator;
    }

    private boolean isInputResetBy(Object object, Object object2, IWorkbenchPart iWorkbenchPart) {
        if (object == null) {
            return iWorkbenchPart == this.fPreviousSelectionProvider;
        }
        if (object2 instanceof IRubyElement && object instanceof IRubyElement) {
            return this.getTypeComparator().compare(object, object2) > 0;
        }
        return false;
    }

    private boolean isInputResetBy(IWorkbenchPart iWorkbenchPart) {
        if (!(iWorkbenchPart instanceof RubyBrowsingPart)) {
            return true;
        }
        Object object = this.getViewer().getInput();
        Object object2 = ((RubyBrowsingPart)iWorkbenchPart).getViewer().getInput();
        if (object instanceof Collection) {
            object = ((Collection)object).iterator().next();
        }
        if (object2 instanceof Collection) {
            object2 = ((Collection)object2).iterator().next();
        }
        if (object instanceof IRubyElement && object2 instanceof IRubyElement) {
            return this.getTypeComparator().compare(object2, object) > 0;
        }
        return true;
    }

    protected boolean isAncestorOf(Object object, Object object2) {
        if (object2 instanceof IRubyElement && object instanceof IRubyElement) {
            return !object2.equals(object) && this.internalIsAncestorOf((IRubyElement)object, (IRubyElement)object2);
        }
        return false;
    }

    private boolean internalIsAncestorOf(IRubyElement iRubyElement, IRubyElement iRubyElement2) {
        if (iRubyElement2 != null) {
            return iRubyElement2.equals(iRubyElement) || this.internalIsAncestorOf(iRubyElement, iRubyElement2.getParent());
        }
        return false;
    }

    protected final IRubyElement findElementToSelect(Object object) {
        if (object instanceof IRubyElement) {
            return this.findElementToSelect((IRubyElement)object);
        }
        return null;
    }

    protected abstract IRubyElement findElementToSelect(IRubyElement var1);

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final Object getSingleElementFromSelection(ISelection iSelection) {
        Object e;
        if (!(iSelection instanceof StructuredSelection)) return null;
        if (iSelection.isEmpty()) {
            return null;
        }
        Iterator iterator = ((StructuredSelection)iSelection).iterator();
        Object e2 = iterator.next();
        if (!(e2 instanceof IRubyElement)) {
            Class<?> clazz;
            IRubyElement iRubyElement;
            void var3_5;
            if (e2 instanceof IMarker) {
                IResource iResource = ((IMarker)e2).getResource();
            }
            if (!(var3_5 instanceof IAdaptable)) return var3_5;
            IAdaptable iAdaptable = (IAdaptable)var3_5;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.rubypeople.rdt.core.IRubyElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz2 = class$0 = clazz3;
            }
            if ((iRubyElement = (IRubyElement)iAdaptable.getAdapter((Class)clazz2)) != null) return iRubyElement;
            if (!(var3_5 instanceof IFile)) return iRubyElement;
            IContainer iContainer = ((IFile)var3_5).getParent();
            if (iContainer == null) return null;
            Class<?> clazz4 = class$0;
            Class<?> clazz5 = clazz4;
            if (clazz4 != null) return (IRubyElement)iContainer.getAdapter((Class)clazz5);
            try {
                clazz = Class.forName("org.rubypeople.rdt.core.IRubyElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz5 = class$0 = clazz;
            return (IRubyElement)iContainer.getAdapter((Class)clazz5);
        }
        Object object = this.getViewer().getInput();
        if (object == null || !object.equals(this.findInputForRubyElement((IRubyElement)e2))) {
            if (!iterator.hasNext()) return e2;
            return null;
        }
        do {
            if (!iterator.hasNext()) {
                return e2;
            }
            e = iterator.next();
            if (e instanceof IRubyElement) continue;
            return null;
        } while (object.equals(this.findInputForRubyElement((IRubyElement)e)));
        return null;
    }

    protected IRubyElement findInputForRubyElement(IRubyElement iRubyElement) {
        if (iRubyElement == null || !iRubyElement.exists()) {
            return null;
        }
        if (this.isValidInput(iRubyElement)) {
            return iRubyElement;
        }
        return this.findInputForRubyElement(iRubyElement.getParent());
    }

    protected RubyElementSorter createRubyElementSorter() {
        return new RubyElementSorter();
    }

    Shell getShell() {
        return this.fViewer.getControl().getShell();
    }

    protected final Display getDisplay() {
        return this.fViewer.getControl().getDisplay();
    }

    ISelectionProvider getSelectionProvider() {
        return this.fViewer;
    }

    protected abstract boolean isValidInput(Object var1);

    protected boolean isValidElement(Object object) {
        if (object == null) {
            return false;
        }
        if ((object = this.getSuitableRubyElement(object)) == null) {
            return false;
        }
        Object object2 = this.getViewer().getInput();
        if (object2 == null) {
            return false;
        }
        if (object2 instanceof Collection) {
            return ((Collection)object2).contains(object);
        }
        return object2.equals(object);
    }

    protected IType getTypeForRubyScript(IRubyScript iRubyScript) {
        IType iType = (iRubyScript = (IRubyScript)this.getSuitableRubyElement(iRubyScript)).findPrimaryType();
        if (iType != null) {
            return iType;
        }
        try {
            IType[] iTypeArray = iRubyScript.getTypes();
            if (iTypeArray.length > 0) {
                return iTypeArray[0];
            }
            return null;
        }
        catch (RubyModelException rubyModelException) {
            return null;
        }
    }

    public void dispose() {
        if (this.fViewer != null) {
            this.getViewSite().getPage().removePostSelectionListener((ISelectionListener)this);
            this.getViewSite().getPage().removePartListener(this.fPartListener);
            this.fViewer = null;
        }
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
        }
        super.dispose();
    }

    void setProcessSelectionEvents(boolean bl) {
        this.fProcessSelectionEvents = bl;
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        RubyPlugin.createStandardGroups(iMenuManager);
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fViewer.getSelection();
        int n = iStructuredSelection.size();
        Object object = iStructuredSelection.getFirstElement();
        if (n == 1) {
            this.addOpenNewWindowAction(iMenuManager, object);
        }
        this.fActionGroups.setContext(new ActionContext((ISelection)iStructuredSelection));
        this.fActionGroups.fillContextMenu(iMenuManager);
        this.fActionGroups.setContext(null);
    }

    private void addOpenNewWindowAction(IMenuManager iMenuManager, Object object) {
        if (object instanceof IRubyElement) {
            object = ((IRubyElement)object).getResource();
        }
        if (!(object instanceof IContainer)) {
            return;
        }
        iMenuManager.appendToGroup("group.open", (IAction)new PatchedOpenInNewWindowAction(this.getSite().getWorkbenchWindow(), (IAdaptable)((IContainer)object)));
    }

    public void saveState(IMemento iMemento) {
        if (this.fViewer == null) {
            if (this.fMemento != null) {
                iMemento.putMemento(this.fMemento);
            }
            return;
        }
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup.saveState(iMemento);
        }
        this.saveLinkingEnabled(iMemento);
    }

    private void saveLinkingEnabled(IMemento iMemento) {
        iMemento.putInteger(this.getLinkToEditorKey(), this.fLinkingEnabled ? 1 : 0);
    }

    protected void setInitialSelection() {
        IWorkbenchPart iWorkbenchPart;
        IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
        ISelection iSelection = null;
        if (iWorkbenchPage != null) {
            iSelection = iWorkbenchPage.getSelection();
        }
        if (iSelection instanceof ITextSelection && (iWorkbenchPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()) instanceof IEditorPart) {
            this.setSelectionFromEditor((IWorkbenchPart)((IEditorPart)iWorkbenchPart));
            if (this.fViewer.getSelection() != null) {
                return;
            }
        }
        if (iSelection == null || iSelection.isEmpty()) {
            Object object = this.getSite().getPage().getInput();
            if (!(object instanceof IRubyElement)) {
                if (object instanceof IAdaptable) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.rubypeople.rdt.core.IRubyElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    object = object.getAdapter((Class)clazz);
                } else {
                    return;
                }
            }
            iSelection = new StructuredSelection(object);
        }
        this.selectionChanged(null, iSelection);
    }

    boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    private void initLinkingEnabled() {
        this.fLinkingEnabled = PreferenceConstants.getPreferenceStore().getBoolean(this.getLinkToEditorKey());
    }

    private boolean linkBrowsingViewSelectionToEditor() {
        return this.isLinkingEnabled();
    }

    public void setLinkingEnabled(boolean bl) {
        IEditorPart iEditorPart;
        this.fLinkingEnabled = bl;
        PreferenceConstants.getPreferenceStore().setValue(this.getLinkToEditorKey(), bl);
        if (bl && (iEditorPart = this.getSite().getPage().getActiveEditor()) != null) {
            this.setSelectionFromEditor((IWorkbenchPart)iEditorPart);
        }
    }

    protected abstract String getLinkToEditorKey();

    void setSelectionFromEditor(IWorkbenchPart iWorkbenchPart) {
        if (!(this.fProcessSelectionEvents && this.linkBrowsingViewSelectionToEditor() && iWorkbenchPart instanceof IEditorPart)) {
            return;
        }
        IWorkbenchPartSite iWorkbenchPartSite = iWorkbenchPart.getSite();
        if (iWorkbenchPartSite == null) {
            return;
        }
        ISelectionProvider iSelectionProvider = iWorkbenchPartSite.getSelectionProvider();
        if (iSelectionProvider != null) {
            this.setSelectionFromEditor(iWorkbenchPart, iSelectionProvider.getSelection());
        }
    }

    private void setSelectionFromEditor(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iWorkbenchPart instanceof IEditorPart) {
            Object object;
            IRubyElement iRubyElement = null;
            if (iSelection instanceof IStructuredSelection && (object = this.getSingleElementFromSelection(iSelection)) instanceof IRubyElement) {
                iRubyElement = (IRubyElement)object;
            }
            object = ((IEditorPart)iWorkbenchPart).getEditorInput();
            if (iSelection instanceof ITextSelection) {
                int n = ((ITextSelection)iSelection).getOffset();
                iRubyElement = this.getElementAt((IEditorInput)object, n);
            }
            if (iRubyElement != null) {
                this.adjustInputAndSetSelection(iRubyElement);
                return;
            }
            if (object instanceof IFileEditorInput) {
                IContainer iContainer;
                IRubyElement iRubyElement2;
                IFile iFile = ((IFileEditorInput)object).getFile();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.rubypeople.rdt.core.IRubyElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iRubyElement2 = (IRubyElement)iFile.getAdapter((Class)clazz)) == null && (iContainer = ((IFileEditorInput)object).getFile().getParent()) != null) {
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.rubypeople.rdt.core.IRubyElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    iRubyElement2 = (IRubyElement)iContainer.getAdapter((Class)clazz2);
                }
                if (iRubyElement2 == null) {
                    this.setSelection(null, false);
                    return;
                }
                this.adjustInputAndSetSelection(iRubyElement2);
            }
        }
    }

    protected IRubyElement getElementAt(IEditorInput iEditorInput, int n) {
        IWorkingCopyManager iWorkingCopyManager = RubyPlugin.getDefault().getWorkingCopyManager();
        IRubyScript iRubyScript = iWorkingCopyManager.getWorkingCopy(iEditorInput);
        if (iRubyScript != null) {
            try {
                if (iRubyScript.isConsistent()) {
                    return iRubyScript.getElementAt(n);
                }
            }
            catch (RubyModelException rubyModelException) {}
        }
        return null;
    }
}

