/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.internal.core.LoadpathEntry;
import org.rubypeople.rdt.internal.core.OpenableElementInfo;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.util.Util;

class RubyProjectElementInfo
extends OpenableElementInfo {
    private Object[] nonRubyResources = null;
    public Map pathToResolvedEntries;

    private Object[] computeNonRubyResources(RubyProject rubyProject) {
        IPath iPath = rubyProject.getProject().getFullPath();
        boolean bl = false;
        char[][] cArray = null;
        char[][] cArray2 = null;
        ILoadpathEntry[] iLoadpathEntryArray = rubyProject.getLoadpaths();
        int n = 0;
        while (n < iLoadpathEntryArray.length) {
            ILoadpathEntry iLoadpathEntry = iLoadpathEntryArray[n];
            if (iPath.equals((Object)iLoadpathEntry.getPath())) {
                bl = true;
                cArray = ((LoadpathEntry)iLoadpathEntry).fullInclusionPatternChars();
                cArray2 = ((LoadpathEntry)iLoadpathEntry).fullExclusionPatternChars();
                break;
            }
            ++n;
        }
        Object[] objectArray = new IResource[5];
        int n2 = 0;
        try {
            IResource[] iResourceArray = ((IContainer)rubyProject.getResource()).members();
            int n3 = 0;
            int n4 = iResourceArray.length;
            while (n3 < n4) {
                IResource iResource = iResourceArray[n3];
                switch (iResource.getType()) {
                    case 1: {
                        IPath iPath2 = iResource.getFullPath();
                        iResource.getName();
                        if (bl && !Util.isExcluded(iResource, cArray, cArray2)) break;
                        if (objectArray.length == n2) {
                            Object[] objectArray2 = objectArray;
                            objectArray = new IResource[n2 * 2];
                            System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                        }
                        objectArray[n2++] = iResource;
                        break;
                    }
                    case 2: {
                        IPath iPath2 = iResource.getFullPath();
                        if (bl && !Util.isExcluded(iResource, cArray, cArray2) || this.isLoadpathEntryOrOutputLocation(iPath2, iLoadpathEntryArray)) break;
                        if (objectArray.length == n2) {
                            Object[] objectArray3 = objectArray;
                            objectArray = new IResource[n2 * 2];
                            System.arraycopy(objectArray3, 0, objectArray, 0, n2);
                        }
                        objectArray[n2++] = iResource;
                    }
                }
                ++n3;
            }
            if (objectArray.length != n2) {
                Object[] objectArray4 = objectArray;
                objectArray = new IResource[n2];
                System.arraycopy(objectArray4, 0, objectArray, 0, n2);
            }
        }
        catch (CoreException coreException) {
            objectArray = NO_NON_RUBY_RESOURCES;
            n2 = 0;
        }
        return objectArray;
    }

    Object[] getNonRubyResources(RubyProject rubyProject) {
        if (this.nonRubyResources == null) {
            this.nonRubyResources = this.computeNonRubyResources(rubyProject);
        }
        return this.nonRubyResources;
    }

    private boolean isLoadpathEntryOrOutputLocation(IPath iPath, ILoadpathEntry[] iLoadpathEntryArray) {
        int n = 0;
        int n2 = iLoadpathEntryArray.length;
        while (n < n2) {
            ILoadpathEntry iLoadpathEntry = iLoadpathEntryArray[n];
            if (iLoadpathEntry.getPath().equals((Object)iPath)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void resetCaches() {
        this.pathToResolvedEntries = null;
    }

    void setNonRubyResources(Object[] objectArray) {
        this.nonRubyResources = objectArray;
    }
}

