/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.http;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractRandomAccessContent;
import org.apache.commons.vfs.provider.http.HttpFileObject;
import org.apache.commons.vfs.provider.http.HttpFileSystem;
import org.apache.commons.vfs.util.MonitorInputStream;
import org.apache.commons.vfs.util.RandomAccessMode;

class HttpRandomAccesContent
extends AbstractRandomAccessContent {
    private final HttpFileObject fileObject;
    private final HttpFileSystem fileSystem;
    protected long filePointer = 0L;
    private DataInputStream dis = null;
    private MonitorInputStream mis = null;

    HttpRandomAccesContent(HttpFileObject fileObject, RandomAccessMode mode) {
        super(mode);
        this.fileObject = fileObject;
        this.fileSystem = (HttpFileSystem)this.fileObject.getFileSystem();
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public void seek(long pos) throws IOException {
        if (pos == this.filePointer) {
            return;
        }
        if (pos < 0L) {
            throw new FileSystemException("vfs.provider/random-access-invalid-position.error", new Object[]{new Long(pos)});
        }
        if (this.dis != null) {
            this.close();
        }
        this.filePointer = pos;
    }

    private void createStream() throws IOException {
        if (this.dis != null) {
            return;
        }
        GetMethod getMethod = new GetMethod();
        this.fileObject.setupMethod((HttpMethod)getMethod);
        getMethod.setRequestHeader("Range", "bytes=" + this.filePointer + "-");
        int status = this.fileSystem.getClient().executeMethod((HttpMethod)getMethod);
        if (status != 206) {
            throw new FileSystemException("vfs.provider.http/get-range.error", new Object[]{this.fileObject.getName(), new Long(this.filePointer)});
        }
        this.mis = new HttpFileObject.HttpInputStream(getMethod);
        this.dis = new DataInputStream(new FilterInputStream(this.mis){

            public int read() throws IOException {
                int ret = super.read();
                if (ret > -1) {
                    ++HttpRandomAccesContent.this.filePointer;
                }
                return ret;
            }

            public int read(byte[] b) throws IOException {
                int ret = super.read(b);
                if (ret > -1) {
                    HttpRandomAccesContent.this.filePointer += (long)ret;
                }
                return ret;
            }

            public int read(byte[] b, int off, int len) throws IOException {
                int ret = super.read(b, off, len);
                if (ret > -1) {
                    HttpRandomAccesContent.this.filePointer += (long)ret;
                }
                return ret;
            }
        });
    }

    public void close() throws IOException {
        if (this.dis != null) {
            this.dis.close();
            this.dis = null;
            this.mis = null;
        }
    }

    public long length() throws IOException {
        return this.fileObject.getContent().getSize();
    }

    public byte readByte() throws IOException {
        this.createStream();
        byte data = this.dis.readByte();
        return data;
    }

    public char readChar() throws IOException {
        this.createStream();
        char data = this.dis.readChar();
        return data;
    }

    public double readDouble() throws IOException {
        this.createStream();
        double data = this.dis.readDouble();
        return data;
    }

    public float readFloat() throws IOException {
        this.createStream();
        float data = this.dis.readFloat();
        return data;
    }

    public int readInt() throws IOException {
        this.createStream();
        int data = this.dis.readInt();
        return data;
    }

    public int readUnsignedByte() throws IOException {
        this.createStream();
        int data = this.dis.readUnsignedByte();
        return data;
    }

    public int readUnsignedShort() throws IOException {
        this.createStream();
        int data = this.dis.readUnsignedShort();
        return data;
    }

    public long readLong() throws IOException {
        this.createStream();
        long data = this.dis.readLong();
        return data;
    }

    public short readShort() throws IOException {
        this.createStream();
        short data = this.dis.readShort();
        return data;
    }

    public boolean readBoolean() throws IOException {
        this.createStream();
        boolean data = this.dis.readBoolean();
        return data;
    }

    public int skipBytes(int n) throws IOException {
        this.createStream();
        int data = this.dis.skipBytes(n);
        return data;
    }

    public void readFully(byte[] b) throws IOException {
        this.createStream();
        this.dis.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.createStream();
        this.dis.readFully(b, off, len);
    }

    public String readUTF() throws IOException {
        this.createStream();
        String data = this.dis.readUTF();
        return data;
    }

    public InputStream getInputStream() throws IOException {
        this.createStream();
        return this.dis;
    }
}

