/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationUtil;
import edu.umd.cs.findbugs.BugAnnotationVisitor;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FindBugsMessageFormat;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class TypeAnnotation
implements BugAnnotation {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_ROLE = "TYPE_DEFAULT";
    public static final String EXPECTED_ROLE = "TYPE_EXPECTED";
    public static final String FOUND_ROLE = "TYPE_FOUND";
    public static final String CLOSEIT_ROLE = "TYPE_CLOSEIT";
    public static final String UNHASHABLE_ROLE = "TYPE_UNHASHABLE";
    private final String descriptor;
    private String roleDescription;
    private static final String ELEMENT_NAME = "Type";

    public TypeAnnotation(String typeDescriptor) {
        this(typeDescriptor, DEFAULT_ROLE);
    }

    public TypeAnnotation(String typeDescriptor, String roleDescription) {
        this.descriptor = typeDescriptor;
        this.roleDescription = roleDescription;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getTypeDescriptor() {
        return this.descriptor;
    }

    public void accept(BugAnnotationVisitor visitor) {
        visitor.visitTypeAnnotation(this);
    }

    public String format(String key, ClassAnnotation primaryClass) {
        return new SignatureConverter(this.descriptor).parseNext();
    }

    public void setDescription(String roleDescription) {
        this.roleDescription = roleDescription;
    }

    public String getDescription() {
        return this.roleDescription;
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TypeAnnotation)) {
            return false;
        }
        return this.descriptor.equals(((TypeAnnotation)o).descriptor);
    }

    public int compareTo(BugAnnotation o) {
        if (!(o instanceof TypeAnnotation)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        return this.descriptor.compareTo(((TypeAnnotation)o).descriptor);
    }

    public String toString() {
        String pattern = I18N.instance().getAnnotationDescription(this.roleDescription);
        FindBugsMessageFormat format = new FindBugsMessageFormat(pattern);
        return format.format(new BugAnnotation[]{this}, null);
    }

    public void writeXML(XMLOutput xmlOutput) throws IOException {
        this.writeXML(xmlOutput, false);
    }

    public void writeXML(XMLOutput xmlOutput, boolean addMessages) throws IOException {
        XMLAttributeList attributeList = new XMLAttributeList().addAttribute("descriptor", this.descriptor);
        String role = this.getDescription();
        if (!role.equals(DEFAULT_ROLE)) {
            attributeList.addAttribute("role", role);
        }
        BugAnnotationUtil.writeXML(xmlOutput, ELEMENT_NAME, this, attributeList, addMessages);
    }

    public boolean isSignificant() {
        return true;
    }

    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((BugAnnotation)x0);
    }
}

