/**
 * <copyright>
 *
 * Service Data Objects
 * Version 1.0
 * Licensed Materials - Property of BEA and IBM
 *
 * (c) Copyright BEA Systems, Inc. and International Business Machines Corp 2003.  All rights reserved.
 *
 * </copyright>
 * 
 * $Id: Type.java,v 1.1 2004/03/26 15:24:15 marcelop Exp $
 */
package commonj.sdo;

import java.util.List;

/**
 * A representation of the type of a {@link Property property} of a {@link DataObject data object}.
 */
public interface Type
{
  /**
   * Returns the name of the type.
   * @return the type name.
   */
  String getName();
  
  /**
   * Returns the namespace URI of the type.
   * @return the namespace URI.
   */
  String getURI();

  /**
   * Returns the Java class that this type represents.
   * @return the Java class.
   */
  Class getInstanceClass();

  /**
   * Returns whether the specified object is an instance of this type.
   * @param object the object in question.
   * @return <code>true</code> if the object is an instance.
   * @see Class#isInstance
   */
  boolean isInstance(Object object);

  /**
   * Returns the list of the {@link Property properties} of this type.
   * <p>
   * The expression
   *<pre>
   *   type.getProperties().indexOf(property)
   *</pre>
   * yields the property's index relative to this type.
   * As such, these expressions are equivalent:
   *<pre>
   *    dataObject.{@link DataObject#get(int) get}(i)
   *    dataObject.{@link DataObject#get(Property) get}((Property)dataObject.getType().getProperties().get(i));
   *</pre>
   * </p>
   * @return the properties of the type.
   * @see Property#getContainingType
   */
  List /*Property*/ getProperties();
  
  /**
   * Returns from {@link #getProperties all the properties} of this type, the one with the specified name.
   * As such, these expressions are equivalent:
   *<pre>
   *    dataObject.{@link DataObject#get(String) get}("name")
   *    dataObject.{@link DataObject#get(Property) get}(dataObject.getType().getProperty("name"))
   *</pre>
   * </p>
   * @return the property with the specified name.
   * @see #getProperties
   */
  Property getProperty(String propertyName);
}
