/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.IFn;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IRef;
import clojure.lang.ISeq;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentHashSet;
import clojure.lang.RT;
import clojure.lang.Util;
import clojure.lang.Var;
import java.util.Map;

public class MultiFn
extends AFn {
    public final IFn dispatchFn;
    public final Object defaultDispatchVal;
    public final IRef hierarchy;
    final String name;
    IPersistentMap methodTable;
    IPersistentMap preferTable;
    IPersistentMap methodCache;
    Object cachedHierarchy;
    static final Var assoc = RT.var("clojure.core", "assoc");
    static final Var dissoc = RT.var("clojure.core", "dissoc");
    static final Var isa = RT.var("clojure.core", "isa?");
    static final Var parents = RT.var("clojure.core", "parents");

    public MultiFn(String name2, IFn dispatchFn, Object defaultDispatchVal, IRef hierarchy) throws Exception {
        this.name = name2;
        this.dispatchFn = dispatchFn;
        this.defaultDispatchVal = defaultDispatchVal;
        this.methodTable = PersistentHashMap.EMPTY;
        this.methodCache = this.getMethodTable();
        this.preferTable = PersistentHashMap.EMPTY;
        this.hierarchy = hierarchy;
        this.cachedHierarchy = null;
    }

    public synchronized MultiFn reset() {
        this.methodCache = this.preferTable = PersistentHashMap.EMPTY;
        this.methodTable = this.preferTable;
        this.cachedHierarchy = null;
        return this;
    }

    public synchronized MultiFn addMethod(Object dispatchVal, IFn method) throws Exception {
        this.methodTable = this.getMethodTable().assoc(dispatchVal, method);
        this.resetCache();
        return this;
    }

    public synchronized MultiFn removeMethod(Object dispatchVal) throws Exception {
        this.methodTable = this.getMethodTable().without(dispatchVal);
        this.resetCache();
        return this;
    }

    public synchronized MultiFn preferMethod(Object dispatchValX, Object dispatchValY) throws Exception {
        if (this.prefers(dispatchValY, dispatchValX)) {
            throw new IllegalStateException(String.format("Preference conflict in multimethod '%s': %s is already preferred to %s", this.name, dispatchValY, dispatchValX));
        }
        this.preferTable = this.getPreferTable().assoc(dispatchValX, RT.conj((IPersistentCollection)RT.get(this.getPreferTable(), dispatchValX, PersistentHashSet.EMPTY), dispatchValY));
        this.resetCache();
        return this;
    }

    private boolean prefers(Object x, Object y) throws Exception {
        ISeq ps;
        IPersistentSet xprefs = (IPersistentSet)this.getPreferTable().valAt(x);
        if (xprefs != null && xprefs.contains(y)) {
            return true;
        }
        for (ps = RT.seq(parents.invoke(y)); ps != null; ps = ps.next()) {
            if (!this.prefers(x, ps.first())) continue;
            return true;
        }
        for (ps = RT.seq(parents.invoke(x)); ps != null; ps = ps.next()) {
            if (!this.prefers(ps.first(), y)) continue;
            return true;
        }
        return false;
    }

    private boolean isA(Object x, Object y) throws Exception {
        return RT.booleanCast(isa.invoke(this.hierarchy.deref(), x, y));
    }

    private boolean dominates(Object x, Object y) throws Exception {
        return this.prefers(x, y) || this.isA(x, y);
    }

    private IPersistentMap resetCache() throws Exception {
        this.methodCache = this.getMethodTable();
        this.cachedHierarchy = this.hierarchy.deref();
        return this.methodCache;
    }

    public synchronized IFn getMethod(Object dispatchVal) throws Exception {
        IFn targetFn;
        if (this.cachedHierarchy != this.hierarchy.deref()) {
            this.resetCache();
        }
        if ((targetFn = (IFn)this.methodCache.valAt(dispatchVal)) != null) {
            return targetFn;
        }
        targetFn = this.findAndCacheBestMethod(dispatchVal);
        if (targetFn != null) {
            return targetFn;
        }
        targetFn = (IFn)this.getMethodTable().valAt(this.defaultDispatchVal);
        return targetFn;
    }

    private IFn getFn(Object dispatchVal) throws Exception {
        IFn targetFn = this.getMethod(dispatchVal);
        if (targetFn == null) {
            throw new IllegalArgumentException(String.format("No method in multimethod '%s' for dispatch value: %s", this.name, dispatchVal));
        }
        return targetFn;
    }

    private IFn findAndCacheBestMethod(Object dispatchVal) throws Exception {
        Map.Entry bestEntry = null;
        for (Object o : this.getMethodTable()) {
            Map.Entry e2 = (Map.Entry)o;
            if (!this.isA(dispatchVal, e2.getKey())) continue;
            if (bestEntry == null || this.dominates(e2.getKey(), bestEntry.getKey())) {
                bestEntry = e2;
            }
            if (this.dominates(bestEntry.getKey(), e2.getKey())) continue;
            throw new IllegalArgumentException(String.format("Multiple methods in multimethod '%s' match dispatch value: %s -> %s and %s, and neither is preferred", this.name, dispatchVal, e2.getKey(), bestEntry.getKey()));
        }
        if (bestEntry == null) {
            return null;
        }
        if (this.cachedHierarchy == this.hierarchy.deref()) {
            this.methodCache = this.methodCache.assoc(dispatchVal, bestEntry.getValue());
            return (IFn)bestEntry.getValue();
        }
        this.resetCache();
        return this.findAndCacheBestMethod(dispatchVal);
    }

    public Object invoke() throws Exception {
        return this.getFn(this.dispatchFn.invoke()).invoke();
    }

    public Object invoke(Object arg1) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1));
        Object object = arg1;
        arg1 = null;
        return iFn.invoke(Util.ret1(object, null));
    }

    public Object invoke(Object arg1, Object arg2) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null), Util.ret1(object16, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null), Util.ret1(object16, null), Util.ret1(object17, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        Object object18 = arg18;
        arg18 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null), Util.ret1(object16, null), Util.ret1(object17, null), Util.ret1(object18, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        Object object18 = arg18;
        arg18 = null;
        Object object19 = arg19;
        arg19 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null), Util.ret1(object16, null), Util.ret1(object17, null), Util.ret1(object18, null), Util.ret1(object19, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        Object object18 = arg18;
        arg18 = null;
        Object object19 = arg19;
        arg19 = null;
        Object object20 = arg20;
        arg20 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null), Util.ret1(object16, null), Util.ret1(object17, null), Util.ret1(object18, null), Util.ret1(object19, null), Util.ret1(object20, null));
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20, Object ... args) throws Exception {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, args));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        Object object18 = arg18;
        arg18 = null;
        Object object19 = arg19;
        arg19 = null;
        Object object20 = arg20;
        arg20 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null), Util.ret1(object16, null), Util.ret1(object17, null), Util.ret1(object18, null), Util.ret1(object19, null), Util.ret1(object20, null), args);
    }

    public IPersistentMap getMethodTable() {
        return this.methodTable;
    }

    public IPersistentMap getPreferTable() {
        return this.preferTable;
    }
}

