/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.http;

import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileContentInfo;
import org.apache.commons.vfs.FileContentInfoFactory;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.impl.DefaultFileContentInfo;
import org.apache.commons.vfs.provider.http.HttpFileObject;

public class HttpFileContentInfoFactory
implements FileContentInfoFactory {
    public FileContentInfo create(FileContent fileContent) throws FileSystemException {
        HttpFileObject httpFile = (HttpFileObject)fileContent.getFile();
        String contentType = null;
        String contentEncoding = null;
        Header header = httpFile.getHeadMethod().getResponseHeader("content-type");
        if (header != null) {
            HeaderElement[] element;
            try {
                element = header.getValues();
            }
            catch (HttpException e) {
                throw new FileSystemException(e);
            }
            if (element != null && element.length > 0) {
                contentType = element[0].getName();
            }
        }
        contentEncoding = httpFile.getHeadMethod().getResponseCharSet();
        return new DefaultFileContentInfo(contentType, contentEncoding);
    }
}

