/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AuthenticationJNI;
import com.microsoft.sqlserver.jdbc.DBComms;
import com.microsoft.sqlserver.jdbc.ExecutableRequest;
import com.microsoft.sqlserver.jdbc.FailoverInfo;
import com.microsoft.sqlserver.jdbc.FailoverMapSingleton;
import com.microsoft.sqlserver.jdbc.FailoverServerPortPlaceHolder;
import com.microsoft.sqlserver.jdbc.IOBuffer;
import com.microsoft.sqlserver.jdbc.PacketRequestor;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.SQLServerConnectionSecurityManager;
import com.microsoft.sqlserver.jdbc.SQLServerDatabaseMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPooledConnection;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerSavepoint;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.StreamError;
import com.microsoft.sqlserver.jdbc.StreamLoginAck;
import com.microsoft.sqlserver.jdbc.StreamPacket;
import com.microsoft.sqlserver.jdbc.StreamSSPI;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.XAConnection;

public class SQLServerConnection
extends IOBuffer
implements Connection,
Serializable {
    static final int STATTYPE_STATEMENT = 0;
    static final int STATTYPE_PREPARED = 1;
    static final int STATTYPE_CALLABLE = 2;
    public static final int TRANSACTION_SNAPSHOT = 4096;
    private static final float FAILOVERTIMEOUTSTEP = 0.08f;
    private boolean sendStringParametersAsUnicode = true;
    private boolean lastUpdateCount;
    private int nLockTimeout;
    private String selectMethod;
    Properties activeConnectionProperties;
    private String applicationName;
    private String instanceName;
    private boolean integratedSecurity = false;
    private AuthenticationJNI intAuthentication;
    String sConnectURL;
    String sqlServerVersion;
    boolean xopenStates;
    private boolean databaseAutoCommitMode = true;
    private boolean inXATransaction = false;
    private byte[] transactionDescriptor = new byte[8];
    boolean bIsOpen;
    int connectionID = 0;
    static final int maxDecimalPrecision = 38;
    private static int baseConnectionID = 0;
    private String sCatalog;
    private int transactionIsolationLevel = 2;
    private PacketRequestor[] packetRequestor;
    private SQLServerPooledConnection pooledConnectionParent;
    private DatabaseMetaData databaseMetaData;
    private int nNextSavePointId = 10000;
    private SQLServerConnectionSecurityManager securityManager;
    private Logger connectionlogger;
    int udpMillisecondsTimeout = 10000;
    private String failoverPartnerServerProvided = null;
    private int nHoldability = 1;
    static final int DEFAULT_TDS_PACKET_SIZE = 4096;
    private int tdsPacketSize = 4096;
    private TDSWriter tdsWriter;
    static final int MAX_SQL_LOGIN_NAME_WCHARS = 128;
    volatile ExecutableRequest currentRequest;
    static final char[] OUT = new char[]{' ', 'O', 'U', 'T'};

    boolean sendStringParametersAsUnicode() {
        return this.sendStringParametersAsUnicode;
    }

    final String getSelectMethod() {
        return this.selectMethod;
    }

    final int getTDSPacketSize() {
        return this.tdsPacketSize;
    }

    final void setTDSPacketSize(int n) {
        this.tdsPacketSize = n;
    }

    SQLServerConnection() {
        super(null, 4096);
        this.init();
    }

    void setFailoverPartnerServerProvided(String string) {
        this.failoverPartnerServerProvided = string;
    }

    private static synchronized int nextConnectionID() {
        return ++baseConnectionID;
    }

    Logger getConnectionLogger() {
        return this.connectionlogger;
    }

    boolean inDistributedTransaction() {
        return this.inXATransaction;
    }

    void init() {
        this.connectionlogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerConnection");
        this.connectionID = SQLServerConnection.nextConnectionID();
        this.sCatalog = "master";
        this.packetRequestor = new PacketRequestor[5];
        for (int i = 0; i < 5; ++i) {
            this.packetRequestor[i] = new PacketRequestor();
        }
    }

    void NotImplemented() throws SQLServerException {
        SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_notSupported"), null, false);
    }

    void checkClosed() throws SQLServerException {
        if (!this.bIsOpen) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_connectionIsClosed"), null, false);
        }
    }

    private boolean booleanPropertyOn(String string, String string2) throws SQLServerException {
        if (null == string2) {
            return false;
        }
        String string3 = string2.toLowerCase(Locale.US);
        if (string3.equals("true")) {
            return true;
        }
        if (string3.equals("false")) {
            return false;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidBooleanValue"));
        Object[] objectArray = new Object[]{new String(string)};
        SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
        return false;
    }

    private static String AppendNameValue(String string, String string2, String string3) {
        string = string + string2;
        string = string + " : ";
        string = string3 != null ? string + string3 : string + "no value set";
        string = string + "  ";
        return string;
    }

    void ValidateMaxSQLLoginName(String string, String string2) throws SQLServerException {
        if (string2 != null && string2.length() > 128) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_propertyMaximumExceedsChars"));
            Object[] objectArray = new Object[]{string, new Integer(128)};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
        }
    }

    Connection connect(Properties properties, SQLServerPooledConnection sQLServerPooledConnection) throws SQLServerException {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        MessageFormat messageFormat;
        Object object4;
        String string = "";
        boolean bl = this.connectionlogger.isLoggable(Level.FINE);
        this.activeConnectionProperties = (Properties)properties.clone();
        this.pooledConnectionParent = sQLServerPooledConnection;
        String string2 = null;
        String string3 = null;
        string2 = "user";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        this.ValidateMaxSQLLoginName(string2, string3);
        string2 = "password";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        this.ValidateMaxSQLLoginName(string2, string3);
        string2 = "databaseName";
        string3 = this.activeConnectionProperties.getProperty(string2);
        this.ValidateMaxSQLLoginName(string2, string3);
        string2 = "loginTimeout";
        String string4 = string3 = this.activeConnectionProperties.getProperty(string2);
        if (null != string4 && string4.length() > 0) {
            Object[] objectArray2;
            try {
                int n = Integer.parseInt(string4);
                if (n >= 0 && n <= 65535) {
                    if (n > 10) {
                        this.udpMillisecondsTimeout = n * 1000;
                    }
                } else {
                    object4 = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                    objectArray2 = new Object[]{string4};
                    SQLServerException.makeFromDriverError(this, this, ((Format)object4).format(objectArray2), null, false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                object4 = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                objectArray2 = new Object[]{string4};
                SQLServerException.makeFromDriverError(this, this, ((Format)object4).format(objectArray2), null, false);
            }
        }
        if ((string3 = this.activeConnectionProperties.getProperty(string2 = "serverName")) == null) {
            string3 = "localhost";
        }
        String string5 = "portNumber";
        object4 = this.activeConnectionProperties.getProperty(string5);
        int n = string3.indexOf(92);
        String string6 = null;
        String string7 = null;
        if (n >= 0) {
            string7 = string3.substring(n + 1, string3.length());
            this.ValidateMaxSQLLoginName("instanceName", string7);
            string3 = string3.substring(0, n);
            if (object4 == null || ((String)object4).equals("0")) {
                string6 = this.getInstancePort(string3, string7);
            }
        }
        this.activeConnectionProperties.setProperty(string2, string3);
        String string8 = this.activeConnectionProperties.getProperty("instanceName");
        if (null != string8) {
            string7 = string8;
        }
        if (string7 != null) {
            this.ValidateMaxSQLLoginName("instanceName", string7);
            if (object4 == null || ((String)object4).equals("0")) {
                string6 = this.getInstancePort(string3, string7);
            }
            this.activeConnectionProperties.setProperty("instanceName", string7);
        }
        if (object4 == null || ((String)object4).equals("0")) {
            object4 = string6 == null ? "1433" : string6;
        }
        this.activeConnectionProperties.setProperty(string5, (String)object4);
        string2 = "applicationName";
        string3 = this.activeConnectionProperties.getProperty(string2);
        this.ValidateMaxSQLLoginName(string2, string3);
        string2 = "lastUpdateCount";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "true";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        if ((string3 = this.activeConnectionProperties.getProperty(string2 = "selectMethod")) == null) {
            string3 = "direct";
        }
        if (string3.equals("cursor") || string3.equals("direct")) {
            this.activeConnectionProperties.setProperty(string2, string3);
        } else {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidselectMethod"));
            object3 = new Object[]{new String(string3)};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(object3), null, false);
        }
        string2 = "disableStatementPooling";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 != null && !this.booleanPropertyOn(string2, string3)) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invaliddisableStatementPooling"));
            object3 = new Object[]{new String(string3)};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(object3), null, false);
        }
        if ((string3 = this.activeConnectionProperties.getProperty(string2 = "integratedSecurity")) != null) {
            this.integratedSecurity = this.booleanPropertyOn(string2, string3);
        }
        string2 = "workstationID";
        string3 = this.activeConnectionProperties.getProperty(string2);
        this.ValidateMaxSQLLoginName(string2, string3);
        int n2 = 0;
        try {
            n2 = new Integer(this.activeConnectionProperties.getProperty("portNumber"));
            if (n2 < 0 || n2 > 65535) {
                object3 = new MessageFormat(SQLServerException.getErrString("R_invalidPortNumber"));
                object2 = new Object[]{new Integer(n2)};
                SQLServerException.makeFromDriverError(this, this, ((Format)object3).format(object2), null, false);
            }
        }
        catch (NumberFormatException numberFormatException) {
            object2 = new MessageFormat(SQLServerException.getErrString("R_invalidPortNumber"));
            object = new Object[]{this.activeConnectionProperties.getProperty("portNumber")};
            SQLServerException.makeFromDriverError(this, this, ((Format)object2).format(object), null, false);
        }
        string3 = this.activeConnectionProperties.getProperty("packetSize");
        if (null != string3 && string3.length() > 0) {
            int n3 = -1;
            try {
                n3 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n3 < 512 || n3 > Short.MAX_VALUE) {
                object2 = new MessageFormat(SQLServerException.getErrString("R_invalidPacketSize"));
                object = new Object[]{string3};
                SQLServerException.makeFromDriverError(this, this, ((Format)object2).format(object), null, false);
            }
        }
        if (bl) {
            this.connectionlogger.fine("Calling securityManager.checkConnect(" + this.activeConnectionProperties.getProperty("serverName") + "," + n2 + ")");
        }
        this.securityManager = new SQLServerConnectionSecurityManager(this.activeConnectionProperties.getProperty("serverName"), n2);
        this.securityManager.checkConnect();
        if (bl) {
            this.connectionlogger.fine("securityManager.checkConnect succeeded.");
        }
        if (this.integratedSecurity) {
            if (bl) {
                this.connectionlogger.fine("securityManager.checkLink.");
            }
            this.securityManager.checkLink();
            if (bl) {
                this.connectionlogger.fine("securityManager.checkLink succeedded.");
            }
        }
        this.sendStringParametersAsUnicode = null == this.activeConnectionProperties.getProperty("sendStringParametersAsUnicode") ? true : this.booleanPropertyOn("sendStringParametersAsUnicode", this.activeConnectionProperties.getProperty("sendStringParametersAsUnicode"));
        this.lastUpdateCount = this.booleanPropertyOn("lastUpdateCount", this.activeConnectionProperties.getProperty("lastUpdateCount"));
        this.xopenStates = this.booleanPropertyOn("xopenStates", this.activeConnectionProperties.getProperty("xopenStates"));
        this.selectMethod = null;
        if (this.activeConnectionProperties.getProperty("selectMethod") != null && this.activeConnectionProperties.getProperty("selectMethod").length() > 0) {
            this.selectMethod = this.activeConnectionProperties.getProperty("selectMethod");
        }
        this.applicationName = Util.nameAndVersion(false);
        if (this.activeConnectionProperties.getProperty("applicationName") != null) {
            this.applicationName = this.activeConnectionProperties.getProperty("applicationName");
            this.ValidateMaxSQLLoginName("applicationName", this.applicationName);
        }
        int n4 = 0;
        if (this.activeConnectionProperties.getProperty("loginTimeout") != null && this.activeConnectionProperties.getProperty("loginTimeout").length() > 0) {
            try {
                int n5 = new Integer(this.activeConnectionProperties.getProperty("loginTimeout"));
                if (n5 >= 0 && n5 <= 65535) {
                    n4 = n5;
                } else {
                    object = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                    objectArray = new Object[]{this.activeConnectionProperties.getProperty("loginTimeout")};
                    SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                object = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                objectArray = new Object[]{this.activeConnectionProperties.getProperty("loginTimeout")};
                SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
            }
        }
        this.nLockTimeout = -1;
        if (this.activeConnectionProperties.getProperty("lockTimeout") != null && this.activeConnectionProperties.getProperty("lockTimeout").length() > 0) {
            try {
                int n6 = new Integer(this.activeConnectionProperties.getProperty("lockTimeout"));
                if (n6 >= -1) {
                    this.nLockTimeout = n6;
                } else {
                    object = new MessageFormat(SQLServerException.getErrString("R_invalidLockTimeOut"));
                    objectArray = new Object[]{this.activeConnectionProperties.getProperty("lockTimeout")};
                    SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                object = new MessageFormat(SQLServerException.getErrString("R_invalidLockTimeOut"));
                objectArray = new Object[]{this.activeConnectionProperties.getProperty("lockTimeout")};
                SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
            }
        }
        FailoverInfo failoverInfo = null;
        if (null != this.activeConnectionProperties.getProperty("databaseName")) {
            failoverInfo = FailoverMapSingleton.getFailoverInfo(this, this.activeConnectionProperties.getProperty("serverName"), this.activeConnectionProperties.getProperty("instanceName"), this.activeConnectionProperties.getProperty("databaseName"));
        } else if (null != this.activeConnectionProperties.getProperty("failoverPartner")) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_failoverPartnerWithoutDB"), null, true);
        }
        object = null;
        if (null == failoverInfo) {
            object = this.activeConnectionProperties.getProperty("failoverPartner");
        }
        if (null == object && null == failoverInfo) {
            this.loginWithoutFailover(this.activeConnectionProperties.getProperty("serverName"), n2, n4);
        } else {
            long l = System.currentTimeMillis();
            this.loginWithFailover(this.activeConnectionProperties.getProperty("serverName"), (String)object, failoverInfo, n2, n4, l);
        }
        this.bIsOpen = true;
        if (bl) {
            this.connectionlogger.fine("End of connect");
        }
        return this;
    }

    private void loginWithFailover(String string, String string2, FailoverInfo failoverInfo, int n, int n2, long l) throws SQLServerException {
        String string3;
        long l2;
        long l3;
        long l4;
        FailoverInfo failoverInfo2;
        int n3 = 100;
        boolean bl = false;
        int n4 = n;
        boolean bl2 = this.connectionlogger.isLoggable(Level.FINE);
        FailoverServerPortPlaceHolder failoverServerPortPlaceHolder = null;
        boolean bl3 = false;
        if (null != failoverInfo) {
            failoverInfo2 = failoverInfo;
            failoverServerPortPlaceHolder = failoverInfo2.failoverPermissionCheck(this, this.integratedSecurity);
            bl3 = true;
            bl = failoverServerPortPlaceHolder.getUseFailoverPartner();
        } else {
            failoverInfo2 = new FailoverInfo(string2, this, false);
        }
        if (0 == n2) {
            l4 = 0L;
            l3 = 0L;
            l2 = 0L;
        } else {
            long l5 = n2 * 1000;
            l4 = l + l5;
            l3 = (long)(0.08f * (float)l5);
            l2 = l + l3;
            if (bl2) {
                this.connectionlogger.fine("Start time: " + l + " Time out time: " + l4 + " Timeout Unit Interval: " + l3);
            }
        }
        int n5 = 0;
        while (true) {
            if (bl) {
                if (!bl3) {
                    failoverServerPortPlaceHolder = failoverInfo2.failoverPermissionCheck(this, this.integratedSecurity);
                    bl3 = true;
                }
                string3 = failoverServerPortPlaceHolder.getFailoverPartner();
                n4 = failoverServerPortPlaceHolder.getFailoverPortNumber();
            } else {
                string3 = string;
                n4 = n;
            }
            if (bl2) {
                this.connectionlogger.fine("This attempt server name: " + string3 + " port: " + n4);
                this.connectionlogger.fine("This attempt endtime: " + l2);
                this.connectionlogger.fine("This attempt No: " + n5);
            }
            try {
                this.connectHelper(string3, n4, SQLServerConnection.TimerRemaining(l2), n2);
            }
            catch (SQLServerException sQLServerException) {
                long l6;
                if (18456 == sQLServerException.getErrorCode() || 18488 == sQLServerException.getErrorCode() || 0 != n2 && SQLServerConnection.timerHasExpired(l4)) {
                    throw sQLServerException;
                }
                if (1 == n5 % 2 && 0 != n2 && (l6 = (long)SQLServerConnection.TimerRemaining(l4)) <= (long)n3) {
                    throw sQLServerException;
                }
                if (1 == n5 % 2) {
                    if (bl2) {
                        this.connectionlogger.fine("sleeping milisec: " + n3);
                    }
                    try {
                        Thread.sleep(n3);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    n3 = n3 < 500 ? n3 * 2 : 1000;
                }
                if (0 != n2 && (l2 = System.currentTimeMillis() + l3 * (long)(++n5 / 2 + 1)) > l4) {
                    l2 = l4;
                }
                bl = !bl;
                continue;
            }
            break;
        }
        if (bl && null == this.failoverPartnerServerProvided) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPartnerConfiguration"));
            Object[] objectArray = new Object[]{new String(this.activeConnectionProperties.getProperty("databaseName")), new String(string3)};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
        }
        if (null != this.failoverPartnerServerProvided) {
            if (null != failoverInfo) {
                failoverInfo.failoverAdd(this, bl, this.failoverPartnerServerProvided);
            } else {
                if (bl2) {
                    this.connectionlogger.fine("adding new failover info server: " + this.activeConnectionProperties.getProperty("serverName") + " instance: " + this.activeConnectionProperties.getProperty("instanceName") + " database: " + this.activeConnectionProperties.getProperty("databaseName") + " server provided failover: " + this.failoverPartnerServerProvided);
                }
                failoverInfo2.failoverAdd(this, bl, this.failoverPartnerServerProvided);
                FailoverMapSingleton.putFailoverInfo(this, string, this.activeConnectionProperties.getProperty("instanceName"), this.activeConnectionProperties.getProperty("databaseName"), failoverInfo2, bl, this.failoverPartnerServerProvided);
            }
        }
    }

    private void loginWithoutFailover(String string, int n, int n2) throws SQLServerException {
        boolean bl = this.connectionlogger.isLoggable(Level.FINE);
        this.connectHelper(string, n, n2 * 1000, n2);
        if (null != this.failoverPartnerServerProvided) {
            FailoverInfo failoverInfo = new FailoverInfo(this.failoverPartnerServerProvided, this, false);
            if (bl) {
                this.connectionlogger.fine("adding new failover info server: " + this.activeConnectionProperties.getProperty("serverName") + " instance: " + this.activeConnectionProperties.getProperty("instanceName") + " database: " + this.activeConnectionProperties.getProperty("databaseName") + " server provided failover: " + this.failoverPartnerServerProvided);
            }
            FailoverMapSingleton.putFailoverInfo(this, this.activeConnectionProperties.getProperty("serverName"), this.activeConnectionProperties.getProperty("instanceName"), this.activeConnectionProperties.getProperty("databaseName"), failoverInfo, false, this.failoverPartnerServerProvided);
        }
    }

    static boolean timerHasExpired(long l) {
        boolean bl = System.currentTimeMillis() > l;
        return bl;
    }

    static int TimerRemaining(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l - l2;
        if (l3 > Integer.MAX_VALUE) {
            l3 = Integer.MAX_VALUE;
        }
        if (l3 < 0L) {
            l3 = 1L;
        }
        return (int)l3;
    }

    private void connectHelper(String string, int n, int n2, int n3) throws SQLServerException {
        boolean bl = this.connectionlogger.isLoggable(Level.FINE);
        IOException iOException = null;
        try {
            if (bl) {
                this.connectionlogger.fine("Connecting with server: " + string + " port: " + n + " Timeout slice: " + n2 + " Timeout Full: " + n3);
            }
            if (0 == n3) {
                this.setDbCom(new DBComms(this, string, n, 0));
            } else {
                this.setDbCom(new DBComms(this, string, n, n2));
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (iOException != null) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_tcpipConnectionFailed"));
            Object[] objectArray = new Object[]{""};
            String string2 = iOException.toString();
            string2 = string2.replaceAll(this.activeConnectionProperties.getProperty("serverName"), "");
            String string3 = messageFormat.format(objectArray);
            string3 = string3 + " " + string2;
            SQLServerException.makeFromDriverError(this, this, string3, "08001", false);
        }
        this.tdsWriter = new TDSWriter(this, this.dbCom);
        this.logon(this.sqlStatementForSettings(), n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeRequest(ExecutableRequest executableRequest, int n) throws SQLServerException {
        TDSWriter tDSWriter = this.tdsWriter;
        synchronized (tDSWriter) {
            this.currentRequest = executableRequest;
            try {
                executableRequest.execute(this.tdsWriter);
            }
            finally {
                this.currentRequest = null;
            }
        }
    }

    void doConnectionCommand(ConnectionCommandRequest connectionCommandRequest, TDSWriter tDSWriter) throws SQLServerException {
        tDSWriter.startRequest((byte)1);
        tDSWriter.writeString(connectionCommandRequest.sCommand);
        tDSWriter.endRequest();
        this.dbCom.receive(this);
        this.packetRequestor[0].setType((byte)-3);
        StreamPacket streamPacket = this.processPackets(this, this.packetRequestor, 0, connectionCommandRequest.sContext, true);
    }

    void connectionCommand(String string, String string2) throws SQLServerException {
        this.executeRequest(new ConnectionCommandRequest(this, string, string2), 0);
    }

    String sqlStatementToInitialize() {
        String string = "";
        if (this.nLockTimeout > -1) {
            string = string + " set lock_timeout " + this.nLockTimeout;
        }
        return string;
    }

    void setCatalogName(String string) {
        if (string != null && string.length() > 0) {
            this.sCatalog = string;
        }
    }

    String sqlStatementToSetTransactionIsolationLevel() throws SQLServerException {
        String string = "set transaction isolation level ";
        switch (this.transactionIsolationLevel) {
            case 1: {
                string = string + " read uncommitted ";
                break;
            }
            case 2: {
                string = string + " read committed ";
                break;
            }
            case 4: {
                string = string + " repeatable read ";
                break;
            }
            case 8: {
                string = string + " serializable ";
                break;
            }
            case 4096: {
                string = string + " snapshot ";
                break;
            }
            default: {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidTransactionLevel"));
                Object[] objectArray = new Object[]{new Integer(this.transactionIsolationLevel)};
                SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
            }
        }
        return string;
    }

    static String sqlStatementToSetCommit(boolean bl) {
        return true == bl ? "set implicit_transactions off " : "set implicit_transactions on ";
    }

    String sqlStatementForSettings() throws SQLServerException {
        String string = "";
        string = string + this.sqlStatementToInitialize() + " " + this.sqlStatementToSetTransactionIsolationLevel() + " " + SQLServerConnection.sqlStatementToSetCommit(this.databaseAutoCommitMode);
        return string;
    }

    String getUrl() {
        return this.sConnectURL;
    }

    private Statement makeStatement(int n, String string, boolean bl, int n2, int n3) throws SQLServerException {
        if (n == 0) {
            return new SQLServerStatement(this, bl, n2, n3, this.lastUpdateCount);
        }
        if (n == 1) {
            return new SQLServerPreparedStatement(this, this.getDbCom(), string, bl, n2, n3, this.lastUpdateCount, this.sendStringParametersAsUnicode);
        }
        if (n == 2) {
            return new SQLServerCallableStatement(this, this.getDbCom(), string, bl, n2, n3, this.sendStringParametersAsUnicode);
        }
        return null;
    }

    public Statement createStatement() throws SQLServerException {
        this.checkClosed();
        return this.makeStatement(0, null, false, 1003, 1007);
    }

    SQLServerStatement createInternalStatement() throws SQLServerException {
        return (SQLServerStatement)this.makeStatement(0, null, true, 0, 0);
    }

    PreparedStatement createInternalPreparedStatement(String string) throws SQLServerException {
        PreparedStatement preparedStatement = (PreparedStatement)this.makeStatement(1, string, true, 0, 0);
        return preparedStatement;
    }

    SQLServerCallableStatement createInternalCallableStatement(String string) throws SQLServerException {
        return (SQLServerCallableStatement)this.makeStatement(2, string, true, 0, 0);
    }

    public PreparedStatement prepareStatement(String string) throws SQLServerException {
        this.checkClosed();
        return (PreparedStatement)this.makeStatement(1, string, false, 1003, 1007);
    }

    public CallableStatement prepareCall(String string) throws SQLServerException {
        this.checkClosed();
        return (CallableStatement)this.makeStatement(2, string, false, 1003, 1007);
    }

    public String nativeSQL(String string) throws SQLServerException {
        this.checkClosed();
        return string;
    }

    public void setAutoCommit(boolean bl) throws SQLServerException {
        String string = "";
        this.checkClosed();
        if (bl == this.databaseAutoCommitMode) {
            return;
        }
        if (bl) {
            string = "IF @@TRANCOUNT > 0 COMMIT TRAN ";
        }
        if (this.connectionlogger.isLoggable(Level.FINE)) {
            this.connectionlogger.fine("connection id  :" + this.connectionID + " Autocommitmode current :" + this.databaseAutoCommitMode + "new: " + bl);
        }
        this.connectionCommand(string + SQLServerConnection.sqlStatementToSetCommit(bl), "setAutoCommit");
        this.databaseAutoCommitMode = bl;
    }

    public boolean getAutoCommit() throws SQLServerException {
        this.checkClosed();
        return !this.inXATransaction && this.databaseAutoCommitMode;
    }

    final byte[] getTransactionDescriptor() {
        return this.transactionDescriptor;
    }

    private String conId() {
        String string = this.toString();
        int n = string.indexOf("@");
        if (n > 0) {
            string = "CON:" + string.substring(n, string.length());
        }
        return string;
    }

    public void commit() throws SQLServerException {
        this.checkClosed();
        if (this.databaseAutoCommitMode) {
            return;
        }
        this.connectionCommand("IF @@TRANCOUNT > 0 COMMIT TRAN", "Connection.commit");
    }

    public void rollback() throws SQLServerException {
        this.checkClosed();
        if (this.databaseAutoCommitMode) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_cantInvokeRollback"), null, true);
        }
        this.connectionCommand("IF @@TRANCOUNT > 0 ROLLBACK TRAN", "Connection.rollback");
    }

    public void close() throws SQLServerException {
        if (!this.bIsOpen) {
            return;
        }
        if (this.connectionlogger.isLoggable(Level.FINE)) {
            this.connectionlogger.fine("Closing connection ID:" + this.connectionID);
        }
        this.bIsOpen = false;
        if (null != this.pooledConnectionParent) {
            if (!this.databaseAutoCommitMode && !(this.pooledConnectionParent instanceof XAConnection)) {
                this.connectionCommand("IF @@TRANCOUNT > 0 ROLLBACK TRAN", "close connection");
            }
            this.notifyPooledConnection(null);
            if (this.connectionlogger.isLoggable(Level.FINE)) {
                this.connectionlogger.fine("Connection closed and returned to connection pool ID: " + this.connectionID);
            }
        } else {
            this.getDbCom().close();
            this.setDbCom(null);
        }
        if (this.integratedSecurity) {
            this.intAuthentication.ReleaseClientContext();
        }
    }

    public boolean isClosed() throws SQLServerException {
        return !this.bIsOpen;
    }

    public DatabaseMetaData getMetaData() throws SQLServerException {
        this.checkClosed();
        if (this.databaseMetaData == null) {
            this.databaseMetaData = new SQLServerDatabaseMetaData(this);
        }
        return this.databaseMetaData;
    }

    public void setReadOnly(boolean bl) throws SQLServerException {
        this.checkClosed();
    }

    public boolean isReadOnly() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public void setCatalog(String string) throws SQLServerException {
        this.checkClosed();
        if (string != null) {
            SQLServerStatement sQLServerStatement = this.createInternalStatement();
            sQLServerStatement.executeUpdate("use " + Util.escapeSQLId(string));
            this.sCatalog = string;
            sQLServerStatement.close();
        }
    }

    public String getCatalog() throws SQLServerException {
        this.checkClosed();
        return this.sCatalog;
    }

    public void setTransactionIsolation(int n) throws SQLServerException {
        this.checkClosed();
        if (!this.bIsOpen) {
            return;
        }
        if (this.getDbCom() == null || !this.getDbCom().socketIsOpen()) {
            return;
        }
        if (n == 0) {
            return;
        }
        this.transactionIsolationLevel = n;
        String string = this.sqlStatementToSetTransactionIsolationLevel();
        this.connectionCommand(string, "setTransactionIsolation");
    }

    public int getTransactionIsolation() throws SQLServerException {
        this.checkClosed();
        return this.transactionIsolationLevel;
    }

    public SQLWarning getWarnings() throws SQLServerException {
        this.checkClosed();
        if (this.sqlWarnings == null) {
            return null;
        }
        return (SQLWarning)this.sqlWarnings.elementAt(0);
    }

    public void clearWarnings() throws SQLServerException {
        this.checkClosed();
        this.sqlWarnings = null;
    }

    public Statement createStatement(int n, int n2) throws SQLServerException {
        this.checkClosed();
        return this.makeStatement(0, null, false, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLServerException {
        this.checkClosed();
        return (PreparedStatement)this.makeStatement(1, string, false, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLServerException {
        this.checkClosed();
        return (CallableStatement)this.makeStatement(2, string, false, n, n2);
    }

    public void setTypeMap(Map map) throws SQLServerException {
        this.NotImplemented();
    }

    public Map getTypeMap() throws SQLServerException {
        this.checkClosed();
        return new HashMap();
    }

    private final void logon(String string, int n) throws SQLServerException {
        this.sendLogon(n);
        this.processLogon(string, n);
    }

    private final void processLogon(String string, int n) throws SQLServerException {
        PacketRequestor[] packetRequestorArray = new PacketRequestor[]{new PacketRequestor(-83), new PacketRequestor(-19)};
        StreamPacket streamPacket = this.processPackets(this, packetRequestorArray, packetRequestorArray.length, "Logon", false);
        if (streamPacket instanceof StreamSSPI) {
            StreamSSPI streamSSPI = (StreamSSPI)streamPacket;
            SQLServerConnection sQLServerConnection = this;
            byte[] byArray = new byte[sQLServerConnection.intAuthentication.GetMaxSSPIBlobSize()];
            int[] nArray = new int[1];
            SQLServerConnection sQLServerConnection2 = this;
            nArray[0] = sQLServerConnection2.intAuthentication.GetMaxSSPIBlobSize();
            int[] nArray2 = nArray;
            boolean[] blArray = new boolean[]{false};
            this.SSPIData(this.activeConnectionProperties.getProperty("serverName"), this.activeConnectionProperties.getProperty("portNumber"), streamSSPI.sspiBlob, byArray, nArray2, blArray);
            if (0 != nArray2[0]) {
                this.tdsWriter.startRequest((byte)17, n, null);
                this.tdsWriter.writeBytes(byArray, nArray2[0]);
                this.tdsWriter.endRequest();
            }
            this.dbCom.receive(this, n, null);
            this.processLogon(string, n);
        } else if (streamPacket instanceof StreamLoginAck) {
            StreamLoginAck streamLoginAck = (StreamLoginAck)streamPacket;
            this.sqlServerVersion = streamLoginAck.sSQLServerVersion;
            this.changeSettings(string);
        } else {
            SQLServerException.makeFromDriverError(this, this, ((StreamError)streamPacket).getMessage(), "08001", false);
        }
    }

    private void SSPIData(String string, String string2, byte[] byArray, byte[] byArray2, int[] nArray, boolean[] blArray) throws SQLServerException {
        String string3 = string + ":";
        string3 = string3 + string2;
        int n = null == byArray ? this.intAuthentication.GenerateClientContext(null, 0, byArray2, nArray, blArray, string3) : this.intAuthentication.GenerateClientContext(byArray, byArray.length, byArray2, nArray, blArray, string3);
        if (n != 0) {
            this.connectionlogger.warning("Authentication failed code" + n);
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_notConfiguredForIntegrated"), "08001", false);
        }
    }

    final void JTAUnenlistConnection() throws SQLServerException {
        this.tdsWriter.startRequest((byte)14);
        this.tdsWriter.writeShort((short)1);
        this.tdsWriter.writeShort((short)0);
        this.tdsWriter.endRequest();
        this.dbCom.receive(this);
        PacketRequestor[] packetRequestorArray = new PacketRequestor[]{new PacketRequestor(-3)};
        StreamPacket streamPacket = this.processPackets(this, packetRequestorArray, packetRequestorArray.length, "MS_DTC", false);
        this.inXATransaction = false;
    }

    final void JTAEnlistConnection(byte[] byArray) throws SQLServerException {
        if (byArray.length > Short.MAX_VALUE) {
            throw new SQLServerException(null, "Invalid transaction cookie length.", null, 0, true);
        }
        this.tdsWriter.startRequest((byte)14);
        this.tdsWriter.writeShort((short)1);
        this.tdsWriter.writeShort((short)byArray.length);
        this.tdsWriter.writeBytes(byArray);
        this.tdsWriter.endRequest();
        this.dbCom.receive(this);
        PacketRequestor[] packetRequestorArray = new PacketRequestor[]{new PacketRequestor(-3)};
        StreamPacket streamPacket = this.processPackets(this, packetRequestorArray, packetRequestorArray.length, "MS_DTC", false);
        this.connectionCommand(this.sqlStatementToSetTransactionIsolationLevel(), "JTAEnlistConnection");
        this.inXATransaction = true;
    }

    private void changeSettings(String string) throws SQLServerException {
        this.tdsWriter.startRequest((byte)1);
        this.tdsWriter.writeString(string);
        this.tdsWriter.endRequest();
        this.dbCom.receive(this);
        PacketRequestor[] packetRequestorArray = new PacketRequestor[]{new PacketRequestor(-3)};
        StreamPacket streamPacket = this.processPackets(this, packetRequestorArray, packetRequestorArray.length, "Change Settings", false);
    }

    private byte[] toUCS16(String string) throws SQLServerException {
        if (string == null) {
            return new byte[0];
        }
        int n = string.length();
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byte by = (byte)(c & 0xFF);
            byArray[n2++] = by;
            byArray[n2++] = (byte)(c >> 8 & 0xFF);
        }
        return byArray;
    }

    private byte[] encryptPassword(String string) {
        if (string == null) {
            string = "";
        }
        int n = string.length();
        byte[] byArray = new byte[n * 2];
        for (int i = 0; i < n; ++i) {
            byte by;
            byte by2;
            int n2 = string.charAt(i) ^ 0x5A5A;
            n2 = (n2 & 0xF) << 4 | (n2 & 0xF0) >> 4 | (n2 & 0xF00) << 4 | (n2 & 0xF000) >> 4;
            byArray[i * 2 + 1] = by2 = (byte)((n2 & 0xFF00) >> 8);
            byArray[i * 2 + 0] = by = (byte)(n2 & 0xFF);
        }
        return byArray;
    }

    private void sendLogon(int n) throws SQLServerException {
        int n2;
        int n3;
        String string = this.activeConnectionProperties.getProperty("workstationID");
        String string2 = this.activeConnectionProperties.getProperty("user");
        String string3 = this.activeConnectionProperties.getProperty("password");
        String string4 = this.activeConnectionProperties.getProperty("applicationName");
        String string5 = this.activeConnectionProperties.getProperty("databaseName");
        if (string == null || string.length() == 0) {
            try {
                string = Util.lookupHostName();
            }
            catch (UnknownHostException unknownHostException) {
                SQLServerException.makeFromDriverError(this, this, unknownHostException.getMessage(), "08001", false);
            }
        }
        byte[] byArray = new byte[]{};
        int[] nArray = new int[]{0};
        boolean[] blArray = new boolean[]{false};
        if (this.integratedSecurity) {
            this.intAuthentication = new AuthenticationJNI();
            SQLServerConnection sQLServerConnection = this;
            if (sQLServerConnection.intAuthentication.IsEnabled()) {
                SQLServerConnection sQLServerConnection2 = this;
                nArray[0] = sQLServerConnection2.intAuthentication.GetMaxSSPIBlobSize();
                byArray = new byte[nArray[0]];
                this.SSPIData(this.activeConnectionProperties.getProperty("serverName"), this.activeConnectionProperties.getProperty("portNumber"), null, byArray, nArray, blArray);
                string2 = null;
                string3 = null;
            } else {
                SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_notConfiguredForIntegrated"), "08001", false);
            }
        }
        byte[] byArray2 = this.toUCS16(string);
        byte[] byArray3 = this.toUCS16(string2);
        byte[] byArray4 = this.encryptPassword(string3);
        int n4 = byArray4 != null ? byArray4.length : 0;
        byte[] byArray5 = this.toUCS16(string4);
        byte[] byArray6 = this.toUCS16(string);
        byte[] byArray7 = this.toUCS16(string5);
        byte[] byArray8 = new byte[6];
        int n5 = 0;
        int n6 = 0;
        if (this.getDbCom().getTDSVersion().isYukonOrLater()) {
            n3 = 1913192450;
            n2 = 94;
        } else {
            n3 = 0x71000000;
            n2 = 86;
        }
        n5 = n4 + byArray2.length + byArray3.length + byArray5.length + byArray6.length + byArray7.length + n2 + nArray[0];
        this.tdsWriter.startRequest((byte)16, n, null);
        this.tdsWriter.writeInt(n5);
        this.tdsWriter.writeInt(n3);
        int n7 = 4096;
        try {
            String string6 = this.activeConnectionProperties.getProperty("packetSize");
            if (null != string6 && string6.length() > 0) {
                n7 = Integer.parseInt(string6);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.tdsWriter.writeInt(n7);
        this.tdsWriter.writeInt(0);
        this.tdsWriter.writeInt(0);
        this.tdsWriter.writeInt(0);
        this.tdsWriter.writeByte((byte)-32);
        if (!this.integratedSecurity) {
            this.tdsWriter.writeByte((byte)3);
        } else {
            this.tdsWriter.writeByte((byte)-125);
        }
        this.tdsWriter.writeByte((byte)0);
        this.tdsWriter.writeByte((byte)0);
        this.tdsWriter.writeInt(0);
        this.tdsWriter.writeInt(0);
        this.tdsWriter.writeShort((short)n2);
        this.tdsWriter.writeShort((short)(string == null ? 0 : string.length()));
        n6 += byArray2.length;
        if (!this.integratedSecurity) {
            this.tdsWriter.writeShort((short)(n2 + n6));
            this.tdsWriter.writeShort((short)(string2 == null ? 0 : string2.length()));
            this.tdsWriter.writeShort((short)(n2 + (n6 += byArray3.length)));
            this.tdsWriter.writeShort((short)(string3 == null ? 0 : string3.length()));
            n6 += n4;
        } else {
            this.tdsWriter.writeShort((short)0);
            this.tdsWriter.writeShort((short)0);
            this.tdsWriter.writeShort((short)0);
            this.tdsWriter.writeShort((short)0);
        }
        this.tdsWriter.writeShort((short)(n2 + n6));
        this.tdsWriter.writeShort((short)(string4 == null ? 0 : string4.length()));
        this.tdsWriter.writeShort((short)(n2 + (n6 += byArray5.length)));
        this.tdsWriter.writeShort((short)(string == null ? 0 : string.length()));
        n6 += byArray6.length;
        this.tdsWriter.writeShort((short)0);
        this.tdsWriter.writeShort((short)0);
        this.tdsWriter.writeShort((short)0);
        this.tdsWriter.writeShort((short)0);
        this.tdsWriter.writeShort((short)0);
        this.tdsWriter.writeShort((short)0);
        this.tdsWriter.writeShort((short)(n2 + n6));
        this.tdsWriter.writeShort((short)(string5 == null ? 0 : string5.length()));
        n6 += byArray7.length;
        this.tdsWriter.writeBytes(byArray8);
        if (!this.integratedSecurity) {
            this.tdsWriter.writeShort((short)0);
            this.tdsWriter.writeShort((short)0);
        } else {
            this.tdsWriter.writeShort((short)(n2 + n6));
            if (65535 <= nArray[0]) {
                this.tdsWriter.writeShort((short)-1);
            } else {
                this.tdsWriter.writeShort((short)nArray[0]);
            }
        }
        this.tdsWriter.writeShort((short)0);
        this.tdsWriter.writeShort((short)0);
        if (n3 >= 0x72000000) {
            this.tdsWriter.writeShort((short)0);
            this.tdsWriter.writeShort((short)0);
            if (65535 <= nArray[0]) {
                this.tdsWriter.writeInt(nArray[0]);
            } else {
                this.tdsWriter.writeInt(0);
            }
        }
        this.tdsWriter.writeBytes(byArray2);
        this.tdsWriter.setDataLoggable(false);
        if (!this.integratedSecurity) {
            this.tdsWriter.writeBytes(byArray3);
            this.tdsWriter.writeBytes(byArray4);
        }
        this.tdsWriter.setDataLoggable(true);
        this.tdsWriter.writeBytes(byArray5);
        this.tdsWriter.writeBytes(byArray6);
        this.tdsWriter.writeBytes(byArray7);
        this.tdsWriter.setDataLoggable(false);
        if (this.integratedSecurity) {
            this.tdsWriter.writeBytes(byArray, nArray[0]);
        }
        this.tdsWriter.setDataLoggable(true);
        this.tdsWriter.endRequest();
        this.dbCom.receive(this);
    }

    private void checkHoldability(int n) throws SQLServerException {
        if (n != 1) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_sqlServerHoldability"), null, false);
        }
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        this.checkHoldability(n3);
        return this.createStatement(n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        this.checkHoldability(n3);
        return this.prepareStatement(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        this.checkHoldability(n3);
        return this.prepareCall(string, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLServerException {
        this.checkClosed();
        SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.prepareStatement(string);
        sQLServerPreparedStatement.bRequestedGeneratedKeys = n == 1;
        return sQLServerPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLServerException {
        this.checkClosed();
        if (nArray == null || nArray.length != 1) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.prepareStatement(string);
        sQLServerPreparedStatement.bRequestedGeneratedKeys = true;
        return sQLServerPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLServerException {
        this.checkClosed();
        if (stringArray == null || stringArray.length != 1) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.prepareStatement(string);
        sQLServerPreparedStatement.bRequestedGeneratedKeys = true;
        return sQLServerPreparedStatement;
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLServerException {
        throw Util.notSupportedBySQLServer("releaseSavepoint");
    }

    private final Savepoint setNamedSavepoint(String string) throws SQLServerException {
        if (this.databaseAutoCommitMode) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_cantSetSavepoint"), null, false);
        }
        SQLServerSavepoint sQLServerSavepoint = new SQLServerSavepoint(this, string);
        this.connectionCommand("IF @@TRANCOUNT = 0 BEGIN BEGIN TRAN IF @@TRANCOUNT = 2 COMMIT TRAN END SAVE TRAN " + Util.escapeSQLId(sQLServerSavepoint.getLabel()), "setSavepoint");
        return sQLServerSavepoint;
    }

    public Savepoint setSavepoint(String string) throws SQLServerException {
        this.checkClosed();
        return this.setNamedSavepoint(string);
    }

    public Savepoint setSavepoint() throws SQLServerException {
        this.checkClosed();
        return this.setNamedSavepoint(null);
    }

    public void rollback(Savepoint savepoint) throws SQLServerException {
        this.checkClosed();
        if (this.databaseAutoCommitMode) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_cantInvokeRollback"), null, false);
        }
        this.connectionCommand("IF @@TRANCOUNT > 0 ROLLBACK TRAN " + Util.escapeSQLId(((SQLServerSavepoint)savepoint).getLabel()), "rollbackSavepoint");
    }

    public int getHoldability() throws SQLServerException {
        return this.nHoldability;
    }

    public void setHoldability(int n) throws SQLServerException {
        this.checkClosed();
        if (n == this.nHoldability) {
            return;
        }
        String string = "SET CURSOR_CLOSE_ON_COMMIT ";
        string = n == 1 ? string + "OFF" : string + "ON";
        this.connectionCommand(string, "setHoldability");
        this.nHoldability = n;
    }

    String buildParamTypeDefinitions(Parameter[] parameterArray) throws SQLServerException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = parameterArray.length;
        char[] cArray = new char[10];
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            int n2 = this.makeParamName(i, cArray, 0);
            for (int j = 0; j < n2; ++j) {
                stringBuffer.append(cArray[j]);
            }
            stringBuffer.append(' ');
            String string = parameterArray[i].getTypeDefinition(this.sendStringParametersAsUnicode);
            if (null == string) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueNotSetForParameter"));
                Object[] objectArray = new Object[]{new Integer(i + 1)};
                SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
            }
            stringBuffer.append(string);
            if (!parameterArray[i].isOutput()) continue;
            stringBuffer.append(" OUTPUT");
        }
        return stringBuffer.toString();
    }

    String replaceParameterMarkers(String string, Parameter[] parameterArray, boolean bl) throws SQLServerException {
        char[] cArray = new char[string.length() + parameterArray.length * (6 + OUT.length)];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5 = ParameterUtils.scanSQLForChar('?', string, n2);
            string.getChars(n2, n5, cArray, n);
            n += n5 - n2;
            if (string.length() == n5) break;
            n += this.makeParamName(n3++, cArray, n);
            n2 = n5 + 1;
            if (!parameterArray[n4++].isOutput() || bl && n4 <= 1) continue;
            System.arraycopy(OUT, 0, cArray, n, OUT.length);
            n += OUT.length;
        }
        while (n < cArray.length) {
            cArray[n++] = 32;
        }
        return new String(cArray);
    }

    private int makeParamName(int n, char[] cArray, int n2) {
        cArray[n2 + 0] = 64;
        cArray[n2 + 1] = 80;
        if (n < 10) {
            cArray[n2 + 2] = (char)(48 + n);
            return 3;
        }
        if (n < 100) {
            int n3 = 2;
            while (true) {
                if (n < n3 * 10) {
                    cArray[n2 + 2] = (char)(48 + (n3 - 1));
                    cArray[n2 + 3] = (char)(48 + (n - (n3 - 1) * 10));
                    return 4;
                }
                ++n3;
            }
        }
        String string = "" + n;
        string.getChars(0, string.length(), cArray, n2 + 2);
        return 2 + string.length();
    }

    void notifyPooledConnection(Exception exception) {
        if (null != this.pooledConnectionParent) {
            this.pooledConnectionParent.notifyEvent(exception);
        }
    }

    void DetachFromPool() {
        this.pooledConnectionParent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInstancePort(String string, String string2) throws SQLServerException {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        DatagramSocket datagramSocket = null;
        byte[] byArray = new byte[4096];
        int n = 1434;
        int n2 = this.udpMillisecondsTimeout;
        int n3 = 0;
        try {
            object3 = (" " + string2).getBytes();
            object3[0] = 4;
            while (true) {
                datagramSocket = new DatagramSocket();
                object2 = new DatagramPacket((byte[])object3, ((byte[])object3).length, InetAddress.getByName(string), n);
                datagramSocket.send((DatagramPacket)object2);
                datagramSocket.setSoTimeout(1000);
                object2 = new DatagramPacket(byArray, byArray.length);
                try {
                    datagramSocket.receive((DatagramPacket)object2);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (0 == n3 % 30 && this.connectionlogger.isLoggable(Level.FINE)) {
                        this.connectionlogger.fine("connection id  :" + this.connectionID + " Unexpected UDP timeout at " + (n3 + 1) + " seconds resolving instance port.  Target -> udp:" + InetAddress.getByName(string) + ":1434.");
                    }
                    ++n3;
                    n2 -= 1000;
                    if (null == datagramSocket) continue;
                    datagramSocket.close();
                    datagramSocket = null;
                    if (n2 > 0) continue;
                    throw socketTimeoutException;
                }
                break;
            }
            byArray = ((DatagramPacket)object2).getData();
        }
        catch (IOException iOException) {
            object2 = new MessageFormat(SQLServerException.getErrString("R_failedConnection"));
            object = iOException.toString();
            object = ((String)object).replaceAll(this.activeConnectionProperties.getProperty("serverName"), "");
            object = ((String)object).replaceAll(string2, "");
            objectArray = new Object[]{"", object};
            SQLServerException.makeFromDriverError(this, this, ((Format)object2).format(objectArray), "08001", false);
        }
        finally {
            if (null != datagramSocket) {
                datagramSocket.close();
            }
        }
        object3 = new String(byArray, 3, byArray.length - 3);
        int n4 = ((String)object3).indexOf("tcp;");
        if (-1 != n4) {
            int n5 = n4 + 4;
            int n6 = ((String)object3).indexOf(59, n5);
            String string3 = ((String)object3).substring(n5, n6);
            return string3;
        }
        object = new MessageFormat(SQLServerException.getErrString("R_notConfiguredToListentcpip"));
        objectArray = new Object[]{string2};
        SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), "08001", false);
        return null;
    }

    int getNextSavepointId() {
        ++this.nNextSavePointId;
        return this.nNextSavePointId;
    }

    SQLServerConnectionSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    final class ConnectionCommandRequest
    extends ExecutableRequest {
        final SQLServerConnection con;
        final String sCommand;
        final String sContext;

        ConnectionCommandRequest(SQLServerConnection sQLServerConnection2, String string, String string2) {
            super(sQLServerConnection2);
            this.con = sQLServerConnection2;
            this.sCommand = string;
            this.sContext = string2;
        }

        void execute(TDSWriter tDSWriter) throws SQLServerException {
            this.con.doConnectionCommand(this, tDSWriter);
        }
    }
}

