smooth.construct.cr.smooth.spec     package:mgcv     R Documentation

_P_e_n_a_l_i_z_e_d _C_u_b_i_c _r_e_g_r_e_s_s_i_o_n _s_p_l_i_n_e_s _i_n _G_A_M_s

_D_e_s_c_r_i_p_t_i_o_n:

     'gam' can use univariate penalized cubic regression spline
     smooths, specified via terms like 's(x,bs="cr")'. 's(x,bs="cs")'
     specifies a penalized cubic regression spline in which a small
     ridge  penalty has been added to the cubic spline penalty, in
     order to allow the term to be shrunk  to zero if the  smoothing
     parameter is high enough (as the smoothing parameter goes to
     infinity a normal cubic spline tends to a  straight line.)
     's(x,bs="cc")' specifies a cyclic penalized cubic regression
     spline smooth.

     `Cardinal' spline bases are used: Wood (2006) sections 4.1.2 and
     4.1.3 gives full details. These bases have  very low setup costs.
     For a given basis dimension, 'k', they typically perform a little
     less well  then thin plate regression splines, but a little better
     than p-splines. See 'te' to use these bases in tensor product
     smooths of several variables.

_U_s_a_g_e:

     ## S3 method for class 'cr.smooth.spec':
     smooth.construct(object, data, knots)
     ## S3 method for class 'cs.smooth.spec':
     smooth.construct(object, data, knots)
     ## S3 method for class 'cc.smooth.spec':
     smooth.construct(object, data, knots)

_A_r_g_u_m_e_n_t_s:

  object: a smooth specification object, usually generated by a term
          's(...,bs="cr",...)', 's(...,bs="cs",...)' or
          's(...,bs="cc",...)'

    data: a list containing just the data (including any 'by' variable)
          required by this term,  with names corresponding to
          'object$term' (and 'object$by'). The 'by' variable  is the
          last element.

   knots: a list containing any knots supplied for basis setup - in
          same order and with same names as 'data'.  Can be 'NULL'

_D_e_t_a_i_l_s:

     The constructor is not normally called directly, but is rather
     used internally by 'gam'.  To use for basis setup it is
     recommended to use 'smooth.construct2'.  

     If they are not supplied then the knots  of the spline are placed
     evenly throughout the covariate values to which the term refers: 
     For example, if fitting 101 data with an 11 knot spline of 'x'
     then there would be a knot at every 10th (ordered)  'x' value. The
     parameterization used represents the spline in terms of its values
     at the knots. The values at neighbouring knots are connected by
     sections of  cubic polynomial constrained to be  continuous up to
     and including second derivative at the knots. The resulting curve
     is a natural cubic  spline through the values at the knots (given
     two extra conditions specifying  that the second derivative of the
     curve should be zero at the two end  knots).

     Note that the cyclic smoother will wrap at the smallest and
     largest covariate values, unless knots are supplied, and  is not
     subject to the condition that second derivatives go to zero at the
     first and last knots.

_V_a_l_u_e:

     An object of class '"cr.smooth"' '"cs.smooth"' or
     '"cyclic.smooth"'. In addition to the usual elements of a smooth
     class documented under 'smooth.construct',  this object will
     contain: 

      xp: giving the knot locations used to generate the basis.

      BD: class '"cyclic.smooth"' objects include matrix 'BD' which
          transforms function values  at the knots to second
          derivatives at the knots.

_A_u_t_h_o_r(_s):

     Simon N. Wood simon.wood@r-project.org

_R_e_f_e_r_e_n_c_e_s:

     Wood S.N. (2006) Generalized Additive Models: An Introduction with
     R. Chapman and Hall/CRC Press.

_E_x_a_m_p_l_e_s:

     ## cyclic spline example...
       set.seed(6)
       x <- sort(runif(200)*10)
       z <- runif(200)
       f <- sin(x*2*pi/10)+.5
       y <- rpois(exp(f),exp(f)) 

     ## finished simulating data, now fit model...
       b <- gam(y ~ s(x,bs="cc",k=12) + s(z),family=poisson,
                           knots=list(x=seq(0,10,length=12)))
     ## plot results...
       par(mfrow=c(2,2))
       plot(x,y);plot(b,select=1,shade=TRUE);lines(x,f-mean(f),col=2)
       plot(b,select=2,shade=TRUE);plot(fitted(b),residuals(b))
       

