# NOTE: Derived from lib/Zoidberg/Fish/Commands.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Zoidberg::Fish::Commands;

#line 157 "lib/Zoidberg/Fish/Commands.pm (autosplit into blib/lib/auto/Zoidberg/Fish/Commands/export.al)"
sub export { # TODO if arg == 1 and not hash then export var from zoid::eval to env :D
	my $self = shift;
	my ($opt, $args, $vals) = getopt 'unexport,n print,p *', @_;
	my $class = $$self{shell}{settings}{perl}{namespace};
	no strict 'refs';
	if ($$opt{unexport}) {
		for (@$args) {
			s/^([\$\@]?)//;
			next unless exists $ENV{$_};
			if ($1 eq '@') { @{$class.'::'.$_} = split ':', delete $ENV{$_} }
			else { ${$class.'::'.$_} = delete $ENV{$_} }
		}
	}
	elsif ($$opt{print}) {
		output [ map {
			my $val = $ENV{$_};
			$val =~ s/'/\\'/g;
			"export $_='$val'";
		} sort keys %ENV ];
	}
	else { # really export
		for (@$args) {
			s/^([\$\@]?)//;
			if ($1 eq '@') { # arrays
				my @env  = defined($$vals{$_})               ? (@{$$vals{$_}})     :
					   defined(*{$class.'::'.$_}{ARRAY}) ? (@{$class.'::'.$_}) : () ;
				$ENV{$_} = join ':', @env if @env;
			}
			else { # scalars
				$env = defined($$vals{$_})        ? $$vals{$_}        :
		        	       defined(${$class.'::'.$_}) ? ${$class.'::'.$_} : undef ;
				$ENV{$_} = $env if defined $env;
			}
		}
	}
}

# end of Zoidberg::Fish::Commands::export
1;
