require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ISPVAR_H)) {
    eval 'sub _ISPVAR_H () {1;}' unless defined(&_ISPVAR_H);
    if(defined(&__NetBSD__) || defined(&__OpenBSD__)) {
	require 'dev/ic/isp_stds.ph';
	require 'dev/ic/ispmbox.ph';
    }
    if(defined(&__FreeBSD__)) {
	require 'dev/isp/isp_stds.ph';
	require 'dev/isp/ispmbox.ph';
    }
    if(defined(&__linux__)) {
	require './dev/ic/isp_stds.ph';
	require './dev/ic/ispmbox.ph';
    }
    if(defined(&__svr4__)) {
	require './dev/ic/isp_stds.ph';
	require './dev/ic/ispmbox.ph';
    }
    eval 'sub ISP_CORE_VERSION_MAJOR () {3;}' unless defined(&ISP_CORE_VERSION_MAJOR);
    eval 'sub ISP_CORE_VERSION_MINOR () {0;}' unless defined(&ISP_CORE_VERSION_MINOR);
    eval 'sub MAX_TARGETS () {16;}' unless defined(&MAX_TARGETS);
    eval 'sub MAX_FC_TARG () {512;}' unless defined(&MAX_FC_TARG);
    eval 'sub ISP_MAX_TARGETS {
        my($isp) = @_;
	    eval q(( &IS_FC($isp)?  &MAX_FC_TARG :  &MAX_TARGETS));
    }' unless defined(&ISP_MAX_TARGETS);
    eval 'sub ISP_MAX_LUNS {
        my($isp) = @_;
	    eval q(($isp)-> &isp_maxluns);
    }' unless defined(&ISP_MAX_LUNS);
    eval 'sub ISP_READ_ISR {
        my($isp, $isrp, $semap, $mbox0p) = @_;
	    eval q((*($isp)-> ($isp_mdvec->{dv_rd_isr}))($isp, $isrp, $semap, $mbox0p));
    }' unless defined(&ISP_READ_ISR);
    eval 'sub ISP_READ {
        my($isp, $reg) = @_;
	    eval q((*($isp)-> ($isp_mdvec->{dv_rd_reg}))(($isp), ($reg)));
    }' unless defined(&ISP_READ);
    eval 'sub ISP_WRITE {
        my($isp, $reg, $val) = @_;
	    eval q((*($isp)-> ($isp_mdvec->{dv_wr_reg}))(($isp), ($reg), ($val)));
    }' unless defined(&ISP_WRITE);
    eval 'sub ISP_MBOXDMASETUP {
        my($isp) = @_;
	    eval q((*($isp)-> ($isp_mdvec->{dv_mbxdma}))(($isp)));
    }' unless defined(&ISP_MBOXDMASETUP);
    eval 'sub ISP_DMASETUP {
        my($isp, $xs, $req, $iptrp, $optr) = @_;
	    eval q((*($isp)-> ($isp_mdvec->{dv_dmaset}))(($isp), ($xs), ($req), ($iptrp), ($optr)));
    }' unless defined(&ISP_DMASETUP);
    eval 'sub ISP_DMAFREE {
        my($isp, $xs, $hndl) = @_;
	    eval q( &if (($isp)-> ($isp_mdvec->{dv_dmaclr})) (*($isp)-> ($isp_mdvec->{dv_dmaclr}))(($isp), ($xs), ($hndl)));
    }' unless defined(&ISP_DMAFREE);
    eval 'sub ISP_RESET0 {
        my($isp) = @_;
	    eval q( &if (($isp)-> ($isp_mdvec->{dv_reset0})) (*($isp)-> ($isp_mdvec->{dv_reset0}))(($isp)));
    }' unless defined(&ISP_RESET0);
    eval 'sub ISP_RESET1 {
        my($isp) = @_;
	    eval q( &if (($isp)-> ($isp_mdvec->{dv_reset1})) (*($isp)-> ($isp_mdvec->{dv_reset1}))(($isp)));
    }' unless defined(&ISP_RESET1);
    eval 'sub ISP_DUMPREGS {
        my($isp, $m) = @_;
	    eval q( &if (($isp)-> ($isp_mdvec->{dv_dregs})) (*($isp)-> ($isp_mdvec->{dv_dregs}))(($isp),($m)));
    }' unless defined(&ISP_DUMPREGS);
    eval 'sub ISP_SETBITS {
        my($isp, $reg, $val) = @_;
	    eval q((*($isp)-> ($isp_mdvec->{dv_wr_reg}))(($isp), ($reg),  &ISP_READ(($isp), ($reg)) | ($val)));
    }' unless defined(&ISP_SETBITS);
    eval 'sub ISP_CLRBITS {
        my($isp, $reg, $val) = @_;
	    eval q((*($isp)-> ($isp_mdvec->{dv_wr_reg}))(($isp), ($reg),  &ISP_READ(($isp), ($reg)) & ~($val)));
    }' unless defined(&ISP_CLRBITS);
    eval 'sub SYNC_REQUEST () {0;}' unless defined(&SYNC_REQUEST);
    eval 'sub SYNC_RESULT () {1;}' unless defined(&SYNC_RESULT);
    eval 'sub SYNC_SFORDEV () {2;}' unless defined(&SYNC_SFORDEV);
    eval 'sub SYNC_SFORCPU () {3;}' unless defined(&SYNC_SFORCPU);
    eval 'sub SYNC_REG () {4;}' unless defined(&SYNC_REG);
    eval 'sub SYNC_ATIOQ () {5;}' unless defined(&SYNC_ATIOQ);
    eval 'sub QENTRY_LEN () {64;}' unless defined(&QENTRY_LEN);
    eval 'sub RQUEST_QUEUE_LEN {
        my($x) = @_;
	    eval q( &MAXISPREQUEST($x));
    }' unless defined(&RQUEST_QUEUE_LEN);
    if(defined(&ISP_TARGET_MODE)) {
	eval 'sub RESULT_QUEUE_LEN {
	    my($x) = @_;
    	    eval q( &MAXISPREQUEST($x));
	}' unless defined(&RESULT_QUEUE_LEN);
    } else {
	eval 'sub RESULT_QUEUE_LEN {
	    my($x) = @_;
    	    eval q(((( &MAXISPREQUEST($x) >> 2) < 64)? 64:  &MAXISPREQUEST($x) >> 2));
	}' unless defined(&RESULT_QUEUE_LEN);
    }
    eval 'sub ISP_QUEUE_ENTRY {
        my($q, $idx) = @_;
	    eval q(((( &u_int8_t *)$q) + (($idx) *  &QENTRY_LEN)));
    }' unless defined(&ISP_QUEUE_ENTRY);
    eval 'sub ISP_QUEUE_SIZE {
        my($n) = @_;
	    eval q((($n) *  &QENTRY_LEN));
    }' unless defined(&ISP_QUEUE_SIZE);
    eval 'sub ISP_NXT_QENTRY {
        my($idx, $qlen) = @_;
	    eval q(((($idx) + 1) & (($qlen)-1)));
    }' unless defined(&ISP_NXT_QENTRY);
    eval 'sub ISP_QFREE {
        my($in, $out, $qlen) = @_;
	    eval q((($in == $out)? ($qlen - 1) : (($in > $out)? (($qlen - 1) - ($in - $out)) : ($out - $in - 1))));
    }' unless defined(&ISP_QFREE);
    eval 'sub ISP_QAVAIL {
        my($isp) = @_;
	    eval q( &ISP_QFREE( ($isp->{isp_reqidx}),  ($isp->{isp_reqodx}),  &RQUEST_QUEUE_LEN($isp)));
    }' unless defined(&ISP_QAVAIL);
    eval 'sub ISP_ADD_REQUEST {
        my($isp, $nxti) = @_;
	    eval q( &MEMORYBARRIER($isp,  &SYNC_REQUEST,  ($isp->{isp_reqidx}),  &QENTRY_LEN);  &ISP_WRITE($isp,  ($isp->{isp_rqstinrp}), $nxti);  ($isp->{isp_reqidx}) = $nxti);
    }' unless defined(&ISP_ADD_REQUEST);
    eval 'sub DPARM_DISC () {0x8000;}' unless defined(&DPARM_DISC);
    eval 'sub DPARM_PARITY () {0x4000;}' unless defined(&DPARM_PARITY);
    eval 'sub DPARM_WIDE () {0x2000;}' unless defined(&DPARM_WIDE);
    eval 'sub DPARM_SYNC () {0x1000;}' unless defined(&DPARM_SYNC);
    eval 'sub DPARM_TQING () {0x800;}' unless defined(&DPARM_TQING);
    eval 'sub DPARM_ARQ () {0x400;}' unless defined(&DPARM_ARQ);
    eval 'sub DPARM_QFRZ () {0x200;}' unless defined(&DPARM_QFRZ);
    eval 'sub DPARM_RENEG () {0x100;}' unless defined(&DPARM_RENEG);
    eval 'sub DPARM_NARROW () {0x80;}' unless defined(&DPARM_NARROW);
    eval 'sub DPARM_ASYNC () {0x40;}' unless defined(&DPARM_ASYNC);
    eval 'sub DPARM_PPR () {0x20;}' unless defined(&DPARM_PPR);
    eval 'sub DPARM_DEFAULT () {(0xff00 & ~ &DPARM_QFRZ);}' unless defined(&DPARM_DEFAULT);
    eval 'sub DPARM_SAFE_DFLT () {( &DPARM_DEFAULT & ~( &DPARM_WIDE| &DPARM_SYNC| &DPARM_TQING));}' unless defined(&DPARM_SAFE_DFLT);
    eval 'sub ISP_80M_SYNCPARMS () {0xc09;}' unless defined(&ISP_80M_SYNCPARMS);
    eval 'sub ISP_40M_SYNCPARMS () {0xc0a;}' unless defined(&ISP_40M_SYNCPARMS);
    eval 'sub ISP_20M_SYNCPARMS () {0xc0c;}' unless defined(&ISP_20M_SYNCPARMS);
    eval 'sub ISP_20M_SYNCPARMS_1040 () {0x80c;}' unless defined(&ISP_20M_SYNCPARMS_1040);
    eval 'sub ISP_10M_SYNCPARMS () {0xc19;}' unless defined(&ISP_10M_SYNCPARMS);
    eval 'sub ISP_08M_SYNCPARMS () {0xc25;}' unless defined(&ISP_08M_SYNCPARMS);
    eval 'sub ISP_05M_SYNCPARMS () {0xc32;}' unless defined(&ISP_05M_SYNCPARMS);
    eval 'sub ISP_04M_SYNCPARMS () {0xc41;}' unless defined(&ISP_04M_SYNCPARMS);
    eval 'sub FL_ID () {0x7e;}' unless defined(&FL_ID);
    eval 'sub SNS_ID () {0x80;}' unless defined(&SNS_ID);
    eval 'sub NPH_MAX () {0xfe;}' unless defined(&NPH_MAX);
    eval 'sub NPH_RESERVED () {0x7f0;}' unless defined(&NPH_RESERVED);
    eval 'sub NPH_MGT_ID () {0x7fa;}' unless defined(&NPH_MGT_ID);
    eval 'sub NPH_SNS_ID () {0x7fc;}' unless defined(&NPH_SNS_ID);
    eval 'sub NPH_FL_ID () {0x7fe;}' unless defined(&NPH_FL_ID);
    eval 'sub NPH_MAX_2K () {0x800;}' unless defined(&NPH_MAX_2K);
    eval 'sub NIL_HANDLE () {0xffff;}' unless defined(&NIL_HANDLE);
    eval 'sub LOCAL_LOOP_LIM () {126;}' unless defined(&LOCAL_LOOP_LIM);
    eval 'sub MANAGEMENT_PORT_ID () {0xfffffa;}' unless defined(&MANAGEMENT_PORT_ID);
    eval 'sub SNS_PORT_ID () {0xfffffc;}' unless defined(&SNS_PORT_ID);
    eval 'sub FABRIC_PORT_ID () {0xfffffe;}' unless defined(&FABRIC_PORT_ID);
    eval 'sub FC_PORTDB_STATE_NIL () {0;}' unless defined(&FC_PORTDB_STATE_NIL);
    eval 'sub FC_PORTDB_STATE_PROBATIONAL () {1;}' unless defined(&FC_PORTDB_STATE_PROBATIONAL);
    eval 'sub FC_PORTDB_STATE_DEAD () {2;}' unless defined(&FC_PORTDB_STATE_DEAD);
    eval 'sub FC_PORTDB_STATE_CHANGED () {3;}' unless defined(&FC_PORTDB_STATE_CHANGED);
    eval 'sub FC_PORTDB_STATE_NEW () {4;}' unless defined(&FC_PORTDB_STATE_NEW);
    eval 'sub FC_PORTDB_STATE_PENDING_VALID () {5;}' unless defined(&FC_PORTDB_STATE_PENDING_VALID);
    eval 'sub FC_PORTDB_STATE_ZOMBIE () {6;}' unless defined(&FC_PORTDB_STATE_ZOMBIE);
    eval 'sub FC_PORTDB_STATE_VALID () {7;}' unless defined(&FC_PORTDB_STATE_VALID);
    if(defined(&ISP_FW_CRASH_DUMP)) {
    }
    eval 'sub FW_CONFIG_WAIT () {0;}' unless defined(&FW_CONFIG_WAIT);
    eval 'sub FW_WAIT_AL_PA () {1;}' unless defined(&FW_WAIT_AL_PA);
    eval 'sub FW_WAIT_LOGIN () {2;}' unless defined(&FW_WAIT_LOGIN);
    eval 'sub FW_READY () {3;}' unless defined(&FW_READY);
    eval 'sub FW_LOSS_OF_SYNC () {4;}' unless defined(&FW_LOSS_OF_SYNC);
    eval 'sub FW_ERROR () {5;}' unless defined(&FW_ERROR);
    eval 'sub FW_REINIT () {6;}' unless defined(&FW_REINIT);
    eval 'sub FW_NON_PART () {7;}' unless defined(&FW_NON_PART);
    eval 'sub LOOP_NIL () {0;}' unless defined(&LOOP_NIL);
    eval 'sub LOOP_LIP_RCVD () {1;}' unless defined(&LOOP_LIP_RCVD);
    eval 'sub LOOP_PDB_RCVD () {2;}' unless defined(&LOOP_PDB_RCVD);
    eval 'sub LOOP_SCANNING_LOOP () {3;}' unless defined(&LOOP_SCANNING_LOOP);
    eval 'sub LOOP_LSCAN_DONE () {4;}' unless defined(&LOOP_LSCAN_DONE);
    eval 'sub LOOP_SCANNING_FABRIC () {5;}' unless defined(&LOOP_SCANNING_FABRIC);
    eval 'sub LOOP_FSCAN_DONE () {6;}' unless defined(&LOOP_FSCAN_DONE);
    eval 'sub LOOP_SYNCING_PDB () {7;}' unless defined(&LOOP_SYNCING_PDB);
    eval 'sub LOOP_READY () {8;}' unless defined(&LOOP_READY);
    eval 'sub TOPO_NL_PORT () {0;}' unless defined(&TOPO_NL_PORT);
    eval 'sub TOPO_FL_PORT () {1;}' unless defined(&TOPO_FL_PORT);
    eval 'sub TOPO_N_PORT () {2;}' unless defined(&TOPO_N_PORT);
    eval 'sub TOPO_F_PORT () {3;}' unless defined(&TOPO_F_PORT);
    eval 'sub TOPO_PTP_STUB () {4;}' unless defined(&TOPO_PTP_STUB);
    if(defined(&ISP_TARGET_MODE)) {
    }
    if(defined(&ISP_TARGET_MODE)) {
    }
    eval 'sub SDPARAM {
        my($isp) = @_;
	    eval q((( &sdparam *) ($isp)-> &isp_param));
    }' unless defined(&SDPARAM);
    eval 'sub FCPARAM {
        my($isp) = @_;
	    eval q((( &fcparam *) ($isp)-> &isp_param));
    }' unless defined(&FCPARAM);
    eval 'sub ISP_NILSTATE () {0;}' unless defined(&ISP_NILSTATE);
    eval 'sub ISP_CRASHED () {1;}' unless defined(&ISP_CRASHED);
    eval 'sub ISP_RESETSTATE () {2;}' unless defined(&ISP_RESETSTATE);
    eval 'sub ISP_INITSTATE () {3;}' unless defined(&ISP_INITSTATE);
    eval 'sub ISP_RUNSTATE () {4;}' unless defined(&ISP_RUNSTATE);
    eval 'sub ISP_CFG_NORELOAD () {0x80;}' unless defined(&ISP_CFG_NORELOAD);
    eval 'sub ISP_CFG_NONVRAM () {0x40;}' unless defined(&ISP_CFG_NONVRAM);
    eval 'sub ISP_CFG_TWOGB () {0x20;}' unless defined(&ISP_CFG_TWOGB);
    eval 'sub ISP_CFG_ONEGB () {0x10;}' unless defined(&ISP_CFG_ONEGB);
    eval 'sub ISP_CFG_FULL_DUPLEX () {0x1;}' unless defined(&ISP_CFG_FULL_DUPLEX);
    eval 'sub ISP_CFG_PORT_PREF () {0xc;}' unless defined(&ISP_CFG_PORT_PREF);
    eval 'sub ISP_CFG_LPORT () {0x;}' unless defined(&ISP_CFG_LPORT);
    eval 'sub ISP_CFG_NPORT () {0x4;}' unless defined(&ISP_CFG_NPORT);
    eval 'sub ISP_CFG_NPORT_ONLY () {0x8;}' unless defined(&ISP_CFG_NPORT_ONLY);
    eval 'sub ISP_CFG_LPORT_ONLY () {0xc;}' unless defined(&ISP_CFG_LPORT_ONLY);
    eval 'sub ISP_CFG_OWNWWPN () {0x100;}' unless defined(&ISP_CFG_OWNWWPN);
    eval 'sub ISP_CFG_OWNWWNN () {0x200;}' unless defined(&ISP_CFG_OWNWWNN);
    eval 'sub ISP_CFG_OWNFSZ () {0x400;}' unless defined(&ISP_CFG_OWNFSZ);
    eval 'sub ISP_CFG_OWNLOOPID () {0x800;}' unless defined(&ISP_CFG_OWNLOOPID);
    eval 'sub ISP_CFG_OWNEXCTHROTTLE () {0x1000;}' unless defined(&ISP_CFG_OWNEXCTHROTTLE);
    eval 'sub ISP_CFG_FOURGB () {0x2000;}' unless defined(&ISP_CFG_FOURGB);
    eval 'sub ISP_ROLE_NONE () {0x;}' unless defined(&ISP_ROLE_NONE);
    eval 'sub ISP_ROLE_TARGET () {0x1;}' unless defined(&ISP_ROLE_TARGET);
    eval 'sub ISP_ROLE_INITIATOR () {0x2;}' unless defined(&ISP_ROLE_INITIATOR);
    eval 'sub ISP_ROLE_BOTH () {( &ISP_ROLE_TARGET| &ISP_ROLE_INITIATOR);}' unless defined(&ISP_ROLE_BOTH);
    eval 'sub ISP_ROLE_EITHER () { &ISP_ROLE_BOTH;}' unless defined(&ISP_ROLE_EITHER);
    unless(defined(&ISP_DEFAULT_ROLES)) {
	eval 'sub ISP_DEFAULT_ROLES () { &ISP_ROLE_INITIATOR;}' unless defined(&ISP_DEFAULT_ROLES);
    }
    eval 'sub ISP_CODE_ORG () {0x1000;}' unless defined(&ISP_CODE_ORG);
    eval 'sub ISP_CODE_ORG_2300 () {0x800;}' unless defined(&ISP_CODE_ORG_2300);
    eval 'sub ISP_CODE_ORG_2400 () {0x100000;}' unless defined(&ISP_CODE_ORG_2400);
    eval 'sub ISP_FW_REV {
        my($maj, $min, $mic) = @_;
	    eval q((($maj << 24) | ($min << 16) | $mic));
    }' unless defined(&ISP_FW_REV);
    eval 'sub ISP_FW_MAJOR {
        my($code) = @_;
	    eval q((($code >> 24) & 0xff));
    }' unless defined(&ISP_FW_MAJOR);
    eval 'sub ISP_FW_MINOR {
        my($code) = @_;
	    eval q((($code >> 16) & 0xff));
    }' unless defined(&ISP_FW_MINOR);
    eval 'sub ISP_FW_MICRO {
        my($code) = @_;
	    eval q((($code >> 8) & 0xff));
    }' unless defined(&ISP_FW_MICRO);
    eval 'sub ISP_FW_REVX {
        my($xp) = @_;
	    eval q((($xp->[0]<<24) | ($xp->[1] << 16) | $xp->[2]));
    }' unless defined(&ISP_FW_REVX);
    eval 'sub ISP_FW_MAJORX {
        my($xp) = @_;
	    eval q(($xp->[0]));
    }' unless defined(&ISP_FW_MAJORX);
    eval 'sub ISP_FW_MINORX {
        my($xp) = @_;
	    eval q(($xp->[1]));
    }' unless defined(&ISP_FW_MINORX);
    eval 'sub ISP_FW_MICROX {
        my($xp) = @_;
	    eval q(($xp->[2]));
    }' unless defined(&ISP_FW_MICROX);
    eval 'sub ISP_FW_NEWER_THAN {
        my($i, $major, $minor, $micro) = @_;
	    eval q(( &ISP_FW_REVX(($i)-> &isp_fwrev) >  &ISP_FW_REV($major, $minor, $micro)));
    }' unless defined(&ISP_FW_NEWER_THAN);
    eval 'sub ISP_FW_OLDER_THAN {
        my($i, $major, $minor, $micro) = @_;
	    eval q(( &ISP_FW_REVX(($i)-> &isp_fwrev) <  &ISP_FW_REV($major, $minor, $micro)));
    }' unless defined(&ISP_FW_OLDER_THAN);
    eval 'sub ISP_BT_PCI () {0;}' unless defined(&ISP_BT_PCI);
    eval 'sub ISP_BT_SBUS () {1;}' unless defined(&ISP_BT_SBUS);
    unless(defined(&ISP_SBUS_SUPPORTED)) {
	eval 'sub ISP_SBUS_SUPPORTED () {1;}' unless defined(&ISP_SBUS_SUPPORTED);
    }
    eval 'sub ISP_HA_SCSI () {0xf;}' unless defined(&ISP_HA_SCSI);
    eval 'sub ISP_HA_SCSI_UNKNOWN () {0x1;}' unless defined(&ISP_HA_SCSI_UNKNOWN);
    eval 'sub ISP_HA_SCSI_1020 () {0x2;}' unless defined(&ISP_HA_SCSI_1020);
    eval 'sub ISP_HA_SCSI_1020A () {0x3;}' unless defined(&ISP_HA_SCSI_1020A);
    eval 'sub ISP_HA_SCSI_1040 () {0x4;}' unless defined(&ISP_HA_SCSI_1040);
    eval 'sub ISP_HA_SCSI_1040A () {0x5;}' unless defined(&ISP_HA_SCSI_1040A);
    eval 'sub ISP_HA_SCSI_1040B () {0x6;}' unless defined(&ISP_HA_SCSI_1040B);
    eval 'sub ISP_HA_SCSI_1040C () {0x7;}' unless defined(&ISP_HA_SCSI_1040C);
    eval 'sub ISP_HA_SCSI_1240 () {0x8;}' unless defined(&ISP_HA_SCSI_1240);
    eval 'sub ISP_HA_SCSI_1080 () {0x9;}' unless defined(&ISP_HA_SCSI_1080);
    eval 'sub ISP_HA_SCSI_1280 () {0xa;}' unless defined(&ISP_HA_SCSI_1280);
    eval 'sub ISP_HA_SCSI_10160 () {0xb;}' unless defined(&ISP_HA_SCSI_10160);
    eval 'sub ISP_HA_SCSI_12160 () {0xc;}' unless defined(&ISP_HA_SCSI_12160);
    eval 'sub ISP_HA_FC () {0xf0;}' unless defined(&ISP_HA_FC);
    eval 'sub ISP_HA_FC_2100 () {0x10;}' unless defined(&ISP_HA_FC_2100);
    eval 'sub ISP_HA_FC_2200 () {0x20;}' unless defined(&ISP_HA_FC_2200);
    eval 'sub ISP_HA_FC_2300 () {0x30;}' unless defined(&ISP_HA_FC_2300);
    eval 'sub ISP_HA_FC_2312 () {0x40;}' unless defined(&ISP_HA_FC_2312);
    eval 'sub ISP_HA_FC_2322 () {0x50;}' unless defined(&ISP_HA_FC_2322);
    eval 'sub ISP_HA_FC_2400 () {0x60;}' unless defined(&ISP_HA_FC_2400);
    eval 'sub IS_SCSI {
        my($isp) = @_;
	    eval q(( ($isp->{isp_type}) &  &ISP_HA_SCSI));
    }' unless defined(&IS_SCSI);
    eval 'sub IS_1240 {
        my($isp) = @_;
	    eval q(( ($isp->{isp_type}) ==  &ISP_HA_SCSI_1240));
    }' unless defined(&IS_1240);
    eval 'sub IS_1080 {
        my($isp) = @_;
	    eval q(( ($isp->{isp_type}) ==  &ISP_HA_SCSI_1080));
    }' unless defined(&IS_1080);
    eval 'sub IS_1280 {
        my($isp) = @_;
	    eval q(( ($isp->{isp_type}) ==  &ISP_HA_SCSI_1280));
    }' unless defined(&IS_1280);
    eval 'sub IS_10160 {
        my($isp) = @_;
	    eval q(( ($isp->{isp_type}) ==  &ISP_HA_SCSI_10160));
    }' unless defined(&IS_10160);
    eval 'sub IS_12160 {
        my($isp) = @_;
	    eval q(( ($isp->{isp_type}) ==  &ISP_HA_SCSI_12160));
    }' unless defined(&IS_12160);
    eval 'sub IS_12X0 {
        my($isp) = @_;
	    eval q(( &IS_1240($isp) ||  &IS_1280($isp)));
    }' unless defined(&IS_12X0);
    eval 'sub IS_1X160 {
        my($isp) = @_;
	    eval q(( &IS_10160($isp) ||  &IS_12160($isp)));
    }' unless defined(&IS_1X160);
    eval 'sub IS_DUALBUS {
        my($isp) = @_;
	    eval q(( &IS_12X0($isp) ||  &IS_12160($isp)));
    }' unless defined(&IS_DUALBUS);
    eval 'sub IS_ULTRA2 {
        my($isp) = @_;
	    eval q(( &IS_1080($isp) ||  &IS_1280($isp) ||  &IS_1X160($isp)));
    }' unless defined(&IS_ULTRA2);
    eval 'sub IS_ULTRA3 {
        my($isp) = @_;
	    eval q(( &IS_1X160($isp)));
    }' unless defined(&IS_ULTRA3);
    eval 'sub IS_FC {
        my($isp) = @_;
	    eval q((($isp)-> &isp_type &  &ISP_HA_FC));
    }' unless defined(&IS_FC);
    eval 'sub IS_2100 {
        my($isp) = @_;
	    eval q((($isp)-> &isp_type ==  &ISP_HA_FC_2100));
    }' unless defined(&IS_2100);
    eval 'sub IS_2200 {
        my($isp) = @_;
	    eval q((($isp)-> &isp_type ==  &ISP_HA_FC_2200));
    }' unless defined(&IS_2200);
    eval 'sub IS_23XX {
        my($isp) = @_;
	    eval q((($isp)-> &isp_type >=  &ISP_HA_FC_2300  && ($isp)-> &isp_type <  &ISP_HA_FC_2400));
    }' unless defined(&IS_23XX);
    eval 'sub IS_2300 {
        my($isp) = @_;
	    eval q((($isp)-> &isp_type ==  &ISP_HA_FC_2300));
    }' unless defined(&IS_2300);
    eval 'sub IS_2312 {
        my($isp) = @_;
	    eval q((($isp)-> &isp_type ==  &ISP_HA_FC_2312));
    }' unless defined(&IS_2312);
    eval 'sub IS_2322 {
        my($isp) = @_;
	    eval q((($isp)-> &isp_type ==  &ISP_HA_FC_2322));
    }' unless defined(&IS_2322);
    eval 'sub IS_24XX {
        my($isp) = @_;
	    eval q((($isp)-> &isp_type >=  &ISP_HA_FC_2400));
    }' unless defined(&IS_24XX);
    eval 'sub DMA_WD3 {
        my($x) = @_;
	    eval q(((( &u_int16_t)((( &u_int64_t)$x) >> 48)) & 0xffff));
    }' unless defined(&DMA_WD3);
    eval 'sub DMA_WD2 {
        my($x) = @_;
	    eval q(((( &u_int16_t)((( &u_int64_t)$x) >> 32)) & 0xffff));
    }' unless defined(&DMA_WD2);
    eval 'sub DMA_WD1 {
        my($x) = @_;
	    eval q((( &u_int16_t)(($x) >> 16) & 0xffff));
    }' unless defined(&DMA_WD1);
    eval 'sub DMA_WD0 {
        my($x) = @_;
	    eval q((( &u_int16_t)(($x) & 0xffff)));
    }' unless defined(&DMA_WD0);
    eval 'sub DMA_LO32 {
        my($x) = @_;
	    eval q((( &u_int32_t) ($x)));
    }' unless defined(&DMA_LO32);
    eval 'sub DMA_HI32 {
        my($x) = @_;
	    eval q((( &u_int32_t)((( &u_int64_t)$x) >> 32)));
    }' unless defined(&DMA_HI32);
    if(defined(&ISP_FW_CRASH_DUMP)) {
    }
    eval 'sub CMD_COMPLETE () {101;}' unless defined(&CMD_COMPLETE);
    eval 'sub CMD_EAGAIN () {102;}' unless defined(&CMD_EAGAIN);
    eval 'sub CMD_QUEUED () {103;}' unless defined(&CMD_QUEUED);
    eval 'sub CMD_RQLATER () {104;}' unless defined(&CMD_RQLATER);
    eval("sub ISPCTL_RESET_BUS () { 0; }") unless defined(&ISPCTL_RESET_BUS);
    eval("sub ISPCTL_RESET_DEV () { 1; }") unless defined(&ISPCTL_RESET_DEV);
    eval("sub ISPCTL_ABORT_CMD () { 2; }") unless defined(&ISPCTL_ABORT_CMD);
    eval("sub ISPCTL_UPDATE_PARAMS () { 3; }") unless defined(&ISPCTL_UPDATE_PARAMS);
    eval("sub ISPCTL_FCLINK_TEST () { 4; }") unless defined(&ISPCTL_FCLINK_TEST);
    eval("sub ISPCTL_SCAN_FABRIC () { 5; }") unless defined(&ISPCTL_SCAN_FABRIC);
    eval("sub ISPCTL_SCAN_LOOP () { 6; }") unless defined(&ISPCTL_SCAN_LOOP);
    eval("sub ISPCTL_PDB_SYNC () { 7; }") unless defined(&ISPCTL_PDB_SYNC);
    eval("sub ISPCTL_SEND_LIP () { 8; }") unless defined(&ISPCTL_SEND_LIP);
    eval("sub ISPCTL_GET_PORTNAME () { 9; }") unless defined(&ISPCTL_GET_PORTNAME);
    eval("sub ISPCTL_RUN_MBOXCMD () { 10; }") unless defined(&ISPCTL_RUN_MBOXCMD);
    eval("sub ISPCTL_TOGGLE_TMODE () { 11; }") unless defined(&ISPCTL_TOGGLE_TMODE);
    eval("sub ISPCTL_GET_PDB () { 12; }") unless defined(&ISPCTL_GET_PDB);
    eval("sub ISPCTL_PLOGX () { 13; }") unless defined(&ISPCTL_PLOGX);
    eval("sub ISPASYNC_NEW_TGT_PARAMS () { 0; }") unless defined(&ISPASYNC_NEW_TGT_PARAMS);
    eval("sub ISPASYNC_BUS_RESET () { 1; }") unless defined(&ISPASYNC_BUS_RESET);
    eval("sub ISPASYNC_LOOP_DOWN () { 2; }") unless defined(&ISPASYNC_LOOP_DOWN);
    eval("sub ISPASYNC_LOOP_UP () { 3; }") unless defined(&ISPASYNC_LOOP_UP);
    eval("sub ISPASYNC_LIP () { 4; }") unless defined(&ISPASYNC_LIP);
    eval("sub ISPASYNC_LOOP_RESET () { 5; }") unless defined(&ISPASYNC_LOOP_RESET);
    eval("sub ISPASYNC_CHANGE_NOTIFY () { 6; }") unless defined(&ISPASYNC_CHANGE_NOTIFY);
    eval("sub ISPASYNC_DEV_ARRIVED () { 7; }") unless defined(&ISPASYNC_DEV_ARRIVED);
    eval("sub ISPASYNC_DEV_CHANGED () { 8; }") unless defined(&ISPASYNC_DEV_CHANGED);
    eval("sub ISPASYNC_DEV_STAYED () { 9; }") unless defined(&ISPASYNC_DEV_STAYED);
    eval("sub ISPASYNC_DEV_GONE () { 10; }") unless defined(&ISPASYNC_DEV_GONE);
    eval("sub ISPASYNC_TARGET_NOTIFY () { 11; }") unless defined(&ISPASYNC_TARGET_NOTIFY);
    eval("sub ISPASYNC_TARGET_ACTION () { 12; }") unless defined(&ISPASYNC_TARGET_ACTION);
    eval("sub ISPASYNC_CONF_CHANGE () { 13; }") unless defined(&ISPASYNC_CONF_CHANGE);
    eval("sub ISPASYNC_UNHANDLED_RESPONSE () { 14; }") unless defined(&ISPASYNC_UNHANDLED_RESPONSE);
    eval("sub ISPASYNC_FW_CRASH () { 15; }") unless defined(&ISPASYNC_FW_CRASH);
    eval("sub ISPASYNC_FW_DUMPED () { 16; }") unless defined(&ISPASYNC_FW_DUMPED);
    eval("sub ISPASYNC_FW_RESTARTED () { 17; }") unless defined(&ISPASYNC_FW_RESTARTED);
    eval 'sub ISPASYNC_CHANGE_PDB () {(( &void *) 0);}' unless defined(&ISPASYNC_CHANGE_PDB);
    eval 'sub ISPASYNC_CHANGE_SNS () {(( &void *) 1);}' unless defined(&ISPASYNC_CHANGE_SNS);
    eval 'sub ISPASYNC_CHANGE_OTHER () {(( &void *) 2);}' unless defined(&ISPASYNC_CHANGE_OTHER);
    eval 'sub ISP_LOGALL () {0x;}' unless defined(&ISP_LOGALL);
    eval 'sub ISP_LOGCONFIG () {0x1;}' unless defined(&ISP_LOGCONFIG);
    eval 'sub ISP_LOGINFO () {0x2;}' unless defined(&ISP_LOGINFO);
    eval 'sub ISP_LOGWARN () {0x4;}' unless defined(&ISP_LOGWARN);
    eval 'sub ISP_LOGERR () {0x8;}' unless defined(&ISP_LOGERR);
    eval 'sub ISP_LOGDEBUG0 () {0x10;}' unless defined(&ISP_LOGDEBUG0);
    eval 'sub ISP_LOGDEBUG1 () {0x20;}' unless defined(&ISP_LOGDEBUG1);
    eval 'sub ISP_LOGDEBUG2 () {0x40;}' unless defined(&ISP_LOGDEBUG2);
    eval 'sub ISP_LOGDEBUG3 () {0x80;}' unless defined(&ISP_LOGDEBUG3);
    eval 'sub ISP_LOGSANCFG () {0x100;}' unless defined(&ISP_LOGSANCFG);
    eval 'sub ISP_LOGTDEBUG0 () {0x200;}' unless defined(&ISP_LOGTDEBUG0);
    eval 'sub ISP_LOGTDEBUG1 () {0x400;}' unless defined(&ISP_LOGTDEBUG1);
    eval 'sub ISP_LOGTDEBUG2 () {0x800;}' unless defined(&ISP_LOGTDEBUG2);
}
1;
