require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&EHCI_SQTD_SIZE)) {
    sub EHCI_SQTD_SIZE () {	(($sizeof{'struct ehci_soft_qtd'} +  &EHCI_QTD_ALIGN - 1) /  &EHCI_QTD_ALIGN *  &EHCI_QTD_ALIGN);}
}
unless(defined(&EHCI_SQTD_CHUNK)) {
    sub EHCI_SQTD_CHUNK () {	( &EHCI_PAGE_SIZE /  &EHCI_SQTD_SIZE);}
}
unless(defined(&EHCI_SQH_SIZE)) {
    sub EHCI_SQH_SIZE () {	(($sizeof{'struct ehci_soft_qh'} +  &EHCI_QH_ALIGN - 1) /  &EHCI_QH_ALIGN *  &EHCI_QH_ALIGN);}
}
unless(defined(&EHCI_SQH_CHUNK)) {
    sub EHCI_SQH_CHUNK () {	( &EHCI_PAGE_SIZE /  &EHCI_SQH_SIZE);}
}
unless(defined(&EHCI_ITD_SIZE)) {
    sub EHCI_ITD_SIZE () {	(($sizeof{'struct ehci_soft_itd'} +  &EHCI_QH_ALIGN - 1) /  &EHCI_ITD_ALIGN *  &EHCI_ITD_ALIGN);}
}
unless(defined(&EHCI_ITD_CHUNK)) {
    sub EHCI_ITD_CHUNK () {	( &EHCI_PAGE_SIZE /  &EHCI_ITD_SIZE);}
}
if(defined(&DIAGNOSTIC)) {
}
unless(defined(&EHCI_XFER_ABORTING)) {
    sub EHCI_XFER_ABORTING () {	0x1;}
}
unless(defined(&EHCI_XFER_ABORTWAIT)) {
    sub EHCI_XFER_ABORTWAIT () {	0x2;}
}
unless(defined(&EXFER)) {
    sub EXFER {
	my($xfer) = @_;
	eval q((($xfer)));
    }
}
unless(defined(&EHCI_FRAMELIST_MAXCOUNT)) {
    sub EHCI_FRAMELIST_MAXCOUNT () {	1024;}
}
unless(defined(&EHCI_IPOLLRATES)) {
    sub EHCI_IPOLLRATES () {	8;}
}
unless(defined(&EHCI_INTRQHS)) {
    sub EHCI_INTRQHS () {	((1<<  &EHCI_IPOLLRATES) - 1);}
}
unless(defined(&EHCI_IQHIDX)) {
    sub EHCI_IQHIDX {
	my($lev, $pos) = @_;
	eval q((((($pos) & ((1<< ($lev)) - 1)) | (1<< ($lev))) - 1));
    }
}
unless(defined(&EHCI_ILEV_IVAL)) {
    sub EHCI_ILEV_IVAL {
	my($lev) = @_;
	eval q((1<< ($lev)));
    }
}
unless(defined(&EHCI_HASH_SIZE)) {
    sub EHCI_HASH_SIZE () {	128;}
}
unless(defined(&EHCI_COMPANION_MAX)) {
    sub EHCI_COMPANION_MAX () {	8;}
}
unless(defined(&EHCI_FREE_LIST_INTERVAL)) {
    sub EHCI_FREE_LIST_INTERVAL () {	100;}
}
unless(defined(&EHCIF_DROPPED_INTR_WORKAROUND)) {
    sub EHCIF_DROPPED_INTR_WORKAROUND () {	0x1;}
}
unless(defined(&EREAD1)) {
    sub EREAD1 {
	my($sc, $a) = @_;
	eval q( &bus_space_read_1(($sc)-> &iot, ($sc)-> &ioh, ($a)));
    }
}
unless(defined(&EREAD2)) {
    sub EREAD2 {
	my($sc, $a) = @_;
	eval q( &bus_space_read_2(($sc)-> &iot, ($sc)-> &ioh, ($a)));
    }
}
unless(defined(&EREAD4)) {
    sub EREAD4 {
	my($sc, $a) = @_;
	eval q( &bus_space_read_4(($sc)-> &iot, ($sc)-> &ioh, ($a)));
    }
}
unless(defined(&EWRITE1)) {
    sub EWRITE1 {
	my($sc, $a, $x) = @_;
	eval q( &bus_space_write_1(($sc)-> &iot, ($sc)-> &ioh, ($a), ($x)));
    }
}
unless(defined(&EWRITE2)) {
    sub EWRITE2 {
	my($sc, $a, $x) = @_;
	eval q( &bus_space_write_2(($sc)-> &iot, ($sc)-> &ioh, ($a), ($x)));
    }
}
unless(defined(&EWRITE4)) {
    sub EWRITE4 {
	my($sc, $a, $x) = @_;
	eval q( &bus_space_write_4(($sc)-> &iot, ($sc)-> &ioh, ($a), ($x)));
    }
}
unless(defined(&EOREAD1)) {
    sub EOREAD1 {
	my($sc, $a) = @_;
	eval q( &bus_space_read_1(($sc)-> &iot, ($sc)-> &ioh, ($sc)-> &sc_offs+($a)));
    }
}
unless(defined(&EOREAD2)) {
    sub EOREAD2 {
	my($sc, $a) = @_;
	eval q( &bus_space_read_2(($sc)-> &iot, ($sc)-> &ioh, ($sc)-> &sc_offs+($a)));
    }
}
unless(defined(&EOREAD4)) {
    sub EOREAD4 {
	my($sc, $a) = @_;
	eval q( &bus_space_read_4(($sc)-> &iot, ($sc)-> &ioh, ($sc)-> &sc_offs+($a)));
    }
}
unless(defined(&EOWRITE1)) {
    sub EOWRITE1 {
	my($sc, $a, $x) = @_;
	eval q( &bus_space_write_1(($sc)-> &iot, ($sc)-> &ioh, ($sc)-> &sc_offs+($a), ($x)));
    }
}
unless(defined(&EOWRITE2)) {
    sub EOWRITE2 {
	my($sc, $a, $x) = @_;
	eval q( &bus_space_write_2(($sc)-> &iot, ($sc)-> &ioh, ($sc)-> &sc_offs+($a), ($x)));
    }
}
unless(defined(&EOWRITE4)) {
    sub EOWRITE4 {
	my($sc, $a, $x) = @_;
	eval q( &bus_space_write_4(($sc)-> &iot, ($sc)-> &ioh, ($sc)-> &sc_offs+($a), ($x)));
    }
}
1;
