require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_I915_DRV_H_)) {
    eval 'sub _I915_DRV_H_ () {1;}' unless defined(&_I915_DRV_H_);
    eval 'sub DRIVER_AUTHOR () {"Tungsten Graphics, Inc.";}' unless defined(&DRIVER_AUTHOR);
    eval 'sub DRIVER_NAME () {"i915";}' unless defined(&DRIVER_NAME);
    eval 'sub DRIVER_DESC () {"Intel Graphics";}' unless defined(&DRIVER_DESC);
    eval 'sub DRIVER_DATE () {"20080730";}' unless defined(&DRIVER_DATE);
    eval("sub PIPE_A () { 0; }") unless defined(&PIPE_A);
    eval("sub PIPE_B () { 1; }") unless defined(&PIPE_B);
    eval 'sub DRIVER_MAJOR () {1;}' unless defined(&DRIVER_MAJOR);
    eval 'sub DRIVER_MINOR () {6;}' unless defined(&DRIVER_MINOR);
    eval 'sub DRIVER_PATCHLEVEL () {0;}' unless defined(&DRIVER_PATCHLEVEL);
    eval 'sub I915_FENCE_REG_NONE () {-1;}' unless defined(&I915_FENCE_REG_NONE);
    eval 'sub hws_obj () { ($hws->{obj});}' unless defined(&hws_obj);
    eval 'sub hws_dmamem () { ($hws->{dmamem});}' unless defined(&hws_dmamem);
    eval 'sub INTELDRM_QUIET () {0x1;}' unless defined(&INTELDRM_QUIET);
    eval 'sub INTELDRM_WEDGED () {0x2;}' unless defined(&INTELDRM_WEDGED);
    eval 'sub INTELDRM_SUSPENDED () {0x4;}' unless defined(&INTELDRM_SUSPENDED);
    eval 'sub CHIP_I830 () {0x1;}' unless defined(&CHIP_I830);
    eval 'sub CHIP_I845G () {0x2;}' unless defined(&CHIP_I845G);
    eval 'sub CHIP_I85X () {0x4;}' unless defined(&CHIP_I85X);
    eval 'sub CHIP_I865G () {0x8;}' unless defined(&CHIP_I865G);
    eval 'sub CHIP_I9XX () {0x10;}' unless defined(&CHIP_I9XX);
    eval 'sub CHIP_I915G () {0x20;}' unless defined(&CHIP_I915G);
    eval 'sub CHIP_I915GM () {0x40;}' unless defined(&CHIP_I915GM);
    eval 'sub CHIP_I945G () {0x80;}' unless defined(&CHIP_I945G);
    eval 'sub CHIP_I945GM () {0x100;}' unless defined(&CHIP_I945GM);
    eval 'sub CHIP_I965 () {0x200;}' unless defined(&CHIP_I965);
    eval 'sub CHIP_I965GM () {0x400;}' unless defined(&CHIP_I965GM);
    eval 'sub CHIP_G33 () {0x800;}' unless defined(&CHIP_G33);
    eval 'sub CHIP_GM45 () {0x1000;}' unless defined(&CHIP_GM45);
    eval 'sub CHIP_G4X () {0x2000;}' unless defined(&CHIP_G4X);
    eval 'sub CHIP_M () {0x4000;}' unless defined(&CHIP_M);
    eval 'sub CHIP_HWS () {0x8000;}' unless defined(&CHIP_HWS);
    eval 'sub CHIP_GEN2 () {0x10000;}' unless defined(&CHIP_GEN2);
    eval 'sub CHIP_GEN3 () {0x20000;}' unless defined(&CHIP_GEN3);
    eval 'sub CHIP_GEN4 () {0x40000;}' unless defined(&CHIP_GEN4);
    eval 'sub CHIP_GEN6 () {0x80000;}' unless defined(&CHIP_GEN6);
    eval 'sub CHIP_PINEVIEW () {0x100000;}' unless defined(&CHIP_PINEVIEW);
    eval 'sub CHIP_IRONLAKE () {0x200000;}' unless defined(&CHIP_IRONLAKE);
    eval 'sub CHIP_IRONLAKE_D () {0x400000;}' unless defined(&CHIP_IRONLAKE_D);
    eval 'sub CHIP_IRONLAKE_M () {0x800000;}' unless defined(&CHIP_IRONLAKE_M);
    eval 'sub I915_ACTIVE () {0x10;}' unless defined(&I915_ACTIVE);
    eval 'sub I915_IN_EXEC () {0x20;}' unless defined(&I915_IN_EXEC);
    eval 'sub I915_USER_PINNED () {0x40;}' unless defined(&I915_USER_PINNED);
    eval 'sub I915_GPU_WRITE () {0x80;}' unless defined(&I915_GPU_WRITE);
    eval 'sub I915_DONTNEED () {0x100;}' unless defined(&I915_DONTNEED);
    eval 'sub I915_PURGED () {0x200;}' unless defined(&I915_PURGED);
    eval 'sub I915_DIRTY () {0x400;}' unless defined(&I915_DIRTY);
    eval 'sub I915_EXEC_NEEDS_FENCE () {0x800;}' unless defined(&I915_EXEC_NEEDS_FENCE);
    eval 'sub I915_FENCED_EXEC () {0x1000;}' unless defined(&I915_FENCED_EXEC);
    eval 'sub I915_FENCE_INVALID () {0x2000;}' unless defined(&I915_FENCE_INVALID);
    eval 'sub read64 {
        my($dev_priv,$off) = @_;
	    eval q({  &u_int32_t  &low,  &high;  &low =  &bus_space_read_4( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), $off);  &high =  &bus_space_read_4( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), $off + 4); (( &u_int64_t) &low | (( &u_int64_t) &high << 32)); });
    }' unless defined(&read64);
    eval 'sub I915_READ64 {
        my($off) = @_;
	    eval q( &read64( &dev_priv, $off));
    }' unless defined(&I915_READ64);
    eval 'sub I915_WRITE64 {
        my($off, $reg) = @_;
	    eval q( &write64( &dev_priv, $off, $reg));
    }' unless defined(&I915_WRITE64);
    eval 'sub I915_READ {
        my($reg) = @_;
	    eval q( &bus_space_read_4( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg)));
    }' unless defined(&I915_READ);
    eval 'sub I915_WRITE {
        my($reg,$val) = @_;
	    eval q( &bus_space_write_4( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg), ($val)));
    }' unless defined(&I915_WRITE);
    eval 'sub I915_READ16 {
        my($reg) = @_;
	    eval q( &bus_space_read_2( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg)));
    }' unless defined(&I915_READ16);
    eval 'sub I915_WRITE16 {
        my($reg,$val) = @_;
	    eval q( &bus_space_write_2( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg), ($val)));
    }' unless defined(&I915_WRITE16);
    eval 'sub I915_READ8 {
        my($reg) = @_;
	    eval q( &bus_space_read_1( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg)));
    }' unless defined(&I915_READ8);
    eval 'sub I915_WRITE8 {
        my($reg,$val) = @_;
	    eval q( &bus_space_write_1( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg), ($val)));
    }' unless defined(&I915_WRITE8);
    eval 'sub INTELDRM_VERBOSE () {0;}' unless defined(&INTELDRM_VERBOSE);
    if((defined(&INTELDRM_VERBOSE) ? &INTELDRM_VERBOSE : undef) > 0) {
	eval 'sub INTELDRM_VPRINTF () {( &fmt,  &args...)  &DRM_INFO( &fmt,  &args);}' unless defined(&INTELDRM_VPRINTF);
    } else {
	eval 'sub INTELDRM_VPRINTF () {( &fmt,  &args...);}' unless defined(&INTELDRM_VPRINTF);
    }
    eval 'sub BEGIN_LP_RING {
        my($n) = @_;
	    eval q( &inteldrm_begin_ring( &dev_priv, $n));
    }' unless defined(&BEGIN_LP_RING);
    eval 'sub OUT_RING {
        my($n) = @_;
	    eval q( &inteldrm_out_ring( &dev_priv, $n));
    }' unless defined(&OUT_RING);
    eval 'sub ADVANCE_LP_RING () {
        eval q( &inteldrm_advance_ring( &dev_priv));
    }' unless defined(&ADVANCE_LP_RING);
    eval 'sub I915_IFPADDR () {0x60;}' unless defined(&I915_IFPADDR);
    eval 'sub I965_IFPADDR () {0x70;}' unless defined(&I965_IFPADDR);
    eval 'sub INTEL_GMCH_CTRL () {0x52;}' unless defined(&INTEL_GMCH_CTRL);
    eval 'sub INTEL_GMCH_ENABLED () {0x4;}' unless defined(&INTEL_GMCH_ENABLED);
    eval 'sub INTEL_GMCH_MEM_MASK () {0x1;}' unless defined(&INTEL_GMCH_MEM_MASK);
    eval 'sub INTEL_GMCH_MEM_64M () {0x1;}' unless defined(&INTEL_GMCH_MEM_64M);
    eval 'sub INTEL_GMCH_MEM_128M () {0;}' unless defined(&INTEL_GMCH_MEM_128M);
    eval 'sub INTEL_855_GMCH_GMS_MASK () {(0x7 << 4);}' unless defined(&INTEL_855_GMCH_GMS_MASK);
    eval 'sub INTEL_855_GMCH_GMS_DISABLED () {(0x << 4);}' unless defined(&INTEL_855_GMCH_GMS_DISABLED);
    eval 'sub INTEL_855_GMCH_GMS_STOLEN_1M () {(0x1 << 4);}' unless defined(&INTEL_855_GMCH_GMS_STOLEN_1M);
    eval 'sub INTEL_855_GMCH_GMS_STOLEN_4M () {(0x2 << 4);}' unless defined(&INTEL_855_GMCH_GMS_STOLEN_4M);
    eval 'sub INTEL_855_GMCH_GMS_STOLEN_8M () {(0x3 << 4);}' unless defined(&INTEL_855_GMCH_GMS_STOLEN_8M);
    eval 'sub INTEL_855_GMCH_GMS_STOLEN_16M () {(0x4 << 4);}' unless defined(&INTEL_855_GMCH_GMS_STOLEN_16M);
    eval 'sub INTEL_855_GMCH_GMS_STOLEN_32M () {(0x5 << 4);}' unless defined(&INTEL_855_GMCH_GMS_STOLEN_32M);
    eval 'sub INTEL_915G_GMCH_GMS_STOLEN_48M () {(0x6 << 4);}' unless defined(&INTEL_915G_GMCH_GMS_STOLEN_48M);
    eval 'sub INTEL_915G_GMCH_GMS_STOLEN_64M () {(0x7 << 4);}' unless defined(&INTEL_915G_GMCH_GMS_STOLEN_64M);
    eval 'sub HPLLCC () {0xc0;}' unless defined(&HPLLCC);
    eval 'sub GC_CLOCK_CONTROL_MASK () {(3<< 0);}' unless defined(&GC_CLOCK_CONTROL_MASK);
    eval 'sub GC_CLOCK_133_200 () {(0<< 0);}' unless defined(&GC_CLOCK_133_200);
    eval 'sub GC_CLOCK_100_200 () {(1<< 0);}' unless defined(&GC_CLOCK_100_200);
    eval 'sub GC_CLOCK_100_133 () {(2<< 0);}' unless defined(&GC_CLOCK_100_133);
    eval 'sub GC_CLOCK_166_250 () {(3<< 0);}' unless defined(&GC_CLOCK_166_250);
    eval 'sub GCFGC () {0xf0;}' unless defined(&GCFGC);
    eval 'sub GC_LOW_FREQUENCY_ENABLE () {(1<< 7);}' unless defined(&GC_LOW_FREQUENCY_ENABLE);
    eval 'sub GC_DISPLAY_CLOCK_190_200_MHZ () {(0<< 4);}' unless defined(&GC_DISPLAY_CLOCK_190_200_MHZ);
    eval 'sub GC_DISPLAY_CLOCK_333_MHZ () {(4<< 4);}' unless defined(&GC_DISPLAY_CLOCK_333_MHZ);
    eval 'sub GC_DISPLAY_CLOCK_MASK () {(7<< 4);}' unless defined(&GC_DISPLAY_CLOCK_MASK);
    eval 'sub LBB () {0xf4;}' unless defined(&LBB);
    eval 'sub GDRST () {0xc0;}' unless defined(&GDRST);
    eval 'sub GDRST_FULL () {(0<<2);}' unless defined(&GDRST_FULL);
    eval 'sub GDRST_RENDER () {(1<<2);}' unless defined(&GDRST_RENDER);
    eval 'sub GDRST_MEDIA () {(3<<2);}' unless defined(&GDRST_MEDIA);
    eval 'sub VGA_ST01_MDA () {0x3ba;}' unless defined(&VGA_ST01_MDA);
    eval 'sub VGA_ST01_CGA () {0x3da;}' unless defined(&VGA_ST01_CGA);
    eval 'sub VGA_MSR_WRITE () {0x3c2;}' unless defined(&VGA_MSR_WRITE);
    eval 'sub VGA_MSR_READ () {0x3cc;}' unless defined(&VGA_MSR_READ);
    eval 'sub VGA_MSR_MEM_EN () {(1<<1);}' unless defined(&VGA_MSR_MEM_EN);
    eval 'sub VGA_MSR_CGA_MODE () {(1<<0);}' unless defined(&VGA_MSR_CGA_MODE);
    eval 'sub VGA_SR_INDEX () {0x3c4;}' unless defined(&VGA_SR_INDEX);
    eval 'sub VGA_SR_DATA () {0x3c5;}' unless defined(&VGA_SR_DATA);
    eval 'sub VGA_AR_INDEX () {0x3c0;}' unless defined(&VGA_AR_INDEX);
    eval 'sub VGA_AR_VID_EN () {(1<<5);}' unless defined(&VGA_AR_VID_EN);
    eval 'sub VGA_AR_DATA_WRITE () {0x3c0;}' unless defined(&VGA_AR_DATA_WRITE);
    eval 'sub VGA_AR_DATA_READ () {0x3c1;}' unless defined(&VGA_AR_DATA_READ);
    eval 'sub VGA_GR_INDEX () {0x3ce;}' unless defined(&VGA_GR_INDEX);
    eval 'sub VGA_GR_DATA () {0x3cf;}' unless defined(&VGA_GR_DATA);
    eval 'sub VGA_GR_MEM_READ_MODE_SHIFT () {3;}' unless defined(&VGA_GR_MEM_READ_MODE_SHIFT);
    eval 'sub VGA_GR_MEM_READ_MODE_PLANE () {1;}' unless defined(&VGA_GR_MEM_READ_MODE_PLANE);
    eval 'sub VGA_GR_MEM_MODE_MASK () {0xc;}' unless defined(&VGA_GR_MEM_MODE_MASK);
    eval 'sub VGA_GR_MEM_MODE_SHIFT () {2;}' unless defined(&VGA_GR_MEM_MODE_SHIFT);
    eval 'sub VGA_GR_MEM_A0000_AFFFF () {0;}' unless defined(&VGA_GR_MEM_A0000_AFFFF);
    eval 'sub VGA_GR_MEM_A0000_BFFFF () {1;}' unless defined(&VGA_GR_MEM_A0000_BFFFF);
    eval 'sub VGA_GR_MEM_B0000_B7FFF () {2;}' unless defined(&VGA_GR_MEM_B0000_B7FFF);
    eval 'sub VGA_GR_MEM_B0000_BFFFF () {3;}' unless defined(&VGA_GR_MEM_B0000_BFFFF);
    eval 'sub VGA_DACMASK () {0x3c6;}' unless defined(&VGA_DACMASK);
    eval 'sub VGA_DACRX () {0x3c7;}' unless defined(&VGA_DACRX);
    eval 'sub VGA_DACWX () {0x3c8;}' unless defined(&VGA_DACWX);
    eval 'sub VGA_DACDATA () {0x3c9;}' unless defined(&VGA_DACDATA);
    eval 'sub VGA_CR_INDEX_MDA () {0x3b4;}' unless defined(&VGA_CR_INDEX_MDA);
    eval 'sub VGA_CR_DATA_MDA () {0x3b5;}' unless defined(&VGA_CR_DATA_MDA);
    eval 'sub VGA_CR_INDEX_CGA () {0x3d4;}' unless defined(&VGA_CR_INDEX_CGA);
    eval 'sub VGA_CR_DATA_CGA () {0x3d5;}' unless defined(&VGA_CR_DATA_CGA);
    eval 'sub MI_INSTR {
        my($opcode, $flags) = @_;
	    eval q(((($opcode) << 23) | ($flags)));
    }' unless defined(&MI_INSTR);
    eval 'sub MI_NOOP () { &MI_INSTR(0, 0);}' unless defined(&MI_NOOP);
    eval 'sub MI_USER_INTERRUPT () { &MI_INSTR(0x2, 0);}' unless defined(&MI_USER_INTERRUPT);
    eval 'sub MI_WAIT_FOR_EVENT () { &MI_INSTR(0x3, 0);}' unless defined(&MI_WAIT_FOR_EVENT);
    eval 'sub MI_WAIT_FOR_PLANE_B_FLIP () {(1<<6);}' unless defined(&MI_WAIT_FOR_PLANE_B_FLIP);
    eval 'sub MI_WAIT_FOR_PLANE_A_FLIP () {(1<<2);}' unless defined(&MI_WAIT_FOR_PLANE_A_FLIP);
    eval 'sub MI_WAIT_FOR_PLANE_A_SCANLINES () {(1<<1);}' unless defined(&MI_WAIT_FOR_PLANE_A_SCANLINES);
    eval 'sub MI_FLUSH () { &MI_INSTR(0x4, 0);}' unless defined(&MI_FLUSH);
    eval 'sub MI_READ_FLUSH () {(1<< 0);}' unless defined(&MI_READ_FLUSH);
    eval 'sub MI_EXE_FLUSH () {(1<< 1);}' unless defined(&MI_EXE_FLUSH);
    eval 'sub MI_NO_WRITE_FLUSH () {(1<< 2);}' unless defined(&MI_NO_WRITE_FLUSH);
    eval 'sub MI_SCENE_COUNT () {(1<< 3);}' unless defined(&MI_SCENE_COUNT);
    eval 'sub MI_END_SCENE () {(1<< 4);}' unless defined(&MI_END_SCENE);
    eval 'sub MI_BATCH_BUFFER_END () { &MI_INSTR(0xa, 0);}' unless defined(&MI_BATCH_BUFFER_END);
    eval 'sub MI_REPORT_HEAD () { &MI_INSTR(0x7, 0);}' unless defined(&MI_REPORT_HEAD);
    eval 'sub MI_LOAD_SCAN_LINES_INCL () { &MI_INSTR(0x12, 0);}' unless defined(&MI_LOAD_SCAN_LINES_INCL);
    eval 'sub MI_STORE_DWORD_IMM () { &MI_INSTR(0x20, 1);}' unless defined(&MI_STORE_DWORD_IMM);
    eval 'sub MI_MEM_VIRTUAL () {(1<< 22);}' unless defined(&MI_MEM_VIRTUAL);
    eval 'sub MI_STORE_DWORD_INDEX () { &MI_INSTR(0x21, 1);}' unless defined(&MI_STORE_DWORD_INDEX);
    eval 'sub MI_STORE_DWORD_INDEX_SHIFT () {2;}' unless defined(&MI_STORE_DWORD_INDEX_SHIFT);
    eval 'sub MI_LOAD_REGISTER_IMM () { &MI_INSTR(0x22, 1);}' unless defined(&MI_LOAD_REGISTER_IMM);
    eval 'sub MI_BATCH_BUFFER () { &MI_INSTR(0x30, 1);}' unless defined(&MI_BATCH_BUFFER);
    eval 'sub MI_BATCH_NON_SECURE () {(1);}' unless defined(&MI_BATCH_NON_SECURE);
    eval 'sub MI_BATCH_NON_SECURE_I965 () {(1<<8);}' unless defined(&MI_BATCH_NON_SECURE_I965);
    eval 'sub MI_BATCH_BUFFER_START () { &MI_INSTR(0x31, 0);}' unless defined(&MI_BATCH_BUFFER_START);
    eval 'sub READ_HWSP {
        my($dev_priv, $reg) = @_;
	    eval q( &inteldrm_read_hws($dev_priv, $reg));
    }' unless defined(&READ_HWSP);
    eval 'sub I915_GEM_HWS_INDEX () {0x20;}' unless defined(&I915_GEM_HWS_INDEX);
    eval 'sub GFX_INSTR {
        my($opcode, $flags) = @_;
	    eval q(((0x3 << 29) | (($opcode) << 24) | ($flags)));
    }' unless defined(&GFX_INSTR);
    eval 'sub GFX_OP_RASTER_RULES () {((0x3<<29)|(0x7<<24));}' unless defined(&GFX_OP_RASTER_RULES);
    eval 'sub GFX_OP_SCISSOR () {((0x3<<29)|(0x1c<<24)|(0x10<<19));}' unless defined(&GFX_OP_SCISSOR);
    eval 'sub SC_UPDATE_SCISSOR () {(0x1<<1);}' unless defined(&SC_UPDATE_SCISSOR);
    eval 'sub SC_ENABLE_MASK () {(0x1<<0);}' unless defined(&SC_ENABLE_MASK);
    eval 'sub SC_ENABLE () {(0x1<<0);}' unless defined(&SC_ENABLE);
    eval 'sub GFX_OP_LOAD_INDIRECT () {((0x3<<29)|(0x1d<<24)|(0x7<<16));}' unless defined(&GFX_OP_LOAD_INDIRECT);
    eval 'sub GFX_OP_SCISSOR_INFO () {((0x3<<29)|(0x1d<<24)|(0x81<<16)|(0x1));}' unless defined(&GFX_OP_SCISSOR_INFO);
    eval 'sub SCI_YMIN_MASK () {(0xffff<<16);}' unless defined(&SCI_YMIN_MASK);
    eval 'sub SCI_XMIN_MASK () {(0xffff<<0);}' unless defined(&SCI_XMIN_MASK);
    eval 'sub SCI_YMAX_MASK () {(0xffff<<16);}' unless defined(&SCI_YMAX_MASK);
    eval 'sub SCI_XMAX_MASK () {(0xffff<<0);}' unless defined(&SCI_XMAX_MASK);
    eval 'sub GFX_OP_SCISSOR_ENABLE () {((0x3<<29)|(0x1c<<24)|(0x10<<19));}' unless defined(&GFX_OP_SCISSOR_ENABLE);
    eval 'sub GFX_OP_SCISSOR_RECT () {((0x3<<29)|(0x1d<<24)|(0x81<<16)|1);}' unless defined(&GFX_OP_SCISSOR_RECT);
    eval 'sub GFX_OP_COLOR_FACTOR () {((0x3<<29)|(0x1d<<24)|(0x1<<16)|0x);}' unless defined(&GFX_OP_COLOR_FACTOR);
    eval 'sub GFX_OP_STIPPLE () {((0x3<<29)|(0x1d<<24)|(0x83<<16));}' unless defined(&GFX_OP_STIPPLE);
    eval 'sub GFX_OP_MAP_INFO () {((0x3<<29)|(0x1d<<24)|0x4);}' unless defined(&GFX_OP_MAP_INFO);
    eval 'sub GFX_OP_DESTBUFFER_VARS () {((0x3<<29)|(0x1d<<24)|(0x85<<16)|0x);}' unless defined(&GFX_OP_DESTBUFFER_VARS);
    eval 'sub GFX_OP_DESTBUFFER_INFO () {((0x3<<29)|(0x1d<<24)|(0x8e<<16)|1);}' unless defined(&GFX_OP_DESTBUFFER_INFO);
    eval 'sub GFX_OP_DRAWRECT_INFO () {((0x3<<29)|(0x1d<<24)|(0x80<<16)|(0x3));}' unless defined(&GFX_OP_DRAWRECT_INFO);
    eval 'sub GFX_OP_DRAWRECT_INFO_I965 () {((0x7900<<16)|0x2);}' unless defined(&GFX_OP_DRAWRECT_INFO_I965);
    eval 'sub SRC_COPY_BLT_CMD () {((2<<29)|(0x43<<22)|4);}' unless defined(&SRC_COPY_BLT_CMD);
    eval 'sub XY_SRC_COPY_BLT_CMD () {((2<<29)|(0x53<<22)|6);}' unless defined(&XY_SRC_COPY_BLT_CMD);
    eval 'sub XY_MONO_SRC_COPY_IMM_BLT () {((2<<29)|(0x71<<22)|5);}' unless defined(&XY_MONO_SRC_COPY_IMM_BLT);
    eval 'sub XY_SRC_COPY_BLT_WRITE_ALPHA () {(1<<21);}' unless defined(&XY_SRC_COPY_BLT_WRITE_ALPHA);
    eval 'sub XY_SRC_COPY_BLT_WRITE_RGB () {(1<<20);}' unless defined(&XY_SRC_COPY_BLT_WRITE_RGB);
    eval 'sub BLT_DEPTH_8 () {(0<<24);}' unless defined(&BLT_DEPTH_8);
    eval 'sub BLT_DEPTH_16_565 () {(1<<24);}' unless defined(&BLT_DEPTH_16_565);
    eval 'sub BLT_DEPTH_16_1555 () {(2<<24);}' unless defined(&BLT_DEPTH_16_1555);
    eval 'sub BLT_DEPTH_32 () {(3<<24);}' unless defined(&BLT_DEPTH_32);
    eval 'sub BLT_ROP_GXCOPY () {(0xcc<<16);}' unless defined(&BLT_ROP_GXCOPY);
    eval 'sub XY_SRC_COPY_BLT_SRC_TILED () {(1<<15);}' unless defined(&XY_SRC_COPY_BLT_SRC_TILED);
    eval 'sub XY_SRC_COPY_BLT_DST_TILED () {(1<<11);}' unless defined(&XY_SRC_COPY_BLT_DST_TILED);
    eval 'sub CMD_OP_DISPLAYBUFFER_INFO () {((0x<<29)|(0x14<<23)|2);}' unless defined(&CMD_OP_DISPLAYBUFFER_INFO);
    eval 'sub ASYNC_FLIP () {(1<<22);}' unless defined(&ASYNC_FLIP);
    eval 'sub DISPLAY_PLANE_A () {(0<<20);}' unless defined(&DISPLAY_PLANE_A);
    eval 'sub DISPLAY_PLANE_B () {(1<<20);}' unless defined(&DISPLAY_PLANE_B);
    eval 'sub FENCE_REG_830_0 () {0x2000;}' unless defined(&FENCE_REG_830_0);
    eval 'sub FENCE_REG_945_8 () {0x3000;}' unless defined(&FENCE_REG_945_8);
    eval 'sub I830_FENCE_START_MASK () {0x7f80000;}' unless defined(&I830_FENCE_START_MASK);
    eval 'sub I830_FENCE_TILING_Y_SHIFT () {12;}' unless defined(&I830_FENCE_TILING_Y_SHIFT);
    eval 'sub I830_FENCE_SIZE_BITS {
        my($size) = @_;
	    eval q((( &ffs(($size) >> 19) - 1) << 8));
    }' unless defined(&I830_FENCE_SIZE_BITS);
    eval 'sub I830_FENCE_PITCH_SHIFT () {4;}' unless defined(&I830_FENCE_PITCH_SHIFT);
    eval 'sub I830_FENCE_REG_VALID () {(1<<0);}' unless defined(&I830_FENCE_REG_VALID);
    eval 'sub I915_FENCE_MAX_PITCH_VAL () {4;}' unless defined(&I915_FENCE_MAX_PITCH_VAL);
    eval 'sub I830_FENCE_MAX_PITCH_VAL () {6;}' unless defined(&I830_FENCE_MAX_PITCH_VAL);
    eval 'sub I830_FENCE_MAX_SIZE_VAL () {(1<<8);}' unless defined(&I830_FENCE_MAX_SIZE_VAL);
    eval 'sub I915_FENCE_START_MASK () {0xff00000;}' unless defined(&I915_FENCE_START_MASK);
    eval 'sub I915_FENCE_SIZE_BITS {
        my($size) = @_;
	    eval q((( &ffs(($size) >> 20) - 1) << 8));
    }' unless defined(&I915_FENCE_SIZE_BITS);
    eval 'sub FENCE_REG_965_0 () {0x3000;}' unless defined(&FENCE_REG_965_0);
    eval 'sub I965_FENCE_PITCH_SHIFT () {2;}' unless defined(&I965_FENCE_PITCH_SHIFT);
    eval 'sub I965_FENCE_TILING_Y_SHIFT () {1;}' unless defined(&I965_FENCE_TILING_Y_SHIFT);
    eval 'sub I965_FENCE_REG_VALID () {(1<<0);}' unless defined(&I965_FENCE_REG_VALID);
    eval 'sub I965_FENCE_MAX_PITCH_VAL () {0x400;}' unless defined(&I965_FENCE_MAX_PITCH_VAL);
    eval 'sub PGTBL_ER () {0x2024;}' unless defined(&PGTBL_ER);
    eval 'sub PRB0_TAIL () {0x2030;}' unless defined(&PRB0_TAIL);
    eval 'sub PRB0_HEAD () {0x2034;}' unless defined(&PRB0_HEAD);
    eval 'sub PRB0_START () {0x2038;}' unless defined(&PRB0_START);
    eval 'sub PRB0_CTL () {0x203c;}' unless defined(&PRB0_CTL);
    eval 'sub TAIL_ADDR () {0x1ffff8;}' unless defined(&TAIL_ADDR);
    eval 'sub HEAD_WRAP_COUNT () {0xffe00000;}' unless defined(&HEAD_WRAP_COUNT);
    eval 'sub HEAD_WRAP_ONE () {0x200000;}' unless defined(&HEAD_WRAP_ONE);
    eval 'sub HEAD_ADDR () {0x1ffffc;}' unless defined(&HEAD_ADDR);
    eval 'sub RING_NR_PAGES () {0x1ff000;}' unless defined(&RING_NR_PAGES);
    eval 'sub RING_REPORT_MASK () {0x6;}' unless defined(&RING_REPORT_MASK);
    eval 'sub RING_REPORT_64K () {0x2;}' unless defined(&RING_REPORT_64K);
    eval 'sub RING_REPORT_128K () {0x4;}' unless defined(&RING_REPORT_128K);
    eval 'sub RING_NO_REPORT () {0x;}' unless defined(&RING_NO_REPORT);
    eval 'sub RING_VALID_MASK () {0x1;}' unless defined(&RING_VALID_MASK);
    eval 'sub RING_VALID () {0x1;}' unless defined(&RING_VALID);
    eval 'sub RING_INVALID () {0x;}' unless defined(&RING_INVALID);
    eval 'sub RING_WAIT_I8XX () {(1<<0);}' unless defined(&RING_WAIT_I8XX);
    eval 'sub RING_WAIT () {(1<<11);}' unless defined(&RING_WAIT);
    eval 'sub PRB1_TAIL () {0x2040;}' unless defined(&PRB1_TAIL);
    eval 'sub PRB1_HEAD () {0x2044;}' unless defined(&PRB1_HEAD);
    eval 'sub PRB1_START () {0x2048;}' unless defined(&PRB1_START);
    eval 'sub PRB1_CTL () {0x204c;}' unless defined(&PRB1_CTL);
    eval 'sub IPEIR_I965 () {0x2064;}' unless defined(&IPEIR_I965);
    eval 'sub IPEHR_I965 () {0x2068;}' unless defined(&IPEHR_I965);
    eval 'sub INSTDONE_I965 () {0x206c;}' unless defined(&INSTDONE_I965);
    eval 'sub INSTPS () {0x2070;}' unless defined(&INSTPS);
    eval 'sub INSTDONE1 () {0x207c;}' unless defined(&INSTDONE1);
    eval 'sub ACTHD_I965 () {0x2074;}' unless defined(&ACTHD_I965);
    eval 'sub HWS_PGA () {0x2080;}' unless defined(&HWS_PGA);
    eval 'sub HWS_ADDRESS_MASK () {0xfffff000;}' unless defined(&HWS_ADDRESS_MASK);
    eval 'sub HWS_START_ADDRESS_SHIFT () {4;}' unless defined(&HWS_START_ADDRESS_SHIFT);
    eval 'sub IPEIR () {0x2088;}' unless defined(&IPEIR);
    eval 'sub IPEHR () {0x208c;}' unless defined(&IPEHR);
    eval 'sub INSTDONE () {0x2090;}' unless defined(&INSTDONE);
    eval 'sub NOPID () {0x2094;}' unless defined(&NOPID);
    eval 'sub HWSTAM () {0x2098;}' unless defined(&HWSTAM);
    eval 'sub MI_MODE () {0x209c;}' unless defined(&MI_MODE);
    eval 'sub VS_TIMER_DISPATCH () {(1<< 6);}' unless defined(&VS_TIMER_DISPATCH);
    eval 'sub SCPD0 () {0x209c;}' unless defined(&SCPD0);
    eval 'sub IER () {0x20a0;}' unless defined(&IER);
    eval 'sub IIR () {0x20a4;}' unless defined(&IIR);
    eval 'sub IMR () {0x20a8;}' unless defined(&IMR);
    eval 'sub ISR () {0x20ac;}' unless defined(&ISR);
    eval 'sub I915_PIPE_CONTROL_NOTIFY_INTERRUPT () {(1<<18);}' unless defined(&I915_PIPE_CONTROL_NOTIFY_INTERRUPT);
    eval 'sub I915_DISPLAY_PORT_INTERRUPT () {(1<<17);}' unless defined(&I915_DISPLAY_PORT_INTERRUPT);
    eval 'sub I915_RENDER_COMMAND_PARSER_ERROR_INTERRUPT () {(1<<15);}' unless defined(&I915_RENDER_COMMAND_PARSER_ERROR_INTERRUPT);
    eval 'sub I915_GMCH_THERMAL_SENSOR_EVENT_INTERRUPT () {(1<<14);}' unless defined(&I915_GMCH_THERMAL_SENSOR_EVENT_INTERRUPT);
    eval 'sub I915_HWB_OOM_INTERRUPT () {(1<<13);}' unless defined(&I915_HWB_OOM_INTERRUPT);
    eval 'sub I915_SYNC_STATUS_INTERRUPT () {(1<<12);}' unless defined(&I915_SYNC_STATUS_INTERRUPT);
    eval 'sub I915_DISPLAY_PLANE_A_FLIP_PENDING_INTERRUPT () {(1<<11);}' unless defined(&I915_DISPLAY_PLANE_A_FLIP_PENDING_INTERRUPT);
    eval 'sub I915_DISPLAY_PLANE_B_FLIP_PENDING_INTERRUPT () {(1<<10);}' unless defined(&I915_DISPLAY_PLANE_B_FLIP_PENDING_INTERRUPT);
    eval 'sub I915_OVERLAY_PLANE_FLIP_PENDING_INTERRUPT () {(1<<9);}' unless defined(&I915_OVERLAY_PLANE_FLIP_PENDING_INTERRUPT);
    eval 'sub I915_DISPLAY_PLANE_C_FLIP_PENDING_INTERRUPT () {(1<<8);}' unless defined(&I915_DISPLAY_PLANE_C_FLIP_PENDING_INTERRUPT);
    eval 'sub I915_DISPLAY_PIPE_A_VBLANK_INTERRUPT () {(1<<7);}' unless defined(&I915_DISPLAY_PIPE_A_VBLANK_INTERRUPT);
    eval 'sub I915_DISPLAY_PIPE_A_EVENT_INTERRUPT () {(1<<6);}' unless defined(&I915_DISPLAY_PIPE_A_EVENT_INTERRUPT);
    eval 'sub I915_DISPLAY_PIPE_B_VBLANK_INTERRUPT () {(1<<5);}' unless defined(&I915_DISPLAY_PIPE_B_VBLANK_INTERRUPT);
    eval 'sub I915_DISPLAY_PIPE_B_EVENT_INTERRUPT () {(1<<4);}' unless defined(&I915_DISPLAY_PIPE_B_EVENT_INTERRUPT);
    eval 'sub I915_DEBUG_INTERRUPT () {(1<<2);}' unless defined(&I915_DEBUG_INTERRUPT);
    eval 'sub I915_USER_INTERRUPT () {(1<<1);}' unless defined(&I915_USER_INTERRUPT);
    eval 'sub I915_ASLE_INTERRUPT () {(1<<0);}' unless defined(&I915_ASLE_INTERRUPT);
    eval 'sub EIR () {0x20b0;}' unless defined(&EIR);
    eval 'sub EMR () {0x20b4;}' unless defined(&EMR);
    eval 'sub ESR () {0x20b8;}' unless defined(&ESR);
    eval 'sub GM45_ERROR_PAGE_TABLE () {(1<<5);}' unless defined(&GM45_ERROR_PAGE_TABLE);
    eval 'sub GM45_ERROR_MEM_PRIV () {(1<<4);}' unless defined(&GM45_ERROR_MEM_PRIV);
    eval 'sub I915_ERROR_PAGE_TABLE () {(1<<4);}' unless defined(&I915_ERROR_PAGE_TABLE);
    eval 'sub GM45_ERROR_CP_PRIV () {(1<<3);}' unless defined(&GM45_ERROR_CP_PRIV);
    eval 'sub I915_ERROR_MEMORY_REFRESH () {(1<<1);}' unless defined(&I915_ERROR_MEMORY_REFRESH);
    eval 'sub I915_ERROR_INSTRUCTION () {(1<<0);}' unless defined(&I915_ERROR_INSTRUCTION);
    eval 'sub GT_ERROR_PTE () {(1<<4);}' unless defined(&GT_ERROR_PTE);
    eval 'sub GT_ERROR_MPE () {(1<<3);}' unless defined(&GT_ERROR_MPE);
    eval 'sub GT_ERROR_CPE () {(1<<2);}' unless defined(&GT_ERROR_CPE);
    eval 'sub INSTPM () {0x20c0;}' unless defined(&INSTPM);
    eval 'sub ACTHD () {0x20c8;}' unless defined(&ACTHD);
    eval 'sub FW_BLC () {0x20d8;}' unless defined(&FW_BLC);
    eval 'sub FW_BLC_SELF () {0x20e0;}' unless defined(&FW_BLC_SELF);
    eval 'sub MI_ARB_STATE () {0x20e4;}' unless defined(&MI_ARB_STATE);
    eval 'sub MI_ARB_MASK_SHIFT () {16;}' unless defined(&MI_ARB_MASK_SHIFT);
    eval 'sub MI_ARB_RENDER_TLB_LOW_PRIORITY () {(1<< 15);}' unless defined(&MI_ARB_RENDER_TLB_LOW_PRIORITY);
    eval 'sub MI_ARB_ISOCH_WAIT_GTT () {(1<< 14);}' unless defined(&MI_ARB_ISOCH_WAIT_GTT);
    eval 'sub MI_ARB_BLOCK_GRANT_MASK () {(3<< 12);}' unless defined(&MI_ARB_BLOCK_GRANT_MASK);
    eval 'sub MI_ARB_BLOCK_GRANT_8 () {(0<< 12);}' unless defined(&MI_ARB_BLOCK_GRANT_8);
    eval 'sub MI_ARB_BLOCK_GRANT_4 () {(1<< 12);}' unless defined(&MI_ARB_BLOCK_GRANT_4);
    eval 'sub MI_ARB_BLOCK_GRANT_2 () {(2<< 12);}' unless defined(&MI_ARB_BLOCK_GRANT_2);
    eval 'sub MI_ARB_BLOCK_GRANT_0 () {(3<< 12);}' unless defined(&MI_ARB_BLOCK_GRANT_0);
    eval 'sub MI_ARB_C3_LP_WRITE_ENABLE () {(1<< 11);}' unless defined(&MI_ARB_C3_LP_WRITE_ENABLE);
    eval 'sub MI_ARB_ASYNC_FLIP_ACK_IMMEDIATE () {(1<< 10);}' unless defined(&MI_ARB_ASYNC_FLIP_ACK_IMMEDIATE);
    eval 'sub MI_ARB_DUAL_DATA_PHASE_DISABLE () {(1<< 9);}' unless defined(&MI_ARB_DUAL_DATA_PHASE_DISABLE);
    eval 'sub MI_ARB_CACHE_SNOOP_DISABLE () {(1<< 8);}' unless defined(&MI_ARB_CACHE_SNOOP_DISABLE);
    eval 'sub MI_ARB_TIME_SLICE_MASK () {(7<< 5);}' unless defined(&MI_ARB_TIME_SLICE_MASK);
    eval 'sub MI_ARB_TIME_SLICE_1 () {(0<< 5);}' unless defined(&MI_ARB_TIME_SLICE_1);
    eval 'sub MI_ARB_TIME_SLICE_2 () {(1<< 5);}' unless defined(&MI_ARB_TIME_SLICE_2);
    eval 'sub MI_ARB_TIME_SLICE_4 () {(2<< 5);}' unless defined(&MI_ARB_TIME_SLICE_4);
    eval 'sub MI_ARB_TIME_SLICE_6 () {(3<< 5);}' unless defined(&MI_ARB_TIME_SLICE_6);
    eval 'sub MI_ARB_TIME_SLICE_8 () {(4<< 5);}' unless defined(&MI_ARB_TIME_SLICE_8);
    eval 'sub MI_ARB_TIME_SLICE_10 () {(5<< 5);}' unless defined(&MI_ARB_TIME_SLICE_10);
    eval 'sub MI_ARB_TIME_SLICE_14 () {(6<< 5);}' unless defined(&MI_ARB_TIME_SLICE_14);
    eval 'sub MI_ARB_TIME_SLICE_16 () {(7<< 5);}' unless defined(&MI_ARB_TIME_SLICE_16);
    eval 'sub MI_ARB_LOW_PRIORITY_GRACE_4KB () {(0<< 4);}' unless defined(&MI_ARB_LOW_PRIORITY_GRACE_4KB);
    eval 'sub MI_ARB_LOW_PRIORITY_GRACE_8KB () {(1<< 4);}' unless defined(&MI_ARB_LOW_PRIORITY_GRACE_8KB);
    eval 'sub MI_ARB_DISPLAY_TRICKLE_FEED_DISABLE () {(1<< 2);}' unless defined(&MI_ARB_DISPLAY_TRICKLE_FEED_DISABLE);
    eval 'sub MI_ARB_DISPLAY_PRIORITY_A_B () {(0<< 0);}' unless defined(&MI_ARB_DISPLAY_PRIORITY_A_B);
    eval 'sub MI_ARB_DISPLAY_PRIORITY_B_A () {(1<< 0);}' unless defined(&MI_ARB_DISPLAY_PRIORITY_B_A);
    eval 'sub CACHE_MODE_0 () {0x2120;}' unless defined(&CACHE_MODE_0);
    eval 'sub CM0_MASK_SHIFT () {16;}' unless defined(&CM0_MASK_SHIFT);
    eval 'sub CM0_IZ_OPT_DISABLE () {(1<<6);}' unless defined(&CM0_IZ_OPT_DISABLE);
    eval 'sub CM0_ZR_OPT_DISABLE () {(1<<5);}' unless defined(&CM0_ZR_OPT_DISABLE);
    eval 'sub CM0_DEPTH_EVICT_DISABLE () {(1<<4);}' unless defined(&CM0_DEPTH_EVICT_DISABLE);
    eval 'sub CM0_COLOR_EVICT_DISABLE () {(1<<3);}' unless defined(&CM0_COLOR_EVICT_DISABLE);
    eval 'sub CM0_DEPTH_WRITE_DISABLE () {(1<<1);}' unless defined(&CM0_DEPTH_WRITE_DISABLE);
    eval 'sub CM0_RC_OP_FLUSH_DISABLE () {(1<<0);}' unless defined(&CM0_RC_OP_FLUSH_DISABLE);
    eval 'sub GFX_FLSH_CNTL () {0x2170;}' unless defined(&GFX_FLSH_CNTL);
    eval 'sub FBC_CFB_BASE () {0x3200;}' unless defined(&FBC_CFB_BASE);
    eval 'sub FBC_LL_BASE () {0x3204;}' unless defined(&FBC_LL_BASE);
    eval 'sub FBC_CONTROL () {0x3208;}' unless defined(&FBC_CONTROL);
    eval 'sub FBC_CTL_EN () {(1<<31);}' unless defined(&FBC_CTL_EN);
    eval 'sub FBC_CTL_PERIODIC () {(1<<30);}' unless defined(&FBC_CTL_PERIODIC);
    eval 'sub FBC_CTL_INTERVAL_SHIFT () {(16);}' unless defined(&FBC_CTL_INTERVAL_SHIFT);
    eval 'sub FBC_CTL_UNCOMPRESSIBLE () {(1<<14);}' unless defined(&FBC_CTL_UNCOMPRESSIBLE);
    eval 'sub FBC_CTL_STRIDE_SHIFT () {(5);}' unless defined(&FBC_CTL_STRIDE_SHIFT);
    eval 'sub FBC_CTL_FENCENO () {(1<<0);}' unless defined(&FBC_CTL_FENCENO);
    eval 'sub FBC_COMMAND () {0x320c;}' unless defined(&FBC_COMMAND);
    eval 'sub FBC_CMD_COMPRESS () {(1<<0);}' unless defined(&FBC_CMD_COMPRESS);
    eval 'sub FBC_STATUS () {0x3210;}' unless defined(&FBC_STATUS);
    eval 'sub FBC_STAT_COMPRESSING () {(1<<31);}' unless defined(&FBC_STAT_COMPRESSING);
    eval 'sub FBC_STAT_COMPRESSED () {(1<<30);}' unless defined(&FBC_STAT_COMPRESSED);
    eval 'sub FBC_STAT_MODIFIED () {(1<<29);}' unless defined(&FBC_STAT_MODIFIED);
    eval 'sub FBC_STAT_CURRENT_LINE () {(1<<0);}' unless defined(&FBC_STAT_CURRENT_LINE);
    eval 'sub FBC_CONTROL2 () {0x3214;}' unless defined(&FBC_CONTROL2);
    eval 'sub FBC_CTL_FENCE_DBL () {(0<<4);}' unless defined(&FBC_CTL_FENCE_DBL);
    eval 'sub FBC_CTL_IDLE_IMM () {(0<<2);}' unless defined(&FBC_CTL_IDLE_IMM);
    eval 'sub FBC_CTL_IDLE_FULL () {(1<<2);}' unless defined(&FBC_CTL_IDLE_FULL);
    eval 'sub FBC_CTL_IDLE_LINE () {(2<<2);}' unless defined(&FBC_CTL_IDLE_LINE);
    eval 'sub FBC_CTL_IDLE_DEBUG () {(3<<2);}' unless defined(&FBC_CTL_IDLE_DEBUG);
    eval 'sub FBC_CTL_CPU_FENCE () {(1<<1);}' unless defined(&FBC_CTL_CPU_FENCE);
    eval 'sub FBC_CTL_PLANEA () {(0<<0);}' unless defined(&FBC_CTL_PLANEA);
    eval 'sub FBC_CTL_PLANEB () {(1<<0);}' unless defined(&FBC_CTL_PLANEB);
    eval 'sub FBC_FENCE_OFF () {0x321b;}' unless defined(&FBC_FENCE_OFF);
    eval 'sub FBC_LL_SIZE () {(1536);}' unless defined(&FBC_LL_SIZE);
    eval 'sub DPFC_CB_BASE () {0x3200;}' unless defined(&DPFC_CB_BASE);
    eval 'sub DPFC_CONTROL () {0x3208;}' unless defined(&DPFC_CONTROL);
    eval 'sub DPFC_CTL_EN () {(1<<31);}' unless defined(&DPFC_CTL_EN);
    eval 'sub DPFC_CTL_PLANEA () {(0<<30);}' unless defined(&DPFC_CTL_PLANEA);
    eval 'sub DPFC_CTL_PLANEB () {(1<<30);}' unless defined(&DPFC_CTL_PLANEB);
    eval 'sub DPFC_CTL_FENCE_EN () {(1<<29);}' unless defined(&DPFC_CTL_FENCE_EN);
    eval 'sub DPFC_SR_EN () {(1<<10);}' unless defined(&DPFC_SR_EN);
    eval 'sub DPFC_CTL_LIMIT_1X () {(0<<6);}' unless defined(&DPFC_CTL_LIMIT_1X);
    eval 'sub DPFC_CTL_LIMIT_2X () {(1<<6);}' unless defined(&DPFC_CTL_LIMIT_2X);
    eval 'sub DPFC_CTL_LIMIT_4X () {(2<<6);}' unless defined(&DPFC_CTL_LIMIT_4X);
    eval 'sub DPFC_RECOMP_CTL () {0x320c;}' unless defined(&DPFC_RECOMP_CTL);
    eval 'sub DPFC_RECOMP_STALL_EN () {(1<<27);}' unless defined(&DPFC_RECOMP_STALL_EN);
    eval 'sub DPFC_RECOMP_STALL_WM_SHIFT () {(16);}' unless defined(&DPFC_RECOMP_STALL_WM_SHIFT);
    eval 'sub DPFC_RECOMP_STALL_WM_MASK () {(0x7ff0000);}' unless defined(&DPFC_RECOMP_STALL_WM_MASK);
    eval 'sub DPFC_RECOMP_TIMER_COUNT_SHIFT () {(0);}' unless defined(&DPFC_RECOMP_TIMER_COUNT_SHIFT);
    eval 'sub DPFC_RECOMP_TIMER_COUNT_MASK () {(0x3f);}' unless defined(&DPFC_RECOMP_TIMER_COUNT_MASK);
    eval 'sub DPFC_STATUS () {0x3210;}' unless defined(&DPFC_STATUS);
    eval 'sub DPFC_INVAL_SEG_SHIFT () {(16);}' unless defined(&DPFC_INVAL_SEG_SHIFT);
    eval 'sub DPFC_INVAL_SEG_MASK () {(0x7ff0000);}' unless defined(&DPFC_INVAL_SEG_MASK);
    eval 'sub DPFC_COMP_SEG_SHIFT () {(0);}' unless defined(&DPFC_COMP_SEG_SHIFT);
    eval 'sub DPFC_COMP_SEG_MASK () {(0x3ff);}' unless defined(&DPFC_COMP_SEG_MASK);
    eval 'sub DPFC_STATUS2 () {0x3214;}' unless defined(&DPFC_STATUS2);
    eval 'sub DPFC_FENCE_YOFF () {0x3218;}' unless defined(&DPFC_FENCE_YOFF);
    eval 'sub DPFC_CHICKEN () {0x3224;}' unless defined(&DPFC_CHICKEN);
    eval 'sub DPFC_HT_MODIFY () {(1<<31);}' unless defined(&DPFC_HT_MODIFY);
    eval 'sub GPIOA () {0x5010;}' unless defined(&GPIOA);
    eval 'sub GPIOB () {0x5014;}' unless defined(&GPIOB);
    eval 'sub GPIOC () {0x5018;}' unless defined(&GPIOC);
    eval 'sub GPIOD () {0x501c;}' unless defined(&GPIOD);
    eval 'sub GPIOE () {0x5020;}' unless defined(&GPIOE);
    eval 'sub GPIOF () {0x5024;}' unless defined(&GPIOF);
    eval 'sub GPIOG () {0x5028;}' unless defined(&GPIOG);
    eval 'sub GPIOH () {0x502c;}' unless defined(&GPIOH);
    eval 'sub GPIO_CLOCK_DIR_MASK () {(1<< 0);}' unless defined(&GPIO_CLOCK_DIR_MASK);
    eval 'sub GPIO_CLOCK_DIR_IN () {(0<< 1);}' unless defined(&GPIO_CLOCK_DIR_IN);
    eval 'sub GPIO_CLOCK_DIR_OUT () {(1<< 1);}' unless defined(&GPIO_CLOCK_DIR_OUT);
    eval 'sub GPIO_CLOCK_VAL_MASK () {(1<< 2);}' unless defined(&GPIO_CLOCK_VAL_MASK);
    eval 'sub GPIO_CLOCK_VAL_OUT () {(1<< 3);}' unless defined(&GPIO_CLOCK_VAL_OUT);
    eval 'sub GPIO_CLOCK_VAL_IN () {(1<< 4);}' unless defined(&GPIO_CLOCK_VAL_IN);
    eval 'sub GPIO_CLOCK_PULLUP_DISABLE () {(1<< 5);}' unless defined(&GPIO_CLOCK_PULLUP_DISABLE);
    eval 'sub GPIO_DATA_DIR_MASK () {(1<< 8);}' unless defined(&GPIO_DATA_DIR_MASK);
    eval 'sub GPIO_DATA_DIR_IN () {(0<< 9);}' unless defined(&GPIO_DATA_DIR_IN);
    eval 'sub GPIO_DATA_DIR_OUT () {(1<< 9);}' unless defined(&GPIO_DATA_DIR_OUT);
    eval 'sub GPIO_DATA_VAL_MASK () {(1<< 10);}' unless defined(&GPIO_DATA_VAL_MASK);
    eval 'sub GPIO_DATA_VAL_OUT () {(1<< 11);}' unless defined(&GPIO_DATA_VAL_OUT);
    eval 'sub GPIO_DATA_VAL_IN () {(1<< 12);}' unless defined(&GPIO_DATA_VAL_IN);
    eval 'sub GPIO_DATA_PULLUP_DISABLE () {(1<< 13);}' unless defined(&GPIO_DATA_PULLUP_DISABLE);
    eval 'sub VGA0 () {0x6000;}' unless defined(&VGA0);
    eval 'sub VGA1 () {0x6004;}' unless defined(&VGA1);
    eval 'sub VGA_PD () {0x6010;}' unless defined(&VGA_PD);
    eval 'sub VGA0_PD_P2_DIV_4 () {(1<< 7);}' unless defined(&VGA0_PD_P2_DIV_4);
    eval 'sub VGA0_PD_P1_DIV_2 () {(1<< 5);}' unless defined(&VGA0_PD_P1_DIV_2);
    eval 'sub VGA0_PD_P1_SHIFT () {0;}' unless defined(&VGA0_PD_P1_SHIFT);
    eval 'sub VGA0_PD_P1_MASK () {(0x1f << 0);}' unless defined(&VGA0_PD_P1_MASK);
    eval 'sub VGA1_PD_P2_DIV_4 () {(1<< 15);}' unless defined(&VGA1_PD_P2_DIV_4);
    eval 'sub VGA1_PD_P1_DIV_2 () {(1<< 13);}' unless defined(&VGA1_PD_P1_DIV_2);
    eval 'sub VGA1_PD_P1_SHIFT () {8;}' unless defined(&VGA1_PD_P1_SHIFT);
    eval 'sub VGA1_PD_P1_MASK () {(0x1f << 8);}' unless defined(&VGA1_PD_P1_MASK);
    eval 'sub DPLL_A () {0x6014;}' unless defined(&DPLL_A);
    eval 'sub DPLL_B () {0x6018;}' unless defined(&DPLL_B);
    eval 'sub DPLL_VCO_ENABLE () {(1<< 31);}' unless defined(&DPLL_VCO_ENABLE);
    eval 'sub DPLL_DVO_HIGH_SPEED () {(1<< 30);}' unless defined(&DPLL_DVO_HIGH_SPEED);
    eval 'sub DPLL_SYNCLOCK_ENABLE () {(1<< 29);}' unless defined(&DPLL_SYNCLOCK_ENABLE);
    eval 'sub DPLL_VGA_MODE_DIS () {(1<< 28);}' unless defined(&DPLL_VGA_MODE_DIS);
    eval 'sub DPLLB_MODE_DAC_SERIAL () {(1<< 26);}' unless defined(&DPLLB_MODE_DAC_SERIAL);
    eval 'sub DPLLB_MODE_LVDS () {(2<< 26);}' unless defined(&DPLLB_MODE_LVDS);
    eval 'sub DPLL_MODE_MASK () {(3<< 26);}' unless defined(&DPLL_MODE_MASK);
    eval 'sub DPLL_DAC_SERIAL_P2_CLOCK_DIV_10 () {(0<< 24);}' unless defined(&DPLL_DAC_SERIAL_P2_CLOCK_DIV_10);
    eval 'sub DPLL_DAC_SERIAL_P2_CLOCK_DIV_5 () {(1<< 24);}' unless defined(&DPLL_DAC_SERIAL_P2_CLOCK_DIV_5);
    eval 'sub DPLLB_LVDS_P2_CLOCK_DIV_14 () {(0<< 24);}' unless defined(&DPLLB_LVDS_P2_CLOCK_DIV_14);
    eval 'sub DPLLB_LVDS_P2_CLOCK_DIV_7 () {(1<< 24);}' unless defined(&DPLLB_LVDS_P2_CLOCK_DIV_7);
    eval 'sub DPLL_P2_CLOCK_DIV_MASK () {0x3000000;}' unless defined(&DPLL_P2_CLOCK_DIV_MASK);
    eval 'sub DPLL_FPA01_P1_POST_DIV_MASK () {0xff0000;}' unless defined(&DPLL_FPA01_P1_POST_DIV_MASK);
    eval 'sub I915_FIFO_UNDERRUN_STATUS () {(1<<31);}' unless defined(&I915_FIFO_UNDERRUN_STATUS);
    eval 'sub I915_CRC_ERROR_ENABLE () {(1<<29);}' unless defined(&I915_CRC_ERROR_ENABLE);
    eval 'sub I915_CRC_DONE_ENABLE () {(1<<28);}' unless defined(&I915_CRC_DONE_ENABLE);
    eval 'sub I915_GMBUS_EVENT_ENABLE () {(1<<27);}' unless defined(&I915_GMBUS_EVENT_ENABLE);
    eval 'sub I915_VSYNC_INTERRUPT_ENABLE () {(1<<25);}' unless defined(&I915_VSYNC_INTERRUPT_ENABLE);
    eval 'sub I915_DISPLAY_LINE_COMPARE_ENABLE () {(1<<24);}' unless defined(&I915_DISPLAY_LINE_COMPARE_ENABLE);
    eval 'sub I915_DPST_EVENT_ENABLE () {(1<<23);}' unless defined(&I915_DPST_EVENT_ENABLE);
    eval 'sub I915_LEGACY_BLC_EVENT_ENABLE () {(1<<22);}' unless defined(&I915_LEGACY_BLC_EVENT_ENABLE);
    eval 'sub I915_ODD_FIELD_INTERRUPT_ENABLE () {(1<<21);}' unless defined(&I915_ODD_FIELD_INTERRUPT_ENABLE);
    eval 'sub I915_EVEN_FIELD_INTERRUPT_ENABLE () {(1<<20);}' unless defined(&I915_EVEN_FIELD_INTERRUPT_ENABLE);
    eval 'sub I915_START_VBLANK_INTERRUPT_ENABLE () {(1<<18);}' unless defined(&I915_START_VBLANK_INTERRUPT_ENABLE);
    eval 'sub I915_VBLANK_INTERRUPT_ENABLE () {(1<<17);}' unless defined(&I915_VBLANK_INTERRUPT_ENABLE);
    eval 'sub I915_OVERLAY_UPDATED_ENABLE () {(1<<16);}' unless defined(&I915_OVERLAY_UPDATED_ENABLE);
    eval 'sub I915_CRC_ERROR_INTERRUPT_STATUS () {(1<<13);}' unless defined(&I915_CRC_ERROR_INTERRUPT_STATUS);
    eval 'sub I915_CRC_DONE_INTERRUPT_STATUS () {(1<<12);}' unless defined(&I915_CRC_DONE_INTERRUPT_STATUS);
    eval 'sub I915_GMBUS_INTERRUPT_STATUS () {(1<<11);}' unless defined(&I915_GMBUS_INTERRUPT_STATUS);
    eval 'sub I915_VSYNC_INTERRUPT_STATUS () {(1<<9);}' unless defined(&I915_VSYNC_INTERRUPT_STATUS);
    eval 'sub I915_DISPLAY_LINE_COMPARE_STATUS () {(1<<8);}' unless defined(&I915_DISPLAY_LINE_COMPARE_STATUS);
    eval 'sub I915_DPST_EVENT_STATUS () {(1<<7);}' unless defined(&I915_DPST_EVENT_STATUS);
    eval 'sub I915_LEGACY_BLC_EVENT_STATUS () {(1<<6);}' unless defined(&I915_LEGACY_BLC_EVENT_STATUS);
    eval 'sub I915_ODD_FIELD_INTERRUPT_STATUS () {(1<<5);}' unless defined(&I915_ODD_FIELD_INTERRUPT_STATUS);
    eval 'sub I915_EVEN_FIELD_INTERRUPT_STATUS () {(1<<4);}' unless defined(&I915_EVEN_FIELD_INTERRUPT_STATUS);
    eval 'sub I915_START_VBLANK_INTERRUPT_STATUS () {(1<<2);}' unless defined(&I915_START_VBLANK_INTERRUPT_STATUS);
    eval 'sub I915_VBLANK_INTERRUPT_STATUS () {(1<<1);}' unless defined(&I915_VBLANK_INTERRUPT_STATUS);
    eval 'sub I915_OVERLAY_UPDATED_STATUS () {(1<<0);}' unless defined(&I915_OVERLAY_UPDATED_STATUS);
    eval 'sub SRX_INDEX () {0x3c4;}' unless defined(&SRX_INDEX);
    eval 'sub SRX_DATA () {0x3c5;}' unless defined(&SRX_DATA);
    eval 'sub SR01 () {1;}' unless defined(&SR01);
    eval 'sub SR01_SCREEN_OFF () {(1<<5);}' unless defined(&SR01_SCREEN_OFF);
    eval 'sub PPCR () {0x61204;}' unless defined(&PPCR);
    eval 'sub PPCR_ON () {(1<<0);}' unless defined(&PPCR_ON);
    eval 'sub DVOB () {0x61140;}' unless defined(&DVOB);
    eval 'sub DVOB_ON () {(1<<31);}' unless defined(&DVOB_ON);
    eval 'sub DVOC () {0x61160;}' unless defined(&DVOC);
    eval 'sub DVOC_ON () {(1<<31);}' unless defined(&DVOC_ON);
    eval 'sub LVDS () {0x61180;}' unless defined(&LVDS);
    eval 'sub LVDS_ON () {(1<<31);}' unless defined(&LVDS_ON);
    eval 'sub ADPA () {0x61100;}' unless defined(&ADPA);
    eval 'sub ADPA_DPMS_MASK () {(~(3<<10));}' unless defined(&ADPA_DPMS_MASK);
    eval 'sub ADPA_DPMS_ON () {(0<<10);}' unless defined(&ADPA_DPMS_ON);
    eval 'sub ADPA_DPMS_SUSPEND () {(1<<10);}' unless defined(&ADPA_DPMS_SUSPEND);
    eval 'sub ADPA_DPMS_STANDBY () {(2<<10);}' unless defined(&ADPA_DPMS_STANDBY);
    eval 'sub ADPA_DPMS_OFF () {(3<<10);}' unless defined(&ADPA_DPMS_OFF);
    eval 'sub RING_TAIL () {0x;}' unless defined(&RING_TAIL);
    eval 'sub TAIL_ADDR () {0x1ffff8;}' unless defined(&TAIL_ADDR);
    eval 'sub RING_HEAD () {0x4;}' unless defined(&RING_HEAD);
    eval 'sub HEAD_WRAP_COUNT () {0xffe00000;}' unless defined(&HEAD_WRAP_COUNT);
    eval 'sub HEAD_WRAP_ONE () {0x200000;}' unless defined(&HEAD_WRAP_ONE);
    eval 'sub HEAD_ADDR () {0x1ffffc;}' unless defined(&HEAD_ADDR);
    eval 'sub RING_START () {0x8;}' unless defined(&RING_START);
    eval 'sub START_ADDR () {0xfffff000;}' unless defined(&START_ADDR);
    eval 'sub RING_LEN () {0xc;}' unless defined(&RING_LEN);
    eval 'sub RING_NR_PAGES () {0x1ff000;}' unless defined(&RING_NR_PAGES);
    eval 'sub RING_REPORT_MASK () {0x6;}' unless defined(&RING_REPORT_MASK);
    eval 'sub RING_REPORT_64K () {0x2;}' unless defined(&RING_REPORT_64K);
    eval 'sub RING_REPORT_128K () {0x4;}' unless defined(&RING_REPORT_128K);
    eval 'sub RING_NO_REPORT () {0x;}' unless defined(&RING_NO_REPORT);
    eval 'sub RING_VALID_MASK () {0x1;}' unless defined(&RING_VALID_MASK);
    eval 'sub RING_VALID () {0x1;}' unless defined(&RING_VALID);
    eval 'sub RING_INVALID () {0x;}' unless defined(&RING_INVALID);
    eval 'sub DPLL_FPA01_P1_POST_DIV_MASK_I830 () {0x1f0000;}' unless defined(&DPLL_FPA01_P1_POST_DIV_MASK_I830);
    eval 'sub DPLL_FPA01_P1_POST_DIV_MASK_I830_LVDS () {0x3f0000;}' unless defined(&DPLL_FPA01_P1_POST_DIV_MASK_I830_LVDS);
    eval 'sub DPLL_FPA01_P1_POST_DIV_SHIFT () {16;}' unless defined(&DPLL_FPA01_P1_POST_DIV_SHIFT);
    eval 'sub DPLL_FPA01_P1_POST_DIV_SHIFT_IGD () {15;}' unless defined(&DPLL_FPA01_P1_POST_DIV_SHIFT_IGD);
    eval 'sub PLL_P2_DIVIDE_BY_4 () {(1<< 23);}' unless defined(&PLL_P2_DIVIDE_BY_4);
    eval 'sub PLL_P1_DIVIDE_BY_TWO () {(1<< 21);}' unless defined(&PLL_P1_DIVIDE_BY_TWO);
    eval 'sub PLL_REF_INPUT_DREFCLK () {(0<< 13);}' unless defined(&PLL_REF_INPUT_DREFCLK);
    eval 'sub PLL_REF_INPUT_TVCLKINA () {(1<< 13);}' unless defined(&PLL_REF_INPUT_TVCLKINA);
    eval 'sub PLL_REF_INPUT_TVCLKINBC () {(2<< 13);}' unless defined(&PLL_REF_INPUT_TVCLKINBC);
    eval 'sub PLLB_REF_INPUT_SPREADSPECTRUMIN () {(3<< 13);}' unless defined(&PLLB_REF_INPUT_SPREADSPECTRUMIN);
    eval 'sub PLL_REF_INPUT_MASK () {(3<< 13);}' unless defined(&PLL_REF_INPUT_MASK);
    eval 'sub PLL_LOAD_PULSE_PHASE_SHIFT () {9;}' unless defined(&PLL_LOAD_PULSE_PHASE_SHIFT);
    eval 'sub PLL_REF_SDVO_HDMI_MULTIPLIER_SHIFT () {9;}' unless defined(&PLL_REF_SDVO_HDMI_MULTIPLIER_SHIFT);
    eval 'sub PLL_REF_SDVO_HDMI_MULTIPLIER_MASK () {(7<< 9);}' unless defined(&PLL_REF_SDVO_HDMI_MULTIPLIER_MASK);
    eval 'sub PLL_REF_SDVO_HDMI_MULTIPLIER {
        my($x) = @_;
	    eval q(((($x)-1) << 9));
    }' unless defined(&PLL_REF_SDVO_HDMI_MULTIPLIER);
    eval 'sub DPLL_FPA1_P1_POST_DIV_SHIFT () {0;}' unless defined(&DPLL_FPA1_P1_POST_DIV_SHIFT);
    eval 'sub DPLL_FPA1_P1_POST_DIV_MASK () {0xff;}' unless defined(&DPLL_FPA1_P1_POST_DIV_MASK);
    eval 'sub PLL_LOAD_PULSE_PHASE_MASK () {(0xf <<  &PLL_LOAD_PULSE_PHASE_SHIFT);}' unless defined(&PLL_LOAD_PULSE_PHASE_MASK);
    eval 'sub DISPLAY_RATE_SELECT_FPA1 () {(1<< 8);}' unless defined(&DISPLAY_RATE_SELECT_FPA1);
    eval 'sub SDVO_MULTIPLIER_MASK () {0xff;}' unless defined(&SDVO_MULTIPLIER_MASK);
    eval 'sub SDVO_MULTIPLIER_SHIFT_HIRES () {4;}' unless defined(&SDVO_MULTIPLIER_SHIFT_HIRES);
    eval 'sub SDVO_MULTIPLIER_SHIFT_VGA () {0;}' unless defined(&SDVO_MULTIPLIER_SHIFT_VGA);
    eval 'sub DPLL_A_MD () {0x601c;}' unless defined(&DPLL_A_MD);
    eval 'sub DPLL_MD_UDI_DIVIDER_MASK () {0x3f000000;}' unless defined(&DPLL_MD_UDI_DIVIDER_MASK);
    eval 'sub DPLL_MD_UDI_DIVIDER_SHIFT () {24;}' unless defined(&DPLL_MD_UDI_DIVIDER_SHIFT);
    eval 'sub DPLL_MD_VGA_UDI_DIVIDER_MASK () {0x3f0000;}' unless defined(&DPLL_MD_VGA_UDI_DIVIDER_MASK);
    eval 'sub DPLL_MD_VGA_UDI_DIVIDER_SHIFT () {16;}' unless defined(&DPLL_MD_VGA_UDI_DIVIDER_SHIFT);
    eval 'sub DPLL_MD_UDI_MULTIPLIER_MASK () {0x3f00;}' unless defined(&DPLL_MD_UDI_MULTIPLIER_MASK);
    eval 'sub DPLL_MD_UDI_MULTIPLIER_SHIFT () {8;}' unless defined(&DPLL_MD_UDI_MULTIPLIER_SHIFT);
    eval 'sub DPLL_MD_VGA_UDI_MULTIPLIER_MASK () {0x3f;}' unless defined(&DPLL_MD_VGA_UDI_MULTIPLIER_MASK);
    eval 'sub DPLL_MD_VGA_UDI_MULTIPLIER_SHIFT () {0;}' unless defined(&DPLL_MD_VGA_UDI_MULTIPLIER_SHIFT);
    eval 'sub DPLL_B_MD () {0x6020;}' unless defined(&DPLL_B_MD);
    eval 'sub FPA0 () {0x6040;}' unless defined(&FPA0);
    eval 'sub FPA1 () {0x6044;}' unless defined(&FPA1);
    eval 'sub FPB0 () {0x6048;}' unless defined(&FPB0);
    eval 'sub FPB1 () {0x604c;}' unless defined(&FPB1);
    eval 'sub FP_N_DIV_MASK () {0x3f0000;}' unless defined(&FP_N_DIV_MASK);
    eval 'sub FP_N_IGD_DIV_MASK () {0xff0000;}' unless defined(&FP_N_IGD_DIV_MASK);
    eval 'sub FP_N_DIV_SHIFT () {16;}' unless defined(&FP_N_DIV_SHIFT);
    eval 'sub FP_M1_DIV_MASK () {0x3f00;}' unless defined(&FP_M1_DIV_MASK);
    eval 'sub FP_M1_DIV_SHIFT () {8;}' unless defined(&FP_M1_DIV_SHIFT);
    eval 'sub FP_M2_DIV_MASK () {0x3f;}' unless defined(&FP_M2_DIV_MASK);
    eval 'sub FP_M2_IGD_DIV_MASK () {0xff;}' unless defined(&FP_M2_IGD_DIV_MASK);
    eval 'sub FP_M2_DIV_SHIFT () {0;}' unless defined(&FP_M2_DIV_SHIFT);
    eval 'sub DPLL_TEST () {0x606c;}' unless defined(&DPLL_TEST);
    eval 'sub DPLLB_TEST_SDVO_DIV_1 () {(0<< 22);}' unless defined(&DPLLB_TEST_SDVO_DIV_1);
    eval 'sub DPLLB_TEST_SDVO_DIV_2 () {(1<< 22);}' unless defined(&DPLLB_TEST_SDVO_DIV_2);
    eval 'sub DPLLB_TEST_SDVO_DIV_4 () {(2<< 22);}' unless defined(&DPLLB_TEST_SDVO_DIV_4);
    eval 'sub DPLLB_TEST_SDVO_DIV_MASK () {(3<< 22);}' unless defined(&DPLLB_TEST_SDVO_DIV_MASK);
    eval 'sub DPLLB_TEST_N_BYPASS () {(1<< 19);}' unless defined(&DPLLB_TEST_N_BYPASS);
    eval 'sub DPLLB_TEST_M_BYPASS () {(1<< 18);}' unless defined(&DPLLB_TEST_M_BYPASS);
    eval 'sub DPLLB_INPUT_BUFFER_ENABLE () {(1<< 16);}' unless defined(&DPLLB_INPUT_BUFFER_ENABLE);
    eval 'sub DPLLA_TEST_N_BYPASS () {(1<< 3);}' unless defined(&DPLLA_TEST_N_BYPASS);
    eval 'sub DPLLA_TEST_M_BYPASS () {(1<< 2);}' unless defined(&DPLLA_TEST_M_BYPASS);
    eval 'sub DPLLA_INPUT_BUFFER_ENABLE () {(1<< 0);}' unless defined(&DPLLA_INPUT_BUFFER_ENABLE);
    eval 'sub D_STATE () {0x6104;}' unless defined(&D_STATE);
    eval 'sub DSTATE_PLL_D3_OFF () {(1<<3);}' unless defined(&DSTATE_PLL_D3_OFF);
    eval 'sub DSTATE_GFX_CLOCK_GATING () {(1<<1);}' unless defined(&DSTATE_GFX_CLOCK_GATING);
    eval 'sub DSTATE_DOT_CLOCK_GATING () {(1<<0);}' unless defined(&DSTATE_DOT_CLOCK_GATING);
    eval 'sub DSPCLK_GATE_D () {0x6200;}' unless defined(&DSPCLK_GATE_D);
    eval 'sub DPUNIT_B_CLOCK_GATE_DISABLE () {(1<< 30);}' unless defined(&DPUNIT_B_CLOCK_GATE_DISABLE);
    eval 'sub VSUNIT_CLOCK_GATE_DISABLE () {(1<< 29);}' unless defined(&VSUNIT_CLOCK_GATE_DISABLE);
    eval 'sub VRHUNIT_CLOCK_GATE_DISABLE () {(1<< 28);}' unless defined(&VRHUNIT_CLOCK_GATE_DISABLE);
    eval 'sub VRDUNIT_CLOCK_GATE_DISABLE () {(1<< 27);}' unless defined(&VRDUNIT_CLOCK_GATE_DISABLE);
    eval 'sub AUDUNIT_CLOCK_GATE_DISABLE () {(1<< 26);}' unless defined(&AUDUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPUNIT_A_CLOCK_GATE_DISABLE () {(1<< 25);}' unless defined(&DPUNIT_A_CLOCK_GATE_DISABLE);
    eval 'sub DPCUNIT_CLOCK_GATE_DISABLE () {(1<< 24);}' unless defined(&DPCUNIT_CLOCK_GATE_DISABLE);
    eval 'sub TVRUNIT_CLOCK_GATE_DISABLE () {(1<< 23);}' unless defined(&TVRUNIT_CLOCK_GATE_DISABLE);
    eval 'sub TVCUNIT_CLOCK_GATE_DISABLE () {(1<< 22);}' unless defined(&TVCUNIT_CLOCK_GATE_DISABLE);
    eval 'sub TVFUNIT_CLOCK_GATE_DISABLE () {(1<< 21);}' unless defined(&TVFUNIT_CLOCK_GATE_DISABLE);
    eval 'sub TVEUNIT_CLOCK_GATE_DISABLE () {(1<< 20);}' unless defined(&TVEUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DVSUNIT_CLOCK_GATE_DISABLE () {(1<< 19);}' unless defined(&DVSUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DSSUNIT_CLOCK_GATE_DISABLE () {(1<< 18);}' unless defined(&DSSUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DDBUNIT_CLOCK_GATE_DISABLE () {(1<< 17);}' unless defined(&DDBUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPRUNIT_CLOCK_GATE_DISABLE () {(1<< 16);}' unless defined(&DPRUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPFUNIT_CLOCK_GATE_DISABLE () {(1<< 15);}' unless defined(&DPFUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPBMUNIT_CLOCK_GATE_DISABLE () {(1<< 14);}' unless defined(&DPBMUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPLSUNIT_CLOCK_GATE_DISABLE () {(1<< 13);}' unless defined(&DPLSUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPLUNIT_CLOCK_GATE_DISABLE () {(1<< 12);}' unless defined(&DPLUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPOUNIT_CLOCK_GATE_DISABLE () {(1<< 11);}' unless defined(&DPOUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPBUNIT_CLOCK_GATE_DISABLE () {(1<< 10);}' unless defined(&DPBUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DCUNIT_CLOCK_GATE_DISABLE () {(1<< 9);}' unless defined(&DCUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPUNIT_CLOCK_GATE_DISABLE () {(1<< 8);}' unless defined(&DPUNIT_CLOCK_GATE_DISABLE);
    eval 'sub VRUNIT_CLOCK_GATE_DISABLE () {(1<< 7);}' unless defined(&VRUNIT_CLOCK_GATE_DISABLE);
    eval 'sub OVHUNIT_CLOCK_GATE_DISABLE () {(1<< 6);}' unless defined(&OVHUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPIOUNIT_CLOCK_GATE_DISABLE () {(1<< 6);}' unless defined(&DPIOUNIT_CLOCK_GATE_DISABLE);
    eval 'sub OVFUNIT_CLOCK_GATE_DISABLE () {(1<< 5);}' unless defined(&OVFUNIT_CLOCK_GATE_DISABLE);
    eval 'sub OVBUNIT_CLOCK_GATE_DISABLE () {(1<< 4);}' unless defined(&OVBUNIT_CLOCK_GATE_DISABLE);
    eval 'sub OVRUNIT_CLOCK_GATE_DISABLE () {(1<< 3);}' unless defined(&OVRUNIT_CLOCK_GATE_DISABLE);
    eval 'sub OVCUNIT_CLOCK_GATE_DISABLE () {(1<< 2);}' unless defined(&OVCUNIT_CLOCK_GATE_DISABLE);
    eval 'sub OVUUNIT_CLOCK_GATE_DISABLE () {(1<< 1);}' unless defined(&OVUUNIT_CLOCK_GATE_DISABLE);
    eval 'sub ZVUNIT_CLOCK_GATE_DISABLE () {(1<< 0);}' unless defined(&ZVUNIT_CLOCK_GATE_DISABLE);
    eval 'sub OVLUNIT_CLOCK_GATE_DISABLE () {(1<< 0);}' unless defined(&OVLUNIT_CLOCK_GATE_DISABLE);
    eval 'sub RENCLK_GATE_D1 () {0x6204;}' unless defined(&RENCLK_GATE_D1);
    eval 'sub BLITTER_CLOCK_GATE_DISABLE () {(1<< 13);}' unless defined(&BLITTER_CLOCK_GATE_DISABLE);
    eval 'sub MPEG_CLOCK_GATE_DISABLE () {(1<< 12);}' unless defined(&MPEG_CLOCK_GATE_DISABLE);
    eval 'sub PC_FE_CLOCK_GATE_DISABLE () {(1<< 11);}' unless defined(&PC_FE_CLOCK_GATE_DISABLE);
    eval 'sub PC_BE_CLOCK_GATE_DISABLE () {(1<< 10);}' unless defined(&PC_BE_CLOCK_GATE_DISABLE);
    eval 'sub WINDOWER_CLOCK_GATE_DISABLE () {(1<< 9);}' unless defined(&WINDOWER_CLOCK_GATE_DISABLE);
    eval 'sub INTERPOLATOR_CLOCK_GATE_DISABLE () {(1<< 8);}' unless defined(&INTERPOLATOR_CLOCK_GATE_DISABLE);
    eval 'sub COLOR_CALCULATOR_CLOCK_GATE_DISABLE () {(1<< 7);}' unless defined(&COLOR_CALCULATOR_CLOCK_GATE_DISABLE);
    eval 'sub MOTION_COMP_CLOCK_GATE_DISABLE () {(1<< 6);}' unless defined(&MOTION_COMP_CLOCK_GATE_DISABLE);
    eval 'sub MAG_CLOCK_GATE_DISABLE () {(1<< 5);}' unless defined(&MAG_CLOCK_GATE_DISABLE);
    eval 'sub MECI_CLOCK_GATE_DISABLE () {(1<< 4);}' unless defined(&MECI_CLOCK_GATE_DISABLE);
    eval 'sub DCMP_CLOCK_GATE_DISABLE () {(1<< 3);}' unless defined(&DCMP_CLOCK_GATE_DISABLE);
    eval 'sub MEC_CLOCK_GATE_DISABLE () {(1<< 2);}' unless defined(&MEC_CLOCK_GATE_DISABLE);
    eval 'sub MECO_CLOCK_GATE_DISABLE () {(1<< 1);}' unless defined(&MECO_CLOCK_GATE_DISABLE);
    eval 'sub SV_CLOCK_GATE_DISABLE () {(1<< 0);}' unless defined(&SV_CLOCK_GATE_DISABLE);
    eval 'sub I915_MPEG_CLOCK_GATE_DISABLE () {(1<< 16);}' unless defined(&I915_MPEG_CLOCK_GATE_DISABLE);
    eval 'sub I915_VLD_IP_PR_CLOCK_GATE_DISABLE () {(1<< 15);}' unless defined(&I915_VLD_IP_PR_CLOCK_GATE_DISABLE);
    eval 'sub I915_MOTION_COMP_CLOCK_GATE_DISABLE () {(1<< 14);}' unless defined(&I915_MOTION_COMP_CLOCK_GATE_DISABLE);
    eval 'sub I915_BD_BF_CLOCK_GATE_DISABLE () {(1<< 13);}' unless defined(&I915_BD_BF_CLOCK_GATE_DISABLE);
    eval 'sub I915_SF_SE_CLOCK_GATE_DISABLE () {(1<< 12);}' unless defined(&I915_SF_SE_CLOCK_GATE_DISABLE);
    eval 'sub I915_WM_CLOCK_GATE_DISABLE () {(1<< 11);}' unless defined(&I915_WM_CLOCK_GATE_DISABLE);
    eval 'sub I915_IZ_CLOCK_GATE_DISABLE () {(1<< 10);}' unless defined(&I915_IZ_CLOCK_GATE_DISABLE);
    eval 'sub I915_PI_CLOCK_GATE_DISABLE () {(1<< 9);}' unless defined(&I915_PI_CLOCK_GATE_DISABLE);
    eval 'sub I915_DI_CLOCK_GATE_DISABLE () {(1<< 8);}' unless defined(&I915_DI_CLOCK_GATE_DISABLE);
    eval 'sub I915_SH_SV_CLOCK_GATE_DISABLE () {(1<< 7);}' unless defined(&I915_SH_SV_CLOCK_GATE_DISABLE);
    eval 'sub I915_PL_DG_QC_FT_CLOCK_GATE_DISABLE () {(1<< 6);}' unless defined(&I915_PL_DG_QC_FT_CLOCK_GATE_DISABLE);
    eval 'sub I915_SC_CLOCK_GATE_DISABLE () {(1<< 5);}' unless defined(&I915_SC_CLOCK_GATE_DISABLE);
    eval 'sub I915_FL_CLOCK_GATE_DISABLE () {(1<< 4);}' unless defined(&I915_FL_CLOCK_GATE_DISABLE);
    eval 'sub I915_DM_CLOCK_GATE_DISABLE () {(1<< 3);}' unless defined(&I915_DM_CLOCK_GATE_DISABLE);
    eval 'sub I915_PS_CLOCK_GATE_DISABLE () {(1<< 2);}' unless defined(&I915_PS_CLOCK_GATE_DISABLE);
    eval 'sub I915_CC_CLOCK_GATE_DISABLE () {(1<< 1);}' unless defined(&I915_CC_CLOCK_GATE_DISABLE);
    eval 'sub I915_BY_CLOCK_GATE_DISABLE () {(1<< 0);}' unless defined(&I915_BY_CLOCK_GATE_DISABLE);
    eval 'sub I965_RCZ_CLOCK_GATE_DISABLE () {(1<< 30);}' unless defined(&I965_RCZ_CLOCK_GATE_DISABLE);
    eval 'sub I965_RCC_CLOCK_GATE_DISABLE () {(1<< 29);}' unless defined(&I965_RCC_CLOCK_GATE_DISABLE);
    eval 'sub I965_RCPB_CLOCK_GATE_DISABLE () {(1<< 28);}' unless defined(&I965_RCPB_CLOCK_GATE_DISABLE);
    eval 'sub I965_DAP_CLOCK_GATE_DISABLE () {(1<< 27);}' unless defined(&I965_DAP_CLOCK_GATE_DISABLE);
    eval 'sub I965_ROC_CLOCK_GATE_DISABLE () {(1<< 26);}' unless defined(&I965_ROC_CLOCK_GATE_DISABLE);
    eval 'sub I965_GW_CLOCK_GATE_DISABLE () {(1<< 25);}' unless defined(&I965_GW_CLOCK_GATE_DISABLE);
    eval 'sub I965_TD_CLOCK_GATE_DISABLE () {(1<< 24);}' unless defined(&I965_TD_CLOCK_GATE_DISABLE);
    eval 'sub I965_ISC_CLOCK_GATE_DISABLE () {(1<< 23);}' unless defined(&I965_ISC_CLOCK_GATE_DISABLE);
    eval 'sub I965_IC_CLOCK_GATE_DISABLE () {(1<< 22);}' unless defined(&I965_IC_CLOCK_GATE_DISABLE);
    eval 'sub I965_EU_CLOCK_GATE_DISABLE () {(1<< 21);}' unless defined(&I965_EU_CLOCK_GATE_DISABLE);
    eval 'sub I965_IF_CLOCK_GATE_DISABLE () {(1<< 20);}' unless defined(&I965_IF_CLOCK_GATE_DISABLE);
    eval 'sub I965_TC_CLOCK_GATE_DISABLE () {(1<< 19);}' unless defined(&I965_TC_CLOCK_GATE_DISABLE);
    eval 'sub I965_SO_CLOCK_GATE_DISABLE () {(1<< 17);}' unless defined(&I965_SO_CLOCK_GATE_DISABLE);
    eval 'sub I965_FBC_CLOCK_GATE_DISABLE () {(1<< 16);}' unless defined(&I965_FBC_CLOCK_GATE_DISABLE);
    eval 'sub I965_MARI_CLOCK_GATE_DISABLE () {(1<< 15);}' unless defined(&I965_MARI_CLOCK_GATE_DISABLE);
    eval 'sub I965_MASF_CLOCK_GATE_DISABLE () {(1<< 14);}' unless defined(&I965_MASF_CLOCK_GATE_DISABLE);
    eval 'sub I965_MAWB_CLOCK_GATE_DISABLE () {(1<< 13);}' unless defined(&I965_MAWB_CLOCK_GATE_DISABLE);
    eval 'sub I965_EM_CLOCK_GATE_DISABLE () {(1<< 12);}' unless defined(&I965_EM_CLOCK_GATE_DISABLE);
    eval 'sub I965_UC_CLOCK_GATE_DISABLE () {(1<< 11);}' unless defined(&I965_UC_CLOCK_GATE_DISABLE);
    eval 'sub I965_SI_CLOCK_GATE_DISABLE () {(1<< 6);}' unless defined(&I965_SI_CLOCK_GATE_DISABLE);
    eval 'sub I965_MT_CLOCK_GATE_DISABLE () {(1<< 5);}' unless defined(&I965_MT_CLOCK_GATE_DISABLE);
    eval 'sub I965_PL_CLOCK_GATE_DISABLE () {(1<< 4);}' unless defined(&I965_PL_CLOCK_GATE_DISABLE);
    eval 'sub I965_DG_CLOCK_GATE_DISABLE () {(1<< 3);}' unless defined(&I965_DG_CLOCK_GATE_DISABLE);
    eval 'sub I965_QC_CLOCK_GATE_DISABLE () {(1<< 2);}' unless defined(&I965_QC_CLOCK_GATE_DISABLE);
    eval 'sub I965_FT_CLOCK_GATE_DISABLE () {(1<< 1);}' unless defined(&I965_FT_CLOCK_GATE_DISABLE);
    eval 'sub I965_DM_CLOCK_GATE_DISABLE () {(1<< 0);}' unless defined(&I965_DM_CLOCK_GATE_DISABLE);
    eval 'sub RENCLK_GATE_D2 () {0x6208;}' unless defined(&RENCLK_GATE_D2);
    eval 'sub VF_UNIT_CLOCK_GATE_DISABLE () {(1<< 9);}' unless defined(&VF_UNIT_CLOCK_GATE_DISABLE);
    eval 'sub GS_UNIT_CLOCK_GATE_DISABLE () {(1<< 7);}' unless defined(&GS_UNIT_CLOCK_GATE_DISABLE);
    eval 'sub CL_UNIT_CLOCK_GATE_DISABLE () {(1<< 6);}' unless defined(&CL_UNIT_CLOCK_GATE_DISABLE);
    eval 'sub RAMCLK_GATE_D () {0x6210;}' unless defined(&RAMCLK_GATE_D);
    eval 'sub DEUC () {0x6214;}' unless defined(&DEUC);
    eval 'sub PALETTE_A () {0xa000;}' unless defined(&PALETTE_A);
    eval 'sub PALETTE_B () {0xa800;}' unless defined(&PALETTE_B);
    eval 'sub MCHBAR_MIRROR_BASE () {0x10000;}' unless defined(&MCHBAR_MIRROR_BASE);
    eval 'sub DCC () {0x10200;}' unless defined(&DCC);
    eval 'sub DCC_ADDRESSING_MODE_SINGLE_CHANNEL () {(0<< 0);}' unless defined(&DCC_ADDRESSING_MODE_SINGLE_CHANNEL);
    eval 'sub DCC_ADDRESSING_MODE_DUAL_CHANNEL_ASYMMETRIC () {(1<< 0);}' unless defined(&DCC_ADDRESSING_MODE_DUAL_CHANNEL_ASYMMETRIC);
    eval 'sub DCC_ADDRESSING_MODE_DUAL_CHANNEL_INTERLEAVED () {(2<< 0);}' unless defined(&DCC_ADDRESSING_MODE_DUAL_CHANNEL_INTERLEAVED);
    eval 'sub DCC_ADDRESSING_MODE_MASK () {(3<< 0);}' unless defined(&DCC_ADDRESSING_MODE_MASK);
    eval 'sub DCC_CHANNEL_XOR_DISABLE () {(1<< 10);}' unless defined(&DCC_CHANNEL_XOR_DISABLE);
    eval 'sub DCC_CHANNEL_XOR_BIT_17 () {(1<< 9);}' unless defined(&DCC_CHANNEL_XOR_BIT_17);
    eval 'sub C0DRB3 () {0x10206;}' unless defined(&C0DRB3);
    eval 'sub C1DRB3 () {0x10606;}' unless defined(&C1DRB3);
    eval 'sub CLKCFG () {0x10c00;}' unless defined(&CLKCFG);
    eval 'sub CLKCFG_FSB_400 () {(5<< 0);}' unless defined(&CLKCFG_FSB_400);
    eval 'sub CLKCFG_FSB_533 () {(1<< 0);}' unless defined(&CLKCFG_FSB_533);
    eval 'sub CLKCFG_FSB_667 () {(3<< 0);}' unless defined(&CLKCFG_FSB_667);
    eval 'sub CLKCFG_FSB_800 () {(2<< 0);}' unless defined(&CLKCFG_FSB_800);
    eval 'sub CLKCFG_FSB_1067 () {(6<< 0);}' unless defined(&CLKCFG_FSB_1067);
    eval 'sub CLKCFG_FSB_1333 () {(7<< 0);}' unless defined(&CLKCFG_FSB_1333);
    eval 'sub CLKCFG_FSB_1600 () {(4<< 0);}' unless defined(&CLKCFG_FSB_1600);
    eval 'sub CLKCFG_FSB_1600_ALT () {(0<< 0);}' unless defined(&CLKCFG_FSB_1600_ALT);
    eval 'sub CLKCFG_FSB_MASK () {(7<< 0);}' unless defined(&CLKCFG_FSB_MASK);
    eval 'sub CLKCFG_MEM_533 () {(1<< 4);}' unless defined(&CLKCFG_MEM_533);
    eval 'sub CLKCFG_MEM_667 () {(2<< 4);}' unless defined(&CLKCFG_MEM_667);
    eval 'sub CLKCFG_MEM_800 () {(3<< 4);}' unless defined(&CLKCFG_MEM_800);
    eval 'sub CLKCFG_MEM_MASK () {(7<< 4);}' unless defined(&CLKCFG_MEM_MASK);
    eval 'sub MCHBAR_RENDER_STANDBY () {0x111b8;}' unless defined(&MCHBAR_RENDER_STANDBY);
    eval 'sub PEG_BAND_GAP_DATA () {0x14d68;}' unless defined(&PEG_BAND_GAP_DATA);
    eval 'sub OVADD () {0x30000;}' unless defined(&OVADD);
    eval 'sub DOVSTA () {0x30008;}' unless defined(&DOVSTA);
    eval 'sub OC_BUF () {(0x3<<20);}' unless defined(&OC_BUF);
    eval 'sub OGAMC5 () {0x30010;}' unless defined(&OGAMC5);
    eval 'sub OGAMC4 () {0x30014;}' unless defined(&OGAMC4);
    eval 'sub OGAMC3 () {0x30018;}' unless defined(&OGAMC3);
    eval 'sub OGAMC2 () {0x3001c;}' unless defined(&OGAMC2);
    eval 'sub OGAMC1 () {0x30020;}' unless defined(&OGAMC1);
    eval 'sub OGAMC0 () {0x30024;}' unless defined(&OGAMC0);
    eval 'sub HTOTAL_A () {0x60000;}' unless defined(&HTOTAL_A);
    eval 'sub HBLANK_A () {0x60004;}' unless defined(&HBLANK_A);
    eval 'sub HSYNC_A () {0x60008;}' unless defined(&HSYNC_A);
    eval 'sub VTOTAL_A () {0x6000c;}' unless defined(&VTOTAL_A);
    eval 'sub VBLANK_A () {0x60010;}' unless defined(&VBLANK_A);
    eval 'sub VSYNC_A () {0x60014;}' unless defined(&VSYNC_A);
    eval 'sub PIPEASRC () {0x6001c;}' unless defined(&PIPEASRC);
    eval 'sub BCLRPAT_A () {0x60020;}' unless defined(&BCLRPAT_A);
    eval 'sub HTOTAL_B () {0x61000;}' unless defined(&HTOTAL_B);
    eval 'sub HBLANK_B () {0x61004;}' unless defined(&HBLANK_B);
    eval 'sub HSYNC_B () {0x61008;}' unless defined(&HSYNC_B);
    eval 'sub VTOTAL_B () {0x6100c;}' unless defined(&VTOTAL_B);
    eval 'sub VBLANK_B () {0x61010;}' unless defined(&VBLANK_B);
    eval 'sub VSYNC_B () {0x61014;}' unless defined(&VSYNC_B);
    eval 'sub PIPEBSRC () {0x6101c;}' unless defined(&PIPEBSRC);
    eval 'sub BCLRPAT_B () {0x61020;}' unless defined(&BCLRPAT_B);
    eval 'sub ADPA () {0x61100;}' unless defined(&ADPA);
    eval 'sub ADPA_DAC_ENABLE () {(1<<31);}' unless defined(&ADPA_DAC_ENABLE);
    eval 'sub ADPA_DAC_DISABLE () {0;}' unless defined(&ADPA_DAC_DISABLE);
    eval 'sub ADPA_PIPE_SELECT_MASK () {(1<<30);}' unless defined(&ADPA_PIPE_SELECT_MASK);
    eval 'sub ADPA_PIPE_A_SELECT () {0;}' unless defined(&ADPA_PIPE_A_SELECT);
    eval 'sub ADPA_PIPE_B_SELECT () {(1<<30);}' unless defined(&ADPA_PIPE_B_SELECT);
    eval 'sub ADPA_USE_VGA_HVPOLARITY () {(1<<15);}' unless defined(&ADPA_USE_VGA_HVPOLARITY);
    eval 'sub ADPA_SETS_HVPOLARITY () {0;}' unless defined(&ADPA_SETS_HVPOLARITY);
    eval 'sub ADPA_VSYNC_CNTL_DISABLE () {(1<<11);}' unless defined(&ADPA_VSYNC_CNTL_DISABLE);
    eval 'sub ADPA_VSYNC_CNTL_ENABLE () {0;}' unless defined(&ADPA_VSYNC_CNTL_ENABLE);
    eval 'sub ADPA_HSYNC_CNTL_DISABLE () {(1<<10);}' unless defined(&ADPA_HSYNC_CNTL_DISABLE);
    eval 'sub ADPA_HSYNC_CNTL_ENABLE () {0;}' unless defined(&ADPA_HSYNC_CNTL_ENABLE);
    eval 'sub ADPA_VSYNC_ACTIVE_HIGH () {(1<<4);}' unless defined(&ADPA_VSYNC_ACTIVE_HIGH);
    eval 'sub ADPA_VSYNC_ACTIVE_LOW () {0;}' unless defined(&ADPA_VSYNC_ACTIVE_LOW);
    eval 'sub ADPA_HSYNC_ACTIVE_HIGH () {(1<<3);}' unless defined(&ADPA_HSYNC_ACTIVE_HIGH);
    eval 'sub ADPA_HSYNC_ACTIVE_LOW () {0;}' unless defined(&ADPA_HSYNC_ACTIVE_LOW);
    eval 'sub ADPA_DPMS_MASK () {(~(3<<10));}' unless defined(&ADPA_DPMS_MASK);
    eval 'sub ADPA_DPMS_ON () {(0<<10);}' unless defined(&ADPA_DPMS_ON);
    eval 'sub ADPA_DPMS_SUSPEND () {(1<<10);}' unless defined(&ADPA_DPMS_SUSPEND);
    eval 'sub ADPA_DPMS_STANDBY () {(2<<10);}' unless defined(&ADPA_DPMS_STANDBY);
    eval 'sub ADPA_DPMS_OFF () {(3<<10);}' unless defined(&ADPA_DPMS_OFF);
    eval 'sub PORT_HOTPLUG_EN () {0x61110;}' unless defined(&PORT_HOTPLUG_EN);
    eval 'sub SDVOB_HOTPLUG_INT_EN () {(1<< 26);}' unless defined(&SDVOB_HOTPLUG_INT_EN);
    eval 'sub SDVOC_HOTPLUG_INT_EN () {(1<< 25);}' unless defined(&SDVOC_HOTPLUG_INT_EN);
    eval 'sub TV_HOTPLUG_INT_EN () {(1<< 18);}' unless defined(&TV_HOTPLUG_INT_EN);
    eval 'sub CRT_HOTPLUG_INT_EN () {(1<< 9);}' unless defined(&CRT_HOTPLUG_INT_EN);
    eval 'sub CRT_HOTPLUG_FORCE_DETECT () {(1<< 3);}' unless defined(&CRT_HOTPLUG_FORCE_DETECT);
    eval 'sub PORT_HOTPLUG_STAT () {0x61114;}' unless defined(&PORT_HOTPLUG_STAT);
    eval 'sub CRT_HOTPLUG_INT_STATUS () {(1<< 11);}' unless defined(&CRT_HOTPLUG_INT_STATUS);
    eval 'sub TV_HOTPLUG_INT_STATUS () {(1<< 10);}' unless defined(&TV_HOTPLUG_INT_STATUS);
    eval 'sub CRT_HOTPLUG_MONITOR_MASK () {(3<< 8);}' unless defined(&CRT_HOTPLUG_MONITOR_MASK);
    eval 'sub CRT_HOTPLUG_MONITOR_COLOR () {(3<< 8);}' unless defined(&CRT_HOTPLUG_MONITOR_COLOR);
    eval 'sub CRT_HOTPLUG_MONITOR_MONO () {(2<< 8);}' unless defined(&CRT_HOTPLUG_MONITOR_MONO);
    eval 'sub CRT_HOTPLUG_MONITOR_NONE () {(0<< 8);}' unless defined(&CRT_HOTPLUG_MONITOR_NONE);
    eval 'sub SDVOC_HOTPLUG_INT_STATUS () {(1<< 7);}' unless defined(&SDVOC_HOTPLUG_INT_STATUS);
    eval 'sub SDVOB_HOTPLUG_INT_STATUS () {(1<< 6);}' unless defined(&SDVOB_HOTPLUG_INT_STATUS);
    eval 'sub SDVOB () {0x61140;}' unless defined(&SDVOB);
    eval 'sub SDVOC () {0x61160;}' unless defined(&SDVOC);
    eval 'sub SDVO_ENABLE () {(1<< 31);}' unless defined(&SDVO_ENABLE);
    eval 'sub SDVO_PIPE_B_SELECT () {(1<< 30);}' unless defined(&SDVO_PIPE_B_SELECT);
    eval 'sub SDVO_STALL_SELECT () {(1<< 29);}' unless defined(&SDVO_STALL_SELECT);
    eval 'sub SDVO_INTERRUPT_ENABLE () {(1<< 26);}' unless defined(&SDVO_INTERRUPT_ENABLE);
    eval 'sub SDVO_PORT_MULTIPLY_MASK () {(7<< 23);}' unless defined(&SDVO_PORT_MULTIPLY_MASK);
    eval 'sub SDVO_PORT_MULTIPLY_SHIFT () {23;}' unless defined(&SDVO_PORT_MULTIPLY_SHIFT);
    eval 'sub SDVO_PHASE_SELECT_MASK () {(15<< 19);}' unless defined(&SDVO_PHASE_SELECT_MASK);
    eval 'sub SDVO_PHASE_SELECT_DEFAULT () {(6<< 19);}' unless defined(&SDVO_PHASE_SELECT_DEFAULT);
    eval 'sub SDVO_CLOCK_OUTPUT_INVERT () {(1<< 18);}' unless defined(&SDVO_CLOCK_OUTPUT_INVERT);
    eval 'sub SDVOC_GANG_MODE () {(1<< 16);}' unless defined(&SDVOC_GANG_MODE);
    eval 'sub SDVO_BORDER_ENABLE () {(1<< 7);}' unless defined(&SDVO_BORDER_ENABLE);
    eval 'sub SDVOB_PCIE_CONCURRENCY () {(1<< 3);}' unless defined(&SDVOB_PCIE_CONCURRENCY);
    eval 'sub SDVO_DETECTED () {(1<< 2);}' unless defined(&SDVO_DETECTED);
    eval 'sub SDVOB_PRESERVE_MASK () {((1<< 17) | (1<< 16) | (1<< 14) | (1<< 26));}' unless defined(&SDVOB_PRESERVE_MASK);
    eval 'sub SDVOC_PRESERVE_MASK () {((1<< 17) | (1<< 26));}' unless defined(&SDVOC_PRESERVE_MASK);
    eval 'sub DVOA () {0x61120;}' unless defined(&DVOA);
    eval 'sub DVOB () {0x61140;}' unless defined(&DVOB);
    eval 'sub DVOC () {0x61160;}' unless defined(&DVOC);
    eval 'sub DVO_ENABLE () {(1<< 31);}' unless defined(&DVO_ENABLE);
    eval 'sub DVO_PIPE_B_SELECT () {(1<< 30);}' unless defined(&DVO_PIPE_B_SELECT);
    eval 'sub DVO_PIPE_STALL_UNUSED () {(0<< 28);}' unless defined(&DVO_PIPE_STALL_UNUSED);
    eval 'sub DVO_PIPE_STALL () {(1<< 28);}' unless defined(&DVO_PIPE_STALL);
    eval 'sub DVO_PIPE_STALL_TV () {(2<< 28);}' unless defined(&DVO_PIPE_STALL_TV);
    eval 'sub DVO_PIPE_STALL_MASK () {(3<< 28);}' unless defined(&DVO_PIPE_STALL_MASK);
    eval 'sub DVO_USE_VGA_SYNC () {(1<< 15);}' unless defined(&DVO_USE_VGA_SYNC);
    eval 'sub DVO_DATA_ORDER_I740 () {(0<< 14);}' unless defined(&DVO_DATA_ORDER_I740);
    eval 'sub DVO_DATA_ORDER_FP () {(1<< 14);}' unless defined(&DVO_DATA_ORDER_FP);
    eval 'sub DVO_VSYNC_DISABLE () {(1<< 11);}' unless defined(&DVO_VSYNC_DISABLE);
    eval 'sub DVO_HSYNC_DISABLE () {(1<< 10);}' unless defined(&DVO_HSYNC_DISABLE);
    eval 'sub DVO_VSYNC_TRISTATE () {(1<< 9);}' unless defined(&DVO_VSYNC_TRISTATE);
    eval 'sub DVO_HSYNC_TRISTATE () {(1<< 8);}' unless defined(&DVO_HSYNC_TRISTATE);
    eval 'sub DVO_BORDER_ENABLE () {(1<< 7);}' unless defined(&DVO_BORDER_ENABLE);
    eval 'sub DVO_DATA_ORDER_GBRG () {(1<< 6);}' unless defined(&DVO_DATA_ORDER_GBRG);
    eval 'sub DVO_DATA_ORDER_RGGB () {(0<< 6);}' unless defined(&DVO_DATA_ORDER_RGGB);
    eval 'sub DVO_DATA_ORDER_GBRG_ERRATA () {(0<< 6);}' unless defined(&DVO_DATA_ORDER_GBRG_ERRATA);
    eval 'sub DVO_DATA_ORDER_RGGB_ERRATA () {(1<< 6);}' unless defined(&DVO_DATA_ORDER_RGGB_ERRATA);
    eval 'sub DVO_VSYNC_ACTIVE_HIGH () {(1<< 4);}' unless defined(&DVO_VSYNC_ACTIVE_HIGH);
    eval 'sub DVO_HSYNC_ACTIVE_HIGH () {(1<< 3);}' unless defined(&DVO_HSYNC_ACTIVE_HIGH);
    eval 'sub DVO_BLANK_ACTIVE_HIGH () {(1<< 2);}' unless defined(&DVO_BLANK_ACTIVE_HIGH);
    eval 'sub DVO_OUTPUT_CSTATE_PIXELS () {(1<< 1);}' unless defined(&DVO_OUTPUT_CSTATE_PIXELS);
    eval 'sub DVO_OUTPUT_SOURCE_SIZE_PIXELS () {(1<< 0);}' unless defined(&DVO_OUTPUT_SOURCE_SIZE_PIXELS);
    eval 'sub DVO_PRESERVE_MASK () {(0x7<<24);}' unless defined(&DVO_PRESERVE_MASK);
    eval 'sub DVOA_SRCDIM () {0x61124;}' unless defined(&DVOA_SRCDIM);
    eval 'sub DVOB_SRCDIM () {0x61144;}' unless defined(&DVOB_SRCDIM);
    eval 'sub DVOC_SRCDIM () {0x61164;}' unless defined(&DVOC_SRCDIM);
    eval 'sub DVO_SRCDIM_HORIZONTAL_SHIFT () {12;}' unless defined(&DVO_SRCDIM_HORIZONTAL_SHIFT);
    eval 'sub DVO_SRCDIM_VERTICAL_SHIFT () {0;}' unless defined(&DVO_SRCDIM_VERTICAL_SHIFT);
    eval 'sub LVDS () {0x61180;}' unless defined(&LVDS);
    eval 'sub LVDS_PORT_EN () {(1<< 31);}' unless defined(&LVDS_PORT_EN);
    eval 'sub LVDS_PIPEB_SELECT () {(1<< 30);}' unless defined(&LVDS_PIPEB_SELECT);
    eval 'sub LVDS_A0A2_CLKA_POWER_MASK () {(3<< 8);}' unless defined(&LVDS_A0A2_CLKA_POWER_MASK);
    eval 'sub LVDS_A0A2_CLKA_POWER_DOWN () {(0<< 8);}' unless defined(&LVDS_A0A2_CLKA_POWER_DOWN);
    eval 'sub LVDS_A0A2_CLKA_POWER_UP () {(3<< 8);}' unless defined(&LVDS_A0A2_CLKA_POWER_UP);
    eval 'sub LVDS_A3_POWER_MASK () {(3<< 6);}' unless defined(&LVDS_A3_POWER_MASK);
    eval 'sub LVDS_A3_POWER_DOWN () {(0<< 6);}' unless defined(&LVDS_A3_POWER_DOWN);
    eval 'sub LVDS_A3_POWER_UP () {(3<< 6);}' unless defined(&LVDS_A3_POWER_UP);
    eval 'sub LVDS_CLKB_POWER_MASK () {(3<< 4);}' unless defined(&LVDS_CLKB_POWER_MASK);
    eval 'sub LVDS_CLKB_POWER_DOWN () {(0<< 4);}' unless defined(&LVDS_CLKB_POWER_DOWN);
    eval 'sub LVDS_CLKB_POWER_UP () {(3<< 4);}' unless defined(&LVDS_CLKB_POWER_UP);
    eval 'sub LVDS_B0B3_POWER_MASK () {(3<< 2);}' unless defined(&LVDS_B0B3_POWER_MASK);
    eval 'sub LVDS_B0B3_POWER_DOWN () {(0<< 2);}' unless defined(&LVDS_B0B3_POWER_DOWN);
    eval 'sub LVDS_B0B3_POWER_UP () {(3<< 2);}' unless defined(&LVDS_B0B3_POWER_UP);
    eval 'sub PP_STATUS () {0x61200;}' unless defined(&PP_STATUS);
    eval 'sub PP_ON () {(1<< 31);}' unless defined(&PP_ON);
    eval 'sub PP_READY () {(1<< 30);}' unless defined(&PP_READY);
    eval 'sub PP_SEQUENCE_NONE () {(0<< 28);}' unless defined(&PP_SEQUENCE_NONE);
    eval 'sub PP_SEQUENCE_ON () {(1<< 28);}' unless defined(&PP_SEQUENCE_ON);
    eval 'sub PP_SEQUENCE_OFF () {(2<< 28);}' unless defined(&PP_SEQUENCE_OFF);
    eval 'sub PP_SEQUENCE_MASK () {0x30000000;}' unless defined(&PP_SEQUENCE_MASK);
    eval 'sub PP_CONTROL () {0x61204;}' unless defined(&PP_CONTROL);
    eval 'sub POWER_TARGET_ON () {(1<< 0);}' unless defined(&POWER_TARGET_ON);
    eval 'sub PP_ON_DELAYS () {0x61208;}' unless defined(&PP_ON_DELAYS);
    eval 'sub PP_OFF_DELAYS () {0x6120c;}' unless defined(&PP_OFF_DELAYS);
    eval 'sub PP_DIVISOR () {0x61210;}' unless defined(&PP_DIVISOR);
    eval 'sub PFIT_CONTROL () {0x61230;}' unless defined(&PFIT_CONTROL);
    eval 'sub PFIT_ENABLE () {(1<< 31);}' unless defined(&PFIT_ENABLE);
    eval 'sub PFIT_PIPE_MASK () {(3<< 29);}' unless defined(&PFIT_PIPE_MASK);
    eval 'sub PFIT_PIPE_SHIFT () {29;}' unless defined(&PFIT_PIPE_SHIFT);
    eval 'sub VERT_INTERP_DISABLE () {(0<< 10);}' unless defined(&VERT_INTERP_DISABLE);
    eval 'sub VERT_INTERP_BILINEAR () {(1<< 10);}' unless defined(&VERT_INTERP_BILINEAR);
    eval 'sub VERT_INTERP_MASK () {(3<< 10);}' unless defined(&VERT_INTERP_MASK);
    eval 'sub VERT_AUTO_SCALE () {(1<< 9);}' unless defined(&VERT_AUTO_SCALE);
    eval 'sub HORIZ_INTERP_DISABLE () {(0<< 6);}' unless defined(&HORIZ_INTERP_DISABLE);
    eval 'sub HORIZ_INTERP_BILINEAR () {(1<< 6);}' unless defined(&HORIZ_INTERP_BILINEAR);
    eval 'sub HORIZ_INTERP_MASK () {(3<< 6);}' unless defined(&HORIZ_INTERP_MASK);
    eval 'sub HORIZ_AUTO_SCALE () {(1<< 5);}' unless defined(&HORIZ_AUTO_SCALE);
    eval 'sub PANEL_8TO6_DITHER_ENABLE () {(1<< 3);}' unless defined(&PANEL_8TO6_DITHER_ENABLE);
    eval 'sub PFIT_PGM_RATIOS () {0x61234;}' unless defined(&PFIT_PGM_RATIOS);
    eval 'sub PFIT_VERT_SCALE_MASK () {0xfff00000;}' unless defined(&PFIT_VERT_SCALE_MASK);
    eval 'sub PFIT_HORIZ_SCALE_MASK () {0xfff0;}' unless defined(&PFIT_HORIZ_SCALE_MASK);
    eval 'sub PFIT_AUTO_RATIOS () {0x61238;}' unless defined(&PFIT_AUTO_RATIOS);
    eval 'sub BLC_PWM_CTL () {0x61254;}' unless defined(&BLC_PWM_CTL);
    eval 'sub BACKLIGHT_MODULATION_FREQ_SHIFT () {(17);}' unless defined(&BACKLIGHT_MODULATION_FREQ_SHIFT);
    eval 'sub BLC_PWM_CTL2 () {0x61250;}' unless defined(&BLC_PWM_CTL2);
    eval 'sub BACKLIGHT_MODULATION_FREQ_MASK () {(0x7fff << 17);}' unless defined(&BACKLIGHT_MODULATION_FREQ_MASK);
    eval 'sub BLM_LEGACY_MODE () {(1<< 16);}' unless defined(&BLM_LEGACY_MODE);
    eval 'sub BACKLIGHT_DUTY_CYCLE_SHIFT () {(0);}' unless defined(&BACKLIGHT_DUTY_CYCLE_SHIFT);
    eval 'sub BACKLIGHT_DUTY_CYCLE_MASK () {(0xffff);}' unless defined(&BACKLIGHT_DUTY_CYCLE_MASK);
    eval 'sub BLC_HIST_CTL () {0x61260;}' unless defined(&BLC_HIST_CTL);
    eval 'sub TV_CTL () {0x68000;}' unless defined(&TV_CTL);
    eval 'sub TV_ENC_ENABLE () {(1<< 31);}' unless defined(&TV_ENC_ENABLE);
    eval 'sub TV_ENC_PIPEB_SELECT () {(1<< 30);}' unless defined(&TV_ENC_PIPEB_SELECT);
    eval 'sub TV_ENC_OUTPUT_COMPOSITE () {(0<< 28);}' unless defined(&TV_ENC_OUTPUT_COMPOSITE);
    eval 'sub TV_ENC_OUTPUT_SVIDEO () {(1<< 28);}' unless defined(&TV_ENC_OUTPUT_SVIDEO);
    eval 'sub TV_ENC_OUTPUT_COMPONENT () {(2<< 28);}' unless defined(&TV_ENC_OUTPUT_COMPONENT);
    eval 'sub TV_ENC_OUTPUT_SVIDEO_COMPOSITE () {(3<< 28);}' unless defined(&TV_ENC_OUTPUT_SVIDEO_COMPOSITE);
    eval 'sub TV_TRILEVEL_SYNC () {(1<< 21);}' unless defined(&TV_TRILEVEL_SYNC);
    eval 'sub TV_SLOW_SYNC () {(1<< 20);}' unless defined(&TV_SLOW_SYNC);
    eval 'sub TV_OVERSAMPLE_4X () {(0<< 18);}' unless defined(&TV_OVERSAMPLE_4X);
    eval 'sub TV_OVERSAMPLE_2X () {(1<< 18);}' unless defined(&TV_OVERSAMPLE_2X);
    eval 'sub TV_OVERSAMPLE_NONE () {(2<< 18);}' unless defined(&TV_OVERSAMPLE_NONE);
    eval 'sub TV_OVERSAMPLE_8X () {(3<< 18);}' unless defined(&TV_OVERSAMPLE_8X);
    eval 'sub TV_PROGRESSIVE () {(1<< 17);}' unless defined(&TV_PROGRESSIVE);
    eval 'sub TV_PAL_BURST () {(1<< 16);}' unless defined(&TV_PAL_BURST);
    eval 'sub TV_YC_SKEW_MASK () {(7<< 12);}' unless defined(&TV_YC_SKEW_MASK);
    eval 'sub TV_ENC_SDP_FIX () {(1<< 11);}' unless defined(&TV_ENC_SDP_FIX);
    eval 'sub TV_ENC_C0_FIX () {(1<< 10);}' unless defined(&TV_ENC_C0_FIX);
    eval 'sub TV_CTL_SAVE () {((3<< 8) | (3<< 6));}' unless defined(&TV_CTL_SAVE);
    eval 'sub TV_FUSE_STATE_MASK () {(3<< 4);}' unless defined(&TV_FUSE_STATE_MASK);
    eval 'sub TV_FUSE_STATE_ENABLED () {(0<< 4);}' unless defined(&TV_FUSE_STATE_ENABLED);
    eval 'sub TV_FUSE_STATE_NO_MACROVISION () {(1<< 4);}' unless defined(&TV_FUSE_STATE_NO_MACROVISION);
    eval 'sub TV_FUSE_STATE_DISABLED () {(2<< 4);}' unless defined(&TV_FUSE_STATE_DISABLED);
    eval 'sub TV_TEST_MODE_NORMAL () {(0<< 0);}' unless defined(&TV_TEST_MODE_NORMAL);
    eval 'sub TV_TEST_MODE_PATTERN_1 () {(1<< 0);}' unless defined(&TV_TEST_MODE_PATTERN_1);
    eval 'sub TV_TEST_MODE_PATTERN_2 () {(2<< 0);}' unless defined(&TV_TEST_MODE_PATTERN_2);
    eval 'sub TV_TEST_MODE_PATTERN_3 () {(3<< 0);}' unless defined(&TV_TEST_MODE_PATTERN_3);
    eval 'sub TV_TEST_MODE_PATTERN_4 () {(4<< 0);}' unless defined(&TV_TEST_MODE_PATTERN_4);
    eval 'sub TV_TEST_MODE_PATTERN_5 () {(5<< 0);}' unless defined(&TV_TEST_MODE_PATTERN_5);
    eval 'sub TV_TEST_MODE_MONITOR_DETECT () {(7<< 0);}' unless defined(&TV_TEST_MODE_MONITOR_DETECT);
    eval 'sub TV_TEST_MODE_MASK () {(7<< 0);}' unless defined(&TV_TEST_MODE_MASK);
    eval 'sub TV_DAC () {0x68004;}' unless defined(&TV_DAC);
    eval 'sub TVDAC_STATE_CHG () {(1<< 31);}' unless defined(&TVDAC_STATE_CHG);
    eval 'sub TVDAC_SENSE_MASK () {(7<< 28);}' unless defined(&TVDAC_SENSE_MASK);
    eval 'sub TVDAC_A_SENSE () {(1<< 30);}' unless defined(&TVDAC_A_SENSE);
    eval 'sub TVDAC_B_SENSE () {(1<< 29);}' unless defined(&TVDAC_B_SENSE);
    eval 'sub TVDAC_C_SENSE () {(1<< 28);}' unless defined(&TVDAC_C_SENSE);
    eval 'sub TVDAC_STATE_CHG_EN () {(1<< 27);}' unless defined(&TVDAC_STATE_CHG_EN);
    eval 'sub TVDAC_A_SENSE_CTL () {(1<< 26);}' unless defined(&TVDAC_A_SENSE_CTL);
    eval 'sub TVDAC_B_SENSE_CTL () {(1<< 25);}' unless defined(&TVDAC_B_SENSE_CTL);
    eval 'sub TVDAC_C_SENSE_CTL () {(1<< 24);}' unless defined(&TVDAC_C_SENSE_CTL);
    eval 'sub DAC_CTL_OVERRIDE () {(1<< 7);}' unless defined(&DAC_CTL_OVERRIDE);
    eval 'sub ENC_TVDAC_SLEW_FAST () {(1<< 6);}' unless defined(&ENC_TVDAC_SLEW_FAST);
    eval 'sub DAC_A_1_3_V () {(0<< 4);}' unless defined(&DAC_A_1_3_V);
    eval 'sub DAC_A_1_1_V () {(1<< 4);}' unless defined(&DAC_A_1_1_V);
    eval 'sub DAC_A_0_7_V () {(2<< 4);}' unless defined(&DAC_A_0_7_V);
    eval 'sub DAC_A_OFF () {(3<< 4);}' unless defined(&DAC_A_OFF);
    eval 'sub DAC_B_1_3_V () {(0<< 2);}' unless defined(&DAC_B_1_3_V);
    eval 'sub DAC_B_1_1_V () {(1<< 2);}' unless defined(&DAC_B_1_1_V);
    eval 'sub DAC_B_0_7_V () {(2<< 2);}' unless defined(&DAC_B_0_7_V);
    eval 'sub DAC_B_OFF () {(3<< 2);}' unless defined(&DAC_B_OFF);
    eval 'sub DAC_C_1_3_V () {(0<< 0);}' unless defined(&DAC_C_1_3_V);
    eval 'sub DAC_C_1_1_V () {(1<< 0);}' unless defined(&DAC_C_1_1_V);
    eval 'sub DAC_C_0_7_V () {(2<< 0);}' unless defined(&DAC_C_0_7_V);
    eval 'sub DAC_C_OFF () {(3<< 0);}' unless defined(&DAC_C_OFF);
    eval 'sub TV_CSC_Y () {0x68010;}' unless defined(&TV_CSC_Y);
    eval 'sub TV_RY_MASK () {0x7ff0000;}' unless defined(&TV_RY_MASK);
    eval 'sub TV_RY_SHIFT () {16;}' unless defined(&TV_RY_SHIFT);
    eval 'sub TV_GY_MASK () {0xfff;}' unless defined(&TV_GY_MASK);
    eval 'sub TV_GY_SHIFT () {0;}' unless defined(&TV_GY_SHIFT);
    eval 'sub TV_CSC_Y2 () {0x68014;}' unless defined(&TV_CSC_Y2);
    eval 'sub TV_BY_MASK () {0x7ff0000;}' unless defined(&TV_BY_MASK);
    eval 'sub TV_BY_SHIFT () {16;}' unless defined(&TV_BY_SHIFT);
    eval 'sub TV_AY_MASK () {0x3ff;}' unless defined(&TV_AY_MASK);
    eval 'sub TV_AY_SHIFT () {0;}' unless defined(&TV_AY_SHIFT);
    eval 'sub TV_CSC_U () {0x68018;}' unless defined(&TV_CSC_U);
    eval 'sub TV_RU_MASK () {0x7ff0000;}' unless defined(&TV_RU_MASK);
    eval 'sub TV_RU_SHIFT () {16;}' unless defined(&TV_RU_SHIFT);
    eval 'sub TV_GU_MASK () {0x7ff;}' unless defined(&TV_GU_MASK);
    eval 'sub TV_GU_SHIFT () {0;}' unless defined(&TV_GU_SHIFT);
    eval 'sub TV_CSC_U2 () {0x6801c;}' unless defined(&TV_CSC_U2);
    eval 'sub TV_BU_MASK () {0x7ff0000;}' unless defined(&TV_BU_MASK);
    eval 'sub TV_BU_SHIFT () {16;}' unless defined(&TV_BU_SHIFT);
    eval 'sub TV_AU_MASK () {0x3ff;}' unless defined(&TV_AU_MASK);
    eval 'sub TV_AU_SHIFT () {0;}' unless defined(&TV_AU_SHIFT);
    eval 'sub TV_CSC_V () {0x68020;}' unless defined(&TV_CSC_V);
    eval 'sub TV_RV_MASK () {0xfff0000;}' unless defined(&TV_RV_MASK);
    eval 'sub TV_RV_SHIFT () {16;}' unless defined(&TV_RV_SHIFT);
    eval 'sub TV_GV_MASK () {0x7ff;}' unless defined(&TV_GV_MASK);
    eval 'sub TV_GV_SHIFT () {0;}' unless defined(&TV_GV_SHIFT);
    eval 'sub TV_CSC_V2 () {0x68024;}' unless defined(&TV_CSC_V2);
    eval 'sub TV_BV_MASK () {0x7ff0000;}' unless defined(&TV_BV_MASK);
    eval 'sub TV_BV_SHIFT () {16;}' unless defined(&TV_BV_SHIFT);
    eval 'sub TV_AV_MASK () {0x7ff;}' unless defined(&TV_AV_MASK);
    eval 'sub TV_AV_SHIFT () {0;}' unless defined(&TV_AV_SHIFT);
    eval 'sub TV_CLR_KNOBS () {0x68028;}' unless defined(&TV_CLR_KNOBS);
    eval 'sub TV_BRIGHTNESS_MASK () {0xff000000;}' unless defined(&TV_BRIGHTNESS_MASK);
    eval 'sub TV_BRIGHTNESS_SHIFT () {24;}' unless defined(&TV_BRIGHTNESS_SHIFT);
    eval 'sub TV_CONTRAST_MASK () {0xff0000;}' unless defined(&TV_CONTRAST_MASK);
    eval 'sub TV_CONTRAST_SHIFT () {16;}' unless defined(&TV_CONTRAST_SHIFT);
    eval 'sub TV_SATURATION_MASK () {0xff00;}' unless defined(&TV_SATURATION_MASK);
    eval 'sub TV_SATURATION_SHIFT () {8;}' unless defined(&TV_SATURATION_SHIFT);
    eval 'sub TV_HUE_MASK () {0xff;}' unless defined(&TV_HUE_MASK);
    eval 'sub TV_HUE_SHIFT () {0;}' unless defined(&TV_HUE_SHIFT);
    eval 'sub TV_CLR_LEVEL () {0x6802c;}' unless defined(&TV_CLR_LEVEL);
    eval 'sub TV_BLACK_LEVEL_MASK () {0x1ff0000;}' unless defined(&TV_BLACK_LEVEL_MASK);
    eval 'sub TV_BLACK_LEVEL_SHIFT () {16;}' unless defined(&TV_BLACK_LEVEL_SHIFT);
    eval 'sub TV_BLANK_LEVEL_MASK () {0x1ff;}' unless defined(&TV_BLANK_LEVEL_MASK);
    eval 'sub TV_BLANK_LEVEL_SHIFT () {0;}' unless defined(&TV_BLANK_LEVEL_SHIFT);
    eval 'sub TV_H_CTL_1 () {0x68030;}' unless defined(&TV_H_CTL_1);
    eval 'sub TV_HSYNC_END_MASK () {0x1fff0000;}' unless defined(&TV_HSYNC_END_MASK);
    eval 'sub TV_HSYNC_END_SHIFT () {16;}' unless defined(&TV_HSYNC_END_SHIFT);
    eval 'sub TV_HTOTAL_MASK () {0x1fff;}' unless defined(&TV_HTOTAL_MASK);
    eval 'sub TV_HTOTAL_SHIFT () {0;}' unless defined(&TV_HTOTAL_SHIFT);
    eval 'sub TV_H_CTL_2 () {0x68034;}' unless defined(&TV_H_CTL_2);
    eval 'sub TV_BURST_ENA () {(1<< 31);}' unless defined(&TV_BURST_ENA);
    eval 'sub TV_HBURST_START_SHIFT () {16;}' unless defined(&TV_HBURST_START_SHIFT);
    eval 'sub TV_HBURST_START_MASK () {0x1fff0000;}' unless defined(&TV_HBURST_START_MASK);
    eval 'sub TV_HBURST_LEN_SHIFT () {0;}' unless defined(&TV_HBURST_LEN_SHIFT);
    eval 'sub TV_HBURST_LEN_MASK () {0x1fff;}' unless defined(&TV_HBURST_LEN_MASK);
    eval 'sub TV_H_CTL_3 () {0x68038;}' unless defined(&TV_H_CTL_3);
    eval 'sub TV_HBLANK_END_SHIFT () {16;}' unless defined(&TV_HBLANK_END_SHIFT);
    eval 'sub TV_HBLANK_END_MASK () {0x1fff0000;}' unless defined(&TV_HBLANK_END_MASK);
    eval 'sub TV_HBLANK_START_SHIFT () {0;}' unless defined(&TV_HBLANK_START_SHIFT);
    eval 'sub TV_HBLANK_START_MASK () {0x1fff;}' unless defined(&TV_HBLANK_START_MASK);
    eval 'sub TV_V_CTL_1 () {0x6803c;}' unless defined(&TV_V_CTL_1);
    eval 'sub TV_NBR_END_SHIFT () {16;}' unless defined(&TV_NBR_END_SHIFT);
    eval 'sub TV_NBR_END_MASK () {0x7ff0000;}' unless defined(&TV_NBR_END_MASK);
    eval 'sub TV_VI_END_F1_SHIFT () {8;}' unless defined(&TV_VI_END_F1_SHIFT);
    eval 'sub TV_VI_END_F1_MASK () {0x3f00;}' unless defined(&TV_VI_END_F1_MASK);
    eval 'sub TV_VI_END_F2_SHIFT () {0;}' unless defined(&TV_VI_END_F2_SHIFT);
    eval 'sub TV_VI_END_F2_MASK () {0x3f;}' unless defined(&TV_VI_END_F2_MASK);
    eval 'sub TV_V_CTL_2 () {0x68040;}' unless defined(&TV_V_CTL_2);
    eval 'sub TV_VSYNC_LEN_MASK () {0x7ff0000;}' unless defined(&TV_VSYNC_LEN_MASK);
    eval 'sub TV_VSYNC_LEN_SHIFT () {16;}' unless defined(&TV_VSYNC_LEN_SHIFT);
    eval 'sub TV_VSYNC_START_F1_MASK () {0x7f00;}' unless defined(&TV_VSYNC_START_F1_MASK);
    eval 'sub TV_VSYNC_START_F1_SHIFT () {8;}' unless defined(&TV_VSYNC_START_F1_SHIFT);
    eval 'sub TV_VSYNC_START_F2_MASK () {0x7f;}' unless defined(&TV_VSYNC_START_F2_MASK);
    eval 'sub TV_VSYNC_START_F2_SHIFT () {0;}' unless defined(&TV_VSYNC_START_F2_SHIFT);
    eval 'sub TV_V_CTL_3 () {0x68044;}' unless defined(&TV_V_CTL_3);
    eval 'sub TV_EQUAL_ENA () {(1<< 31);}' unless defined(&TV_EQUAL_ENA);
    eval 'sub TV_VEQ_LEN_MASK () {0x7f0000;}' unless defined(&TV_VEQ_LEN_MASK);
    eval 'sub TV_VEQ_LEN_SHIFT () {16;}' unless defined(&TV_VEQ_LEN_SHIFT);
    eval 'sub TV_VEQ_START_F1_MASK () {0x7f00;}' unless defined(&TV_VEQ_START_F1_MASK);
    eval 'sub TV_VEQ_START_F1_SHIFT () {8;}' unless defined(&TV_VEQ_START_F1_SHIFT);
    eval 'sub TV_VEQ_START_F2_MASK () {0x7f;}' unless defined(&TV_VEQ_START_F2_MASK);
    eval 'sub TV_VEQ_START_F2_SHIFT () {0;}' unless defined(&TV_VEQ_START_F2_SHIFT);
    eval 'sub TV_V_CTL_4 () {0x68048;}' unless defined(&TV_V_CTL_4);
    eval 'sub TV_VBURST_START_F1_MASK () {0x3f0000;}' unless defined(&TV_VBURST_START_F1_MASK);
    eval 'sub TV_VBURST_START_F1_SHIFT () {16;}' unless defined(&TV_VBURST_START_F1_SHIFT);
    eval 'sub TV_VBURST_END_F1_MASK () {0xff;}' unless defined(&TV_VBURST_END_F1_MASK);
    eval 'sub TV_VBURST_END_F1_SHIFT () {0;}' unless defined(&TV_VBURST_END_F1_SHIFT);
    eval 'sub TV_V_CTL_5 () {0x6804c;}' unless defined(&TV_V_CTL_5);
    eval 'sub TV_VBURST_START_F2_MASK () {0x3f0000;}' unless defined(&TV_VBURST_START_F2_MASK);
    eval 'sub TV_VBURST_START_F2_SHIFT () {16;}' unless defined(&TV_VBURST_START_F2_SHIFT);
    eval 'sub TV_VBURST_END_F2_MASK () {0xff;}' unless defined(&TV_VBURST_END_F2_MASK);
    eval 'sub TV_VBURST_END_F2_SHIFT () {0;}' unless defined(&TV_VBURST_END_F2_SHIFT);
    eval 'sub TV_V_CTL_6 () {0x68050;}' unless defined(&TV_V_CTL_6);
    eval 'sub TV_VBURST_START_F3_MASK () {0x3f0000;}' unless defined(&TV_VBURST_START_F3_MASK);
    eval 'sub TV_VBURST_START_F3_SHIFT () {16;}' unless defined(&TV_VBURST_START_F3_SHIFT);
    eval 'sub TV_VBURST_END_F3_MASK () {0xff;}' unless defined(&TV_VBURST_END_F3_MASK);
    eval 'sub TV_VBURST_END_F3_SHIFT () {0;}' unless defined(&TV_VBURST_END_F3_SHIFT);
    eval 'sub TV_V_CTL_7 () {0x68054;}' unless defined(&TV_V_CTL_7);
    eval 'sub TV_VBURST_START_F4_MASK () {0x3f0000;}' unless defined(&TV_VBURST_START_F4_MASK);
    eval 'sub TV_VBURST_START_F4_SHIFT () {16;}' unless defined(&TV_VBURST_START_F4_SHIFT);
    eval 'sub TV_VBURST_END_F4_MASK () {0xff;}' unless defined(&TV_VBURST_END_F4_MASK);
    eval 'sub TV_VBURST_END_F4_SHIFT () {0;}' unless defined(&TV_VBURST_END_F4_SHIFT);
    eval 'sub TV_SC_CTL_1 () {0x68060;}' unless defined(&TV_SC_CTL_1);
    eval 'sub TV_SC_DDA1_EN () {(1<< 31);}' unless defined(&TV_SC_DDA1_EN);
    eval 'sub TV_SC_DDA2_EN () {(1<< 30);}' unless defined(&TV_SC_DDA2_EN);
    eval 'sub TV_SC_DDA3_EN () {(1<< 29);}' unless defined(&TV_SC_DDA3_EN);
    eval 'sub TV_SC_RESET_EVERY_2 () {(0<< 24);}' unless defined(&TV_SC_RESET_EVERY_2);
    eval 'sub TV_SC_RESET_EVERY_4 () {(1<< 24);}' unless defined(&TV_SC_RESET_EVERY_4);
    eval 'sub TV_SC_RESET_EVERY_8 () {(2<< 24);}' unless defined(&TV_SC_RESET_EVERY_8);
    eval 'sub TV_SC_RESET_NEVER () {(3<< 24);}' unless defined(&TV_SC_RESET_NEVER);
    eval 'sub TV_BURST_LEVEL_MASK () {0xff0000;}' unless defined(&TV_BURST_LEVEL_MASK);
    eval 'sub TV_BURST_LEVEL_SHIFT () {16;}' unless defined(&TV_BURST_LEVEL_SHIFT);
    eval 'sub TV_SCDDA1_INC_MASK () {0xfff;}' unless defined(&TV_SCDDA1_INC_MASK);
    eval 'sub TV_SCDDA1_INC_SHIFT () {0;}' unless defined(&TV_SCDDA1_INC_SHIFT);
    eval 'sub TV_SC_CTL_2 () {0x68064;}' unless defined(&TV_SC_CTL_2);
    eval 'sub TV_SCDDA2_SIZE_MASK () {0x7fff0000;}' unless defined(&TV_SCDDA2_SIZE_MASK);
    eval 'sub TV_SCDDA2_SIZE_SHIFT () {16;}' unless defined(&TV_SCDDA2_SIZE_SHIFT);
    eval 'sub TV_SCDDA2_INC_MASK () {0x7fff;}' unless defined(&TV_SCDDA2_INC_MASK);
    eval 'sub TV_SCDDA2_INC_SHIFT () {0;}' unless defined(&TV_SCDDA2_INC_SHIFT);
    eval 'sub TV_SC_CTL_3 () {0x68068;}' unless defined(&TV_SC_CTL_3);
    eval 'sub TV_SCDDA3_SIZE_MASK () {0x7fff0000;}' unless defined(&TV_SCDDA3_SIZE_MASK);
    eval 'sub TV_SCDDA3_SIZE_SHIFT () {16;}' unless defined(&TV_SCDDA3_SIZE_SHIFT);
    eval 'sub TV_SCDDA3_INC_MASK () {0x7fff;}' unless defined(&TV_SCDDA3_INC_MASK);
    eval 'sub TV_SCDDA3_INC_SHIFT () {0;}' unless defined(&TV_SCDDA3_INC_SHIFT);
    eval 'sub TV_WIN_POS () {0x68070;}' unless defined(&TV_WIN_POS);
    eval 'sub TV_XPOS_MASK () {0x1fff0000;}' unless defined(&TV_XPOS_MASK);
    eval 'sub TV_XPOS_SHIFT () {16;}' unless defined(&TV_XPOS_SHIFT);
    eval 'sub TV_YPOS_MASK () {0xfff;}' unless defined(&TV_YPOS_MASK);
    eval 'sub TV_YPOS_SHIFT () {0;}' unless defined(&TV_YPOS_SHIFT);
    eval 'sub TV_WIN_SIZE () {0x68074;}' unless defined(&TV_WIN_SIZE);
    eval 'sub TV_XSIZE_MASK () {0x1fff0000;}' unless defined(&TV_XSIZE_MASK);
    eval 'sub TV_XSIZE_SHIFT () {16;}' unless defined(&TV_XSIZE_SHIFT);
    eval 'sub TV_YSIZE_MASK () {0xfff;}' unless defined(&TV_YSIZE_MASK);
    eval 'sub TV_YSIZE_SHIFT () {0;}' unless defined(&TV_YSIZE_SHIFT);
    eval 'sub TV_FILTER_CTL_1 () {0x68080;}' unless defined(&TV_FILTER_CTL_1);
    eval 'sub TV_AUTO_SCALE () {(1<< 31);}' unless defined(&TV_AUTO_SCALE);
    eval 'sub TV_V_FILTER_BYPASS () {(1<< 29);}' unless defined(&TV_V_FILTER_BYPASS);
    eval 'sub TV_VADAPT () {(1<< 28);}' unless defined(&TV_VADAPT);
    eval 'sub TV_VADAPT_MODE_MASK () {(3<< 26);}' unless defined(&TV_VADAPT_MODE_MASK);
    eval 'sub TV_VADAPT_MODE_LEAST () {(0<< 26);}' unless defined(&TV_VADAPT_MODE_LEAST);
    eval 'sub TV_VADAPT_MODE_MODERATE () {(1<< 26);}' unless defined(&TV_VADAPT_MODE_MODERATE);
    eval 'sub TV_VADAPT_MODE_MOST () {(3<< 26);}' unless defined(&TV_VADAPT_MODE_MOST);
    eval 'sub TV_HSCALE_FRAC_MASK () {0x3fff;}' unless defined(&TV_HSCALE_FRAC_MASK);
    eval 'sub TV_HSCALE_FRAC_SHIFT () {0;}' unless defined(&TV_HSCALE_FRAC_SHIFT);
    eval 'sub TV_FILTER_CTL_2 () {0x68084;}' unless defined(&TV_FILTER_CTL_2);
    eval 'sub TV_VSCALE_INT_MASK () {0x38000;}' unless defined(&TV_VSCALE_INT_MASK);
    eval 'sub TV_VSCALE_INT_SHIFT () {15;}' unless defined(&TV_VSCALE_INT_SHIFT);
    eval 'sub TV_VSCALE_FRAC_MASK () {0x7fff;}' unless defined(&TV_VSCALE_FRAC_MASK);
    eval 'sub TV_VSCALE_FRAC_SHIFT () {0;}' unless defined(&TV_VSCALE_FRAC_SHIFT);
    eval 'sub TV_FILTER_CTL_3 () {0x68088;}' unless defined(&TV_FILTER_CTL_3);
    eval 'sub TV_VSCALE_IP_INT_MASK () {0x38000;}' unless defined(&TV_VSCALE_IP_INT_MASK);
    eval 'sub TV_VSCALE_IP_INT_SHIFT () {15;}' unless defined(&TV_VSCALE_IP_INT_SHIFT);
    eval 'sub TV_VSCALE_IP_FRAC_MASK () {0x7fff;}' unless defined(&TV_VSCALE_IP_FRAC_MASK);
    eval 'sub TV_VSCALE_IP_FRAC_SHIFT () {0;}' unless defined(&TV_VSCALE_IP_FRAC_SHIFT);
    eval 'sub TV_CC_CONTROL () {0x68090;}' unless defined(&TV_CC_CONTROL);
    eval 'sub TV_CC_ENABLE () {(1<< 31);}' unless defined(&TV_CC_ENABLE);
    eval 'sub TV_CC_FID_MASK () {(1<< 27);}' unless defined(&TV_CC_FID_MASK);
    eval 'sub TV_CC_FID_SHIFT () {27;}' unless defined(&TV_CC_FID_SHIFT);
    eval 'sub TV_CC_HOFF_MASK () {0x3ff0000;}' unless defined(&TV_CC_HOFF_MASK);
    eval 'sub TV_CC_HOFF_SHIFT () {16;}' unless defined(&TV_CC_HOFF_SHIFT);
    eval 'sub TV_CC_LINE_MASK () {0x3f;}' unless defined(&TV_CC_LINE_MASK);
    eval 'sub TV_CC_LINE_SHIFT () {0;}' unless defined(&TV_CC_LINE_SHIFT);
    eval 'sub TV_CC_DATA () {0x68094;}' unless defined(&TV_CC_DATA);
    eval 'sub TV_CC_RDY () {(1<< 31);}' unless defined(&TV_CC_RDY);
    eval 'sub TV_CC_DATA_2_MASK () {0x7f0000;}' unless defined(&TV_CC_DATA_2_MASK);
    eval 'sub TV_CC_DATA_2_SHIFT () {16;}' unless defined(&TV_CC_DATA_2_SHIFT);
    eval 'sub TV_CC_DATA_1_MASK () {0x7f;}' unless defined(&TV_CC_DATA_1_MASK);
    eval 'sub TV_CC_DATA_1_SHIFT () {0;}' unless defined(&TV_CC_DATA_1_SHIFT);
    eval 'sub TV_H_LUMA_0 () {0x68100;}' unless defined(&TV_H_LUMA_0);
    eval 'sub TV_H_LUMA_59 () {0x681ec;}' unless defined(&TV_H_LUMA_59);
    eval 'sub TV_H_CHROMA_0 () {0x68200;}' unless defined(&TV_H_CHROMA_0);
    eval 'sub TV_H_CHROMA_59 () {0x682ec;}' unless defined(&TV_H_CHROMA_59);
    eval 'sub TV_V_LUMA_0 () {0x68300;}' unless defined(&TV_V_LUMA_0);
    eval 'sub TV_V_LUMA_42 () {0x683a8;}' unless defined(&TV_V_LUMA_42);
    eval 'sub TV_V_CHROMA_0 () {0x68400;}' unless defined(&TV_V_CHROMA_0);
    eval 'sub TV_V_CHROMA_42 () {0x684a8;}' unless defined(&TV_V_CHROMA_42);
    eval 'sub DP_A () {0x64000;}' unless defined(&DP_A);
    eval 'sub DP_B () {0x64100;}' unless defined(&DP_B);
    eval 'sub DP_C () {0x64200;}' unless defined(&DP_C);
    eval 'sub DP_D () {0x64300;}' unless defined(&DP_D);
    eval 'sub DP_PORT_EN () {(1<< 31);}' unless defined(&DP_PORT_EN);
    eval 'sub DP_PIPEB_SELECT () {(1<< 30);}' unless defined(&DP_PIPEB_SELECT);
    eval 'sub DP_LINK_TRAIN_PAT_1 () {(0<< 28);}' unless defined(&DP_LINK_TRAIN_PAT_1);
    eval 'sub DP_LINK_TRAIN_PAT_2 () {(1<< 28);}' unless defined(&DP_LINK_TRAIN_PAT_2);
    eval 'sub DP_LINK_TRAIN_PAT_IDLE () {(2<< 28);}' unless defined(&DP_LINK_TRAIN_PAT_IDLE);
    eval 'sub DP_LINK_TRAIN_OFF () {(3<< 28);}' unless defined(&DP_LINK_TRAIN_OFF);
    eval 'sub DP_LINK_TRAIN_MASK () {(3<< 28);}' unless defined(&DP_LINK_TRAIN_MASK);
    eval 'sub DP_LINK_TRAIN_SHIFT () {28;}' unless defined(&DP_LINK_TRAIN_SHIFT);
    eval 'sub DP_VOLTAGE_0_4 () {(0<< 25);}' unless defined(&DP_VOLTAGE_0_4);
    eval 'sub DP_VOLTAGE_0_6 () {(1<< 25);}' unless defined(&DP_VOLTAGE_0_6);
    eval 'sub DP_VOLTAGE_0_8 () {(2<< 25);}' unless defined(&DP_VOLTAGE_0_8);
    eval 'sub DP_VOLTAGE_1_2 () {(3<< 25);}' unless defined(&DP_VOLTAGE_1_2);
    eval 'sub DP_VOLTAGE_MASK () {(7<< 25);}' unless defined(&DP_VOLTAGE_MASK);
    eval 'sub DP_VOLTAGE_SHIFT () {25;}' unless defined(&DP_VOLTAGE_SHIFT);
    eval 'sub DP_PRE_EMPHASIS_0 () {(0<< 22);}' unless defined(&DP_PRE_EMPHASIS_0);
    eval 'sub DP_PRE_EMPHASIS_3_5 () {(1<< 22);}' unless defined(&DP_PRE_EMPHASIS_3_5);
    eval 'sub DP_PRE_EMPHASIS_6 () {(2<< 22);}' unless defined(&DP_PRE_EMPHASIS_6);
    eval 'sub DP_PRE_EMPHASIS_9_5 () {(3<< 22);}' unless defined(&DP_PRE_EMPHASIS_9_5);
    eval 'sub DP_PRE_EMPHASIS_MASK () {(7<< 22);}' unless defined(&DP_PRE_EMPHASIS_MASK);
    eval 'sub DP_PRE_EMPHASIS_SHIFT () {22;}' unless defined(&DP_PRE_EMPHASIS_SHIFT);
    eval 'sub DP_PORT_WIDTH_1 () {(0<< 19);}' unless defined(&DP_PORT_WIDTH_1);
    eval 'sub DP_PORT_WIDTH_2 () {(1<< 19);}' unless defined(&DP_PORT_WIDTH_2);
    eval 'sub DP_PORT_WIDTH_4 () {(3<< 19);}' unless defined(&DP_PORT_WIDTH_4);
    eval 'sub DP_PORT_WIDTH_MASK () {(7<< 19);}' unless defined(&DP_PORT_WIDTH_MASK);
    eval 'sub DP_ENHANCED_FRAMING () {(1<< 18);}' unless defined(&DP_ENHANCED_FRAMING);
    eval 'sub DP_PLL_FREQ_270MHZ () {(0<< 16);}' unless defined(&DP_PLL_FREQ_270MHZ);
    eval 'sub DP_PLL_FREQ_160MHZ () {(1<< 16);}' unless defined(&DP_PLL_FREQ_160MHZ);
    eval 'sub DP_PLL_FREQ_MASK () {(3<< 16);}' unless defined(&DP_PLL_FREQ_MASK);
    eval 'sub DP_PORT_REVERSAL () {(1<< 15);}' unless defined(&DP_PORT_REVERSAL);
    eval 'sub DP_PLL_ENABLE () {(1<< 14);}' unless defined(&DP_PLL_ENABLE);
    eval 'sub DP_CLOCK_OUTPUT_ENABLE () {(1<< 13);}' unless defined(&DP_CLOCK_OUTPUT_ENABLE);
    eval 'sub DP_SCRAMBLING_DISABLE () {(1<< 12);}' unless defined(&DP_SCRAMBLING_DISABLE);
    eval 'sub DP_SCRAMBLING_DISABLE_IGDNG () {(1<< 7);}' unless defined(&DP_SCRAMBLING_DISABLE_IGDNG);
    eval 'sub DP_COLOR_RANGE_16_235 () {(1<< 8);}' unless defined(&DP_COLOR_RANGE_16_235);
    eval 'sub DP_AUDIO_OUTPUT_ENABLE () {(1<< 6);}' unless defined(&DP_AUDIO_OUTPUT_ENABLE);
    eval 'sub DP_SYNC_VS_HIGH () {(1<< 4);}' unless defined(&DP_SYNC_VS_HIGH);
    eval 'sub DP_SYNC_HS_HIGH () {(1<< 3);}' unless defined(&DP_SYNC_HS_HIGH);
    eval 'sub DP_DETECTED () {(1<< 2);}' unless defined(&DP_DETECTED);
    eval 'sub DPA_AUX_CH_CTL () {0x64010;}' unless defined(&DPA_AUX_CH_CTL);
    eval 'sub DPA_AUX_CH_DATA1 () {0x64014;}' unless defined(&DPA_AUX_CH_DATA1);
    eval 'sub DPA_AUX_CH_DATA2 () {0x64018;}' unless defined(&DPA_AUX_CH_DATA2);
    eval 'sub DPA_AUX_CH_DATA3 () {0x6401c;}' unless defined(&DPA_AUX_CH_DATA3);
    eval 'sub DPA_AUX_CH_DATA4 () {0x64020;}' unless defined(&DPA_AUX_CH_DATA4);
    eval 'sub DPA_AUX_CH_DATA5 () {0x64024;}' unless defined(&DPA_AUX_CH_DATA5);
    eval 'sub DPB_AUX_CH_CTL () {0x64110;}' unless defined(&DPB_AUX_CH_CTL);
    eval 'sub DPB_AUX_CH_DATA1 () {0x64114;}' unless defined(&DPB_AUX_CH_DATA1);
    eval 'sub DPB_AUX_CH_DATA2 () {0x64118;}' unless defined(&DPB_AUX_CH_DATA2);
    eval 'sub DPB_AUX_CH_DATA3 () {0x6411c;}' unless defined(&DPB_AUX_CH_DATA3);
    eval 'sub DPB_AUX_CH_DATA4 () {0x64120;}' unless defined(&DPB_AUX_CH_DATA4);
    eval 'sub DPB_AUX_CH_DATA5 () {0x64124;}' unless defined(&DPB_AUX_CH_DATA5);
    eval 'sub DPC_AUX_CH_CTL () {0x64210;}' unless defined(&DPC_AUX_CH_CTL);
    eval 'sub DPC_AUX_CH_DATA1 () {0x64214;}' unless defined(&DPC_AUX_CH_DATA1);
    eval 'sub DPC_AUX_CH_DATA2 () {0x64218;}' unless defined(&DPC_AUX_CH_DATA2);
    eval 'sub DPC_AUX_CH_DATA3 () {0x6421c;}' unless defined(&DPC_AUX_CH_DATA3);
    eval 'sub DPC_AUX_CH_DATA4 () {0x64220;}' unless defined(&DPC_AUX_CH_DATA4);
    eval 'sub DPC_AUX_CH_DATA5 () {0x64224;}' unless defined(&DPC_AUX_CH_DATA5);
    eval 'sub DPD_AUX_CH_CTL () {0x64310;}' unless defined(&DPD_AUX_CH_CTL);
    eval 'sub DPD_AUX_CH_DATA1 () {0x64314;}' unless defined(&DPD_AUX_CH_DATA1);
    eval 'sub DPD_AUX_CH_DATA2 () {0x64318;}' unless defined(&DPD_AUX_CH_DATA2);
    eval 'sub DPD_AUX_CH_DATA3 () {0x6431c;}' unless defined(&DPD_AUX_CH_DATA3);
    eval 'sub DPD_AUX_CH_DATA4 () {0x64320;}' unless defined(&DPD_AUX_CH_DATA4);
    eval 'sub DPD_AUX_CH_DATA5 () {0x64324;}' unless defined(&DPD_AUX_CH_DATA5);
    eval 'sub DP_AUX_CH_CTL_SEND_BUSY () {(1<< 31);}' unless defined(&DP_AUX_CH_CTL_SEND_BUSY);
    eval 'sub DP_AUX_CH_CTL_DONE () {(1<< 30);}' unless defined(&DP_AUX_CH_CTL_DONE);
    eval 'sub DP_AUX_CH_CTL_INTERRUPT () {(1<< 29);}' unless defined(&DP_AUX_CH_CTL_INTERRUPT);
    eval 'sub DP_AUX_CH_CTL_TIME_OUT_ERROR () {(1<< 28);}' unless defined(&DP_AUX_CH_CTL_TIME_OUT_ERROR);
    eval 'sub DP_AUX_CH_CTL_TIME_OUT_400us () {(0<< 26);}' unless defined(&DP_AUX_CH_CTL_TIME_OUT_400us);
    eval 'sub DP_AUX_CH_CTL_TIME_OUT_600us () {(1<< 26);}' unless defined(&DP_AUX_CH_CTL_TIME_OUT_600us);
    eval 'sub DP_AUX_CH_CTL_TIME_OUT_800us () {(2<< 26);}' unless defined(&DP_AUX_CH_CTL_TIME_OUT_800us);
    eval 'sub DP_AUX_CH_CTL_TIME_OUT_1600us () {(3<< 26);}' unless defined(&DP_AUX_CH_CTL_TIME_OUT_1600us);
    eval 'sub DP_AUX_CH_CTL_TIME_OUT_MASK () {(3<< 26);}' unless defined(&DP_AUX_CH_CTL_TIME_OUT_MASK);
    eval 'sub DP_AUX_CH_CTL_RECEIVE_ERROR () {(1<< 25);}' unless defined(&DP_AUX_CH_CTL_RECEIVE_ERROR);
    eval 'sub DP_AUX_CH_CTL_MESSAGE_SIZE_MASK () {(0x1f << 20);}' unless defined(&DP_AUX_CH_CTL_MESSAGE_SIZE_MASK);
    eval 'sub DP_AUX_CH_CTL_MESSAGE_SIZE_SHIFT () {20;}' unless defined(&DP_AUX_CH_CTL_MESSAGE_SIZE_SHIFT);
    eval 'sub DP_AUX_CH_CTL_PRECHARGE_2US_MASK () {(0xf << 16);}' unless defined(&DP_AUX_CH_CTL_PRECHARGE_2US_MASK);
    eval 'sub DP_AUX_CH_CTL_PRECHARGE_2US_SHIFT () {16;}' unless defined(&DP_AUX_CH_CTL_PRECHARGE_2US_SHIFT);
    eval 'sub DP_AUX_CH_CTL_AUX_AKSV_SELECT () {(1<< 15);}' unless defined(&DP_AUX_CH_CTL_AUX_AKSV_SELECT);
    eval 'sub DP_AUX_CH_CTL_MANCHESTER_TEST () {(1<< 14);}' unless defined(&DP_AUX_CH_CTL_MANCHESTER_TEST);
    eval 'sub DP_AUX_CH_CTL_SYNC_TEST () {(1<< 13);}' unless defined(&DP_AUX_CH_CTL_SYNC_TEST);
    eval 'sub DP_AUX_CH_CTL_DEGLITCH_TEST () {(1<< 12);}' unless defined(&DP_AUX_CH_CTL_DEGLITCH_TEST);
    eval 'sub DP_AUX_CH_CTL_PRECHARGE_TEST () {(1<< 11);}' unless defined(&DP_AUX_CH_CTL_PRECHARGE_TEST);
    eval 'sub DP_AUX_CH_CTL_BIT_CLOCK_2X_MASK () {(0x7ff);}' unless defined(&DP_AUX_CH_CTL_BIT_CLOCK_2X_MASK);
    eval 'sub DP_AUX_CH_CTL_BIT_CLOCK_2X_SHIFT () {0;}' unless defined(&DP_AUX_CH_CTL_BIT_CLOCK_2X_SHIFT);
    eval 'sub PIPEA_GMCH_DATA_M () {0x70050;}' unless defined(&PIPEA_GMCH_DATA_M);
    eval 'sub PIPEB_GMCH_DATA_M () {0x71050;}' unless defined(&PIPEB_GMCH_DATA_M);
    eval 'sub PIPE_GMCH_DATA_M_TU_SIZE_MASK () {(0x3f << 25);}' unless defined(&PIPE_GMCH_DATA_M_TU_SIZE_MASK);
    eval 'sub PIPE_GMCH_DATA_M_TU_SIZE_SHIFT () {25;}' unless defined(&PIPE_GMCH_DATA_M_TU_SIZE_SHIFT);
    eval 'sub PIPE_GMCH_DATA_M_MASK () {(0xffffff);}' unless defined(&PIPE_GMCH_DATA_M_MASK);
    eval 'sub PIPEA_GMCH_DATA_N () {0x70054;}' unless defined(&PIPEA_GMCH_DATA_N);
    eval 'sub PIPEB_GMCH_DATA_N () {0x71054;}' unless defined(&PIPEB_GMCH_DATA_N);
    eval 'sub PIPE_GMCH_DATA_N_MASK () {(0xffffff);}' unless defined(&PIPE_GMCH_DATA_N_MASK);
    eval 'sub PIPEA_DP_LINK_M () {0x70060;}' unless defined(&PIPEA_DP_LINK_M);
    eval 'sub PIPEB_DP_LINK_M () {0x71060;}' unless defined(&PIPEB_DP_LINK_M);
    eval 'sub PIPEA_DP_LINK_M_MASK () {(0xffffff);}' unless defined(&PIPEA_DP_LINK_M_MASK);
    eval 'sub PIPEA_DP_LINK_N () {0x70064;}' unless defined(&PIPEA_DP_LINK_N);
    eval 'sub PIPEB_DP_LINK_N () {0x71064;}' unless defined(&PIPEB_DP_LINK_N);
    eval 'sub PIPEA_DP_LINK_N_MASK () {(0xffffff);}' unless defined(&PIPEA_DP_LINK_N_MASK);
    eval 'sub PIPEADSL () {0x70000;}' unless defined(&PIPEADSL);
    eval 'sub PIPEACONF () {0x70008;}' unless defined(&PIPEACONF);
    eval 'sub PIPEACONF_ENABLE () {(1<<31);}' unless defined(&PIPEACONF_ENABLE);
    eval 'sub PIPEACONF_DISABLE () {0;}' unless defined(&PIPEACONF_DISABLE);
    eval 'sub PIPEACONF_DOUBLE_WIDE () {(1<<30);}' unless defined(&PIPEACONF_DOUBLE_WIDE);
    eval 'sub I965_PIPECONF_ACTIVE () {(1<<30);}' unless defined(&I965_PIPECONF_ACTIVE);
    eval 'sub PIPEACONF_SINGLE_WIDE () {0;}' unless defined(&PIPEACONF_SINGLE_WIDE);
    eval 'sub PIPEACONF_PIPE_UNLOCKED () {0;}' unless defined(&PIPEACONF_PIPE_UNLOCKED);
    eval 'sub PIPEACONF_PIPE_LOCKED () {(1<<25);}' unless defined(&PIPEACONF_PIPE_LOCKED);
    eval 'sub PIPEACONF_PALETTE () {0;}' unless defined(&PIPEACONF_PALETTE);
    eval 'sub PIPEACONF_GAMMA () {(1<<24);}' unless defined(&PIPEACONF_GAMMA);
    eval 'sub PIPECONF_FORCE_BORDER () {(1<<25);}' unless defined(&PIPECONF_FORCE_BORDER);
    eval 'sub PIPECONF_PROGRESSIVE () {(0<< 21);}' unless defined(&PIPECONF_PROGRESSIVE);
    eval 'sub PIPECONF_INTERLACE_W_FIELD_INDICATION () {(6<< 21);}' unless defined(&PIPECONF_INTERLACE_W_FIELD_INDICATION);
    eval 'sub PIPECONF_INTERLACE_FIELD_0_ONLY () {(7<< 21);}' unless defined(&PIPECONF_INTERLACE_FIELD_0_ONLY);
    eval 'sub PIPEASTAT () {0x70024;}' unless defined(&PIPEASTAT);
    eval 'sub PIPE_FIFO_UNDERRUN_STATUS () {(1<<31);}' unless defined(&PIPE_FIFO_UNDERRUN_STATUS);
    eval 'sub PIPE_CRC_ERROR_ENABLE () {(1<<29);}' unless defined(&PIPE_CRC_ERROR_ENABLE);
    eval 'sub PIPE_CRC_DONE_ENABLE () {(1<<28);}' unless defined(&PIPE_CRC_DONE_ENABLE);
    eval 'sub PIPE_GMBUS_EVENT_ENABLE () {(1<<27);}' unless defined(&PIPE_GMBUS_EVENT_ENABLE);
    eval 'sub PIPE_HOTPLUG_INTERRUPT_ENABLE () {(1<<26);}' unless defined(&PIPE_HOTPLUG_INTERRUPT_ENABLE);
    eval 'sub PIPE_VSYNC_INTERRUPT_ENABLE () {(1<<25);}' unless defined(&PIPE_VSYNC_INTERRUPT_ENABLE);
    eval 'sub PIPE_DISPLAY_LINE_COMPARE_ENABLE () {(1<<24);}' unless defined(&PIPE_DISPLAY_LINE_COMPARE_ENABLE);
    eval 'sub PIPE_DPST_EVENT_ENABLE () {(1<<23);}' unless defined(&PIPE_DPST_EVENT_ENABLE);
    eval 'sub PIPE_LEGACY_BLC_EVENT_ENABLE () {(1<<22);}' unless defined(&PIPE_LEGACY_BLC_EVENT_ENABLE);
    eval 'sub PIPE_ODD_FIELD_INTERRUPT_ENABLE () {(1<<21);}' unless defined(&PIPE_ODD_FIELD_INTERRUPT_ENABLE);
    eval 'sub PIPE_EVEN_FIELD_INTERRUPT_ENABLE () {(1<<20);}' unless defined(&PIPE_EVEN_FIELD_INTERRUPT_ENABLE);
    eval 'sub PIPE_HOTPLUG_TV_INTERRUPT_ENABLE () {(1<<18);}' unless defined(&PIPE_HOTPLUG_TV_INTERRUPT_ENABLE);
    eval 'sub PIPE_START_VBLANK_INTERRUPT_ENABLE () {(1<<18);}' unless defined(&PIPE_START_VBLANK_INTERRUPT_ENABLE);
    eval 'sub PIPE_VBLANK_INTERRUPT_ENABLE () {(1<<17);}' unless defined(&PIPE_VBLANK_INTERRUPT_ENABLE);
    eval 'sub PIPE_OVERLAY_UPDATED_ENABLE () {(1<<16);}' unless defined(&PIPE_OVERLAY_UPDATED_ENABLE);
    eval 'sub PIPE_CRC_ERROR_INTERRUPT_STATUS () {(1<<13);}' unless defined(&PIPE_CRC_ERROR_INTERRUPT_STATUS);
    eval 'sub PIPE_CRC_DONE_INTERRUPT_STATUS () {(1<<12);}' unless defined(&PIPE_CRC_DONE_INTERRUPT_STATUS);
    eval 'sub PIPE_GMBUS_INTERRUPT_STATUS () {(1<<11);}' unless defined(&PIPE_GMBUS_INTERRUPT_STATUS);
    eval 'sub PIPE_HOTPLUG_INTERRUPT_STATUS () {(1<<10);}' unless defined(&PIPE_HOTPLUG_INTERRUPT_STATUS);
    eval 'sub PIPE_VSYNC_INTERRUPT_STATUS () {(1<<9);}' unless defined(&PIPE_VSYNC_INTERRUPT_STATUS);
    eval 'sub PIPE_DISPLAY_LINE_COMPARE_STATUS () {(1<<8);}' unless defined(&PIPE_DISPLAY_LINE_COMPARE_STATUS);
    eval 'sub PIPE_DPST_EVENT_STATUS () {(1<<7);}' unless defined(&PIPE_DPST_EVENT_STATUS);
    eval 'sub PIPE_LEGACY_BLC_EVENT_STATUS () {(1<<6);}' unless defined(&PIPE_LEGACY_BLC_EVENT_STATUS);
    eval 'sub PIPE_ODD_FIELD_INTERRUPT_STATUS () {(1<<5);}' unless defined(&PIPE_ODD_FIELD_INTERRUPT_STATUS);
    eval 'sub PIPE_EVEN_FIELD_INTERRUPT_STATUS () {(1<<4);}' unless defined(&PIPE_EVEN_FIELD_INTERRUPT_STATUS);
    eval 'sub PIPE_HOTPLUG_TV_INTERRUPT_STATUS () {(1<<2);}' unless defined(&PIPE_HOTPLUG_TV_INTERRUPT_STATUS);
    eval 'sub PIPE_START_VBLANK_INTERRUPT_STATUS () {(1<<2);}' unless defined(&PIPE_START_VBLANK_INTERRUPT_STATUS);
    eval 'sub PIPE_VBLANK_INTERRUPT_STATUS () {(1<<1);}' unless defined(&PIPE_VBLANK_INTERRUPT_STATUS);
    eval 'sub PIPE_OVERLAY_UPDATED_STATUS () {(1<<0);}' unless defined(&PIPE_OVERLAY_UPDATED_STATUS);
    eval 'sub DSPARB () {0x70030;}' unless defined(&DSPARB);
    eval 'sub DSPARB_CSTART_MASK () {(0x7f << 7);}' unless defined(&DSPARB_CSTART_MASK);
    eval 'sub DSPARB_CSTART_SHIFT () {7;}' unless defined(&DSPARB_CSTART_SHIFT);
    eval 'sub DSPARB_BSTART_MASK () {(0x7f);}' unless defined(&DSPARB_BSTART_MASK);
    eval 'sub DSPARB_BSTART_SHIFT () {0;}' unless defined(&DSPARB_BSTART_SHIFT);
    eval 'sub PIPEAFRAMEHIGH () {0x70040;}' unless defined(&PIPEAFRAMEHIGH);
    eval 'sub PIPE_FRAME_HIGH_MASK () {0xffff;}' unless defined(&PIPE_FRAME_HIGH_MASK);
    eval 'sub PIPE_FRAME_HIGH_SHIFT () {0;}' unless defined(&PIPE_FRAME_HIGH_SHIFT);
    eval 'sub PIPEAFRAMEPIXEL () {0x70044;}' unless defined(&PIPEAFRAMEPIXEL);
    eval 'sub PIPE_FRAME_LOW_MASK () {0xff000000;}' unless defined(&PIPE_FRAME_LOW_MASK);
    eval 'sub PIPE_FRAME_LOW_SHIFT () {24;}' unless defined(&PIPE_FRAME_LOW_SHIFT);
    eval 'sub PIPE_PIXEL_MASK () {0xffffff;}' unless defined(&PIPE_PIXEL_MASK);
    eval 'sub PIPE_PIXEL_SHIFT () {0;}' unless defined(&PIPE_PIXEL_SHIFT);
    eval 'sub PIPEA_FRMCOUNT_GM45 () {0x70040;}' unless defined(&PIPEA_FRMCOUNT_GM45);
    eval 'sub PIPEA_FLIPCOUNT_GM45 () {0x70044;}' unless defined(&PIPEA_FLIPCOUNT_GM45);
    eval 'sub CURACNTR () {0x70080;}' unless defined(&CURACNTR);
    eval 'sub CURSOR_MODE_DISABLE () {0x;}' unless defined(&CURSOR_MODE_DISABLE);
    eval 'sub CURSOR_MODE_64_32B_AX () {0x7;}' unless defined(&CURSOR_MODE_64_32B_AX);
    eval 'sub CURSOR_MODE_64_ARGB_AX () {((1<< 5) |  &CURSOR_MODE_64_32B_AX);}' unless defined(&CURSOR_MODE_64_ARGB_AX);
    eval 'sub MCURSOR_GAMMA_ENABLE () {(1<< 26);}' unless defined(&MCURSOR_GAMMA_ENABLE);
    eval 'sub CURABASE () {0x70084;}' unless defined(&CURABASE);
    eval 'sub CURAPOS () {0x70088;}' unless defined(&CURAPOS);
    eval 'sub CURSOR_POS_MASK () {0x7ff;}' unless defined(&CURSOR_POS_MASK);
    eval 'sub CURSOR_POS_SIGN () {0x8000;}' unless defined(&CURSOR_POS_SIGN);
    eval 'sub CURSOR_X_SHIFT () {0;}' unless defined(&CURSOR_X_SHIFT);
    eval 'sub CURSOR_Y_SHIFT () {16;}' unless defined(&CURSOR_Y_SHIFT);
    eval 'sub CURSIZE () {0x700a0;}' unless defined(&CURSIZE);
    eval 'sub CURBCNTR () {0x700c0;}' unless defined(&CURBCNTR);
    eval 'sub CURBBASE () {0x700c4;}' unless defined(&CURBBASE);
    eval 'sub CURBPOS () {0x700c8;}' unless defined(&CURBPOS);
    eval 'sub DSPACNTR () {0x70180;}' unless defined(&DSPACNTR);
    eval 'sub DISPLAY_PLANE_ENABLE () {(1<<31);}' unless defined(&DISPLAY_PLANE_ENABLE);
    eval 'sub DISPLAY_PLANE_DISABLE () {0;}' unless defined(&DISPLAY_PLANE_DISABLE);
    eval 'sub DISPPLANE_GAMMA_ENABLE () {(1<<30);}' unless defined(&DISPPLANE_GAMMA_ENABLE);
    eval 'sub DISPPLANE_GAMMA_DISABLE () {0;}' unless defined(&DISPPLANE_GAMMA_DISABLE);
    eval 'sub DISPPLANE_PIXFORMAT_MASK () {(0xf<<26);}' unless defined(&DISPPLANE_PIXFORMAT_MASK);
    eval 'sub DISPPLANE_8BPP () {(0x2<<26);}' unless defined(&DISPPLANE_8BPP);
    eval 'sub DISPPLANE_15_16BPP () {(0x4<<26);}' unless defined(&DISPPLANE_15_16BPP);
    eval 'sub DISPPLANE_16BPP () {(0x5<<26);}' unless defined(&DISPPLANE_16BPP);
    eval 'sub DISPPLANE_32BPP_NO_ALPHA () {(0x6<<26);}' unless defined(&DISPPLANE_32BPP_NO_ALPHA);
    eval 'sub DISPPLANE_32BPP () {(0x7<<26);}' unless defined(&DISPPLANE_32BPP);
    eval 'sub DISPPLANE_STEREO_ENABLE () {(1<<25);}' unless defined(&DISPPLANE_STEREO_ENABLE);
    eval 'sub DISPPLANE_STEREO_DISABLE () {0;}' unless defined(&DISPPLANE_STEREO_DISABLE);
    eval 'sub DISPPLANE_SEL_PIPE_MASK () {(1<<24);}' unless defined(&DISPPLANE_SEL_PIPE_MASK);
    eval 'sub DISPPLANE_SEL_PIPE_A () {0;}' unless defined(&DISPPLANE_SEL_PIPE_A);
    eval 'sub DISPPLANE_SEL_PIPE_B () {(1<<24);}' unless defined(&DISPPLANE_SEL_PIPE_B);
    eval 'sub DISPPLANE_SRC_KEY_ENABLE () {(1<<22);}' unless defined(&DISPPLANE_SRC_KEY_ENABLE);
    eval 'sub DISPPLANE_SRC_KEY_DISABLE () {0;}' unless defined(&DISPPLANE_SRC_KEY_DISABLE);
    eval 'sub DISPPLANE_LINE_DOUBLE () {(1<<20);}' unless defined(&DISPPLANE_LINE_DOUBLE);
    eval 'sub DISPPLANE_NO_LINE_DOUBLE () {0;}' unless defined(&DISPPLANE_NO_LINE_DOUBLE);
    eval 'sub DISPPLANE_STEREO_POLARITY_FIRST () {0;}' unless defined(&DISPPLANE_STEREO_POLARITY_FIRST);
    eval 'sub DISPPLANE_STEREO_POLARITY_SECOND () {(1<<18);}' unless defined(&DISPPLANE_STEREO_POLARITY_SECOND);
    eval 'sub DSPAADDR () {0x70184;}' unless defined(&DSPAADDR);
    eval 'sub DSPASTRIDE () {0x70188;}' unless defined(&DSPASTRIDE);
    eval 'sub DSPAPOS () {0x7018c;}' unless defined(&DSPAPOS);
    eval 'sub DSPASIZE () {0x70190;}' unless defined(&DSPASIZE);
    eval 'sub DSPASURF () {0x7019c;}' unless defined(&DSPASURF);
    eval 'sub DSPATILEOFF () {0x701a4;}' unless defined(&DSPATILEOFF);
    eval 'sub SWF00 () {0x71410;}' unless defined(&SWF00);
    eval 'sub SWF01 () {0x71414;}' unless defined(&SWF01);
    eval 'sub SWF02 () {0x71418;}' unless defined(&SWF02);
    eval 'sub SWF03 () {0x7141c;}' unless defined(&SWF03);
    eval 'sub SWF04 () {0x71420;}' unless defined(&SWF04);
    eval 'sub SWF05 () {0x71424;}' unless defined(&SWF05);
    eval 'sub SWF06 () {0x71428;}' unless defined(&SWF06);
    eval 'sub SWF10 () {0x70410;}' unless defined(&SWF10);
    eval 'sub SWF11 () {0x70414;}' unless defined(&SWF11);
    eval 'sub SWF14 () {0x71420;}' unless defined(&SWF14);
    eval 'sub SWF30 () {0x72414;}' unless defined(&SWF30);
    eval 'sub SWF31 () {0x72418;}' unless defined(&SWF31);
    eval 'sub SWF32 () {0x7241c;}' unless defined(&SWF32);
    eval 'sub PIPEBDSL () {0x71000;}' unless defined(&PIPEBDSL);
    eval 'sub PIPEBCONF () {0x71008;}' unless defined(&PIPEBCONF);
    eval 'sub PIPEBSTAT () {0x71024;}' unless defined(&PIPEBSTAT);
    eval 'sub PIPEBFRAMEHIGH () {0x71040;}' unless defined(&PIPEBFRAMEHIGH);
    eval 'sub PIPEBFRAMEPIXEL () {0x71044;}' unless defined(&PIPEBFRAMEPIXEL);
    eval 'sub PIPEB_FRMCOUNT_GM45 () {0x71040;}' unless defined(&PIPEB_FRMCOUNT_GM45);
    eval 'sub PIPEB_FLIPCOUNT_GM45 () {0x71044;}' unless defined(&PIPEB_FLIPCOUNT_GM45);
    eval 'sub DSPBCNTR () {0x71180;}' unless defined(&DSPBCNTR);
    eval 'sub DISPPLANE_ALPHA_TRANS_ENABLE () {(1<<15);}' unless defined(&DISPPLANE_ALPHA_TRANS_ENABLE);
    eval 'sub DISPPLANE_ALPHA_TRANS_DISABLE () {0;}' unless defined(&DISPPLANE_ALPHA_TRANS_DISABLE);
    eval 'sub DISPPLANE_SPRITE_ABOVE_DISPLAY () {0;}' unless defined(&DISPPLANE_SPRITE_ABOVE_DISPLAY);
    eval 'sub DISPPLANE_SPRITE_ABOVE_OVERLAY () {(1);}' unless defined(&DISPPLANE_SPRITE_ABOVE_OVERLAY);
    eval 'sub DSPBADDR () {0x71184;}' unless defined(&DSPBADDR);
    eval 'sub DSPBSTRIDE () {0x71188;}' unless defined(&DSPBSTRIDE);
    eval 'sub DSPBPOS () {0x7118c;}' unless defined(&DSPBPOS);
    eval 'sub DSPBSIZE () {0x71190;}' unless defined(&DSPBSIZE);
    eval 'sub DSPBSURF () {0x7119c;}' unless defined(&DSPBSURF);
    eval 'sub DSPBTILEOFF () {0x711a4;}' unless defined(&DSPBTILEOFF);
    eval 'sub VGACNTRL () {0x71400;}' unless defined(&VGACNTRL);
    eval 'sub VGA_DISP_DISABLE () {(1<< 31);}' unless defined(&VGA_DISP_DISABLE);
    eval 'sub VGA_2X_MODE () {(1<< 30);}' unless defined(&VGA_2X_MODE);
    eval 'sub VGA_PIPE_B_SELECT () {(1<< 29);}' unless defined(&VGA_PIPE_B_SELECT);
    eval 'sub CPU_VGACNTRL () {0x41000;}' unless defined(&CPU_VGACNTRL);
    eval 'sub DIGITAL_PORT_HOTPLUG_CNTRL () {0x44030;}' unless defined(&DIGITAL_PORT_HOTPLUG_CNTRL);
    eval 'sub DIGITAL_PORTA_HOTPLUG_ENABLE () {(1<< 4);}' unless defined(&DIGITAL_PORTA_HOTPLUG_ENABLE);
    eval 'sub DIGITAL_PORTA_SHORT_PULSE_2MS () {(0<< 2);}' unless defined(&DIGITAL_PORTA_SHORT_PULSE_2MS);
    eval 'sub DIGITAL_PORTA_SHORT_PULSE_4_5MS () {(1<< 2);}' unless defined(&DIGITAL_PORTA_SHORT_PULSE_4_5MS);
    eval 'sub DIGITAL_PORTA_SHORT_PULSE_6MS () {(2<< 2);}' unless defined(&DIGITAL_PORTA_SHORT_PULSE_6MS);
    eval 'sub DIGITAL_PORTA_SHORT_PULSE_100MS () {(3<< 2);}' unless defined(&DIGITAL_PORTA_SHORT_PULSE_100MS);
    eval 'sub DIGITAL_PORTA_NO_DETECT () {(0<< 0);}' unless defined(&DIGITAL_PORTA_NO_DETECT);
    eval 'sub DIGITAL_PORTA_LONG_PULSE_DETECT_MASK () {(1<< 1);}' unless defined(&DIGITAL_PORTA_LONG_PULSE_DETECT_MASK);
    eval 'sub DIGITAL_PORTA_SHORT_PULSE_DETECT_MASK () {(1<< 0);}' unless defined(&DIGITAL_PORTA_SHORT_PULSE_DETECT_MASK);
    eval 'sub RR_HW_CTL () {0x45300;}' unless defined(&RR_HW_CTL);
    eval 'sub RR_HW_LOW_POWER_FRAMES_MASK () {0xff;}' unless defined(&RR_HW_LOW_POWER_FRAMES_MASK);
    eval 'sub RR_HW_HIGH_POWER_FRAMES_MASK () {0xff00;}' unless defined(&RR_HW_HIGH_POWER_FRAMES_MASK);
    eval 'sub FDI_PLL_BIOS_0 () {0x46000;}' unless defined(&FDI_PLL_BIOS_0);
    eval 'sub FDI_PLL_BIOS_1 () {0x46004;}' unless defined(&FDI_PLL_BIOS_1);
    eval 'sub FDI_PLL_BIOS_2 () {0x46008;}' unless defined(&FDI_PLL_BIOS_2);
    eval 'sub DISPLAY_PORT_PLL_BIOS_0 () {0x4600c;}' unless defined(&DISPLAY_PORT_PLL_BIOS_0);
    eval 'sub DISPLAY_PORT_PLL_BIOS_1 () {0x46010;}' unless defined(&DISPLAY_PORT_PLL_BIOS_1);
    eval 'sub DISPLAY_PORT_PLL_BIOS_2 () {0x46014;}' unless defined(&DISPLAY_PORT_PLL_BIOS_2);
    eval 'sub PCH_DSPCLK_GATE_D () {0x42020;}' unless defined(&PCH_DSPCLK_GATE_D);
    eval 'sub DPFDUNIT_CLOCK_GATE_DISABLE () {(1<< 7);}' unless defined(&DPFDUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPARBUNIT_CLOCK_GATE_DISABLE () {(1<< 5);}' unless defined(&DPARBUNIT_CLOCK_GATE_DISABLE);
    eval 'sub PCH_3DCGDIS0 () {0x46020;}' unless defined(&PCH_3DCGDIS0);
    eval 'sub MARIUNIT_CLOCK_GATE_DISABLE () {(1<< 18);}' unless defined(&MARIUNIT_CLOCK_GATE_DISABLE);
    eval 'sub SVSMUNIT_CLOCK_GATE_DISABLE () {(1<< 1);}' unless defined(&SVSMUNIT_CLOCK_GATE_DISABLE);
    eval 'sub FDI_PLL_FREQ_CTL () {0x46030;}' unless defined(&FDI_PLL_FREQ_CTL);
    eval 'sub FDI_PLL_FREQ_CHANGE_REQUEST () {(1<<24);}' unless defined(&FDI_PLL_FREQ_CHANGE_REQUEST);
    eval 'sub FDI_PLL_FREQ_LOCK_LIMIT_MASK () {0xfff00;}' unless defined(&FDI_PLL_FREQ_LOCK_LIMIT_MASK);
    eval 'sub FDI_PLL_FREQ_DISABLE_COUNT_LIMIT_MASK () {0xff;}' unless defined(&FDI_PLL_FREQ_DISABLE_COUNT_LIMIT_MASK);
    eval 'sub PIPEA_DATA_M1 () {0x60030;}' unless defined(&PIPEA_DATA_M1);
    eval 'sub TU_SIZE {
        my($x) = @_;
	    eval q(((($x)-1) << 25));
    }' unless defined(&TU_SIZE);
    eval 'sub TU_SIZE_MASK () {0x7e000000;}' unless defined(&TU_SIZE_MASK);
    eval 'sub PIPEA_DATA_M1_OFFSET () {0;}' unless defined(&PIPEA_DATA_M1_OFFSET);
    eval 'sub PIPEA_DATA_N1 () {0x60034;}' unless defined(&PIPEA_DATA_N1);
    eval 'sub PIPEA_DATA_N1_OFFSET () {0;}' unless defined(&PIPEA_DATA_N1_OFFSET);
    eval 'sub PIPEA_DATA_M2 () {0x60038;}' unless defined(&PIPEA_DATA_M2);
    eval 'sub PIPEA_DATA_M2_OFFSET () {0;}' unless defined(&PIPEA_DATA_M2_OFFSET);
    eval 'sub PIPEA_DATA_N2 () {0x6003c;}' unless defined(&PIPEA_DATA_N2);
    eval 'sub PIPEA_DATA_N2_OFFSET () {0;}' unless defined(&PIPEA_DATA_N2_OFFSET);
    eval 'sub PIPEA_LINK_M1 () {0x60040;}' unless defined(&PIPEA_LINK_M1);
    eval 'sub PIPEA_LINK_M1_OFFSET () {0;}' unless defined(&PIPEA_LINK_M1_OFFSET);
    eval 'sub PIPEA_LINK_N1 () {0x60044;}' unless defined(&PIPEA_LINK_N1);
    eval 'sub PIPEA_LINK_N1_OFFSET () {0;}' unless defined(&PIPEA_LINK_N1_OFFSET);
    eval 'sub PIPEA_LINK_M2 () {0x60048;}' unless defined(&PIPEA_LINK_M2);
    eval 'sub PIPEA_LINK_M2_OFFSET () {0;}' unless defined(&PIPEA_LINK_M2_OFFSET);
    eval 'sub PIPEA_LINK_N2 () {0x6004c;}' unless defined(&PIPEA_LINK_N2);
    eval 'sub PIPEA_LINK_N2_OFFSET () {0;}' unless defined(&PIPEA_LINK_N2_OFFSET);
    eval 'sub PIPEB_DATA_M1 () {0x61030;}' unless defined(&PIPEB_DATA_M1);
    eval 'sub PIPEB_DATA_M1_OFFSET () {0;}' unless defined(&PIPEB_DATA_M1_OFFSET);
    eval 'sub PIPEB_DATA_N1 () {0x61034;}' unless defined(&PIPEB_DATA_N1);
    eval 'sub PIPEB_DATA_N1_OFFSET () {0;}' unless defined(&PIPEB_DATA_N1_OFFSET);
    eval 'sub PIPEB_DATA_M2 () {0x61038;}' unless defined(&PIPEB_DATA_M2);
    eval 'sub PIPEB_DATA_M2_OFFSET () {0;}' unless defined(&PIPEB_DATA_M2_OFFSET);
    eval 'sub PIPEB_DATA_N2 () {0x6103c;}' unless defined(&PIPEB_DATA_N2);
    eval 'sub PIPEB_DATA_N2_OFFSET () {0;}' unless defined(&PIPEB_DATA_N2_OFFSET);
    eval 'sub PIPEB_LINK_M1 () {0x61040;}' unless defined(&PIPEB_LINK_M1);
    eval 'sub PIPEB_LINK_M1_OFFSET () {0;}' unless defined(&PIPEB_LINK_M1_OFFSET);
    eval 'sub PIPEB_LINK_N1 () {0x61044;}' unless defined(&PIPEB_LINK_N1);
    eval 'sub PIPEB_LINK_N1_OFFSET () {0;}' unless defined(&PIPEB_LINK_N1_OFFSET);
    eval 'sub PIPEB_LINK_M2 () {0x61048;}' unless defined(&PIPEB_LINK_M2);
    eval 'sub PIPEB_LINK_M2_OFFSET () {0;}' unless defined(&PIPEB_LINK_M2_OFFSET);
    eval 'sub PIPEB_LINK_N2 () {0x6104c;}' unless defined(&PIPEB_LINK_N2);
    eval 'sub PIPEB_LINK_N2_OFFSET () {0;}' unless defined(&PIPEB_LINK_N2_OFFSET);
    eval 'sub PFA_CTL_1 () {0x68080;}' unless defined(&PFA_CTL_1);
    eval 'sub PFB_CTL_1 () {0x68880;}' unless defined(&PFB_CTL_1);
    eval 'sub PF_ENABLE () {(1<<31);}' unless defined(&PF_ENABLE);
    eval 'sub PF_FILTER_MASK () {(3<<23);}' unless defined(&PF_FILTER_MASK);
    eval 'sub PF_FILTER_PROGRAMMED () {(0<<23);}' unless defined(&PF_FILTER_PROGRAMMED);
    eval 'sub PF_FILTER_MED_3x3 () {(1<<23);}' unless defined(&PF_FILTER_MED_3x3);
    eval 'sub PF_FILTER_EDGE_ENHANCE () {(2<<23);}' unless defined(&PF_FILTER_EDGE_ENHANCE);
    eval 'sub PF_FILTER_EDGE_SOFTEN () {(3<<23);}' unless defined(&PF_FILTER_EDGE_SOFTEN);
    eval 'sub PFA_WIN_SZ () {0x68074;}' unless defined(&PFA_WIN_SZ);
    eval 'sub PFB_WIN_SZ () {0x68874;}' unless defined(&PFB_WIN_SZ);
    eval 'sub PFA_WIN_POS () {0x68070;}' unless defined(&PFA_WIN_POS);
    eval 'sub PFB_WIN_POS () {0x68870;}' unless defined(&PFB_WIN_POS);
    eval 'sub LGC_PALETTE_A () {0x4a000;}' unless defined(&LGC_PALETTE_A);
    eval 'sub LGC_PALETTE_B () {0x4a800;}' unless defined(&LGC_PALETTE_B);
    eval 'sub DE_MASTER_IRQ_CONTROL () {(1<< 31);}' unless defined(&DE_MASTER_IRQ_CONTROL);
    eval 'sub DE_SPRITEB_FLIP_DONE () {(1<< 29);}' unless defined(&DE_SPRITEB_FLIP_DONE);
    eval 'sub DE_SPRITEA_FLIP_DONE () {(1<< 28);}' unless defined(&DE_SPRITEA_FLIP_DONE);
    eval 'sub DE_PLANEB_FLIP_DONE () {(1<< 27);}' unless defined(&DE_PLANEB_FLIP_DONE);
    eval 'sub DE_PLANEA_FLIP_DONE () {(1<< 26);}' unless defined(&DE_PLANEA_FLIP_DONE);
    eval 'sub DE_PCU_EVENT () {(1<< 25);}' unless defined(&DE_PCU_EVENT);
    eval 'sub DE_GTT_FAULT () {(1<< 24);}' unless defined(&DE_GTT_FAULT);
    eval 'sub DE_POISON () {(1<< 23);}' unless defined(&DE_POISON);
    eval 'sub DE_PERFORM_COUNTER () {(1<< 22);}' unless defined(&DE_PERFORM_COUNTER);
    eval 'sub DE_PCH_EVENT () {(1<< 21);}' unless defined(&DE_PCH_EVENT);
    eval 'sub DE_AUX_CHANNEL_A () {(1<< 20);}' unless defined(&DE_AUX_CHANNEL_A);
    eval 'sub DE_DP_A_HOTPLUG () {(1<< 19);}' unless defined(&DE_DP_A_HOTPLUG);
    eval 'sub DE_GSE () {(1<< 18);}' unless defined(&DE_GSE);
    eval 'sub DE_PIPEB_VBLANK () {(1<< 15);}' unless defined(&DE_PIPEB_VBLANK);
    eval 'sub DE_PIPEB_EVEN_FIELD () {(1<< 14);}' unless defined(&DE_PIPEB_EVEN_FIELD);
    eval 'sub DE_PIPEB_ODD_FIELD () {(1<< 13);}' unless defined(&DE_PIPEB_ODD_FIELD);
    eval 'sub DE_PIPEB_LINE_COMPARE () {(1<< 12);}' unless defined(&DE_PIPEB_LINE_COMPARE);
    eval 'sub DE_PIPEB_VSYNC () {(1<< 11);}' unless defined(&DE_PIPEB_VSYNC);
    eval 'sub DE_PIPEB_FIFO_UNDERRUN () {(1<< 8);}' unless defined(&DE_PIPEB_FIFO_UNDERRUN);
    eval 'sub DE_PIPEA_VBLANK () {(1<< 7);}' unless defined(&DE_PIPEA_VBLANK);
    eval 'sub DE_PIPEA_EVEN_FIELD () {(1<< 6);}' unless defined(&DE_PIPEA_EVEN_FIELD);
    eval 'sub DE_PIPEA_ODD_FIELD () {(1<< 5);}' unless defined(&DE_PIPEA_ODD_FIELD);
    eval 'sub DE_PIPEA_LINE_COMPARE () {(1<< 4);}' unless defined(&DE_PIPEA_LINE_COMPARE);
    eval 'sub DE_PIPEA_VSYNC () {(1<< 3);}' unless defined(&DE_PIPEA_VSYNC);
    eval 'sub DE_PIPEA_FIFO_UNDERRUN () {(1<< 0);}' unless defined(&DE_PIPEA_FIFO_UNDERRUN);
    eval 'sub DEISR () {0x44000;}' unless defined(&DEISR);
    eval 'sub DEIMR () {0x44004;}' unless defined(&DEIMR);
    eval 'sub DEIIR () {0x44008;}' unless defined(&DEIIR);
    eval 'sub DEIER () {0x4400c;}' unless defined(&DEIER);
    eval 'sub GT_MASTER_ERROR () {(1<< 3);}' unless defined(&GT_MASTER_ERROR);
    eval 'sub GT_SYNC_STATUS () {(1<< 2);}' unless defined(&GT_SYNC_STATUS);
    eval 'sub GT_USER_INTERRUPT () {(1<< 0);}' unless defined(&GT_USER_INTERRUPT);
    eval 'sub GTISR () {0x44010;}' unless defined(&GTISR);
    eval 'sub GTIMR () {0x44014;}' unless defined(&GTIMR);
    eval 'sub GTIIR () {0x44018;}' unless defined(&GTIIR);
    eval 'sub GTIER () {0x4401c;}' unless defined(&GTIER);
    eval 'sub ILK_DISPLAY_CHICKEN2 () {0x42004;}' unless defined(&ILK_DISPLAY_CHICKEN2);
    eval 'sub ILK_DPARB_GATE () {(1<<22);}' unless defined(&ILK_DPARB_GATE);
    eval 'sub ILK_VSDPFD_FULL () {(1<<21);}' unless defined(&ILK_VSDPFD_FULL);
    eval 'sub ILK_DSPCLK_GATE () {0x42020;}' unless defined(&ILK_DSPCLK_GATE);
    eval 'sub ILK_DPARB_CLK_GATE () {(1<<5);}' unless defined(&ILK_DPARB_CLK_GATE);
    eval 'sub DISP_ARB_CTL () {0x45000;}' unless defined(&DISP_ARB_CTL);
    eval 'sub DISP_TILE_SURFACE_SWIZZLING () {(1<<13);}' unless defined(&DISP_TILE_SURFACE_SWIZZLING);
    eval 'sub DISP_FBC_WM_DIS () {(1<<15);}' unless defined(&DISP_FBC_WM_DIS);
    eval 'sub SDE_CRT_HOTPLUG () {(1<< 11);}' unless defined(&SDE_CRT_HOTPLUG);
    eval 'sub SDE_PORTD_HOTPLUG () {(1<< 10);}' unless defined(&SDE_PORTD_HOTPLUG);
    eval 'sub SDE_PORTC_HOTPLUG () {(1<< 9);}' unless defined(&SDE_PORTC_HOTPLUG);
    eval 'sub SDE_PORTB_HOTPLUG () {(1<< 8);}' unless defined(&SDE_PORTB_HOTPLUG);
    eval 'sub SDE_SDVOB_HOTPLUG () {(1<< 6);}' unless defined(&SDE_SDVOB_HOTPLUG);
    eval 'sub SDE_HOTPLUG_MASK () {(0xf << 8);}' unless defined(&SDE_HOTPLUG_MASK);
    eval 'sub SDE_CRT_HOTPLUG_CPT () {(1<< 19);}' unless defined(&SDE_CRT_HOTPLUG_CPT);
    eval 'sub SDE_PORTD_HOTPLUG_CPT () {(1<< 23);}' unless defined(&SDE_PORTD_HOTPLUG_CPT);
    eval 'sub SDE_PORTC_HOTPLUG_CPT () {(1<< 22);}' unless defined(&SDE_PORTC_HOTPLUG_CPT);
    eval 'sub SDE_PORTB_HOTPLUG_CPT () {(1<< 21);}' unless defined(&SDE_PORTB_HOTPLUG_CPT);
    eval 'sub SDEISR () {0xc4000;}' unless defined(&SDEISR);
    eval 'sub SDEIMR () {0xc4004;}' unless defined(&SDEIMR);
    eval 'sub SDEIIR () {0xc4008;}' unless defined(&SDEIIR);
    eval 'sub SDEIER () {0xc400c;}' unless defined(&SDEIER);
    eval 'sub PCH_PORT_HOTPLUG () {0xc4030;}' unless defined(&PCH_PORT_HOTPLUG);
    eval 'sub PORTD_HOTPLUG_ENABLE () {(1<< 20);}' unless defined(&PORTD_HOTPLUG_ENABLE);
    eval 'sub PORTD_PULSE_DURATION_2ms () {(0);}' unless defined(&PORTD_PULSE_DURATION_2ms);
    eval 'sub PORTD_PULSE_DURATION_4_5ms () {(1<< 18);}' unless defined(&PORTD_PULSE_DURATION_4_5ms);
    eval 'sub PORTD_PULSE_DURATION_6ms () {(2<< 18);}' unless defined(&PORTD_PULSE_DURATION_6ms);
    eval 'sub PORTD_PULSE_DURATION_100ms () {(3<< 18);}' unless defined(&PORTD_PULSE_DURATION_100ms);
    eval 'sub PORTD_HOTPLUG_NO_DETECT () {(0);}' unless defined(&PORTD_HOTPLUG_NO_DETECT);
    eval 'sub PORTD_HOTPLUG_SHORT_DETECT () {(1<< 16);}' unless defined(&PORTD_HOTPLUG_SHORT_DETECT);
    eval 'sub PORTD_HOTPLUG_LONG_DETECT () {(1<< 17);}' unless defined(&PORTD_HOTPLUG_LONG_DETECT);
    eval 'sub PORTC_HOTPLUG_ENABLE () {(1<< 12);}' unless defined(&PORTC_HOTPLUG_ENABLE);
    eval 'sub PORTC_PULSE_DURATION_2ms () {(0);}' unless defined(&PORTC_PULSE_DURATION_2ms);
    eval 'sub PORTC_PULSE_DURATION_4_5ms () {(1<< 10);}' unless defined(&PORTC_PULSE_DURATION_4_5ms);
    eval 'sub PORTC_PULSE_DURATION_6ms () {(2<< 10);}' unless defined(&PORTC_PULSE_DURATION_6ms);
    eval 'sub PORTC_PULSE_DURATION_100ms () {(3<< 10);}' unless defined(&PORTC_PULSE_DURATION_100ms);
    eval 'sub PORTC_HOTPLUG_NO_DETECT () {(0);}' unless defined(&PORTC_HOTPLUG_NO_DETECT);
    eval 'sub PORTC_HOTPLUG_SHORT_DETECT () {(1<< 8);}' unless defined(&PORTC_HOTPLUG_SHORT_DETECT);
    eval 'sub PORTC_HOTPLUG_LONG_DETECT () {(1<< 9);}' unless defined(&PORTC_HOTPLUG_LONG_DETECT);
    eval 'sub PORTB_HOTPLUG_ENABLE () {(1<< 4);}' unless defined(&PORTB_HOTPLUG_ENABLE);
    eval 'sub PORTB_PULSE_DURATION_2ms () {(0);}' unless defined(&PORTB_PULSE_DURATION_2ms);
    eval 'sub PORTB_PULSE_DURATION_4_5ms () {(1<< 2);}' unless defined(&PORTB_PULSE_DURATION_4_5ms);
    eval 'sub PORTB_PULSE_DURATION_6ms () {(2<< 2);}' unless defined(&PORTB_PULSE_DURATION_6ms);
    eval 'sub PORTB_PULSE_DURATION_100ms () {(3<< 2);}' unless defined(&PORTB_PULSE_DURATION_100ms);
    eval 'sub PORTB_HOTPLUG_NO_DETECT () {(0);}' unless defined(&PORTB_HOTPLUG_NO_DETECT);
    eval 'sub PORTB_HOTPLUG_SHORT_DETECT () {(1<< 0);}' unless defined(&PORTB_HOTPLUG_SHORT_DETECT);
    eval 'sub PORTB_HOTPLUG_LONG_DETECT () {(1<< 1);}' unless defined(&PORTB_HOTPLUG_LONG_DETECT);
    eval 'sub PCH_GPIOA () {0xc5010;}' unless defined(&PCH_GPIOA);
    eval 'sub PCH_GPIOB () {0xc5014;}' unless defined(&PCH_GPIOB);
    eval 'sub PCH_GPIOC () {0xc5018;}' unless defined(&PCH_GPIOC);
    eval 'sub PCH_GPIOD () {0xc501c;}' unless defined(&PCH_GPIOD);
    eval 'sub PCH_GPIOE () {0xc5020;}' unless defined(&PCH_GPIOE);
    eval 'sub PCH_GPIOF () {0xc5024;}' unless defined(&PCH_GPIOF);
    eval 'sub PCH_GMBUS0 () {0xc5100;}' unless defined(&PCH_GMBUS0);
    eval 'sub PCH_GMBUS1 () {0xc5104;}' unless defined(&PCH_GMBUS1);
    eval 'sub PCH_GMBUS2 () {0xc5108;}' unless defined(&PCH_GMBUS2);
    eval 'sub PCH_GMBUS3 () {0xc510c;}' unless defined(&PCH_GMBUS3);
    eval 'sub PCH_GMBUS4 () {0xc5110;}' unless defined(&PCH_GMBUS4);
    eval 'sub PCH_GMBUS5 () {0xc5120;}' unless defined(&PCH_GMBUS5);
    eval 'sub PCH_DPLL_A () {0xc6014;}' unless defined(&PCH_DPLL_A);
    eval 'sub PCH_DPLL_B () {0xc6018;}' unless defined(&PCH_DPLL_B);
    eval 'sub PCH_FPA0 () {0xc6040;}' unless defined(&PCH_FPA0);
    eval 'sub PCH_FPA1 () {0xc6044;}' unless defined(&PCH_FPA1);
    eval 'sub PCH_FPB0 () {0xc6048;}' unless defined(&PCH_FPB0);
    eval 'sub PCH_FPB1 () {0xc604c;}' unless defined(&PCH_FPB1);
    eval 'sub PCH_DPLL_TEST () {0xc606c;}' unless defined(&PCH_DPLL_TEST);
    eval 'sub PCH_DREF_CONTROL () {0xc6200;}' unless defined(&PCH_DREF_CONTROL);
    eval 'sub DREF_CONTROL_MASK () {0x7fc3;}' unless defined(&DREF_CONTROL_MASK);
    eval 'sub DREF_CPU_SOURCE_OUTPUT_DISABLE () {(0<<13);}' unless defined(&DREF_CPU_SOURCE_OUTPUT_DISABLE);
    eval 'sub DREF_CPU_SOURCE_OUTPUT_DOWNSPREAD () {(2<<13);}' unless defined(&DREF_CPU_SOURCE_OUTPUT_DOWNSPREAD);
    eval 'sub DREF_CPU_SOURCE_OUTPUT_NONSPREAD () {(3<<13);}' unless defined(&DREF_CPU_SOURCE_OUTPUT_NONSPREAD);
    eval 'sub DREF_CPU_SOURCE_OUTPUT_MASK () {(3<<13);}' unless defined(&DREF_CPU_SOURCE_OUTPUT_MASK);
    eval 'sub DREF_SSC_SOURCE_DISABLE () {(0<<11);}' unless defined(&DREF_SSC_SOURCE_DISABLE);
    eval 'sub DREF_SSC_SOURCE_ENABLE () {(2<<11);}' unless defined(&DREF_SSC_SOURCE_ENABLE);
    eval 'sub DREF_SSC_SOURCE_MASK () {(3<<11);}' unless defined(&DREF_SSC_SOURCE_MASK);
    eval 'sub DREF_NONSPREAD_SOURCE_DISABLE () {(0<<9);}' unless defined(&DREF_NONSPREAD_SOURCE_DISABLE);
    eval 'sub DREF_NONSPREAD_CK505_ENABLE () {(1<<9);}' unless defined(&DREF_NONSPREAD_CK505_ENABLE);
    eval 'sub DREF_NONSPREAD_SOURCE_ENABLE () {(2<<9);}' unless defined(&DREF_NONSPREAD_SOURCE_ENABLE);
    eval 'sub DREF_NONSPREAD_SOURCE_MASK () {(3<<9);}' unless defined(&DREF_NONSPREAD_SOURCE_MASK);
    eval 'sub DREF_SUPERSPREAD_SOURCE_DISABLE () {(0<<7);}' unless defined(&DREF_SUPERSPREAD_SOURCE_DISABLE);
    eval 'sub DREF_SUPERSPREAD_SOURCE_ENABLE () {(2<<7);}' unless defined(&DREF_SUPERSPREAD_SOURCE_ENABLE);
    eval 'sub DREF_SSC4_DOWNSPREAD () {(0<<6);}' unless defined(&DREF_SSC4_DOWNSPREAD);
    eval 'sub DREF_SSC4_CENTERSPREAD () {(1<<6);}' unless defined(&DREF_SSC4_CENTERSPREAD);
    eval 'sub DREF_SSC1_DISABLE () {(0<<1);}' unless defined(&DREF_SSC1_DISABLE);
    eval 'sub DREF_SSC1_ENABLE () {(1<<1);}' unless defined(&DREF_SSC1_ENABLE);
    eval 'sub DREF_SSC4_DISABLE () {(0);}' unless defined(&DREF_SSC4_DISABLE);
    eval 'sub DREF_SSC4_ENABLE () {(1);}' unless defined(&DREF_SSC4_ENABLE);
    eval 'sub PCH_RAWCLK_FREQ () {0xc6204;}' unless defined(&PCH_RAWCLK_FREQ);
    eval 'sub FDL_TP1_TIMER_SHIFT () {12;}' unless defined(&FDL_TP1_TIMER_SHIFT);
    eval 'sub FDL_TP1_TIMER_MASK () {(3<<12);}' unless defined(&FDL_TP1_TIMER_MASK);
    eval 'sub FDL_TP2_TIMER_SHIFT () {10;}' unless defined(&FDL_TP2_TIMER_SHIFT);
    eval 'sub FDL_TP2_TIMER_MASK () {(3<<10);}' unless defined(&FDL_TP2_TIMER_MASK);
    eval 'sub RAWCLK_FREQ_MASK () {0x3ff;}' unless defined(&RAWCLK_FREQ_MASK);
    eval 'sub PCH_DPLL_TMR_CFG () {0xc6208;}' unless defined(&PCH_DPLL_TMR_CFG);
    eval 'sub PCH_SSC4_PARMS () {0xc6210;}' unless defined(&PCH_SSC4_PARMS);
    eval 'sub PCH_SSC4_AUX_PARMS () {0xc6214;}' unless defined(&PCH_SSC4_AUX_PARMS);
    eval 'sub PCH_DPLL_SEL () {0xc7000;}' unless defined(&PCH_DPLL_SEL);
    eval 'sub TRANSA_DPLL_ENABLE () {(1<<3);}' unless defined(&TRANSA_DPLL_ENABLE);
    eval 'sub TRANSA_DPLLB_SEL () {(1<<0);}' unless defined(&TRANSA_DPLLB_SEL);
    eval 'sub TRANSA_DPLLA_SEL () {0;}' unless defined(&TRANSA_DPLLA_SEL);
    eval 'sub TRANSB_DPLL_ENABLE () {(1<<7);}' unless defined(&TRANSB_DPLL_ENABLE);
    eval 'sub TRANSB_DPLLB_SEL () {(1<<4);}' unless defined(&TRANSB_DPLLB_SEL);
    eval 'sub TRANSB_DPLLA_SEL () {(0);}' unless defined(&TRANSB_DPLLA_SEL);
    eval 'sub TRANSC_DPLL_ENABLE () {(1<<11);}' unless defined(&TRANSC_DPLL_ENABLE);
    eval 'sub TRANSC_DPLLB_SEL () {(1<<8);}' unless defined(&TRANSC_DPLLB_SEL);
    eval 'sub TRANSC_DPLLA_SEL () {(0);}' unless defined(&TRANSC_DPLLA_SEL);
    eval 'sub TRANS_HTOTAL_A () {0xe0000;}' unless defined(&TRANS_HTOTAL_A);
    eval 'sub TRANS_HTOTAL_SHIFT () {16;}' unless defined(&TRANS_HTOTAL_SHIFT);
    eval 'sub TRANS_HACTIVE_SHIFT () {0;}' unless defined(&TRANS_HACTIVE_SHIFT);
    eval 'sub TRANS_HBLANK_A () {0xe0004;}' unless defined(&TRANS_HBLANK_A);
    eval 'sub TRANS_HBLANK_END_SHIFT () {16;}' unless defined(&TRANS_HBLANK_END_SHIFT);
    eval 'sub TRANS_HBLANK_START_SHIFT () {0;}' unless defined(&TRANS_HBLANK_START_SHIFT);
    eval 'sub TRANS_HSYNC_A () {0xe0008;}' unless defined(&TRANS_HSYNC_A);
    eval 'sub TRANS_HSYNC_END_SHIFT () {16;}' unless defined(&TRANS_HSYNC_END_SHIFT);
    eval 'sub TRANS_HSYNC_START_SHIFT () {0;}' unless defined(&TRANS_HSYNC_START_SHIFT);
    eval 'sub TRANS_VTOTAL_A () {0xe000c;}' unless defined(&TRANS_VTOTAL_A);
    eval 'sub TRANS_VTOTAL_SHIFT () {16;}' unless defined(&TRANS_VTOTAL_SHIFT);
    eval 'sub TRANS_VACTIVE_SHIFT () {0;}' unless defined(&TRANS_VACTIVE_SHIFT);
    eval 'sub TRANS_VBLANK_A () {0xe0010;}' unless defined(&TRANS_VBLANK_A);
    eval 'sub TRANS_VBLANK_END_SHIFT () {16;}' unless defined(&TRANS_VBLANK_END_SHIFT);
    eval 'sub TRANS_VBLANK_START_SHIFT () {0;}' unless defined(&TRANS_VBLANK_START_SHIFT);
    eval 'sub TRANS_VSYNC_A () {0xe0014;}' unless defined(&TRANS_VSYNC_A);
    eval 'sub TRANS_VSYNC_END_SHIFT () {16;}' unless defined(&TRANS_VSYNC_END_SHIFT);
    eval 'sub TRANS_VSYNC_START_SHIFT () {0;}' unless defined(&TRANS_VSYNC_START_SHIFT);
    eval 'sub TRANSA_DATA_M1 () {0xe0030;}' unless defined(&TRANSA_DATA_M1);
    eval 'sub TRANSA_DATA_N1 () {0xe0034;}' unless defined(&TRANSA_DATA_N1);
    eval 'sub TRANSA_DATA_M2 () {0xe0038;}' unless defined(&TRANSA_DATA_M2);
    eval 'sub TRANSA_DATA_N2 () {0xe003c;}' unless defined(&TRANSA_DATA_N2);
    eval 'sub TRANSA_DP_LINK_M1 () {0xe0040;}' unless defined(&TRANSA_DP_LINK_M1);
    eval 'sub TRANSA_DP_LINK_N1 () {0xe0044;}' unless defined(&TRANSA_DP_LINK_N1);
    eval 'sub TRANSA_DP_LINK_M2 () {0xe0048;}' unless defined(&TRANSA_DP_LINK_M2);
    eval 'sub TRANSA_DP_LINK_N2 () {0xe004c;}' unless defined(&TRANSA_DP_LINK_N2);
    eval 'sub TRANS_HTOTAL_B () {0xe1000;}' unless defined(&TRANS_HTOTAL_B);
    eval 'sub TRANS_HBLANK_B () {0xe1004;}' unless defined(&TRANS_HBLANK_B);
    eval 'sub TRANS_HSYNC_B () {0xe1008;}' unless defined(&TRANS_HSYNC_B);
    eval 'sub TRANS_VTOTAL_B () {0xe100c;}' unless defined(&TRANS_VTOTAL_B);
    eval 'sub TRANS_VBLANK_B () {0xe1010;}' unless defined(&TRANS_VBLANK_B);
    eval 'sub TRANS_VSYNC_B () {0xe1014;}' unless defined(&TRANS_VSYNC_B);
    eval 'sub TRANSB_DATA_M1 () {0xe1030;}' unless defined(&TRANSB_DATA_M1);
    eval 'sub TRANSB_DATA_N1 () {0xe1034;}' unless defined(&TRANSB_DATA_N1);
    eval 'sub TRANSB_DATA_M2 () {0xe1038;}' unless defined(&TRANSB_DATA_M2);
    eval 'sub TRANSB_DATA_N2 () {0xe103c;}' unless defined(&TRANSB_DATA_N2);
    eval 'sub TRANSB_DP_LINK_M1 () {0xe1040;}' unless defined(&TRANSB_DP_LINK_M1);
    eval 'sub TRANSB_DP_LINK_N1 () {0xe1044;}' unless defined(&TRANSB_DP_LINK_N1);
    eval 'sub TRANSB_DP_LINK_M2 () {0xe1048;}' unless defined(&TRANSB_DP_LINK_M2);
    eval 'sub TRANSB_DP_LINK_N2 () {0xe104c;}' unless defined(&TRANSB_DP_LINK_N2);
    eval 'sub TRANSACONF () {0xf0008;}' unless defined(&TRANSACONF);
    eval 'sub TRANSBCONF () {0xf1008;}' unless defined(&TRANSBCONF);
    eval 'sub TRANS_DISABLE () {(0<<31);}' unless defined(&TRANS_DISABLE);
    eval 'sub TRANS_ENABLE () {(1<<31);}' unless defined(&TRANS_ENABLE);
    eval 'sub TRANS_STATE_MASK () {(1<<30);}' unless defined(&TRANS_STATE_MASK);
    eval 'sub TRANS_STATE_DISABLE () {(0<<30);}' unless defined(&TRANS_STATE_DISABLE);
    eval 'sub TRANS_STATE_ENABLE () {(1<<30);}' unless defined(&TRANS_STATE_ENABLE);
    eval 'sub TRANS_FSYNC_DELAY_HB1 () {(0<<27);}' unless defined(&TRANS_FSYNC_DELAY_HB1);
    eval 'sub TRANS_FSYNC_DELAY_HB2 () {(1<<27);}' unless defined(&TRANS_FSYNC_DELAY_HB2);
    eval 'sub TRANS_FSYNC_DELAY_HB3 () {(2<<27);}' unless defined(&TRANS_FSYNC_DELAY_HB3);
    eval 'sub TRANS_FSYNC_DELAY_HB4 () {(3<<27);}' unless defined(&TRANS_FSYNC_DELAY_HB4);
    eval 'sub TRANS_DP_AUDIO_ONLY () {(1<<26);}' unless defined(&TRANS_DP_AUDIO_ONLY);
    eval 'sub TRANS_DP_VIDEO_AUDIO () {(0<<26);}' unless defined(&TRANS_DP_VIDEO_AUDIO);
    eval 'sub TRANS_PROGRESSIVE () {(0<<21);}' unless defined(&TRANS_PROGRESSIVE);
    eval 'sub TRANS_8BPC () {(0<<5);}' unless defined(&TRANS_8BPC);
    eval 'sub TRANS_10BPC () {(1<<5);}' unless defined(&TRANS_10BPC);
    eval 'sub TRANS_6BPC () {(2<<5);}' unless defined(&TRANS_6BPC);
    eval 'sub TRANS_12BPC () {(3<<5);}' unless defined(&TRANS_12BPC);
    eval 'sub FDI_RXA_CHICKEN () {0xc200c;}' unless defined(&FDI_RXA_CHICKEN);
    eval 'sub FDI_RXB_CHICKEN () {0xc2010;}' unless defined(&FDI_RXB_CHICKEN);
    eval 'sub FDI_RX_PHASE_SYNC_POINTER_ENABLE () {(1);}' unless defined(&FDI_RX_PHASE_SYNC_POINTER_ENABLE);
    eval 'sub FDI_TXA_CTL () {0x60100;}' unless defined(&FDI_TXA_CTL);
    eval 'sub FDI_TXB_CTL () {0x61100;}' unless defined(&FDI_TXB_CTL);
    eval 'sub FDI_TX_DISABLE () {(0<<31);}' unless defined(&FDI_TX_DISABLE);
    eval 'sub FDI_TX_ENABLE () {(1<<31);}' unless defined(&FDI_TX_ENABLE);
    eval 'sub FDI_LINK_TRAIN_PATTERN_1 () {(0<<28);}' unless defined(&FDI_LINK_TRAIN_PATTERN_1);
    eval 'sub FDI_LINK_TRAIN_PATTERN_2 () {(1<<28);}' unless defined(&FDI_LINK_TRAIN_PATTERN_2);
    eval 'sub FDI_LINK_TRAIN_PATTERN_IDLE () {(2<<28);}' unless defined(&FDI_LINK_TRAIN_PATTERN_IDLE);
    eval 'sub FDI_LINK_TRAIN_NONE () {(3<<28);}' unless defined(&FDI_LINK_TRAIN_NONE);
    eval 'sub FDI_LINK_TRAIN_VOLTAGE_0_4V () {(0<<25);}' unless defined(&FDI_LINK_TRAIN_VOLTAGE_0_4V);
    eval 'sub FDI_LINK_TRAIN_VOLTAGE_0_6V () {(1<<25);}' unless defined(&FDI_LINK_TRAIN_VOLTAGE_0_6V);
    eval 'sub FDI_LINK_TRAIN_VOLTAGE_0_8V () {(2<<25);}' unless defined(&FDI_LINK_TRAIN_VOLTAGE_0_8V);
    eval 'sub FDI_LINK_TRAIN_VOLTAGE_1_2V () {(3<<25);}' unless defined(&FDI_LINK_TRAIN_VOLTAGE_1_2V);
    eval 'sub FDI_LINK_TRAIN_PRE_EMPHASIS_NONE () {(0<<22);}' unless defined(&FDI_LINK_TRAIN_PRE_EMPHASIS_NONE);
    eval 'sub FDI_LINK_TRAIN_PRE_EMPHASIS_1_5X () {(1<<22);}' unless defined(&FDI_LINK_TRAIN_PRE_EMPHASIS_1_5X);
    eval 'sub FDI_LINK_TRAIN_PRE_EMPHASIS_2X () {(2<<22);}' unless defined(&FDI_LINK_TRAIN_PRE_EMPHASIS_2X);
    eval 'sub FDI_LINK_TRAIN_PRE_EMPHASIS_3X () {(3<<22);}' unless defined(&FDI_LINK_TRAIN_PRE_EMPHASIS_3X);
    eval 'sub FDI_LINK_TRAIN_400MV_0DB_SNB_A () {(0x38<<22);}' unless defined(&FDI_LINK_TRAIN_400MV_0DB_SNB_A);
    eval 'sub FDI_LINK_TRAIN_400MV_6DB_SNB_A () {(0x2<<22);}' unless defined(&FDI_LINK_TRAIN_400MV_6DB_SNB_A);
    eval 'sub FDI_LINK_TRAIN_600MV_3_5DB_SNB_A () {(0x1<<22);}' unless defined(&FDI_LINK_TRAIN_600MV_3_5DB_SNB_A);
    eval 'sub FDI_LINK_TRAIN_800MV_0DB_SNB_A () {(0x<<22);}' unless defined(&FDI_LINK_TRAIN_800MV_0DB_SNB_A);
    eval 'sub FDI_LINK_TRAIN_400MV_0DB_SNB_B () {(0x<<22);}' unless defined(&FDI_LINK_TRAIN_400MV_0DB_SNB_B);
    eval 'sub FDI_LINK_TRAIN_400MV_6DB_SNB_B () {(0x3a<<22);}' unless defined(&FDI_LINK_TRAIN_400MV_6DB_SNB_B);
    eval 'sub FDI_LINK_TRAIN_600MV_3_5DB_SNB_B () {(0x39<<22);}' unless defined(&FDI_LINK_TRAIN_600MV_3_5DB_SNB_B);
    eval 'sub FDI_LINK_TRAIN_800MV_0DB_SNB_B () {(0x38<<22);}' unless defined(&FDI_LINK_TRAIN_800MV_0DB_SNB_B);
    eval 'sub FDI_LINK_TRAIN_VOL_EMP_MASK () {(0x3f<<22);}' unless defined(&FDI_LINK_TRAIN_VOL_EMP_MASK);
    eval 'sub FDI_DP_PORT_WIDTH_X1 () {(0<<19);}' unless defined(&FDI_DP_PORT_WIDTH_X1);
    eval 'sub FDI_DP_PORT_WIDTH_X2 () {(1<<19);}' unless defined(&FDI_DP_PORT_WIDTH_X2);
    eval 'sub FDI_DP_PORT_WIDTH_X3 () {(2<<19);}' unless defined(&FDI_DP_PORT_WIDTH_X3);
    eval 'sub FDI_DP_PORT_WIDTH_X4 () {(3<<19);}' unless defined(&FDI_DP_PORT_WIDTH_X4);
    eval 'sub FDI_TX_ENHANCE_FRAME_ENABLE () {(1<<18);}' unless defined(&FDI_TX_ENHANCE_FRAME_ENABLE);
    eval 'sub FDI_TX_PLL_ENABLE () {(1<<14);}' unless defined(&FDI_TX_PLL_ENABLE);
    eval 'sub FDI_SCRAMBLING_ENABLE () {(0<<7);}' unless defined(&FDI_SCRAMBLING_ENABLE);
    eval 'sub FDI_SCRAMBLING_DISABLE () {(1<<7);}' unless defined(&FDI_SCRAMBLING_DISABLE);
    eval 'sub FDI_RXA_CTL () {0xf000c;}' unless defined(&FDI_RXA_CTL);
    eval 'sub FDI_RXB_CTL () {0xf100c;}' unless defined(&FDI_RXB_CTL);
    eval 'sub FDI_RX_ENABLE () {(1<<31);}' unless defined(&FDI_RX_ENABLE);
    eval 'sub FDI_RX_DISABLE () {(0<<31);}' unless defined(&FDI_RX_DISABLE);
    eval 'sub FDI_DP_PORT_WIDTH_X8 () {(7<<19);}' unless defined(&FDI_DP_PORT_WIDTH_X8);
    eval 'sub FDI_8BPC () {(0<<16);}' unless defined(&FDI_8BPC);
    eval 'sub FDI_10BPC () {(1<<16);}' unless defined(&FDI_10BPC);
    eval 'sub FDI_6BPC () {(2<<16);}' unless defined(&FDI_6BPC);
    eval 'sub FDI_12BPC () {(3<<16);}' unless defined(&FDI_12BPC);
    eval 'sub FDI_LINK_REVERSE_OVERWRITE () {(1<<15);}' unless defined(&FDI_LINK_REVERSE_OVERWRITE);
    eval 'sub FDI_DMI_LINK_REVERSE_MASK () {(1<<14);}' unless defined(&FDI_DMI_LINK_REVERSE_MASK);
    eval 'sub FDI_RX_PLL_ENABLE () {(1<<13);}' unless defined(&FDI_RX_PLL_ENABLE);
    eval 'sub FDI_FS_ERR_CORRECT_ENABLE () {(1<<11);}' unless defined(&FDI_FS_ERR_CORRECT_ENABLE);
    eval 'sub FDI_FE_ERR_CORRECT_ENABLE () {(1<<10);}' unless defined(&FDI_FE_ERR_CORRECT_ENABLE);
    eval 'sub FDI_FS_ERR_REPORT_ENABLE () {(1<<9);}' unless defined(&FDI_FS_ERR_REPORT_ENABLE);
    eval 'sub FDI_FE_ERR_REPORT_ENABLE () {(1<<8);}' unless defined(&FDI_FE_ERR_REPORT_ENABLE);
    eval 'sub FDI_RX_ENHANCE_FRAME_ENABLE () {(1<<6);}' unless defined(&FDI_RX_ENHANCE_FRAME_ENABLE);
    eval 'sub FDI_SEL_RAWCLK () {(0<<4);}' unless defined(&FDI_SEL_RAWCLK);
    eval 'sub FDI_SEL_PCDCLK () {(1<<4);}' unless defined(&FDI_SEL_PCDCLK);
    eval 'sub FDI_AUTO_TRAINING () {(1<<10);}' unless defined(&FDI_AUTO_TRAINING);
    eval 'sub FDI_LINK_TRAIN_PATTERN_1_CPT () {(0<<8);}' unless defined(&FDI_LINK_TRAIN_PATTERN_1_CPT);
    eval 'sub FDI_LINK_TRAIN_PATTERN_2_CPT () {(1<<8);}' unless defined(&FDI_LINK_TRAIN_PATTERN_2_CPT);
    eval 'sub FDI_LINK_TRAIN_PATTERN_IDLE_CPT () {(2<<8);}' unless defined(&FDI_LINK_TRAIN_PATTERN_IDLE_CPT);
    eval 'sub FDI_LINK_TRAIN_NORMAL_CPT () {(3<<8);}' unless defined(&FDI_LINK_TRAIN_NORMAL_CPT);
    eval 'sub FDI_LINK_TRAIN_PATTERN_MASK_CPT () {(3<<8);}' unless defined(&FDI_LINK_TRAIN_PATTERN_MASK_CPT);
    eval 'sub FDI_RXA_MISC () {0xf0010;}' unless defined(&FDI_RXA_MISC);
    eval 'sub FDI_RXB_MISC () {0xf1010;}' unless defined(&FDI_RXB_MISC);
    eval 'sub FDI_RXA_TUSIZE1 () {0xf0030;}' unless defined(&FDI_RXA_TUSIZE1);
    eval 'sub FDI_RXA_TUSIZE2 () {0xf0038;}' unless defined(&FDI_RXA_TUSIZE2);
    eval 'sub FDI_RXB_TUSIZE1 () {0xf1030;}' unless defined(&FDI_RXB_TUSIZE1);
    eval 'sub FDI_RXB_TUSIZE2 () {0xf1038;}' unless defined(&FDI_RXB_TUSIZE2);
    eval 'sub FDI_RX_INTER_LANE_ALIGN () {(1<<10);}' unless defined(&FDI_RX_INTER_LANE_ALIGN);
    eval 'sub FDI_RX_SYMBOL_LOCK () {(1<<9);}' unless defined(&FDI_RX_SYMBOL_LOCK);
    eval 'sub FDI_RX_BIT_LOCK () {(1<<8);}' unless defined(&FDI_RX_BIT_LOCK);
    eval 'sub FDI_RX_TRAIN_PATTERN_2_FAIL () {(1<<7);}' unless defined(&FDI_RX_TRAIN_PATTERN_2_FAIL);
    eval 'sub FDI_RX_FS_CODE_ERR () {(1<<6);}' unless defined(&FDI_RX_FS_CODE_ERR);
    eval 'sub FDI_RX_FE_CODE_ERR () {(1<<5);}' unless defined(&FDI_RX_FE_CODE_ERR);
    eval 'sub FDI_RX_SYMBOL_ERR_RATE_ABOVE () {(1<<4);}' unless defined(&FDI_RX_SYMBOL_ERR_RATE_ABOVE);
    eval 'sub FDI_RX_HDCP_LINK_FAIL () {(1<<3);}' unless defined(&FDI_RX_HDCP_LINK_FAIL);
    eval 'sub FDI_RX_PIXEL_FIFO_OVERFLOW () {(1<<2);}' unless defined(&FDI_RX_PIXEL_FIFO_OVERFLOW);
    eval 'sub FDI_RX_CROSS_CLOCK_OVERFLOW () {(1<<1);}' unless defined(&FDI_RX_CROSS_CLOCK_OVERFLOW);
    eval 'sub FDI_RX_SYMBOL_QUEUE_OVERFLOW () {(1<<0);}' unless defined(&FDI_RX_SYMBOL_QUEUE_OVERFLOW);
    eval 'sub FDI_RXA_IIR () {0xf0014;}' unless defined(&FDI_RXA_IIR);
    eval 'sub FDI_RXA_IMR () {0xf0018;}' unless defined(&FDI_RXA_IMR);
    eval 'sub FDI_RXB_IIR () {0xf1014;}' unless defined(&FDI_RXB_IIR);
    eval 'sub FDI_RXB_IMR () {0xf1018;}' unless defined(&FDI_RXB_IMR);
    eval 'sub FDI_PLL_CTL_1 () {0xfe000;}' unless defined(&FDI_PLL_CTL_1);
    eval 'sub FDI_PLL_CTL_2 () {0xfe004;}' unless defined(&FDI_PLL_CTL_2);
    eval 'sub PCH_ADPA () {0xe1100;}' unless defined(&PCH_ADPA);
    eval 'sub ADPA_TRANS_SELECT_MASK () {(1<<30);}' unless defined(&ADPA_TRANS_SELECT_MASK);
    eval 'sub ADPA_TRANS_A_SELECT () {0;}' unless defined(&ADPA_TRANS_A_SELECT);
    eval 'sub ADPA_TRANS_B_SELECT () {(1<<30);}' unless defined(&ADPA_TRANS_B_SELECT);
    eval 'sub ADPA_CRT_HOTPLUG_MASK () {0x3ff0000;}' unless defined(&ADPA_CRT_HOTPLUG_MASK);
    eval 'sub ADPA_CRT_HOTPLUG_MONITOR_NONE () {(0<<24);}' unless defined(&ADPA_CRT_HOTPLUG_MONITOR_NONE);
    eval 'sub ADPA_CRT_HOTPLUG_MONITOR_MASK () {(3<<24);}' unless defined(&ADPA_CRT_HOTPLUG_MONITOR_MASK);
    eval 'sub ADPA_CRT_HOTPLUG_MONITOR_COLOR () {(3<<24);}' unless defined(&ADPA_CRT_HOTPLUG_MONITOR_COLOR);
    eval 'sub ADPA_CRT_HOTPLUG_MONITOR_MONO () {(2<<24);}' unless defined(&ADPA_CRT_HOTPLUG_MONITOR_MONO);
    eval 'sub ADPA_CRT_HOTPLUG_ENABLE () {(1<<23);}' unless defined(&ADPA_CRT_HOTPLUG_ENABLE);
    eval 'sub ADPA_CRT_HOTPLUG_PERIOD_64 () {(0<<22);}' unless defined(&ADPA_CRT_HOTPLUG_PERIOD_64);
    eval 'sub ADPA_CRT_HOTPLUG_PERIOD_128 () {(1<<22);}' unless defined(&ADPA_CRT_HOTPLUG_PERIOD_128);
    eval 'sub ADPA_CRT_HOTPLUG_WARMUP_5MS () {(0<<21);}' unless defined(&ADPA_CRT_HOTPLUG_WARMUP_5MS);
    eval 'sub ADPA_CRT_HOTPLUG_WARMUP_10MS () {(1<<21);}' unless defined(&ADPA_CRT_HOTPLUG_WARMUP_10MS);
    eval 'sub ADPA_CRT_HOTPLUG_SAMPLE_2S () {(0<<20);}' unless defined(&ADPA_CRT_HOTPLUG_SAMPLE_2S);
    eval 'sub ADPA_CRT_HOTPLUG_SAMPLE_4S () {(1<<20);}' unless defined(&ADPA_CRT_HOTPLUG_SAMPLE_4S);
    eval 'sub ADPA_CRT_HOTPLUG_VOLTAGE_40 () {(0<<18);}' unless defined(&ADPA_CRT_HOTPLUG_VOLTAGE_40);
    eval 'sub ADPA_CRT_HOTPLUG_VOLTAGE_50 () {(1<<18);}' unless defined(&ADPA_CRT_HOTPLUG_VOLTAGE_50);
    eval 'sub ADPA_CRT_HOTPLUG_VOLTAGE_60 () {(2<<18);}' unless defined(&ADPA_CRT_HOTPLUG_VOLTAGE_60);
    eval 'sub ADPA_CRT_HOTPLUG_VOLTAGE_70 () {(3<<18);}' unless defined(&ADPA_CRT_HOTPLUG_VOLTAGE_70);
    eval 'sub ADPA_CRT_HOTPLUG_VOLREF_325MV () {(0<<17);}' unless defined(&ADPA_CRT_HOTPLUG_VOLREF_325MV);
    eval 'sub ADPA_CRT_HOTPLUG_VOLREF_475MV () {(1<<17);}' unless defined(&ADPA_CRT_HOTPLUG_VOLREF_475MV);
    eval 'sub ADPA_CRT_HOTPLUG_FORCE_TRIGGER () {(1<<16);}' unless defined(&ADPA_CRT_HOTPLUG_FORCE_TRIGGER);
    eval 'sub HDMIB () {0xe1140;}' unless defined(&HDMIB);
    eval 'sub PORT_ENABLE () {(1<< 31);}' unless defined(&PORT_ENABLE);
    eval 'sub TRANSCODER_A () {(0);}' unless defined(&TRANSCODER_A);
    eval 'sub TRANSCODER_B () {(1<< 30);}' unless defined(&TRANSCODER_B);
    eval 'sub COLOR_FORMAT_8bpc () {(0);}' unless defined(&COLOR_FORMAT_8bpc);
    eval 'sub COLOR_FORMAT_12bpc () {(3<< 26);}' unless defined(&COLOR_FORMAT_12bpc);
    eval 'sub SDVOB_HOTPLUG_ENABLE () {(1<< 23);}' unless defined(&SDVOB_HOTPLUG_ENABLE);
    eval 'sub SDVO_ENCODING () {(0);}' unless defined(&SDVO_ENCODING);
    eval 'sub TMDS_ENCODING () {(2<< 10);}' unless defined(&TMDS_ENCODING);
    eval 'sub NULL_PACKET_VSYNC_ENABLE () {(1<< 9);}' unless defined(&NULL_PACKET_VSYNC_ENABLE);
    eval 'sub SDVOB_BORDER_ENABLE () {(1<< 7);}' unless defined(&SDVOB_BORDER_ENABLE);
    eval 'sub AUDIO_ENABLE () {(1<< 6);}' unless defined(&AUDIO_ENABLE);
    eval 'sub VSYNC_ACTIVE_HIGH () {(1<< 4);}' unless defined(&VSYNC_ACTIVE_HIGH);
    eval 'sub HSYNC_ACTIVE_HIGH () {(1<< 3);}' unless defined(&HSYNC_ACTIVE_HIGH);
    eval 'sub PORT_DETECTED () {(1<< 2);}' unless defined(&PORT_DETECTED);
    eval 'sub PCH_SDVOB () { &HDMIB;}' unless defined(&PCH_SDVOB);
    eval 'sub HDMIC () {0xe1150;}' unless defined(&HDMIC);
    eval 'sub HDMID () {0xe1160;}' unless defined(&HDMID);
    eval 'sub PCH_LVDS () {0xe1180;}' unless defined(&PCH_LVDS);
    eval 'sub LVDS_DETECTED () {(1<< 1);}' unless defined(&LVDS_DETECTED);
    eval 'sub BLC_PWM_CPU_CTL2 () {0x48250;}' unless defined(&BLC_PWM_CPU_CTL2);
    eval 'sub PWM_ENABLE () {(1<< 31);}' unless defined(&PWM_ENABLE);
    eval 'sub PWM_PIPE_A () {(0<< 29);}' unless defined(&PWM_PIPE_A);
    eval 'sub PWM_PIPE_B () {(1<< 29);}' unless defined(&PWM_PIPE_B);
    eval 'sub BLC_PWM_CPU_CTL () {0x48254;}' unless defined(&BLC_PWM_CPU_CTL);
    eval 'sub BLC_PWM_PCH_CTL1 () {0xc8250;}' unless defined(&BLC_PWM_PCH_CTL1);
    eval 'sub PWM_PCH_ENABLE () {(1<< 31);}' unless defined(&PWM_PCH_ENABLE);
    eval 'sub PWM_POLARITY_ACTIVE_LOW () {(1<< 29);}' unless defined(&PWM_POLARITY_ACTIVE_LOW);
    eval 'sub PWM_POLARITY_ACTIVE_HIGH () {(0<< 29);}' unless defined(&PWM_POLARITY_ACTIVE_HIGH);
    eval 'sub PWM_POLARITY_ACTIVE_LOW2 () {(1<< 28);}' unless defined(&PWM_POLARITY_ACTIVE_LOW2);
    eval 'sub PWM_POLARITY_ACTIVE_HIGH2 () {(0<< 28);}' unless defined(&PWM_POLARITY_ACTIVE_HIGH2);
    eval 'sub BLC_PWM_PCH_CTL2 () {0xc8254;}' unless defined(&BLC_PWM_PCH_CTL2);
    eval 'sub PCH_PP_STATUS () {0xc7200;}' unless defined(&PCH_PP_STATUS);
    eval 'sub PCH_PP_CONTROL () {0xc7204;}' unless defined(&PCH_PP_CONTROL);
    eval 'sub EDP_FORCE_VDD () {(1<< 3);}' unless defined(&EDP_FORCE_VDD);
    eval 'sub EDP_BLC_ENABLE () {(1<< 2);}' unless defined(&EDP_BLC_ENABLE);
    eval 'sub PANEL_POWER_RESET () {(1<< 1);}' unless defined(&PANEL_POWER_RESET);
    eval 'sub PANEL_POWER_OFF () {(0<< 0);}' unless defined(&PANEL_POWER_OFF);
    eval 'sub PANEL_POWER_ON () {(1<< 0);}' unless defined(&PANEL_POWER_ON);
    eval 'sub PCH_PP_ON_DELAYS () {0xc7208;}' unless defined(&PCH_PP_ON_DELAYS);
    eval 'sub EDP_PANEL () {(1<< 30);}' unless defined(&EDP_PANEL);
    eval 'sub PCH_PP_OFF_DELAYS () {0xc720c;}' unless defined(&PCH_PP_OFF_DELAYS);
    eval 'sub PCH_PP_DIVISOR () {0xc7210;}' unless defined(&PCH_PP_DIVISOR);
    eval 'sub PCH_DP_B () {0xe4100;}' unless defined(&PCH_DP_B);
    eval 'sub PCH_DPB_AUX_CH_CTL () {0xe4110;}' unless defined(&PCH_DPB_AUX_CH_CTL);
    eval 'sub PCH_DPB_AUX_CH_DATA1 () {0xe4114;}' unless defined(&PCH_DPB_AUX_CH_DATA1);
    eval 'sub PCH_DPB_AUX_CH_DATA2 () {0xe4118;}' unless defined(&PCH_DPB_AUX_CH_DATA2);
    eval 'sub PCH_DPB_AUX_CH_DATA3 () {0xe411c;}' unless defined(&PCH_DPB_AUX_CH_DATA3);
    eval 'sub PCH_DPB_AUX_CH_DATA4 () {0xe4120;}' unless defined(&PCH_DPB_AUX_CH_DATA4);
    eval 'sub PCH_DPB_AUX_CH_DATA5 () {0xe4124;}' unless defined(&PCH_DPB_AUX_CH_DATA5);
    eval 'sub PCH_DP_C () {0xe4200;}' unless defined(&PCH_DP_C);
    eval 'sub PCH_DPC_AUX_CH_CTL () {0xe4210;}' unless defined(&PCH_DPC_AUX_CH_CTL);
    eval 'sub PCH_DPC_AUX_CH_DATA1 () {0xe4214;}' unless defined(&PCH_DPC_AUX_CH_DATA1);
    eval 'sub PCH_DPC_AUX_CH_DATA2 () {0xe4218;}' unless defined(&PCH_DPC_AUX_CH_DATA2);
    eval 'sub PCH_DPC_AUX_CH_DATA3 () {0xe421c;}' unless defined(&PCH_DPC_AUX_CH_DATA3);
    eval 'sub PCH_DPC_AUX_CH_DATA4 () {0xe4220;}' unless defined(&PCH_DPC_AUX_CH_DATA4);
    eval 'sub PCH_DPC_AUX_CH_DATA5 () {0xe4224;}' unless defined(&PCH_DPC_AUX_CH_DATA5);
    eval 'sub PCH_DP_D () {0xe4300;}' unless defined(&PCH_DP_D);
    eval 'sub PCH_DPD_AUX_CH_CTL () {0xe4310;}' unless defined(&PCH_DPD_AUX_CH_CTL);
    eval 'sub PCH_DPD_AUX_CH_DATA1 () {0xe4314;}' unless defined(&PCH_DPD_AUX_CH_DATA1);
    eval 'sub PCH_DPD_AUX_CH_DATA2 () {0xe4318;}' unless defined(&PCH_DPD_AUX_CH_DATA2);
    eval 'sub PCH_DPD_AUX_CH_DATA3 () {0xe431c;}' unless defined(&PCH_DPD_AUX_CH_DATA3);
    eval 'sub PCH_DPD_AUX_CH_DATA4 () {0xe4320;}' unless defined(&PCH_DPD_AUX_CH_DATA4);
    eval 'sub PCH_DPD_AUX_CH_DATA5 () {0xe4324;}' unless defined(&PCH_DPD_AUX_CH_DATA5);
    eval 'sub PORT_TRANS_A_SEL_CPT () {0;}' unless defined(&PORT_TRANS_A_SEL_CPT);
    eval 'sub PORT_TRANS_B_SEL_CPT () {(1<<29);}' unless defined(&PORT_TRANS_B_SEL_CPT);
    eval 'sub PORT_TRANS_C_SEL_CPT () {(2<<29);}' unless defined(&PORT_TRANS_C_SEL_CPT);
    eval 'sub PORT_TRANS_SEL_MASK () {(3<<29);}' unless defined(&PORT_TRANS_SEL_MASK);
    eval 'sub TRANS_DP_CTL_A () {0xe0300;}' unless defined(&TRANS_DP_CTL_A);
    eval 'sub TRANS_DP_CTL_B () {0xe1300;}' unless defined(&TRANS_DP_CTL_B);
    eval 'sub TRANS_DP_CTL_C () {0xe2300;}' unless defined(&TRANS_DP_CTL_C);
    eval 'sub TRANS_DP_OUTPUT_ENABLE () {(1<<31);}' unless defined(&TRANS_DP_OUTPUT_ENABLE);
    eval 'sub TRANS_DP_PORT_SEL_B () {(0<<29);}' unless defined(&TRANS_DP_PORT_SEL_B);
    eval 'sub TRANS_DP_PORT_SEL_C () {(1<<29);}' unless defined(&TRANS_DP_PORT_SEL_C);
    eval 'sub TRANS_DP_PORT_SEL_D () {(2<<29);}' unless defined(&TRANS_DP_PORT_SEL_D);
    eval 'sub TRANS_DP_PORT_SEL_MASK () {(3<<29);}' unless defined(&TRANS_DP_PORT_SEL_MASK);
    eval 'sub TRANS_DP_AUDIO_ONLY () {(1<<26);}' unless defined(&TRANS_DP_AUDIO_ONLY);
    eval 'sub TRANS_DP_ENH_FRAMING () {(1<<18);}' unless defined(&TRANS_DP_ENH_FRAMING);
    eval 'sub TRANS_DP_8BPC () {(0<<9);}' unless defined(&TRANS_DP_8BPC);
    eval 'sub TRANS_DP_10BPC () {(1<<9);}' unless defined(&TRANS_DP_10BPC);
    eval 'sub TRANS_DP_6BPC () {(2<<9);}' unless defined(&TRANS_DP_6BPC);
    eval 'sub TRANS_DP_12BPC () {(3<<9);}' unless defined(&TRANS_DP_12BPC);
    eval 'sub TRANS_DP_VSYNC_ACTIVE_HIGH () {(1<<4);}' unless defined(&TRANS_DP_VSYNC_ACTIVE_HIGH);
    eval 'sub TRANS_DP_VSYNC_ACTIVE_LOW () {0;}' unless defined(&TRANS_DP_VSYNC_ACTIVE_LOW);
    eval 'sub TRANS_DP_HSYNC_ACTIVE_HIGH () {(1<<3);}' unless defined(&TRANS_DP_HSYNC_ACTIVE_HIGH);
    eval 'sub TRANS_DP_HSYNC_ACTIVE_LOW () {0;}' unless defined(&TRANS_DP_HSYNC_ACTIVE_LOW);
    eval 'sub EDP_LINK_TRAIN_400MV_0DB_SNB_A () {(0x38<<22);}' unless defined(&EDP_LINK_TRAIN_400MV_0DB_SNB_A);
    eval 'sub EDP_LINK_TRAIN_400MV_6DB_SNB_A () {(0x2<<22);}' unless defined(&EDP_LINK_TRAIN_400MV_6DB_SNB_A);
    eval 'sub EDP_LINK_TRAIN_600MV_3_5DB_SNB_A () {(0x1<<22);}' unless defined(&EDP_LINK_TRAIN_600MV_3_5DB_SNB_A);
    eval 'sub EDP_LINK_TRAIN_800MV_0DB_SNB_A () {(0x<<22);}' unless defined(&EDP_LINK_TRAIN_800MV_0DB_SNB_A);
    eval 'sub EDP_LINK_TRAIN_400MV_0DB_SNB_B () {(0x<<22);}' unless defined(&EDP_LINK_TRAIN_400MV_0DB_SNB_B);
    eval 'sub EDP_LINK_TRAIN_400MV_6DB_SNB_B () {(0x3a<<22);}' unless defined(&EDP_LINK_TRAIN_400MV_6DB_SNB_B);
    eval 'sub EDP_LINK_TRAIN_600MV_3_5DB_SNB_B () {(0x39<<22);}' unless defined(&EDP_LINK_TRAIN_600MV_3_5DB_SNB_B);
    eval 'sub EDP_LINK_TRAIN_800MV_0DB_SNB_B () {(0x38<<22);}' unless defined(&EDP_LINK_TRAIN_800MV_0DB_SNB_B);
    eval 'sub EDP_LINK_TRAIN_VOL_EMP_MASK_SNB () {(0x3f<<22);}' unless defined(&EDP_LINK_TRAIN_VOL_EMP_MASK_SNB);
    eval 'sub IS_I830 {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I830));
    }' unless defined(&IS_I830);
    eval 'sub IS_845G {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I845G));
    }' unless defined(&IS_845G);
    eval 'sub IS_I85X {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I85X));
    }' unless defined(&IS_I85X);
    eval 'sub IS_I865G {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I865G));
    }' unless defined(&IS_I865G);
    eval 'sub IS_I915G {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I915G));
    }' unless defined(&IS_I915G);
    eval 'sub IS_I915GM {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I915GM));
    }' unless defined(&IS_I915GM);
    eval 'sub IS_I945G {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I945G));
    }' unless defined(&IS_I945G);
    eval 'sub IS_I945GM {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I945GM));
    }' unless defined(&IS_I945GM);
    eval 'sub IS_I965G {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I965));
    }' unless defined(&IS_I965G);
    eval 'sub IS_I965GM {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I965GM));
    }' unless defined(&IS_I965GM);
    eval 'sub IS_GM45 {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_GM45));
    }' unless defined(&IS_GM45);
    eval 'sub IS_G4X {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_G4X));
    }' unless defined(&IS_G4X);
    eval 'sub IS_G33 {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_G33));
    }' unless defined(&IS_G33);
    eval 'sub IS_I9XX {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I9XX));
    }' unless defined(&IS_I9XX);
    eval 'sub IS_IRONLAKE {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_IRONLAKE));
    }' unless defined(&IS_IRONLAKE);
    eval 'sub IS_IRONLAKE_D {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_IRONLAKE_D));
    }' unless defined(&IS_IRONLAKE_D);
    eval 'sub IS_IRONLAKE_M {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_IRONLAKE_M));
    }' unless defined(&IS_IRONLAKE_M);
    eval 'sub IS_MOBILE {
        my($dev_priv) = @_;
	    eval q(( ($dev_priv->{flags}) &  &CHIP_M));
    }' unless defined(&IS_MOBILE);
    eval 'sub I915_NEED_GFX_HWS {
        my($dev_priv) = @_;
	    eval q(( ($dev_priv->{flags}) &  &CHIP_HWS));
    }' unless defined(&I915_NEED_GFX_HWS);
    eval 'sub HAS_RESET {
        my($dev_priv) = @_;
	    eval q( &IS_I965G($dev_priv));
    }' unless defined(&HAS_RESET);
    eval 'sub IS_GEN2 {
        my($dev_priv) = @_;
	    eval q(( ($dev_priv->{flags}) &  &CHIP_GEN2));
    }' unless defined(&IS_GEN2);
    eval 'sub IS_GEN3 {
        my($dev_priv) = @_;
	    eval q(( ($dev_priv->{flags}) &  &CHIP_GEN3));
    }' unless defined(&IS_GEN3);
    eval 'sub IS_GEN4 {
        my($dev_priv) = @_;
	    eval q(( ($dev_priv->{flags}) &  &CHIP_GEN4));
    }' unless defined(&IS_GEN4);
    eval 'sub IS_GEN6 {
        my($dev_priv) = @_;
	    eval q(( ($dev_priv->{flags}) &  &CHIP_GEN6));
    }' unless defined(&IS_GEN6);
    eval 'sub HAS_PCH_SPLIT {
        my($dev_priv) = @_;
	    eval q(( &IS_IRONLAKE($dev_priv) ||  &IS_GEN6($dev_priv)));
    }' unless defined(&HAS_PCH_SPLIT);
    eval 'sub I915_INTERRUPT_ENABLE_FIX () {( &I915_DISPLAY_PIPE_A_EVENT_INTERRUPT |  &I915_DISPLAY_PIPE_B_EVENT_INTERRUPT |  &I915_RENDER_COMMAND_PARSER_ERROR_INTERRUPT);}' unless defined(&I915_INTERRUPT_ENABLE_FIX);
    eval 'sub I915_INTERRUPT_ENABLE_VAR () {( &I915_USER_INTERRUPT);}' unless defined(&I915_INTERRUPT_ENABLE_VAR);
    eval 'sub I915_INTERRUPT_ENABLE_MASK () {( &I915_INTERRUPT_ENABLE_FIX |  &I915_INTERRUPT_ENABLE_VAR);}' unless defined(&I915_INTERRUPT_ENABLE_MASK);
    eval 'sub PCH_SPLIT_DISPLAY_INTR_FIX () {( &DE_MASTER_IRQ_CONTROL);}' unless defined(&PCH_SPLIT_DISPLAY_INTR_FIX);
    eval 'sub PCH_SPLIT_DISPLAY_INTR_VAR () {( &DE_PIPEA_VBLANK |  &DE_PIPEB_VBLANK);}' unless defined(&PCH_SPLIT_DISPLAY_INTR_VAR);
    eval 'sub PCH_SPLIT_DISPLAY_ENABLE_MASK () {( &PCH_SPLIT_DISPLAY_INTR_FIX |  &PCH_SPLIT_DISPLAY_INTR_VAR);}' unless defined(&PCH_SPLIT_DISPLAY_ENABLE_MASK);
    eval 'sub PCH_SPLIT_RENDER_INTR_FIX () {(0);}' unless defined(&PCH_SPLIT_RENDER_INTR_FIX);
    eval 'sub PCH_SPLIT_RENDER_INTR_VAR () {( &GT_USER_INTERRUPT |  &GT_MASTER_ERROR);}' unless defined(&PCH_SPLIT_RENDER_INTR_VAR);
    eval 'sub PCH_SPLIT_RENDER_ENABLE_MASK () {( &PCH_SPLIT_RENDER_INTR_FIX |  &PCH_SPLIT_RENDER_INTR_VAR);}' unless defined(&PCH_SPLIT_RENDER_ENABLE_MASK);
    eval 'sub PCH_SPLIT_HOTPLUG_INTR_FIX () {(0);}' unless defined(&PCH_SPLIT_HOTPLUG_INTR_FIX);
    eval 'sub PCH_SPLIT_HOTPLUG_INTR_VAR () {(0);}' unless defined(&PCH_SPLIT_HOTPLUG_INTR_VAR);
    eval 'sub PCH_SPLIT_HOTPLUG_ENABLE_MASK () {( &PCH_SPLIT_HOTPLUG_INTR_FIX |  &PCH_SPLIT_HOTPLUG_INTR_VAR);}' unless defined(&PCH_SPLIT_HOTPLUG_ENABLE_MASK);
    eval 'sub printeir {
        my($val) = @_;
	    eval q( &printf(\\"%s: error reg: %b\\\\n\\",  &__func__, $val, \\"\\\\20\\\\x10PTEERR\\\\x2REFRESHERR\\\\x1INSTERR\\"));
    }' unless defined(&printeir);
    eval 'sub HAS_128_BYTE_Y_TILING {
        my($dev_priv) = @_;
	    eval q(( &IS_I9XX($dev_priv)  && !( &IS_I915G($dev_priv) ||  &IS_I915GM($dev_priv))));
    }' unless defined(&HAS_128_BYTE_Y_TILING);
    eval 'sub PRIMARY_RINGBUFFER_SIZE () {(128*1024);}' unless defined(&PRIMARY_RINGBUFFER_SIZE);
    eval 'sub i915_obj_purgeable {
        my($obj_priv) = @_;
	    eval q({ ( ($obj_priv->{obj}->{do_flags}) &  &I915_DONTNEED); });
    }' unless defined(&i915_obj_purgeable);
    eval 'sub i915_obj_purged {
        my($obj_priv) = @_;
	    eval q({ ( ($obj_priv->{obj}->{do_flags}) &  &I915_PURGED); });
    }' unless defined(&i915_obj_purged);
    eval 'sub inteldrm_is_active {
        my($obj_priv) = @_;
	    eval q({ ( ($obj_priv->{obj}->{do_flags}) &  &I915_ACTIVE); });
    }' unless defined(&inteldrm_is_active);
    eval 'sub inteldrm_is_dirty {
        my($obj_priv) = @_;
	    eval q({ ( ($obj_priv->{obj}->{do_flags}) &  &I915_DIRTY); });
    }' unless defined(&inteldrm_is_dirty);
    eval 'sub inteldrm_exec_needs_fence {
        my($obj_priv) = @_;
	    eval q({ ( ($obj_priv->{obj}->{do_flags}) &  &I915_EXEC_NEEDS_FENCE); });
    }' unless defined(&inteldrm_exec_needs_fence);
    eval 'sub inteldrm_needs_fence {
        my($obj_priv) = @_;
	    eval q({ ( ($obj_priv->{obj}->{do_flags}) &  &I915_FENCED_EXEC); });
    }' unless defined(&inteldrm_needs_fence);
}
1;
