/*	$OpenBSD: kqueue-pipe.c,v 1.4 2003/07/31 21:48:08 deraadt Exp $	*/
/*
 * Copyright 2001 Niels Provos <provos@citi.umich.edu>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Niels Provos.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <sys/types.h>
#include <sys/time.h>
#include <sys/event.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>

int do_pipe(void);

int
do_pipe(void)
{
        int kq;
        int n;
        int fd[2];
        struct kevent ev;
        struct timespec ts;
        char buf[8000];

        if (pipe(fd) == -1)
                return (1);
        if (fcntl(fd[1], F_SETFL, O_NONBLOCK) == -1)
                return (1);

	if ((kq = kqueue()) == -1)
                return (1);

        ev.ident = fd[1];
        ev.filter = EVFILT_WRITE;
        ev.flags = EV_ADD | EV_ENABLE;
        n = kevent(kq, &ev, 1, NULL, 0, NULL);
        if (n == -1)
                return (1);
        
        while ((n = write(fd[1], buf, sizeof(buf))) == sizeof(buf))
                ;

        ts.tv_sec = 0;
        ts.tv_nsec = 0;
        n = kevent(kq, NULL, 0, &ev, 1, &ts);
        if (n != 0)
                return (1);

	read(fd[0], buf, sizeof(buf));

        ts.tv_sec = 0;
        ts.tv_nsec = 0;
        n = kevent(kq, NULL, 0, &ev, 1, &ts);
        if (n == -1 || n == 0)
                return (1);

        return (0);
}
